/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.inet.jortho.SpellChecker;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.jalbum.component.JDraggableList;
import net.miginfocom.swing.MigLayout;
import se.datadosen.component.ComboBoxFilter;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JDatePatternComboBox;
import se.datadosen.component.JFileSelector;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JNotification;
import se.datadosen.component.JNumberField;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.RiverLayout2;
import se.datadosen.io.IIORegistryManager;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JPrefsPanel_language_actionAdapter;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SpellCheckerUtils;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.LaF;
import se.datadosen.util.Languages;
import se.datadosen.util.Platform;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.annotations.Bound;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.TabTitle;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.Title;
import se.datadosen.util.annotations.ToolTipText;

public class JPreferencesWindow
extends JSmartDialog
implements JComponentHolder {
    JAlbumFrame parent;
    JTabbedPane tabs = new JTabbedPane();
    @Text(value="ui.~")
    JLabel loggingLevelLabel = new JLabel();
    JComboBox<Config.LoggingLevel> loggingLevel = new JComboBox<Config.LoggingLevel>(Config.LoggingLevel.values());
    @Text(value="prefs.projectsByUse")
    @ToolTipText(value="prefs.projectsListToolTip")
    JLabel recentProjectsLabel = new JLabel();
    @ToolTipText(value="prefs.projectsListToolTip")
    JSpinner recentProjects = new JSpinner(new SpinnerNumberModel(50, 0, 99, 1));
    @Text(value="ui.thumbnailsLabel")
    JLabel thumbnailQualityLabel = new JLabel();
    JComboBox<Config.ThumbnailQuality> thumbnailQuality = new JComboBox<Config.ThumbnailQuality>(Config.ThumbnailQuality.values());
    @Text(value="ui.type")
    JLabel previewModeLabel = new JLabel();
    JComboBox previewMode = new JComboBox<Config.PreviewMode>(Config.PreviewMode.values());
    @Text(value="prefs.serverBasedPreview")
    JCheckBox serverBasedPreview = new JCheckBox();
    @Text(value="share.port")
    @ToolTipText(value="ui.emptyAutoSelects")
    JLabel previewServerPortLabel = new JLabel();
    @Text(value="prefs.localServerURL")
    JLabel localServerURLLabel = new JLabel();
    @ToolTipText(value="prefs.localServerURLToolTip")
    JTextField localServerURL = new JTextField(20);
    @ToolTipText(value="ui.emptyAutoSelects")
    JNumberField previewServerPort = new JNumberField(5);
    @Text(value="ui.notifications")
    JLabel bgNotificationsLabel = new JLabel();
    JComboBox bgNotifications = new JComboBox<Config.NotificationLevel>(Config.NotificationLevel.values());
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox checkForUpdates = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox checkSpelling = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox closeProgressDialog = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox saveOnMakeAlbum = new JCheckBox();
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox backgroundMode = new JCheckBox();
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox compressAudioClips = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox showOpenHTMLEditorButton = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox customTitleBar = new JCheckBox();
    @Text(value="ui.available")
    JLabel availableDetailsViewFieldsLabel = new JLabel();
    @Text(value="ui.chosen")
    JLabel chosenDetailsViewFieldsLabel = new JLabel();
    @ToolTipText(value="ui.tipLabel")
    public JDraggableList<Config.FieldType> detailsViewFields = new JDraggableList<Object>((E[])Config.FieldType.values(), (E[])new Object[]{Config.FieldType.fileName, Config.FieldType.title, Config.FieldType.caption}).small();
    @Text(value="ui.reset")
    JButton detailsViewFieldsResetButton = new JButton();
    @Text(value="ui.tipLabel")
    @Icon(value="16x16/lightbulb.svg")
    JLabel dragAndDropWorksLabel = new JLabel();
    @Text(value="ui.~")
    JCheckBox useLayoutHints = new JCheckBox();
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox restorePreviousSettings = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox writeXmp = new JCheckBox();
    JComboBox language;
    @Text(value="ui.dateFormat")
    JLabel datePatternLabel;
    @ToolTipText(value="ui.dateFormatTemplateToolTip")
    JDatePatternComboBox datePattern;
    @Text(value="ui.dateAndTimePatterns")
    JLinkLabel dateAndTimePatternsLink;
    JLabel dateExampleLabel;
    JComboBox lookAndFeelName;
    @Text(value="ui.fontSize")
    JLabel fontSizeLabel;
    JSpinner fontSize;
    @TabTitle(value="ui.mainPanel")
    ControlPanel general;
    @TabTitle(value="ui.explorer")
    ControlPanel explorer;
    @Title(value="ui.detailsViewFields")
    ControlPanel detailsViewPanel;
    @TabTitle(value="ui.projects")
    ControlPanel projects;
    @TabTitle(value="ui.preview")
    ControlPanel preview;
    @TabTitle(value="ui.~Title")
    ControlPanel publishing;
    @Title(value="ui.search")
    ControlPanel search;
    @TabTitle(value="ui.advancedPanel")
    ControlPanel advanced;
    JTabbedPane advancedTabs;
    @TabTitle(value="ui.mainPanel")
    ControlPanel advancedGeneral;
    @TabTitle(value="prefs.imageReaders")
    ControlPanel imageReadersPanel;
    @TabTitle(value="prefs.imageWriters")
    ControlPanel imageWritersPanel;
    @Title(value="prefs.webProxy")
    ControlPanel webProxy;
    @Title(value="ui.backgroundTasks")
    ControlPanel backgroundTasks;
    @Title(value="prefs.whenCreatingProjects")
    ControlPanel whenCreatingProjects;
    @Title(value="prefs.~Border")
    ControlPanel skins;
    @Title(value="prefs.imageEditingBorder")
    ControlPanel editing;
    @Title(value="prefs.~Border")
    ControlPanel guides;
    @Text(value="prefs.~")
    JCheckBox showWarnings;
    @Title(value="prefs.~Border")
    ControlPanel multipleProcessors;
    @Text(value="prefs.nThreadsLabel")
    JLabel cpuCoresLabel;
    JComboBox cpuCores;
    @Text(value="prefs.projectsDirectory")
    JLabel myAlbumsLocationLabel;
    JTextField myAlbumsLocation;
    private JFileSelector myAlbumsSelector;
    @Text(value="prefs.outputDirectoryLocation")
    JLabel outputDirectoryLocationLabel;
    JComboBox<Config.OutputDirectoryLocation> outputDirectoryLocation;
    @Text(value="prefs.webDirectory")
    JLabel webDirectoryLabel;
    JTextField webDirectory;
    private JFileSelector webDirectorySelector;
    @Text(value="prefs.illegalCharacters")
    @ToolTipText(value="prefs.illegalCharactersToolTip")
    JLabel illegalCharactersLabel;
    @ToolTipText(value="prefs.illegalCharactersToolTip")
    JTextField illegalCharacters;
    @Text(value="prefs.language")
    JLabel languageLabel;
    @Text(value="prefs.lookAndFeel")
    JLabel lookAndFeelLabel;
    @Text(value="prefs.slideShow")
    JLabel slideShowLabel;
    @Text(value="prefs.~")
    JCheckBox cleanOutputFiles;
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox synchronizeOutputDirectory;
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox useHardLinks;
    @Text(value="prefs.~")
    JCheckBox cacheThumbnails;
    @Text(value="prefs.videoSupport")
    @ToolTipText(value="prefs.videoSupportToolTip")
    JCheckBox videoSupported;
    @Text(value="prefs.fileAddBehavior")
    JLabel fileAddBehaviorLabel;
    public JComboBox fileAddMethod;
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox rememberCopiedFiles;
    @Text(value="prefs.~")
    public JCheckBox thumbnailsInFileChooser;
    @Text(value="prefs.afterPublishingAction")
    JLabel afterPublishingLabel;
    JComboBox afterPublishAction;
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox includeLifeboatFile;
    @Text(value="prefs.maxSimultaneousTransfers")
    JLabel maxSimultaneousTransfersLabel;
    JComboBox maxSimultaneousTransfers;
    public JToggleButton addressBar;
    public JToggleButton largeThumbnails;
    JCheckBox expandedMainSettings;
    JCheckBox expandedFolderSettings;
    JTextField userName;
    JTextField password;
    JCheckBox rememberSignIn;
    JCheckBox doNotShowSigninAgain;
    JCheckBox backgroundSignInOnStart;
    @Title(value="ui.~")
    JCollapsiblePanel paranoia;
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox encryptManifest;
    @Text(value="prefs.manifestPassword")
    JLabel manifestPasswordLabel;
    JTextField manifestPassword;
    @Title(value="ui.advancedPanel")
    JCollapsiblePanel advancedPublishing;
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox zipstreaming;
    @Text(value="prefs.~")
    JCheckBox rememberWindowBounds;
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox rememberLastSelectedItem;
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox scrollToTop;
    @Text(value="prefs.scrollSpeed")
    @ToolTipText(value="prefs.scrollSpeedToolTip")
    JLabel explorerScrollSpeedLabel;
    JSlider explorerScrollSpeed;
    @Text(value="prefs.~")
    JCheckBox backupProjects;
    @Text(value="prefs.~")
    JCheckBox showTipOfTheDay;
    @ToolTipText(value="share.hostName")
    JTextField httpProxyHost;
    @ToolTipText(value="share.port")
    JTextField httpProxyPort;
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox useWatchdog;
    @Text(value="prefs.~")
    JCheckBox useNativeFileDialogs;
    @Text(value="prefs.~")
    JLabel supportedVideoFormatsLabel;
    JTextArea supportedVideoFormats;
    @Text(value="ui.restore")
    Action restoreIllegalCharacters;
    @Text(value="prefs.~")
    JCheckBox indexAlbumObjects;
    @Text(value="prefs.~")
    JCheckBox indexMetadata;
    @Bound
    Rectangle windowBounds;
    IIORegistryManager.JReadersWritersList<ImageReaderSpi> excludedImageReaders;
    IIORegistryManager.JReadersWritersList<ImageWriterSpi> excludedImageWriters;

    public JPreferencesWindow(JAlbumFrame parent) {
        super((Window)parent, false);
        this.language = new JComboBox(Languages.modelFrom(new File(Config.getConfig().progDir, "texts"))){
            {
                this.insertItemAt(new Item("default", Msg.get("prefs.systemDefault")), 0);
            }
        };
        this.datePatternLabel = new JLabel();
        this.datePattern = new JDatePatternComboBox();
        this.dateAndTimePatternsLink = new JLinkLabel("http://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html", "");
        this.dateExampleLabel = new JLabel();
        this.lookAndFeelName = new JComboBox(JPreferencesWindow.fillLookAndFeels()){
            {
                new ComboBoxFilter(this, "Metal", "CDE/Motif", "Nimbus");
                this.setMaximumRowCount(12);
            }
        };
        this.fontSizeLabel = new JLabel();
        this.fontSize = new JSpinner(new SpinnerNumberModel(11, 10, 18, 1));
        this.general = new ControlPanel();
        this.explorer = new ControlPanel();
        this.detailsViewPanel = new ControlPanel();
        this.projects = new ControlPanel();
        this.preview = new ControlPanel();
        this.publishing = new ControlPanel();
        this.search = new ControlPanel((LayoutManager)new MigLayout("insets 0,wrap 2"));
        this.advanced = new ControlPanel();
        this.advancedTabs = new JTabbedPane();
        this.advancedGeneral = new ControlPanel(new RiverLayout2());
        this.imageReadersPanel = new ControlPanel(new RiverLayout2());
        this.imageWritersPanel = new ControlPanel(new RiverLayout2());
        this.webProxy = new ControlPanel();
        this.backgroundTasks = new ControlPanel();
        this.whenCreatingProjects = new ControlPanel();
        this.skins = new ControlPanel();
        this.editing = new ControlPanel();
        this.guides = new ControlPanel();
        this.showWarnings = new JCheckBox();
        this.multipleProcessors = new ControlPanel();
        this.cpuCoresLabel = new JLabel();
        this.cpuCores = new JComboBox<Object>(JPreferencesWindow.fillCpuCores());
        this.myAlbumsLocationLabel = new JLabel();
        this.myAlbumsLocation = new JSmartTextField();
        this.myAlbumsSelector = new JFileSelector(this.myAlbumsLocation);
        this.outputDirectoryLocationLabel = new JLabel();
        this.outputDirectoryLocation = new JComboBox<Config.OutputDirectoryLocation>(Config.OutputDirectoryLocation.values());
        this.webDirectoryLabel = new JLabel();
        this.webDirectory = new JSmartTextField();
        this.webDirectorySelector = new JFileSelector(this.webDirectory);
        this.illegalCharactersLabel = new JLabel();
        this.illegalCharacters = new JSmartTextField();
        this.languageLabel = new JLabel();
        this.lookAndFeelLabel = new JLabel();
        this.slideShowLabel = new JLabel();
        this.cleanOutputFiles = new JCheckBox();
        this.synchronizeOutputDirectory = new JCheckBox();
        this.useHardLinks = new JCheckBox();
        this.cacheThumbnails = new JCheckBox();
        this.videoSupported = new JCheckBox();
        this.fileAddBehaviorLabel = new JLabel();
        this.fileAddMethod = new JComboBox<Config.FileAddMethod>(Config.FileAddMethod.values());
        this.rememberCopiedFiles = new JCheckBox();
        this.thumbnailsInFileChooser = new JCheckBox();
        this.afterPublishingLabel = new JLabel();
        this.afterPublishAction = new JComboBox<Config.AfterPublishAction>(Config.AfterPublishAction.values());
        this.includeLifeboatFile = new JCheckBox();
        this.maxSimultaneousTransfersLabel = new JLabel();
        this.maxSimultaneousTransfers = new JComboBox<Object>(new Object[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        this.addressBar = new JToggleButton("", true);
        this.largeThumbnails = new JToggleButton("", true);
        this.expandedMainSettings = new JCheckBox();
        this.expandedFolderSettings = new JCheckBox();
        this.userName = new JTextField();
        this.password = new JTextField();
        this.rememberSignIn = new JCheckBox();
        this.doNotShowSigninAgain = new JCheckBox();
        this.backgroundSignInOnStart = new JCheckBox();
        this.paranoia = new JCollapsiblePanel(new RiverLayout());
        this.encryptManifest = new JCheckBox();
        this.manifestPasswordLabel = new JLabel();
        this.manifestPassword = new JTextField(12);
        this.advancedPublishing = new JCollapsiblePanel(new RiverLayout());
        this.zipstreaming = new JCheckBox();
        this.rememberWindowBounds = new JCheckBox();
        this.rememberLastSelectedItem = new JCheckBox();
        this.scrollToTop = new JCheckBox();
        this.explorerScrollSpeedLabel = new JLabel();
        this.explorerScrollSpeed = new JSlider(1, 70, 30);
        this.backupProjects = new JCheckBox();
        this.showTipOfTheDay = new JCheckBox();
        this.httpProxyHost = new JTextField(12);
        this.httpProxyPort = new JTextField(4);
        this.useWatchdog = new JCheckBox();
        this.useNativeFileDialogs = new JCheckBox();
        this.supportedVideoFormatsLabel = new JLabel();
        this.supportedVideoFormats = new JSmartTextArea(5, 30);
        this.restoreIllegalCharacters = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JPreferencesWindow.this.illegalCharacters.setText("#$%&*\"\\/:;?=|~");
            }
        };
        this.indexAlbumObjects = new JCheckBox();
        this.indexMetadata = new JCheckBox();
        this.windowBounds = new Rectangle();
        this.excludedImageReaders = new IIORegistryManager.JReadersWritersList(IIORegistryManager.getReadersModel());
        this.excludedImageWriters = new IIORegistryManager.JReadersWritersList(IIORegistryManager.getWritersModel());
        this.parent = parent;
        try {
            this.jbInit();
            parent.prepareWindow(this);
            this.loadPreferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateDateExample() {
        String dateString = "";
        try {
            String pattern = this.datePattern.getEditorComponent().getText();
            DateFormat formatter = pattern.length() > 0 ? new SimpleDateFormat(pattern) : DateFormat.getDateTimeInstance();
            dateString = formatter.format(new Date());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.dateExampleLabel.setText(Msg.get("ui.example") + ": " + dateString);
    }

    private void jbInit() throws Exception {
        JPreferencesWindow.makeSmaller(this.dateExampleLabel);
        JPreferencesWindow.makeSmaller(this.dateAndTimePatternsLink);
        Config.getConfig().bind("language", pce -> {
            this.datePattern.getEditorComponent().setBackgroundText(((SimpleDateFormat)DateFormat.getDateTimeInstance()).toPattern());
            this.updateDateExample();
        });
        this.datePattern.getEditorComponent().onChange(de -> this.updateDateExample());
        this.expandedMainSettings.setSelected(true);
        this.rememberSignIn.setSelected(true);
        this.restorePreviousSettings.setSelected(true);
        this.cleanOutputFiles.setSelected(true);
        this.synchronizeOutputDirectory.setSelected(true);
        this.thumbnailsInFileChooser.setSelected(true);
        this.zipstreaming.setSelected(true);
        this.detailsViewFieldsResetButton.addActionListener(ae -> this.detailsViewFields.setContent((Config.FieldType[])new Config.FieldType[]{Config.FieldType.fileName, Config.FieldType.title, Config.FieldType.caption}));
        Config.getConfig().addPropertyChangeListener("checkSpelling", pce -> this.checkSpelling.setSelected((Boolean)pce.getNewValue()));
        this.checkSpelling.addActionListener(ae -> {
            if (this.checkSpelling.isSelected()) {
                File userDictDir = new File(MiniConfig.getMiniConfig().configDir, "dictionaries");
                String lang = Config.getConfig().getInterpretedLanguage();
                try {
                    SpellChecker.setCurrentLocale((Locale)new Locale(lang));
                }
                catch (IllegalArgumentException ex) {
                    SpellCheckerUtils.downloadDictionary(this.checkSpelling, lang);
                }
            }
        });
        ComponentUtilities.whenSelectedDisable((AbstractButton)this.serverBasedPreview, this.localServerURLLabel, this.localServerURL);
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.encryptManifest, this.manifestPasswordLabel, this.manifestPassword);
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.serverBasedPreview, this.previewServerPortLabel, this.previewServerPort);
        ComponentUtilities.whenEqualsEnable(this.previewMode, (Object)Config.PreviewMode.external, (JComponent)this.closeProgressDialog);
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.indexAlbumObjects, (JComponent)this.indexMetadata);
        this.cpuCores.setSelectedIndex(Math.min(this.cpuCores.getItemCount() - 1, 7));
        this.showTipOfTheDay.addActionListener(e -> {
            try {
                JNotification.forgetAllShown();
            }
            catch (BackingStoreException ex) {
                throw new RuntimeException(ex);
            }
        });
        this.useHardLinks.addActionListener(ae -> {
            if (this.useHardLinks.isSelected()) {
                JOptionPane.showMessageDialog(this, Msg.get("prefs.useHardLinksWarning"), Msg.get("prefs.useHardLinks"), 2);
            }
        });
        this.myAlbumsSelector.setDirectories(true);
        this.webDirectorySelector.setDirectories(true);
        ComponentUtilities.whenEqualsEnable(this.outputDirectoryLocation, (Object)Config.OutputDirectoryLocation.web, this.webDirectoryLabel, this.webDirectory, this.webDirectorySelector);
        this.saveOnMakeAlbum.addActionListener(e -> {
            if (this.saveOnMakeAlbum.isSelected()) {
                this.backupProjects.setSelected(true);
            }
        });
        AbstractAction okAction = new AbstractAction(Msg.get("ok")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPreferencesWindow.this.setVisible(false);
                JPreferencesWindow.this.savePreferences();
            }
        };
        AbstractAction cancelAction = new AbstractAction(Msg.get("cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPreferencesWindow.this.setVisible(false);
                JPreferencesWindow.this.cancelPreferences();
            }
        };
        this.registerActions(okAction, cancelAction);
        this.supportedVideoFormats.setLineWrap(true);
        this.supportedVideoFormats.setWrapStyleWord(true);
        this.language.addActionListener(new JPrefsPanel_language_actionAdapter(this));
        Container c = this.getContentPane();
        c.setLayout(new RiverLayout());
        this.advancedTabs.add(this.advancedGeneral);
        this.advancedTabs.add(this.imageReadersPanel);
        this.advancedTabs.add(this.imageWritersPanel);
        this.advanced.add("hfill vfill", this.advancedTabs);
        this.tabs.add(this.general);
        this.tabs.add(this.explorer);
        this.tabs.add(this.projects);
        this.tabs.add(this.preview);
        this.tabs.add(this.publishing);
        this.tabs.add(this.advanced);
        c.add("br hfill vfill", this.tabs);
        this.general.add("br", this.languageLabel);
        this.general.add("tab", this.language);
        this.general.add("br", this.datePatternLabel);
        this.general.add("tab", this.datePattern);
        this.general.add(this.dateAndTimePatternsLink);
        this.general.add("br tab", this.dateExampleLabel);
        this.general.add("br", this.lookAndFeelLabel);
        this.general.add("tab", this.lookAndFeelName);
        this.general.add("br", this.fontSizeLabel);
        this.general.add("tab", this.fontSize);
        this.general.add("br", this.loggingLevelLabel);
        this.general.add("tab", this.loggingLevel);
        this.general.add("br", this.recentProjectsLabel);
        this.general.add("tab", this.recentProjects);
        this.general.add("br hfill", this.search);
        this.editing.add(this.writeXmp);
        this.general.add("br hfill", this.editing);
        JPanel generalOptions = new JPanel((LayoutManager)new MigLayout("insets 0,wrap 2"));
        generalOptions.add(this.checkForUpdates);
        generalOptions.add(this.showWarnings);
        generalOptions.add(this.rememberWindowBounds);
        generalOptions.add(this.showTipOfTheDay);
        generalOptions.add(this.thumbnailsInFileChooser);
        generalOptions.add(this.backgroundMode);
        generalOptions.add(this.closeProgressDialog);
        generalOptions.add(this.checkSpelling);
        generalOptions.add(this.showOpenHTMLEditorButton);
        if (Platform.isLinux()) {
            generalOptions.add(this.customTitleBar);
        }
        this.general.add("br hfill", generalOptions);
        this.detailsViewPanel.add("br", this.availableDetailsViewFieldsLabel);
        this.detailsViewPanel.add("tab", this.chosenDetailsViewFieldsLabel);
        this.detailsViewPanel.add("br", new JScrollPane(this.detailsViewFields.getSecondaryList(), 22, 31));
        this.detailsViewPanel.add("tab", new JScrollPane(this.detailsViewFields, 22, 31));
        this.detailsViewPanel.add("br", this.dragAndDropWorksLabel);
        this.detailsViewPanel.add("hfill", Box.createHorizontalGlue());
        this.detailsViewPanel.add("right", this.detailsViewFieldsResetButton);
        this.explorer.add("br", this.fileAddBehaviorLabel);
        this.explorer.add("tab", this.fileAddMethod);
        this.explorer.add("br", this.thumbnailQualityLabel);
        this.explorer.add("tab", this.thumbnailQuality);
        JPanel explorerOpts = new JPanel((LayoutManager)new MigLayout("insets 0,wrap 2"));
        explorerOpts.add(this.cacheThumbnails);
        explorerOpts.add(this.rememberLastSelectedItem);
        explorerOpts.add(this.scrollToTop);
        this.explorer.add("br", explorerOpts);
        this.explorer.add("br", this.explorerScrollSpeedLabel);
        this.explorer.add("tab", this.explorerScrollSpeed);
        this.explorer.add(new JLabel("s"));
        this.explorer.add("p", this.detailsViewPanel);
        this.detailsViewFields.getSecondaryList().setVisibleRowCount(12);
        this.detailsViewFields.setVisibleRowCount(12);
        this.projects.add("br hfill", this.whenCreatingProjects);
        this.whenCreatingProjects.add("br", this.myAlbumsLocationLabel);
        this.whenCreatingProjects.add("tab hfill", this.myAlbumsLocation);
        this.whenCreatingProjects.add(this.myAlbumsSelector);
        this.whenCreatingProjects.add("br", this.outputDirectoryLocationLabel);
        this.whenCreatingProjects.add(this.outputDirectoryLocation);
        this.whenCreatingProjects.add("br", this.webDirectoryLabel);
        this.whenCreatingProjects.add("tab hfill", this.webDirectory);
        this.whenCreatingProjects.add(this.webDirectorySelector);
        this.projects.add("br", this.illegalCharactersLabel);
        this.projects.add("tab hfill", this.illegalCharacters);
        this.projects.add(new JButton(this.restoreIllegalCharacters));
        if (Runtime.getRuntime().availableProcessors() < 2) {
            this.multipleProcessors.setEnabled(false);
        }
        JPanel albumCheckboxes = new JPanel((LayoutManager)new MigLayout("insets 0,wrap 2"));
        albumCheckboxes.add(this.cleanOutputFiles);
        albumCheckboxes.add(this.synchronizeOutputDirectory);
        albumCheckboxes.add(this.includeLifeboatFile);
        albumCheckboxes.add(this.backupProjects);
        albumCheckboxes.add(this.saveOnMakeAlbum);
        albumCheckboxes.add(this.useHardLinks);
        albumCheckboxes.add(this.compressAudioClips);
        this.projects.add("p hfill", albumCheckboxes);
        this.skins.add(this.useLayoutHints);
        this.skins.add("br", this.restorePreviousSettings);
        this.projects.add("br hfill", this.skins);
        this.preview.add("br", this.previewModeLabel);
        this.preview.add("tab", this.previewMode);
        this.preview.add("br", this.serverBasedPreview);
        this.preview.add("", this.previewServerPortLabel);
        this.preview.add("", this.previewServerPort);
        this.preview.add("br", this.localServerURLLabel);
        this.preview.add("tab", this.localServerURL);
        this.publishing.add("br", this.afterPublishingLabel);
        this.publishing.add("tab", this.afterPublishAction);
        this.publishing.add("br", this.maxSimultaneousTransfersLabel);
        this.publishing.add("", this.maxSimultaneousTransfers);
        this.advancedPublishing.getContentPanel().add(this.zipstreaming);
        this.publishing.add("br hfill", this.advancedPublishing);
        this.paranoia.getContentPanel().add(this.encryptManifest);
        this.paranoia.getContentPanel().add("br", this.manifestPasswordLabel);
        this.paranoia.getContentPanel().add("tab", this.manifestPassword);
        this.publishing.add("p hfill", this.paranoia);
        this.search.add(this.indexAlbumObjects);
        this.search.add(this.indexMetadata);
        this.webProxy.add(this.httpProxyHost);
        this.webProxy.add(new JLabel(":"));
        this.webProxy.add(this.httpProxyPort);
        this.advancedGeneral.add("hfill", this.webProxy);
        this.advancedGeneral.add("p", this.cpuCoresLabel);
        this.advancedGeneral.add("tab", this.cpuCores);
        this.backgroundTasks.add(this.bgNotificationsLabel);
        this.backgroundTasks.add(this.bgNotifications);
        this.advancedGeneral.add("br hfill", this.backgroundTasks);
        ControlPanel advOpts = new ControlPanel((LayoutManager)new MigLayout("insets 0,wrap 2"));
        advOpts.add(this.useWatchdog);
        advOpts.add(this.videoSupported);
        if (Platform.isMac() || Platform.isLinux()) {
            advOpts.add(this.useNativeFileDialogs);
        }
        this.advancedGeneral.add("br", advOpts);
        this.advancedGeneral.add("p", this.supportedVideoFormatsLabel);
        this.advancedGeneral.add("br hfill vfill", new JScrollPane(this.supportedVideoFormats));
        this.imageReadersPanel.add("br hfill vfill", new JScrollPane(this.excludedImageReaders));
        this.imageWritersPanel.add("br hfill vfill", new JScrollPane(this.excludedImageWriters));
        Msg.maintainTranslated(this);
        ContextHelp help = ContextHelp.getInstance();
        help.installHelpButton(this, ContextHelp.Corner.TOP_RIGHT);
        help.add(this.general, "Preferences#General");
        help.add(this.explorer, "Preferences#Details_view");
        help.add(this.projects, "Preferences#Album");
        help.add(this.publishing, "Preferences#Publishing");
        help.add(this.search, "Preferences#Search");
        help.add(this.advanced, "Preferences#Advanced");
        help.add(this.imageReadersPanel, "Preferences#ImageIO");
        this.detailsViewFields.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                JPreferencesWindow.this.firePropertyChange("listViewFields", null, null);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                JPreferencesWindow.this.firePropertyChange("listViewFields", null, null);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                JPreferencesWindow.this.firePropertyChange("listViewFields", null, null);
            }
        });
    }

    public void loadPreferences() {
        if (AlbumProject.defaultProjectFile != null && AlbumProject.defaultProjectFile.exists()) {
            try {
                Properties props = IO.readPropertyFile(AlbumProject.defaultProjectFile);
                PropertyBinder.syncUI(props, this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        BeanBinder.getProperties((Object)Config.getConfig(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePreferences() {
        FileOutputStream fos = null;
        try {
            Config config = Config.getConfig();
            Properties visiblePreferences = PropertyBinder.getProperties(this);
            BeanBinder.setProperties(config, visiblePreferences);
            Properties allPreferences = BeanBinder.getProperties((Object)config, visiblePreferences);
            Properties defaults = new Properties();
            if (AlbumProject.defaultProjectFile.exists()) {
                defaults = IO.readPropertyFile(AlbumProject.defaultProjectFile);
            }
            defaults.putAll((Map<?, ?>)allPreferences);
            fos = new FileOutputStream(AlbumProject.defaultProjectFile);
            defaults.store(fos, "JAlbum Project");
            IO.close(fos);
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.parent.statusBar.setText(ex.getMessage());
        }
        finally {
            IO.close(fos);
        }
    }

    private void cancelPreferences() {
        try {
            Properties defaults = new Properties();
            if (AlbumProject.defaultProjectFile.exists()) {
                defaults = IO.readPropertyFile(AlbumProject.defaultProjectFile);
            }
            PropertyBinder.syncUI(defaults, this);
            BeanBinder.getProperties((Object)Config.getConfig(), this);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
            this.parent.statusBar.setText(ex.getMessage());
        }
    }

    private static Object[] fillLookAndFeels() {
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        Object[] result = new Object[lafInfo.length + 1];
        result[0] = new Item(LaF.getNameFromClassName(UIManager.getSystemLookAndFeelClassName()), Msg.get("prefs.systemDefault"));
        for (int i = 0; i < lafInfo.length; ++i) {
            result[i + 1] = new Item(lafInfo[i].getName(), lafInfo[i].getName());
        }
        return result;
    }

    private static Object[] fillCpuCores() {
        Object[] result = new Object[Runtime.getRuntime().availableProcessors()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i + 1;
        }
        return result;
    }

    void language_actionPerformed(ActionEvent e) {
        Item lang = (Item)this.language.getSelectedItem();
        String newLang = (String)lang.value;
        Config config = Config.getConfig();
        if (!config.getLanguage().equals(newLang)) {
            config.setLanguage(newLang);
            this.parent.ui2Engine();
            Msg.setTexts();
            this.parent.setTexts();
            this.parent.engine2UI();
        }
    }

    private static void makeSmaller(JComponent comp) {
        float size = comp.getFont().getSize2D() - 2.0f;
        if (size < 10.0f) {
            size = 10.0f;
        }
        comp.setFont(comp.getFont().deriveFont(size));
    }
}

