/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.JPropertyPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PhotoSphere;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.annotations.Text;

public class JPhotoSphereSettingsPanel
extends JPanel
implements EditListener,
JComponentHolder {
    private AlbumObject ao;
    private PluginContext context;
    private boolean showing = false;
    @Text(value="360image.pose", postfix=":")
    private JLabel poseLabel = new JPropertyPanel.JSmallLabel();
    @Text(value="360image.initialView", postfix=":")
    private JLabel initialViewLabel = new JPropertyPanel.JSmallLabel();
    @Text(value="360image.title")
    JCheckBox photoSphereCheckBox = new JCheckBox();
    @Text(value="360image.fieldOfView")
    JLabel fieldOfViewLabel = new JPropertyPanel.JSmallLabel();
    JSpinner fieldOfView = new JSpinner(new SpinnerNumberModel(70.0, 1.0, 360.0, 10.0));
    JSpinner poseHeading = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 360.0, 10.0));
    JSpinner posePitch = new JSpinner(new SpinnerNumberModel(0.0, -90.0, 90.0, 10.0));
    JSpinner poseRoll = new JSpinner(new SpinnerNumberModel(0.0, -180.0, 180.0, 10.0));
    JSpinner initialViewHeading = new JSpinner(new SpinnerNumberModel(0, 0, 360, 10));
    JSpinner initialViewPitch = new JSpinner(new SpinnerNumberModel(0, -90, 90, 10));
    JSpinner initialViewRoll = new JSpinner(new SpinnerNumberModel(0, -180, 180, 10));
    PhotoSphere.Model model = new PhotoSphere.Model();

    public JPhotoSphereSettingsPanel(PluginContext context) {
        this.context = context;
        this.init();
    }

    @Override
    public void setAlbumObject(AlbumObject ao) {
        this.save();
        this.ao = ao;
        if (ao == null || !PhotoSphere.isPotentialPhotoSphere(ao) && this.showing) {
            this.context.getEditPanel().removeCustomTab(this);
            this.showing = false;
            return;
        }
        if (PhotoSphere.isPotentialPhotoSphere(ao) && !this.showing) {
            this.context.getEditPanel().addCustomTab(Msg.get("360image.title"), this);
            this.showing = true;
        }
        this.model = new PhotoSphere.Model();
        XmpManager mgr = ao.getXmpManager();
        if (mgr != null) {
            try {
                this.model.read(mgr.getXMPMeta());
            }
            catch (XMPException ex) {
                Logger.getLogger(JPhotoSphereSettingsPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        BeanBinder.getProperties((Object)this.model, this);
        this.photoSphereCheckBox.setSelected(this.model.projectionType.equals("equirectangular"));
    }

    void save() {
        if (this.ao == null) {
            return;
        }
        XmpManager mgr = this.ao.getXmpManager();
        if (mgr != null) {
            try {
                PhotoSphere.Model test = new PhotoSphere.Model();
                BeanBinder.setProperties((Object)test, this);
                test.setProjectionType(this.photoSphereCheckBox.isSelected() ? "equirectangular" : "");
                if (!test.equals(this.model)) {
                    this.model = test;
                    this.model.write(mgr.getXMPMeta());
                    mgr.save(false);
                }
            }
            catch (XMPException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    private void init() {
        this.context.getEditPanel().addEditListener(this);
        Msg.maintainTranslated(this);
        this.setLayout(new RiverLayout(4, 0));
        FocusListener fl = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                JPhotoSphereSettingsPanel.this.save();
            }
        };
        this.photoSphereCheckBox.addActionListener(ae -> {
            if (!this.photoSphereCheckBox.isSelected()) {
                this.deletePhotoSphereXmpData();
            }
            this.save();
        });
        this.setFocusListener(this.fieldOfView, fl);
        this.setFocusListener(this.poseHeading, fl);
        this.setFocusListener(this.posePitch, fl);
        this.setFocusListener(this.poseRoll, fl);
        this.setFocusListener(this.initialViewHeading, fl);
        this.setFocusListener(this.initialViewPitch, fl);
        this.setFocusListener(this.initialViewRoll, fl);
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.photoSphereCheckBox, this.fieldOfViewLabel, this.fieldOfView, this.poseLabel, this.poseHeading, this.posePitch, this.poseRoll, this.initialViewLabel, this.initialViewHeading, this.initialViewPitch, this.initialViewRoll);
        this.add(this.photoSphereCheckBox);
        this.add("br", this.fieldOfViewLabel);
        this.add(this.fieldOfView);
        this.add("p", this.poseLabel);
        this.add("br", this.poseHeading);
        this.add("tab", this.posePitch);
        this.add("tab", this.poseRoll);
        this.add("p", this.initialViewLabel);
        this.add("br", this.initialViewHeading);
        this.add("tab", this.initialViewPitch);
        this.add("tab", this.initialViewRoll);
        this.setBackground(JAlbumColor.text);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.validate();
    }

    private void deletePhotoSphereXmpData() {
        XmpManager mgr = this.ao.getXmpManager();
        if (mgr != null) {
            XMPMeta meta = mgr.getXMPMeta();
            PhotoSphere.deleteXmpData(meta);
            try {
                mgr.save();
            }
            catch (IOException ex) {
                Logger.getLogger(JPhotoSphereSettingsPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void setFocusListener(JSpinner spinner, FocusListener fl) {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)spinner.getEditor();
        editor.getTextField().addFocusListener(fl);
    }
}

