/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.datadosen.component.JNotification;
import se.datadosen.component.VerticalLayout;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NotificationManager;

public class JNotificationsPopup
extends JPanel
implements PropertyChangeListener {
    private JPanel panel = new JPanel(new VerticalLayout()){

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = 350;
            return size;
        }
    };
    private List<JNotification> notifications;
    private NotificationManager manager;
    private boolean showMessage = false;

    public JNotificationsPopup(NotificationManager manager) {
        this.manager = manager;
        this.notifications = manager.getOldNotifications();
        this.init();
    }

    public void updateNotifications() {
        this.notifications = this.manager.getOldNotifications();
        this.panel.removeAll();
        this.updatePanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JNotification source = (JNotification)evt.getSource();
        this.manager.removeOldNotification(source);
    }

    public void show(Component invoker, int x, int y) {
        Window win = SwingUtilities.windowForComponent(invoker);
        if (!(win instanceof JFrame)) {
            throw new RuntimeException("Invoker must be instance of JFrame");
        }
        JFrame frame = (JFrame)win;
        Point invokerLoc = invoker.getLocationOnScreen();
        Rectangle winBounds = frame.getBounds();
        Rectangle rootBounds = frame.getRootPane().getBounds();
        Point p = new Point(invokerLoc.x - winBounds.x - rootBounds.x + x, invokerLoc.y - winBounds.y - rootBounds.y + y);
        Rectangle panelBounds = this.panel.getBounds();
        if (p.x + panelBounds.width > rootBounds.width) {
            p.x -= p.x + panelBounds.width - rootBounds.width;
        }
        this.panel.setLocation(p.x, p.y);
        frame.setGlassPane(this);
        this.setVisible(true);
        if (this.notifications.isEmpty()) {
            this.showMessage = true;
        }
        for (JNotification notification : this.notifications) {
            notification.setShownInPopup(notification.isDismissed());
        }
        this.updatePanel();
    }

    private void init() {
        this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(JAlbumColor.controlShadow), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        JNotificationsPopup.this.setVisible(false);
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JNotificationsPopup.this.setVisible(false);
            }
        });
        this.setLayout(null);
        this.add(this.panel);
        this.updatePanel();
        this.setOpaque(false);
    }

    private void updatePanel() {
        if (this.notifications.isEmpty()) {
            if (this.showMessage) {
                this.panel.removeAll();
                JLabel label = new JLabel(Msg.get("ui.noNotifications"));
                label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                this.panel.add(label);
                this.showMessage = false;
            } else {
                this.setVisible(false);
            }
        } else {
            for (JNotification notification : this.notifications) {
                notification.setVisible(true);
                this.panel.add(notification);
                notification.removePropertyChangeListener("dismissed", this);
                notification.addPropertyChangeListener("dismissed", this);
            }
        }
        this.panel.validate();
        this.panel.setSize(this.panel.getPreferredSize());
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

