/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.jalbum.projectgroups.ProjectGroups;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.JAlbumTagsField;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.FileNameDocument;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.Debug;

public class JNewProjectDialog
extends JSmartDialog {
    private final Action changeDefaultsAction = new AbstractAction(Msg.get("ui.changeDefaults")){
        {
            this.putValue("ShortDescription", Msg.get("ui.changeDefaultsToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JNewProjectDialog.this.setVisible(false);
            JAlbumFrame window = (JAlbumFrame)JNewProjectDialog.this.getOwner();
            window.show(window.preferencesWindow);
            window.preferencesWindow.tabs.setSelectedComponent(window.preferencesWindow.projects);
        }
    };
    private JLabel albumNameLabel = new JLabel(Msg.get("newproject.albumNameLabel"));
    private JSmartTextField albumName = new JSmartTextField(20);
    private JLabel albumTagsLabel = new JLabel(Msg.get("edit.albumTags"));
    private JAlbumTagsField albumTags = new JAlbumTagsField(20);
    private JLabel albumDescriptionLabel = new JLabel(Msg.get("edit.albumDescription"));
    private JTextArea albumDescription = (JTextArea)((JSmartTextArea)((JSmartTextArea)new JSmartTextArea(3, 20).spelling()).setAllowHTMLEditing(true)).setFullHTMLEditing(true);
    private JLabel albumLocationLabel = new JLabel(Msg.get("newproject.albumLocationLabel"));
    private JTextField albumLocation = new JTextField(20);
    private JButton browseButton = new JButton(Icons.small("open-folder"));
    private DirectoryChooser albumLocationChooser = ChooserFactory.createDirectoryChooser(this);
    private JLinkLabel changeDefaultLink = new JLinkLabel(this.changeDefaultsAction);
    private List files;
    private int dropAction;
    Action okAction;
    Action cancelAction;
    private boolean isCancelled;

    public JNewProjectDialog(Frame parent) {
        super(parent, Msg.get("newproject.title"), true);
        this.initComponents();
        Tracer.getInstance().trace("new project dialog presented");
    }

    public void setAlbumName(String albumName) {
        this.albumName.setText(albumName);
        this.fixUIDisabling();
    }

    public void setFiles(List files, int dropAction) {
        this.files = files;
        this.dropAction = dropAction;
    }

    private File getProjectDirectory() {
        return new File(this.albumLocation.getText() + File.separator + this.albumName.getText().trim()).getAbsoluteFile();
    }

    private void initComponents() {
        this.setResizable(false);
        this.albumTagsLabel.setToolTipText(Msg.get("edit.albumTagsToolTip"));
        File projectGroupLocation = ProjectGroups.getInstance().getNewProjectLocation();
        this.albumLocationChooser.setCurrentDirectory(projectGroupLocation);
        this.albumLocation.setText(projectGroupLocation.getAbsolutePath());
        this.okAction = new AbstractAction(Msg.get("ok")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File projectDirectory = JNewProjectDialog.this.getProjectDirectory();
                    if (!projectDirectory.exists()) {
                        projectDirectory.mkdirs();
                    } else if (projectDirectory.listFiles() != null && projectDirectory.listFiles().length > 0) {
                        int result = JOptionPane.showConfirmDialog(JNewProjectDialog.this, new Object[]{Msg.get("newProject.projectAlreadyExistsError", JNewProjectDialog.this.albumName.getText().trim()), Msg.get("ui.OpenProjectQuestion")}, Msg.get("newproject.title"), 0, 2);
                        if (result == 0) {
                            JNewProjectDialog.this.setVisible(false);
                            JNewProjectDialog.this.dispose();
                            ArrayList<File> files = new ArrayList<File>();
                            files.add(projectDirectory);
                            ((JAlbumFrame)JNewProjectDialog.this.getOwner()).addFiles(files);
                        }
                        return;
                    }
                    if (projectDirectory.listFiles() == null) {
                        throw new IOException("Can't create directory " + projectDirectory.getName());
                    }
                    JNewProjectDialog.this.setVisible(false);
                    JNewProjectDialog.this.dispose();
                    ((JAlbumFrame)JNewProjectDialog.this.getOwner()).initProject(JNewProjectDialog.this.getProjectDirectory());
                    AlbumObject root = ((JAlbumFrame)JNewProjectDialog.this.getOwner()).albumExplorer.getRootFolder();
                    try {
                        root.setComment(JNewProjectDialog.this.albumDescription.getText());
                        AlbumObjectProperties props = root.getProperties();
                        props.put("tags", JNewProjectDialog.this.albumTags.getText());
                        props.save();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                    ((JAlbumFrame)JNewProjectDialog.this.getOwner()).saveProject(new File(JNewProjectDialog.this.getProjectDirectory(), "jalbum-settings.jap"));
                    if (JNewProjectDialog.this.files != null && JNewProjectDialog.this.files.size() > 0) {
                        JAlbum.mainFrame.albumExplorer.explorer.handleFileAdd(JNewProjectDialog.this.files, JNewProjectDialog.this.dropAction, true);
                    }
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JNewProjectDialog.this, ex);
                }
            }
        };
        this.cancelAction = new AbstractAction(Msg.get("cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JNewProjectDialog.this.setVisible(false);
                JNewProjectDialog.this.dispose();
                JNewProjectDialog.this.isCancelled = true;
            }
        };
        this.initEventListeners();
        this.albumName.setDocument(new FileNameDocument());
        this.albumName.spelling();
        this.albumNameLabel.setLabelFor(this.albumName);
        this.albumTagsLabel.setLabelFor(this.albumTags);
        this.albumDescriptionLabel.setLabelFor(this.albumDescription);
        this.albumLocationLabel.setLabelFor(this.albumLocation);
        this.albumDescription.setFocusTraversalKeys(0, null);
        this.albumDescription.setFocusTraversalKeys(1, null);
        this.albumDescription.setLineWrap(true);
        this.albumDescription.setWrapStyleWord(true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 6, 4, 6));
        content.add((Component)new JLabel(Icons.get("new_album")), "Before");
        ControlPanel rightPanel = new ControlPanel();
        rightPanel.add(this.albumNameLabel);
        rightPanel.add("br", this.albumName);
        rightPanel.add("p", this.albumDescriptionLabel);
        rightPanel.add("br hfill", new JScrollPane(this.albumDescription));
        rightPanel.add("p", this.albumTagsLabel);
        rightPanel.add("br hfill", this.albumTags);
        content.add((Component)rightPanel, "Center");
        JPanel moreContent = new JPanel(new RiverLayout());
        JCollapsiblePanel cp = new JCollapsiblePanel(Msg.get("ui.more"), moreContent);
        cp.addPropertyChangeListener("expanded", evt -> this.pack());
        cp.setBackground(Color.yellow);
        moreContent.setLayout(new RiverLayout());
        moreContent.add(this.albumLocationLabel);
        moreContent.add("br hfill", this.albumLocation);
        moreContent.add(this.browseButton);
        moreContent.add("br", this.changeDefaultLink);
        content.add((Component)cp, "South");
        this.getContentPane().add((Component)content, "Center");
        this.registerActions(this.okAction, this.cancelAction);
        this.fixUIDisabling();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private void fixUIDisabling() {
        this.okAction.setEnabled(this.albumName.getText().trim().length() > 0);
    }

    private void initEventListeners() {
        this.albumName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JNewProjectDialog.this.fixUIDisabling();
            }
        });
        this.browseButton.addActionListener(evt -> {
            this.albumLocationChooser.setCurrentDirectory(new File(this.albumLocation.getText()));
            if (this.albumLocationChooser.showOpenDialog(this) == 0) {
                this.albumLocation.setText(this.albumLocationChooser.getSelectedFile().getAbsolutePath());
            }
        });
    }
}

