/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import digfx.util.FXBinder;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.jalbum.util.Profiler;
import net.miginfocom.swing.MigLayout;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JFallbackLabel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JNotification;
import se.datadosen.component.JPopupButton;
import se.datadosen.component.JSmartComboBox;
import se.datadosen.component.JSmartSeparator;
import se.datadosen.component.JToolBarButton;
import se.datadosen.component.MarginIcon;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.JHtmlBox;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.LicenseManagerImpl;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinComboBoxModel;
import se.datadosen.jalbum.SkinLoadingThread;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.StyleFileFilter;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.tags.ElementException;
import se.datadosen.util.AliasAction;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.NameValue;
import se.datadosen.util.Platform;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.VersionNumber;
import se.datadosen.util.WorkCounter;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JMainSettingsPanel
extends JPanel
implements JComponentHolder {
    private JAlbumFrame parent;
    @Text(value="ui.skinAndStyle")
    JLabel skinAndStyleLabel = new JFallbackLabel();
    JComboBox skin = new JSmartComboBox(new SkinComboBoxModel()){

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject == SkinComboBoxModel.moreSkins) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        BrowserLauncher.openURL(JAlbumSite.getInstance().getSkinsUrl() + "/?utm_source=client&utm_medium=downloadSkinsLink&utm_campaign=skinChooser");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JMainSettingsPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
            } else {
                super.setSelectedItem(anObject);
            }
        }
    };
    @Text(value="ui.makeAlbum")
    @ToolTipText(value="ui.makeInBackground")
    @Icon(value="20x20/btn-make-bg.svg")
    Action makeInBackgroundAction;
    @Text(value="ui.upload")
    @ToolTipText(value="ui.uploadInBackground")
    @Icon(value="20x20/btn-upload-bg.svg")
    Action uploadInBackgroundAction;
    @Icon(value="20x20/btn-make.svg")
    Action makeAction;
    @Icon(value="20x20/btn-upload.svg")
    Action uploadAction;
    JComboBox style = new JSmartComboBox();
    JLinkLabel moreSkinsLink = new JLinkLabel();
    private JRadioButton makeChanges = new JRadioButton();
    private JRadioButton makeAll = new JRadioButton();
    public ButtonGroup appendImages = new ButtonGroup(){
        {
            this.add(JMainSettingsPanel.this.makeChanges);
            this.add(JMainSettingsPanel.this.makeAll);
            JMainSettingsPanel.this.makeAll.setSelected(true);
            JMainSettingsPanel.this.makeChanges.setActionCommand("true");
            JMainSettingsPanel.this.makeAll.setActionCommand("false");
        }
    };
    private JCollapsiblePanel collapsiblePanel = new JCollapsiblePanel((LayoutManager)new MigLayout());
    public JPopupButton makeAlbumButton;
    private JPopupButton publishButton;
    JButton previewButton;
    private JButton previewRemoteButton;
    private JButton settingsButton;
    private PropertyChangeListener rootPropertyListener;
    private MouseListener skinsScanner = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            JMainSettingsPanel.this.scanSkins();
        }
    };
    private PopupMenuListener skinPreviewer = new PopupMenuListener(){

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JMainSettingsPanel.this.parent.setSkinGlassPane();
            JMainSettingsPanel.this.parent.setPreviewImage();
            JMainSettingsPanel.this.parent.previewPanel.setVisible(true);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            JMainSettingsPanel.this.parent.previewPanel.setVisible(false);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    };
    SkinLoadingThread scheduledOnLoadThread;
    ActionListener skinSelectedActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int answer;
            JMainSettingsPanel.this.parent.albumExplorer.updateStatusBar();
            String oldSkin = JMainSettingsPanel.this.parent.engine.getSkin();
            SkinProperties oldSkinProperties = JMainSettingsPanel.this.parent.engine.getSkinProperties();
            String oldFamily = oldSkinProperties.getProperty("skinFamily", oldSkin);
            JMainSettingsPanel.this.parent.abortCurrentSkinLoading();
            JMainSettingsPanel.this.loadCounter.workStarted();
            JMainSettingsPanel.this.parent.configureCounter.workStarted();
            NameValue selectedSkin = (NameValue)JMainSettingsPanel.this.skin.getSelectedItem();
            JMainSettingsPanel.this.parent.engine.setSkin(selectedSkin.name);
            Tracer.getInstance().trace("skin selected", selectedSkin.name);
            JMainSettingsPanel.this.parent.fireSkinChanged(new JAlbumEvent(this));
            this.checkForSkinUpdate();
            JMainSettingsPanel.this.parent.setSkinUI(null);
            Object selectedStyle = JMainSettingsPanel.this.style.getSelectedItem();
            JMainSettingsPanel.this.style.removeActionListener(JMainSettingsPanel.this.styleSelectedActionListener);
            JMainSettingsPanel.this.style.removeAllItems();
            File skinDir = (File)selectedSkin.value;
            SkinProperties sp = JMainSettingsPanel.this.parent.engine.getSkinProperties();
            JMainSettingsPanel.this.parent.settingsWindow.thumbnailLayoutPanel.setEnabled(sp.isEnableThumbnailLayout());
            JMainSettingsPanel.this.parent.settingsWindow.thumbnailLayoutPanel.setToolTipText(sp.isEnableThumbnailLayout() ? "" : Msg.get("ui.notUsedBySkin"));
            File slideTemplateFile = new File(skinDir, "slide.htt");
            JMainSettingsPanel.this.parent.settingsWindow.slides.setEnabled(slideTemplateFile.exists() && slideTemplateFile.length() > 0L);
            JMainSettingsPanel.this.disabledControls.remove("thumbnailLayoutPanel");
            JMainSettingsPanel.this.disabledControls.remove("slides");
            JMainSettingsPanel.this.handleUIDisabling(sp);
            JMainSettingsPanel.this.parent.settingsWindow.variantsPanel.setVisible(sp.isSupportsVariants());
            JMainSettingsPanel.this.parent.settingsWindow.noVariantSupportLabel.setVisible(!sp.isSupportsVariants());
            boolean supportsFolderImages = "true".equals(sp.getProperty("supportsFolderThumbs"));
            JMainSettingsPanel.this.parent.settingsWindow.folderThumbSizeLabel.setVisible(supportsFolderImages);
            JMainSettingsPanel.this.parent.settingsWindow.folderThumbSize.setVisible(supportsFolderImages);
            JMainSettingsPanel.this.parent.settingsWindow.processFolderThumbs.setVisible(supportsFolderImages);
            JMainSettingsPanel.this.parent.skinVersion = sp.getVersion();
            JAlbumUtilities.fillCombo(JMainSettingsPanel.this.style, new File(skinDir, "styles"), (FileFilter)new StyleFileFilter());
            JMainSettingsPanel.this.style.setSelectedItem(selectedStyle);
            if (JMainSettingsPanel.this.style.getSelectedIndex() == -1 && JMainSettingsPanel.this.style.getItemCount() > 0) {
                JMainSettingsPanel.this.style.setSelectedIndex(0);
            }
            JMainSettingsPanel.this.style.addActionListener(JMainSettingsPanel.this.styleSelectedActionListener);
            if (JMainSettingsPanel.this.parent.albumExplorer.isProjectLoaded() && !selectedSkin.name.equals(oldSkin) && oldFamily.equals(sp.getProperty("skinFamily"))) {
                System.out.println("Ignoring skin hints. Same family: " + oldFamily);
                JMainSettingsPanel.this.parent.engine.setSkinVariables(JMainSettingsPanel.this.parent.engine.getSkinVariables());
            } else {
                JMainSettingsPanel.this.parent.applyHints();
            }
            File skinDefaultsFile = JMainSettingsPanel.this.parent.getSkinDefaultsFile();
            if (!JMainSettingsPanel.this.parent.loadingProject && e != null && (e.getModifiers() & 8) == 0 && skinDefaultsFile.exists()) {
                try {
                    Properties defaults = IO.readPropertyFile(skinDefaultsFile);
                    JAlbumFrame cfr_ignored_0 = JMainSettingsPanel.this.parent;
                    JAlbumFrame.removeProjectSpecific(defaults);
                    JMainSettingsPanel.this.parent.engine.setProperties(defaults);
                    JMainSettingsPanel.this.parent.engine2UI();
                    JMainSettingsPanel.this.parent.statusBar.setText(Msg.get("ui.skinDefaultsApplied"));
                }
                catch (IOException ex) {
                    Logger.getLogger(JMainSettingsPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            String req = sp.getProperty("requiredJalbumVersion");
            VersionNumber current = new VersionNumber(AlbumBean.getInternalVersion());
            if (req != null && current.compareTo(new VersionNumber(req)) < 0 && (answer = JOptionPane.showConfirmDialog(JMainSettingsPanel.this.parent, Msg.get("ui.upgradeRecommended", selectedSkin, req), Msg.get("ui.upgradeRecommendedTitle"), 0, 2)) == 0) {
                try {
                    Object uic = "";
                    LicenseManager mgr = JAlbumContext.getInstance().getLicenseManager();
                    if (mgr.isLicenseValid() && ((LicenseManagerImpl)mgr).getUIC() != null) {
                        uic = (String)uic + "&uic=" + ((LicenseManagerImpl)mgr).getUIC();
                    }
                    BrowserLauncher.openURL(JAlbumSite.getTrueInstance().getUpgradeUrl() + "?utm_source=client&utm_medium=yesButton&utm_campaign=skinNeedsUpdatedJAlbum" + (String)uic);
                    JMainSettingsPanel.this.parent.doExit();
                }
                catch (IOException | ElementException uic) {
                    // empty catch block
                }
            }
            JMainSettingsPanel.this.parent.settingsWindow.setPreferredSize(null);
            final String mainClassName = sp.getProperty("mainClass");
            final File onLoadScript = AlbumBean.resolveScriptFile((File)selectedSkin.value, "onload");
            if (onLoadScript.exists() || mainClassName != null) {
                final String statusMessage = Msg.get("ui.loadingSkinInfo", selectedSkin) + "...";
                JMainSettingsPanel.this.parent.statusBar.pushText(statusMessage);
                JMainSettingsPanel.this.parent.progressSpinner.workStarted();
                JMainSettingsPanel.this.parent.actions.makeAction.setEnabled(false);
                JMainSettingsPanel.this.parent.actions.forceRebuildAction.setEnabled(false);
                JMainSettingsPanel.this.parent.actions.makeTestAction.setEnabled(false);
                JMainSettingsPanel.this.interruptSkinLoading();
                JMainSettingsPanel.this.scheduledOnLoadThread = new SkinLoadingThread(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.setDaemon(true);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = JAlbum.initializedOkMonitor;
                        synchronized (object) {
                            Stopwatch sw = new Stopwatch("Skin loading");
                            sw.start();
                            try (Profiler.Sample _s = Profiler.profile("Skin loading");){
                                Map<String, Object> controls = null;
                                if (mainClassName != null) {
                                    URLClassLoader cl = this.this$1.JMainSettingsPanel.this.parent.engine.getScriptEnvironment().classLoader;
                                    Class<?> mainClazz = cl.loadClass(mainClassName);
                                    Object main = mainClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                    if (main instanceof JAlbumPlugin) {
                                        ((JAlbumPlugin)main).init(this.this$1.JMainSettingsPanel.this.parent.context.getPluginContext());
                                    }
                                } else if (onLoadScript.exists()) {
                                    this.this$1.JMainSettingsPanel.this.parent.engine.initInterpreter();
                                    this.this$1.JMainSettingsPanel.this.parent.executeScript(onLoadScript, controls);
                                }
                            }
                            catch (InvocationTargetException ex) {
                                Debug.showErrorDialog(this.this$1.JMainSettingsPanel.this.parent, ex.getCause());
                            }
                            catch (ReflectiveOperationException ex) {
                                Debug.showErrorDialog(this.this$1.JMainSettingsPanel.this.parent, ex);
                            }
                            finally {
                                SwingUtilities.invokeLater(() -> {
                                    this.this$1.JMainSettingsPanel.this.parent.statusBar.popText(statusMessage);
                                    this.this$1.JMainSettingsPanel.this.parent.progressSpinner.workDone();
                                    this.this$1.JMainSettingsPanel.this.parent.directorySelected();
                                });
                                this.this$1.JMainSettingsPanel.this.loadCounter.workDone();
                                this.this$1.JMainSettingsPanel.this.parent.configureCounter.workDone();
                                sw.print();
                                this.this$1.JMainSettingsPanel.this.parent.changeStatus.refresh();
                            }
                        }
                    }
                };
                JMainSettingsPanel.this.scheduledOnLoadThread.start();
            } else {
                JMainSettingsPanel.this.loadCounter.workDone();
                JMainSettingsPanel.this.parent.configureCounter.workDone();
                JMainSettingsPanel.this.parent.fireSkinLoaded();
            }
        }

        private void checkForSkinUpdate() {
            new Thread("Skin update checker"){

                @Override
                public void run() {
                    try {
                        SkinProperties skinProps = JMainSettingsPanel.this.parent.engine.getSkinProperties();
                        String iv = skinProps.getProperty("version");
                        if (iv != null) {
                            VersionNumber installedVersion = new VersionNumber(iv);
                            SkinProperties.RepositoryProperties rp = skinProps.getRepositoryProperties();
                            if (rp.getCurrentVersion().compareTo(installedVersion) > 0) {
                                final String skinName = JMainSettingsPanel.this.parent.engine.getSkin();
                                final JNotification n = new JNotification();
                                n.setType(JNotification.Type.SKIN);
                                Object msg = Msg.get("ui.newSkinUpdate", skinName, rp.getCurrentVersion(), rp.getFormattedLastUpdated(), URLDecoder.decode(rp.getSkinPage(), "UTF-8"), installedVersion, JAlbumSite.getInstance().getSkinDownloadUrl(skinName));
                                if (rp.getRequiredJAlbumVersion() != null && rp.getRequiredJAlbumVersion().compareTo(new VersionNumber(AlbumBean.getInternalVersion())) > 0) {
                                    msg = (String)msg + ". " + Msg.get("ui.requiresJAlbumVersion", rp.getRequiredJAlbumVersion());
                                }
                                JHtmlBox box = new JHtmlBox(this, (String)msg){
                                    final /* synthetic */ 2 this$2;
                                    {
                                        this.this$2 = this$2;
                                        super(htmlText);
                                    }

                                    @Override
                                    protected void linkActivated(HyperlinkEvent e) {
                                        String address = e.getURL().toExternalForm();
                                        if (address.equals(JAlbumSite.getInstance().getSkinDownloadUrl(skinName))) {
                                            SkinManager sm = new SkinManager();
                                            n.abortButton.doClick();
                                            sm.installSkin(skinName, e.getURL(), null);
                                        } else {
                                            super.linkActivated(e);
                                        }
                                    }
                                };
                                n.setContent(box);
                                n.setPriority(JNotification.Priority.HIGH);
                                n.setExpiration(15);
                                n.setRememberDismissed(true);
                                n.setCloseButtonToolTipText(Msg.get("ui.dontShowAgainForThisVersion"));
                                if (!n.isDismissedBefore()) {
                                    JMainSettingsPanel.this.parent.showNotification(n);
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    };
    private final Map<String, String> disabledControls = new HashMap<String, String>();
    ActionListener styleSelectedActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e != null && !"comboBoxChangedDuringProjectLoading".equals(e.getActionCommand())) {
                JMainSettingsPanel.this.parent.setPreviewImage();
                Item item = (Item)JMainSettingsPanel.this.style.getSelectedItem();
                if (item != null) {
                    JMainSettingsPanel.this.styleChanged((String)item.item);
                }
                JMainSettingsPanel.this.parent.fireStyleChanged(new JAlbumEvent(JMainSettingsPanel.this.parent));
            } else {
                JMainSettingsPanel.this.skin.setActionCommand("comboBoxChanged");
            }
        }
    };
    private WorkCounter loadCounter = new WorkCounter();

    private void handleUIDisabling(SkinProperties sp) {
        this.parent.binder.walkComponents((name, comp) -> {
            if (this.disabledControls.keySet().contains(name)) {
                ComponentUtilities.removeEnabledVeto(comp, this.parent);
                comp.setEnabled(!ComponentUtilities.isEnabledVetoed(comp));
                comp.setToolTipText(this.disabledControls.get(name));
            }
        });
        this.disabledControls.clear();
        HashSet<Object> disabledNames = new HashSet<Object>();
        for (String disabledName : sp.getProperty("disabledControls", "").split(",\\s?")) {
            disabledNames.add(disabledName);
            disabledNames.add(disabledName + "Label");
        }
        if (!disabledNames.isEmpty()) {
            this.parent.binder.walkComponents((name, comp) -> {
                if (disabledNames.contains(name)) {
                    this.disabledControls.put((String)name, comp.getToolTipText());
                    comp.setEnabled(false);
                    comp.setToolTipText(Msg.get("ui.disabledBySkin"));
                    ComponentUtilities.addEnabledVeto(comp, this.parent);
                }
            });
        }
    }

    void styleChanged(String styleName) {
        this.parent.engine.setStyle(styleName);
        NameValue selectedSkin = (NameValue)this.skin.getSelectedItem();
        File skinDir = (File)selectedSkin.value;
        File styleDir = new File(skinDir, "styles");
        File hintsFile = new File(styleDir, styleName + ".jap");
        if (hintsFile.exists() && this.parent.preferencesWindow.useLayoutHints.isSelected() && !this.parent.isLoadingProject()) {
            try {
                Properties styleHints = IO.readPropertyFile(hintsFile);
                Map vars = new HashMap();
                Map<Object, Object> skinVars = new HashMap();
                if (!this.parent.context.getLicenseManager().isLicenseValid() && this.parent.freeSettings != null) {
                    vars = this.parent.freeSettings.main;
                    skinVars = this.parent.freeSettings.skin;
                }
                vars.putAll(JAlbumUtilities.getOrdinaryVariables(styleHints));
                skinVars.putAll(JAlbumUtilities.getSkinVariables(styleHints));
                Object ui = this.parent.getSkinUI();
                if (ui != null) {
                    if (ui instanceof JComponentHolder) {
                        PropertyBinder.syncUI(skinVars, (JComponentHolder)ui);
                    } else if (ui instanceof Parent) {
                        FXBinder.syncUI(skinVars, (Node)((Parent)ui));
                    }
                }
                PropertyBinder.syncUI(vars, this.parent.settingsWindow);
                if (!BeanBinder.isSynchingUI()) {
                    this.parent.ui2Engine();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public boolean isLoadingSkin() {
        return this.loadCounter.getCount() > 0;
    }

    void interruptSkinLoading() {
        if (this.scheduledOnLoadThread != null && this.scheduledOnLoadThread.isAlive()) {
            System.out.println("Interrupting");
            this.scheduledOnLoadThread.abort();
        }
    }

    public JMainSettingsPanel(JAlbumFrame frame) {
        this.parent = frame;
        this.init();
    }

    public void reloadSkin() {
        this.parent.reloadSkin();
    }

    private void init() {
        this.makeInBackgroundAction = new AliasAction(this.parent.actions.makeInBackgroundAction);
        this.uploadInBackgroundAction = new AliasAction(this.parent.actions.uploadInBackgroundAction);
        this.makeAction = new AliasAction(this.parent.actions.makeAction);
        this.uploadAction = new AliasAction(this.parent.actions.publishAction);
        Msg.maintainTranslated(this);
        this.scanSkins();
        if (!Platform.isMac()) {
            this.skin.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.skin.addActionListener(evt -> {
                JComboBox combo = (JComboBox)evt.getSource();
                combo.hidePopup();
            });
        }
        this.skinAndStyleLabel.setFont(JAlbumFrame.TITLE_FONT);
        this.skin.getComponent(0).addMouseListener(this.skinsScanner);
        this.skin.addPopupMenuListener(this.skinPreviewer);
        this.style.addPopupMenuListener(this.skinPreviewer);
        this.previewButton = new JToolBarButton(this.parent.actions.viewAlbumAction, false);
        this.previewRemoteButton = new JToolBarButton(this.parent.actions.viewRemoteAlbumAction, false);
        this.settingsButton = new JButton(this.parent.actions.settingsAction);
        this.settingsButton.setIcon(new MarginIcon(2, Icons.get("btn-settings", 20)));
        PropertyChangeListener rootListener = evt -> {
            AlbumObject root = this.parent.albumExplorer.getRootFolder();
            this.rootPropertyListener = evt1 -> {
                String albumURL = (String)root.getProperties().get("albumURL");
                boolean isPublished = albumURL != null;
                this.parent.actions.viewRemoteAlbumAction.setEnabled(isPublished);
                this.parent.actions.viewRemoteAlbumAction.putValue("Name", isPublished ? Msg.get("ui.publishedTo", albumURL) : Msg.get("ui.notPublished"));
                this.parent.actions.viewRemoteAlbumAction.putValue("ShortDescription", isPublished ? Msg.get("ui.publishedTo", albumURL) : Msg.get("ui.notPublished"));
                this.parent.albumExplorer.shareModeAction.setEnabled(isPublished);
                boolean projectLoaded = root != null && root.getName().length() > 0;
                boolean showToolTip = isPublished || !projectLoaded;
                this.parent.albumExplorer.shareModeAction.putValue("ShortDescription", showToolTip ? null : Msg.get("ui.notPublished"));
            };
            this.rootPropertyListener.propertyChange(null);
            root.getProperties().addPropertyChangeListener(this.rootPropertyListener);
        };
        this.parent.addPropertyChangeListener("rootFolder", rootListener);
        DropTarget skinDropTarget = new DropTarget(){

            @Override
            public void dragEnter(DropTargetDragEvent e) {
                if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.acceptDrag(1);
                } else {
                    e.rejectDrag();
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
                if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.acceptDrag(1);
                } else {
                    e.rejectDrag();
                }
            }

            @Override
            public void dragExit(DropTargetEvent e) {
            }

            @Override
            public void drop(DropTargetDropEvent e) {
                if (!e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.rejectDrop();
                    return;
                }
                e.acceptDrop(1);
                try {
                    List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    e.dropComplete(true);
                    final File f = (File)files.get(0);
                    String name = f.getName().toLowerCase();
                    if (name.endsWith(".zip") || name.endsWith(".jaskin")) {
                        new Thread(this){
                            final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = this$1;
                                this.setDaemon(true);
                            }

                            @Override
                            public void run() {
                                SkinManager sm = new SkinManager();
                                sm.installSkin(f);
                            }
                        }.start();
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    e.dropComplete(false);
                    Debug.showErrorDialog(JMainSettingsPanel.this, ex);
                }
            }
        };
        this.skin.setDropTarget(skinDropTarget);
        ListCellRenderer defaultRenderer = this.skin.getRenderer();
        this.skin.setRenderer((list, obj, index, isSelected, cellHasFocus) -> {
            Component comp = defaultRenderer.getListCellRendererComponent(list, obj, index, isSelected, cellHasFocus);
            if (obj == SkinComboBoxModel.moreSkins) {
                comp.setForeground(JAlbumColor.linkText);
                return comp;
            }
            NameValue item = (NameValue)obj;
            if (isSelected && !cellHasFocus) {
                this.parent.setPreviewImage(item, this.getDefaultStyleForSkin((File)item.value));
            }
            if (obj != null) {
                Config cfg = Config.getConfig();
                File skinDir = (File)item.value;
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    if (skinDir.getParentFile().equals(cfg.chainedSkinsDir.getDirectory())) {
                        label.setFont(label.getFont().deriveFont(1));
                    }
                }
            }
            return comp;
        });
        ListCellRenderer styleRenderer = this.style.getRenderer();
        this.style.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            if (isSelected && !cellHasFocus && value != null) {
                this.parent.setPreviewImage((NameValue)this.skin.getSelectedItem(), value.toString());
            }
            return styleRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        });
        this.setupPanel();
    }

    private static void setSmallerFont(JComponent comp) {
        Font f = comp.getFont();
        comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
    }

    private void updatePublishPopupMenu() {
        JPopupMenu menu = this.publishButton.getPopup();
        menu.removeAll();
        AccountManager manager = AccountManager.getInstance();
        ButtonGroup bg = new ButtonGroup();
        try {
            menu.add(this.parent.actions.showPublishWindowAction);
            menu.add(this.parent.actions.uploadInBackgroundAction);
            menu.addSeparator();
            DefaultListModel accounts = manager.getAccounts();
            Enumeration e = accounts.elements();
            while (e.hasMoreElements()) {
                AccountProfile a = (AccountProfile)e.nextElement();
                JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(a.getName());
                menuItem.addActionListener(e1 -> JAlbumContext.getInstance().getEngine().setAccountProfileName(e1.getActionCommand()));
                bg.add(menuItem);
                menu.add(menuItem);
            }
            this.setSelectedAccountProfile();
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    private void setSelectedAccountProfile() {
        JRadioButtonMenuItem item;
        if (JAlbumContext.getInstance().getEngine() == null) {
            return;
        }
        JPopupMenu menu = this.publishButton.getPopup();
        AccountManager mgr = AccountManager.getInstance();
        String selectedAccountProfile = JAlbumContext.getInstance().getEngine().getAccountProfileName();
        for (Component comp : menu.getComponents()) {
            if (!(comp instanceof JRadioButtonMenuItem) || !(item = (JRadioButtonMenuItem)comp).getText().equals(selectedAccountProfile)) continue;
            item.setSelected(true);
            return;
        }
        for (Component comp : menu.getComponents()) {
            if (!(comp instanceof JRadioButtonMenuItem)) continue;
            item = (JRadioButtonMenuItem)comp;
            item.setSelected(true);
            return;
        }
    }

    private void setupButtons() {
        if (Config.getConfig().isBackgroundMode()) {
            this.makeAlbumButton.setAction(this.makeInBackgroundAction);
            this.publishButton.setAction(this.uploadInBackgroundAction);
        } else {
            this.makeAlbumButton.setAction(this.makeAction);
            this.makeAlbumButton.setToolTipText(null);
            this.publishButton.setAction(this.uploadAction);
        }
        this.makeAlbumButton.setIcon(new MarginIcon(2, this.makeAlbumButton.getIcon()));
        this.publishButton.setIcon(new MarginIcon(2, this.publishButton.getIcon()));
    }

    private void setupPanel() {
        if (Platform.isMac()) {
            JMainSettingsPanel.setSmallerFont(this.skin);
            JMainSettingsPanel.setSmallerFont(this.style);
            JMainSettingsPanel.setSmallerFont(this.moreSkinsLink);
            JMainSettingsPanel.setSmallerFont(this.makeAll);
            JMainSettingsPanel.setSmallerFont(this.makeChanges);
        }
        this.makeAlbumButton = new JPopupButton();
        this.makeAlbumButton.add(this.parent.actions.makeAction);
        this.makeAlbumButton.add(this.parent.actions.makeInBackgroundAction);
        this.makeAlbumButton.add(this.parent.actions.makeAndUploadInBackgroundAction);
        this.makeAlbumButton.add(new JSeparator());
        this.makeAlbumButton.add(this.parent.actions.forceRebuildAction);
        this.makeAlbumButton.add(this.parent.actions.makeTestAction);
        this.makeAlbumButton.add(this.parent.actions.multiMakerAction);
        this.makeAlbumButton.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.publishButton = new JPopupButton();
        this.publishButton.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setupButtons();
        Config.getConfig().addPropertyChangeListener("backgroundMode", pce -> this.setupButtons());
        this.updatePublishPopupMenu();
        AccountManager.getInstance().addAccountManagerListener(this::updatePublishPopupMenu);
        JAlbumContext.getInstance().addPropertyChangeListener("engine", evt -> JAlbumContext.getInstance().getEngine().addPropertyChangeListener("accountProfileName", evt1 -> this.setSelectedAccountProfile()));
        JPanel content = new JPanel((LayoutManager)new MigLayout("fillx, insets 4 6 6 4"));
        content.add((Component)this.skinAndStyleLabel, "growx, pushx, span, wrap");
        content.add((Component)this.skin, "growx, pushx");
        JToolBarButton skinInfoButton = new JToolBarButton(this.parent.actions.skinInfoAction, false);
        skinInfoButton.setIcon(Icons.toolbar("information"));
        content.add((Component)skinInfoButton, "gapbefore 4px, wrap");
        content.add((Component)this.style, "growx, pushx");
        JToolBarButton skinSettingsButton = new JToolBarButton(this.parent.actions.skinSettingsAction, false);
        skinSettingsButton.setIcon(Icons.toolbar("btn-settings"));
        content.add((Component)skinSettingsButton, "gapbefore 4px, wrap");
        content.add((Component)new JSmartSeparator(), "growx, pushx, span, wrap");
        content.add((Component)this.settingsButton, "growx, wrap");
        content.add((Component)this.makeAlbumButton, "sg btn, growx, pushx");
        content.add((Component)this.previewButton, "gapbefore 4px, wrap");
        content.add((Component)this.publishButton, "sg btn, growx, pushx");
        content.add((Component)this.previewRemoteButton, "gapbefore 4px, wrap");
        this.setLayout(new BorderLayout());
        this.add((Component)content, "Center");
    }

    void setTexts() {
        this.skin.setToolTipText(Msg.get("ui.skinToolTip"));
        this.style.setToolTipText(Msg.get("ui.styleToolTip"));
        this.moreSkinsLink.setText(Msg.get("ui.downloadSkins"));
        this.moreSkinsLink.setToolTipText(Msg.get("ui.downloadSkinsToolTip"));
        this.moreSkinsLink.setURL(JAlbumSite.getInstance().getSkinsUrl());
        this.collapsiblePanel.setTitle(Msg.get("ui.more"));
        this.makeChanges.setText(Msg.get("ui.changes"));
        this.makeChanges.setToolTipText(Msg.get("ui.makeAlbumToolTip"));
        this.makeAll.setText(Msg.get("ui.all"));
        this.makeAll.setToolTipText(Msg.get("ui.rebuildAllToolTip"));
        this.makeAlbumButton.setText(Msg.get("ui.makeAlbum"));
    }

    public void scanSkins() {
        this.skin.removeActionListener(this.skinSelectedActionListener);
        Object selected = this.skin.getSelectedItem();
        this.skin.removeAllItems();
        JAlbumUtilities.fillCombo(this.skin, this.parent.cfg.chainedSkinsDir, (FileFilter)new DirectoryFilter());
        this.skin.setSelectedItem(selected);
        this.skin.addActionListener(this.skinSelectedActionListener);
        Object newSelected = this.skin.getSelectedItem();
        if (newSelected != null && !newSelected.equals(selected)) {
            this.skin.setSelectedItem(this.skin.getSelectedItem());
        }
    }

    private String getDefaultStyleForSkin(File skinDir) {
        try {
            File stylesDir = new File(skinDir, "styles");
            Properties skinProps = IO.readPropertyFile(new File(skinDir, "hints.jap"));
            String style = skinProps.getProperty("style");
            if (style == null || !new File(stylesDir, style).exists()) {
                File[] styles = stylesDir.listFiles(new StyleFileFilter());
                if (styles != null && styles.length > 0) {
                    return styles[0].getName();
                }
                return "";
            }
            return style;
        }
        catch (IOException ex) {
            return "";
        }
    }

    public void setSelectedSkin(String skinName) {
        for (int k = 0; k < this.skin.getItemCount(); ++k) {
            Object item = this.skin.getItemAt(k);
            if (!item.equals(skinName)) continue;
            this.skin.setSelectedIndex(k);
            return;
        }
    }

    String getSelectedSkin() {
        Object item = this.skin.getSelectedItem();
        if (item instanceof NameValue) {
            return ((NameValue)item).toString();
        }
        return (String)item;
    }

    String getSelectedStyle() {
        Item item = (Item)this.style.getSelectedItem();
        if (item == null) {
            return null;
        }
        return (String)item.value;
    }

    boolean isMakeChanges() {
        return this.makeChanges.isSelected();
    }

    static class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

