/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.jalbum.filters.AbstractFilter;
import net.jalbum.filters.GrayscaleFilter;
import net.jalbum.filters.HasOSDControls;
import net.jalbum.filters.JAlbumFilter;
import net.jalbum.filters.LogoFilter;
import net.jalbum.filters.TextFilter;
import net.jalbum.filters.arty.ArtyFilter;
import net.jalbum.filters.auto.AutoFilter;
import se.datadosen.component.JMapTable;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JFilteredImagePanel;
import se.datadosen.jalbum.JSettingsWindow;
import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.ElementException;
import se.datadosen.util.AttributeSerializer;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.BinderListener;
import se.datadosen.util.ContextHelp;

public class JImageEffectsPanel
extends JPanel
implements BinderListener {
    private final JSettingsWindow parent;
    private final ExplorerSelectionModel selectionModel;
    public static final int IMAGE_SIZE = 800;
    private static final Dimension imageBounds = new Dimension(800, 800);
    private AlbumObject root;
    private boolean dirty;
    private PropertyChangeListener representingAlbumObjectListener;
    private ImageCache imageCache = new ImageCache(1, imageBounds);
    private final Map<String, JAlbumFilter> filterMap = new HashMap<String, JAlbumFilter>();
    private final LinkedList<JAFilter> filters = new LinkedList();
    private final JFilteredImagePanel display = new JFilteredImagePanel(){

        @Override
        protected void paintComponent(Graphics g) {
            if (JImageEffectsPanel.this.dirty) {
                AlbumObject rep;
                Image im = null;
                JAlbumObject selected = JImageEffectsPanel.this.selectionModel.getSingleSelected();
                if (selected != null) {
                    try {
                        AlbumObject rep2 = selected.ao.getRepresentingAlbumObject(true);
                        rep2 = rep2 != null ? rep2 : selected.ao;
                        im = JImageEffectsPanel.this.imageCache.getImage(rep2);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JImageEffectsPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (JImageEffectsPanel.this.root != null && (rep = JImageEffectsPanel.this.root.getRepresentingAlbumObject(true)) != null) {
                    try {
                        im = JImageEffectsPanel.this.imageCache.getImage(rep);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JImageEffectsPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.originalBackgroundImage = im;
                JImageEffectsPanel.this.dirty = false;
            }
            super.paintComponent(g);
        }
    };
    private final JTabbedPane tabs = new JTabbedPane();
    private Component currentUI;
    private final PropertyChangeListener changeListener = evt -> this.display.repaint();

    public List<JAFilter> getEnabledFilters() {
        LinkedList<JAFilter> list = new LinkedList<JAFilter>();
        for (JAFilter filter : this.filters) {
            JAlbumFilter f = (JAlbumFilter)filter;
            if (!f.isEnabled()) continue;
            list.addFirst(f);
        }
        return list;
    }

    public void addFilter(final JAlbumFilter filter, String helpPath) {
        this.filterMap.put(filter.getClass().getName(), filter);
        this.filters.addFirst(filter);
        JComponent ui = filter.userInterface();
        ContextHelp.getInstance().add(ui, helpPath);
        this.tabs.addTab(filter.getName(), filter.getIcon(), ui);
        JLabel l = new JLabel(this, filter.getName(), filter.getIcon(), 10){
            private Color fg;
            final /* synthetic */ JImageEffectsPanel this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1, arg2);
            }

            @Override
            public void setForeground(Color fg) {
                this.fg = fg;
                super.setForeground(fg);
            }

            @Override
            public void paintComponent(Graphics g) {
                if (UIManager.getLookAndFeel().getClass().getName().contains("Aqua") && filter.isEnabled()) {
                    super.setForeground(this == this.this$0.tabs.getTabComponentAt(this.this$0.tabs.getSelectedIndex()) ? this.fg.brighter() : this.fg);
                }
                super.paintComponent(g);
            }
        };
        PropertyChangeListener enabledListener = evt -> l.setForeground(filter.isEnabled() ? Color.green.darker() : JAlbumColor.textText);
        filter.addPropertyChangeListener("enabled", enabledListener);
        enabledListener.propertyChange(null);
        try {
            this.tabs.setTabComponentAt(this.tabs.getTabCount() - 1, l);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        filter.addPropertyChangeListener(this.changeListener);
    }

    public JImageEffectsPanel(JSettingsWindow parent) {
        this.parent = parent;
        this.selectionModel = parent.parent.albumExplorer.explorer.selectionModel;
        this.selectionModel.addSelectionListener(model -> this.imageUpdated());
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.tabs.addChangeListener(e -> {
            if (this.currentUI instanceof HasOSDControls) {
                ((HasOSDControls)((Object)this.currentUI)).detachOSDControls(this.display);
            }
            this.currentUI = this.tabs.getSelectedComponent();
            if (this.currentUI instanceof HasOSDControls) {
                ((HasOSDControls)((Object)this.currentUI)).attachOSDControls(this.display);
            }
        });
        this.addFilter(new TextFilter(true, false).setAsTemplate(), "Settings/Effects");
        this.addFilter(new LogoFilter(true, false).setAsTemplate(), "Settings/Effects#Logotype");
        this.addFilter(new GrayscaleFilter(), "Settings/Effects#Gray");
        this.addFilter(new AutoFilter(), "Settings/Effects#Auto");
        this.addFilter(new ArtyFilter(), "Settings/Effects#Arty");
        this.tabs.setSelectedIndex(0);
        this.display.setFilters(this.filters);
        this.display.setBackground(JAlbumColor.text);
        this.display.setImageBorder(BorderFactory.createLineBorder(new Color(96, 96, 96)));
        this.addHierarchyListener(new HierarchyListener(){
            boolean lastShowing = false;

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (JImageEffectsPanel.this.isShowing() && !this.lastShowing) {
                        JImageEffectsPanel.this.modelRead();
                    } else if (!JImageEffectsPanel.this.isShowing() && this.lastShowing) {
                        JImageEffectsPanel.this.writeModel();
                    }
                    this.lastShowing = JImageEffectsPanel.this.isShowing();
                }
            }
        });
        this.add((Component)this.display, "Center");
        this.add((Component)this.tabs, "South");
        this.parent.parent.binder.addBinderListener(this);
    }

    public void setAlbumObject(AlbumObject ao) {
        this.root = ao;
        this.imageUpdated();
        if (this.root != null) {
            this.representingAlbumObjectListener = evt -> this.imageUpdated();
            this.root.addPropertyChangeListener("representingAlbumObject", this.representingAlbumObjectListener);
            this.root.addPropertyChangeListener("children", this.representingAlbumObjectListener);
        } else {
            this.representingAlbumObjectListener = null;
        }
    }

    private void imageUpdated() {
        this.dirty = true;
        this.display.repaint();
    }

    @Override
    public void writeModel() {
        String attributes;
        if (BeanBinder.isSynchingUI()) {
            return;
        }
        JMapTable userVars = this.parent.userVariablesTable;
        LinkedHashMap vars = userVars.getMap();
        LinkedList<String> filterVars = new LinkedList<String>();
        HashSet<Object> processedFilters = new HashSet<Object>();
        AttributeSerializer serializer = new AttributeSerializer();
        int i = 1;
        while ((attributes = (String)vars.get("filter" + i)) != null) {
            filterVars.add(attributes);
            vars.remove("filter" + i);
            ++i;
        }
        ListIterator<String> it = filterVars.listIterator();
        while (it.hasNext()) {
            try {
                JAlbumFilter jAlbumFilter;
                Properties props = AttributeTokenizer.getProperties((String)it.next());
                String className = props.getProperty("class");
                if (className == null || (jAlbumFilter = this.filterMap.get(className)) == null || processedFilters.contains(className)) continue;
                if (jAlbumFilter.isEnabled()) {
                    it.set(serializer.toAttributeString(jAlbumFilter));
                } else {
                    it.remove();
                }
                processedFilters.add(className);
            }
            catch (ElementException ex) {
                ex.printStackTrace(System.err);
            }
        }
        LinkedList<String> newFilterVars = new LinkedList<String>();
        for (Map.Entry entry : this.filterMap.entrySet()) {
            if (processedFilters.contains(entry.getKey()) || !((JAlbumFilter)entry.getValue()).isEnabled()) continue;
            newFilterVars.add(serializer.toAttributeString(entry.getValue()));
        }
        filterVars.addAll(newFilterVars);
        int i2 = 1;
        for (String a : filterVars) {
            vars.put("filter" + i2++, a);
        }
        userVars.clear();
        userVars.putAll(vars);
    }

    @Override
    public void modelRead() {
        String attributes;
        JMapTable userVars = this.parent.userVariablesTable;
        LinkedHashMap vars = userVars.getMap();
        AttributeSerializer serializer = new AttributeSerializer();
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        int i = 1;
        while ((attributes = (String)vars.get("filter" + i)) != null) {
            try {
                Properties props = AttributeTokenizer.getProperties(attributes);
                String className = props.getProperty("class");
                if (!map.containsKey(className)) {
                    map.put(className, props);
                }
            }
            catch (ElementException ex) {
                ex.printStackTrace(System.err);
            }
            ++i;
        }
        for (Map.Entry<String, JAlbumFilter> e : this.filterMap.entrySet()) {
            AbstractFilter filter = (AbstractFilter)e.getValue();
            serializer.toBean((Properties)map.get(e.getKey()), filter, filter.getTemplate());
            BeanBinder.getProperties((Object)filter, filter.userInterface());
        }
    }
}

