/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.JAlbumTagsField;
import se.datadosen.component.JBackgroundTextField;
import se.datadosen.component.JFilePathField;
import se.datadosen.component.JMenuButton;
import se.datadosen.component.JSmartSyntaxTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.StateMonitor;
import se.datadosen.dnd.JFileDropPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JSettingsWindow;
import se.datadosen.jalbum.JThumbnailChooser;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.Title;
import se.datadosen.util.annotations.ToolTipText;

public class JGeneralSettingsPanel
extends ControlPanel {
    private JSettingsWindow parent;
    private AlbumObject root;
    ControlPanel upperPanel = new ControlPanel(new RiverLayout(0, 0));
    @Text(value="edit.albumThumbnail")
    JLabel albumThumbnailLabel = new JLabel();
    JThumbnailChooser albumThumbnail = new JThumbnailChooser();
    @Text(value="edit.albumTitle")
    JLabel albumTitleLabel = new JLabel();
    @ToolTipText(value="edit.titleToolTip")
    JBackgroundTextField albumTitle = new JBackgroundTextField(20);
    @Text(value="edit.albumDescription")
    JLabel albumDescriptionLabel = new JLabel();
    JSmartSyntaxTextArea albumDescription = (JSmartSyntaxTextArea)((Object)((JSmartSyntaxTextArea)((Object)new JSmartSyntaxTextArea(4, 20).setFullHTMLEditing(true))).spelling());
    @Text(value="edit.albumTags")
    @ToolTipText(value="edit.albumTagsToolTip")
    JLabel albumTagsLabel = new JLabel();
    JAlbumTagsField albumTags = new JAlbumTagsField(20);
    @Text(value="ui.imageDirectoryLabel")
    @ToolTipText(value="ui.imageDirectoryToolTip")
    JLabel directoryLabel = new JLabel();
    public JSmartTextField directory = new JSmartTextField(30);
    @ToolTipText(value="ui.chooseDirectoryToolTip")
    JButton chooseDirectoryButton = new JButton();
    @Text(value="ui.outputDirectory")
    @ToolTipText(value="ui.outputDirectoryToolTip")
    JLabel outputDirectoryLabel = new JLabel();
    @ToolTipText(value="ui.outputDirectoryToolTip")
    JFilePathField outputDirectory = new JFilePathField(30);
    @ToolTipText(value="ui.outputDirectoryToolTip")
    JButton chooseOutputDirectoryButton = new JButton();
    JFileDropPanel imageDirectoryPanel = new JFileDropPanel();
    JFileDropPanel outputDirectoryPanel = new JFileDropPanel();
    DirectoryChooser directoryChooser;
    DirectoryChooser outputDirectoryChooser;
    boolean directoryErrorShown = false;
    @Text(value="share.url")
    JLabel albumAddressLabel = new JLabel();
    JBackgroundTextField albumAddress = new JBackgroundTextField(30);
    @Title(value="ui.collaborativeAlbum")
    ControlPanel collaborativePanel = new ControlPanel();
    private JButton attachDetachButton;
    private JButton fetchNewObjectsButton;
    @Text(value="ui.invite")
    @Icon(value="20x20/collaborative-invite.svg")
    private JMenuButton inviteButton = new JMenuButton();
    private final JLabel invitePrompt = new JLabel(Msg.get("ui.attachInboxToolTip"));
    private PropertyChangeListener changeListener;

    public JGeneralSettingsPanel(JSettingsWindow parent) {
        this.parent = parent;
        this.init();
    }

    public AlbumObject getAlbumObject() {
        return this.albumThumbnail.getAlbumObject();
    }

    public void setAlbumObject(AlbumObject root) {
        this.changeListener = null;
        this.albumThumbnail.setAlbumObject(root);
        this.root = root;
        boolean okRoot = root != null && root.getChildren(false) != null;
        this.upperPanel.setEnabled(okRoot);
        if (okRoot) {
            this.albumAddress.setBackgroundText(root.getProperties().get("albumURL", ""));
            this.albumTitle.setBackgroundText(root.getName());
            this.albumTitle.setInitialText((String)root.getProperties().get("title"));
            this.albumTags.setInitialText((String)root.getProperties().get("tags"));
            this.albumDescription.setInitialText(root.getComment());
            this.changeListener = evt -> {
                if (evt.getPropertyName().equals("comment")) {
                    this.albumDescription.setText(this.getAlbumObject().getComment());
                    this.albumDescription.repaint();
                } else if (evt.getPropertyName().equals("properties")) {
                    this.albumTitle.setText((String)this.getAlbumObject().getProperties().get("title"));
                    this.albumTags.setText((String)this.getAlbumObject().getProperties().get("tags"));
                    this.albumAddress.setBackgroundText(root.getProperties().get("albumURL", ""));
                }
            };
            root.addPropertyChangeListener(this.changeListener);
        } else {
            this.albumTitle.setInitialText("");
            this.albumTitle.setBackgroundText("");
            this.albumTags.setInitialText("");
            this.albumDescription.setInitialText("");
            this.albumAddress.setBackgroundText("");
        }
    }

    private void checkDirectories() {
        File dir = new File(this.directory.getText());
        File f = new File(this.outputDirectory.getText());
        if (!f.isAbsolute()) {
            f = IO.resolvePath(dir, this.outputDirectory.getText());
        }
        if (!this.directoryErrorShown && dir.getAbsolutePath().equals(f.getAbsolutePath())) {
            this.directoryErrorShown = true;
            JOptionPane.showMessageDialog(this, Msg.get("error.directory"), Msg.get("error.message"), 2);
        }
    }

    private void init() {
        Msg.maintainTranslated(this);
        this.albumTitle.spelling();
        this.albumTags.spelling();
        this.directoryChooser = ChooserFactory.createDirectoryChooser(this.parent);
        this.outputDirectoryChooser = ChooserFactory.createDirectoryChooser(this.parent);
        this.attachDetachButton = new JButton(this.parent.parent.actions.attachDetachAction);
        this.fetchNewObjectsButton = new JButton(this.parent.parent.actions.fetchNewObjectsAction);
        this.inviteButton.add(this.parent.parent.actions.inviteEmailAction);
        this.inviteButton.add(this.parent.parent.actions.inviteQRAction);
        this.parent.parent.actions.inviteEmailAction.addPropertyChangeListener(evt -> {
            if (((AbstractAction)evt.getSource()).isEnabled()) {
                this.invitePrompt.setText(Msg.get("ui.attachInboxConfirmation", this.parent.parent.actions.getAttachedEmail(), this.root.getName()));
            } else {
                this.invitePrompt.setText(Msg.get("ui.attachInboxToolTip"));
            }
        });
        this.invitePrompt.setFont(this.invitePrompt.getFont().deriveFont(this.invitePrompt.getFont().getSize2D() - 1.0f));
        this.setLayout(new RiverLayout());
        if (Platform.isMac()) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        this.albumDescription.setFocusTraversalKeys(0, null);
        this.albumDescription.setFocusTraversalKeys(1, null);
        this.albumDescription.setLineWrap(true);
        this.albumDescription.setWrapStyleWord(true);
        this.albumTitle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    JGeneralSettingsPanel.this.getAlbumObject().setTitle(JGeneralSettingsPanel.this.albumTitle.getText());
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JGeneralSettingsPanel.this, ex);
                }
            }
        });
        this.albumTags.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AlbumObjectProperties props = JGeneralSettingsPanel.this.getAlbumObject().getProperties();
                props.put("tags", JGeneralSettingsPanel.this.albumTags.getText());
                try {
                    props.store();
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JGeneralSettingsPanel.this, ex);
                }
            }
        });
        this.albumDescription.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    JGeneralSettingsPanel.this.getAlbumObject().setComment(JGeneralSettingsPanel.this.albumDescription.getText());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        ControlPanel leftPanel = new ControlPanel();
        leftPanel.add(this.albumThumbnailLabel);
        leftPanel.add("br", this.albumThumbnail);
        this.upperPanel.add("vtop", leftPanel);
        ControlPanel rightPanel = new ControlPanel();
        rightPanel.add(this.albumTitleLabel);
        rightPanel.add("br hfill", this.albumTitle);
        rightPanel.add("p", this.albumDescriptionLabel);
        rightPanel.add("br hfill", new JScrollPane((Component)((Object)this.albumDescription)));
        rightPanel.add("p", this.albumTagsLabel);
        rightPanel.add("br hfill", this.albumTags);
        this.upperPanel.add("hfill", rightPanel);
        this.add("hfill", this.upperPanel);
        final JCheckBox editFolderSettings = new JCheckBox(Msg.get("ui.editFolderSettings"), true);
        ControlPanel directoriesPanel = new ControlPanel();
        new StateMonitor(this){
            final /* synthetic */ JGeneralSettingsPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onChange() {
                this.this$0.directory.setEditable(editFolderSettings.isSelected());
                this.this$0.outputDirectory.setEditable(editFolderSettings.isSelected());
                4.enable(editFolderSettings.isSelected(), (JComponent)this.this$0.chooseDirectoryButton, (JComponent)this.this$0.chooseOutputDirectoryButton);
            }
        }.add(editFolderSettings);
        directoriesPanel.add("label", this.directoryLabel);
        directoriesPanel.add("tab hfill", this.directory);
        directoriesPanel.add(this.chooseDirectoryButton);
        directoriesPanel.add("br label", this.outputDirectoryLabel);
        directoriesPanel.add("tab hfill", this.outputDirectory);
        directoriesPanel.add(this.chooseOutputDirectoryButton);
        directoriesPanel.add("br label", this.albumAddressLabel);
        directoriesPanel.add("tab hfill", this.albumAddress);
        editFolderSettings.addActionListener(e -> {
            this.parent.parent.preferencesWindow.expandedFolderSettings.setSelected(((JCheckBox)e.getSource()).isSelected());
            this.parent.parent.preferencesWindow.savePreferences();
        });
        editFolderSettings.setSelected(this.parent.parent.preferencesWindow.expandedFolderSettings.isSelected());
        AbstractAction showDirectoryInFileSystemAction = new AbstractAction(Msg.get("edit.showInFilesystem"), Icons.small("open-folder")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File dest = new File(JGeneralSettingsPanel.this.directory.getText());
                    BrowserLauncher.openLocal(dest);
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JGeneralSettingsPanel.this, ex);
                }
            }
        };
        this.directory.getPopupMenu().insert(showDirectoryInFileSystemAction, 0);
        this.directory.getPopupMenu().insert(new JSeparator(), 1);
        this.directory.addActionListener(e -> this.checkDirectories());
        this.directory.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                JGeneralSettingsPanel.this.checkDirectories();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.directory.onChange(de -> {
            this.directoryErrorShown = false;
            this.outputDirectory.setParentFile(new File(this.directory.getText()));
        });
        AbstractAction showOutputDirectoryInFileSystemAction = new AbstractAction(Msg.get("edit.showInFilesystem"), Icons.small("open-folder")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File dest = new File(JGeneralSettingsPanel.this.outputDirectory.getText());
                    if (!dest.isAbsolute()) {
                        dest = new File(JGeneralSettingsPanel.this.directory.getText(), JGeneralSettingsPanel.this.outputDirectory.getText());
                    }
                    BrowserLauncher.openLocal(dest);
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JGeneralSettingsPanel.this, ex);
                }
            }
        };
        this.outputDirectory.getPopupMenu().insert(showOutputDirectoryInFileSystemAction, 0);
        this.outputDirectory.getPopupMenu().insert(new JSeparator(), 1);
        this.outputDirectory.addActionListener(e -> this.checkDirectories());
        this.outputDirectory.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                JGeneralSettingsPanel.this.checkDirectories();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.outputDirectory.onChange(de -> {
            this.directoryErrorShown = false;
        });
        this.directoryLabel.setLabelFor(this.directory);
        this.chooseDirectoryButton.addActionListener(e -> {
            String dir = this.directory.getText();
            if (dir.length() > 0) {
                File d = new File(dir);
                if (d.isDirectory()) {
                    this.directoryChooser.setCurrentDirectory(d);
                }
            } else {
                String myPicturesPath = System.getProperty("my.pictures.path");
                if (myPicturesPath != null) {
                    File myPicturesDir = new File(myPicturesPath);
                    this.directoryChooser.setCurrentDirectory(myPicturesDir);
                }
            }
            int returnVal = this.directoryChooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.directory.setText(this.directoryChooser.getSelectedFile().getAbsolutePath());
                this.parent.parent.directorySelected();
                this.parent.parent.scanImageDirectory();
                this.checkDirectories();
            }
        });
        KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JGeneralSettingsPanel.this.parent.parent.directorySelected();
            }
        };
        this.directory.addKeyListener(ka);
        this.outputDirectory.addKeyListener(ka);
        this.directoryChooser.setDialogTitle(Msg.get("ui.chooseDirectoryToolTip"));
        this.outputDirectoryChooser.setDialogTitle(Msg.get("ui.chooseDirectoryToolTip"));
        this.chooseDirectoryButton.setMargin(new Insets(3, 3, 3, 3));
        this.chooseDirectoryButton.setIcon(Icons.small("open-folder"));
        this.outputDirectoryPanel.addComponent(this.outputDirectory);
        this.outputDirectoryPanel.addComponent(this.outputDirectoryPanel);
        this.imageDirectoryPanel.addComponent(this.directory);
        this.imageDirectoryPanel.addFileDropListener(e -> {
            File droppedFile = e.getFirstFile();
            if (droppedFile.isDirectory()) {
                this.directory.setText(e.getFirstFile().getAbsolutePath());
            }
        });
        this.outputDirectoryPanel.addFileDropListener(e -> {
            if (e.getFirstFile().isDirectory()) {
                this.outputDirectory.setText(e.getFirstFile().getAbsolutePath());
                this.parent.parent.directorySelected();
            } else {
                this.parent.parent.messageBox(Msg.get("ui.filesDroppedError2"));
            }
        });
        this.outputDirectoryPanel.setLayout(new RiverLayout());
        this.outputDirectoryLabel.setLabelFor(this.outputDirectory);
        this.chooseOutputDirectoryButton.setMargin(new Insets(3, 3, 3, 3));
        this.chooseOutputDirectoryButton.setIcon(Icons.small("open-folder"));
        this.chooseOutputDirectoryButton.addActionListener(e -> {
            int returnVal;
            if (this.outputDirectory.getText().length() > 0) {
                File dir = new File(this.outputDirectory.getText());
                if (!dir.isAbsolute()) {
                    dir = new File(this.directory.getText(), this.outputDirectory.getText());
                }
                this.outputDirectoryChooser.setCurrentDirectory(dir);
            }
            if ((returnVal = this.outputDirectoryChooser.showOpenDialog(this)) == 0) {
                this.outputDirectory.setText(this.outputDirectoryChooser.getSelectedFile().getAbsolutePath());
                this.parent.parent.directorySelected();
                this.checkDirectories();
            }
        });
        this.add("p", editFolderSettings);
        this.add("br hfill", directoriesPanel);
        this.collaborativePanel.add(this.attachDetachButton);
        this.collaborativePanel.add(this.inviteButton);
        this.collaborativePanel.add(this.fetchNewObjectsButton);
        this.collaborativePanel.add("br", this.invitePrompt);
        this.add("br", this.collaborativePanel);
    }
}

