/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import net.jalbum.filters.JAlbumFilter;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.util.GraphicsUtilities;

public class JFilteredImagePanel
extends JBackgroundPanel {
    protected List<JAFilter> filters;
    protected Image originalBackgroundImage;

    public List<JAFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<JAFilter> filters) {
        this.filters = filters;
        this.repaint();
    }

    @Override
    public Image getBackgroundImage() {
        return this.originalBackgroundImage;
    }

    @Override
    public void setBackgroundImage(Image bg) {
        this.originalBackgroundImage = bg;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        if (this.filters != null && this.originalBackgroundImage != null) {
            BufferedImage copy = GraphicsUtilities.duplicate(this.originalBackgroundImage);
            HashMap vars = new HashMap();
            for (JAFilter f : this.filters) {
                if (!(f instanceof JAlbumFilter) || !((JAlbumFilter)f).isEnabled()) continue;
                copy = f.filter(copy, vars);
            }
            this.bg = copy;
        } else {
            this.bg = this.originalBackgroundImage;
        }
        Graphics2D g = (Graphics2D)g2d;
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
    }
}

