/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.ActionTracker;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ToolFileFilter;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Scope;

class JExternalToolsMenu
extends JMenu {
    private JAlbumFrame ui;
    ChainedDirectory toolsDir;

    public JExternalToolsMenu(JAlbumFrame ui) {
        this.ui = ui;
        this.init();
    }

    private void init() {
        this.toolsDir = Config.getConfig().chainedToolsDir;
        this.toolsDir.setSortFileList(true);
        this.rebuildMenu();
    }

    protected void rebuildMenu() {
        this.removeAll();
        File[] tools = this.toolsDir.listFiles(new ToolFileFilter());
        Arrays.sort(tools, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        for (File f : tools) {
            this.add(new ActionTracker(new ToolAction(f)));
            JMenuItem mi = (JMenuItem)this.getMenuComponent(this.getMenuComponentCount() - 1);
            if (!f.getParentFile().equals(Config.getConfig().chainedToolsDir)) continue;
            mi.setFont(this.getFont().deriveFont(1));
        }
    }

    class ToolAction
    extends AbstractAction {
        protected final File toolFile;

        public ToolAction(File toolFile) {
            super(IO.baseName(toolFile));
            this.toolFile = toolFile;
            this.putValue("ShortDescription", toolFile.getAbsolutePath());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JExternalToolsMenu.this.ui.ui2Engine();
            }
            catch (BeanBinderException ex) {
                Debug.showStackTraceDialog(JExternalToolsMenu.this, ex);
            }
            new Thread("ScriptingThread"){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    try {
                        JExternalToolsMenu.this.ui.engine.init();
                        if (ToolAction.this.toolFile.exists()) {
                            JExternalToolsMenu.this.ui.engine.init();
                            Scope globals = JExternalToolsMenu.this.ui.engine.globalVariables;
                            Scope locals = new Scope(globals);
                            locals.put("currentFolder", (Object)JExternalToolsMenu.this.ui.albumExplorer.getCurrentFolder());
                            locals.put("rootFolder", (Object)JExternalToolsMenu.this.ui.albumExplorer.getRootFolder());
                            AlbumObject[] sel = JExternalToolsMenu.this.ui.albumExplorer.explorer.getSelectedAlbumObjects();
                            locals.put("selected", (Object)(sel.length > 0 ? sel[0] : null));
                            JExternalToolsMenu.this.ui.engine.processScript(ToolAction.this.toolFile, locals);
                        }
                    }
                    catch (ScriptException ex) {
                        Debug.showCopyableError(JExternalToolsMenu.this.ui, ex, Msg.get("ui.scriptingError"));
                    }
                    catch (OperationAbortedException ex) {
                        JExternalToolsMenu.this.ui.statusBar.setText(Msg.get("ui.operationAborted"));
                    }
                    catch (IOException ex) {
                        Debug.showStackTraceDialog(JExternalToolsMenu.this.ui, ex);
                    }
                }
            }.start();
        }
    }
}

