/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.ShareIcons;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;

public class JEmbedPanel
extends ControlPanel {
    Action copyToClipboardAction = new AbstractAction(Msg.get("ui.copyToClipboard")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(JEmbedPanel.this.codeArea.getText()), null);
        }
    };
    Action closeAction = new AbstractAction(Msg.get("close")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JEmbedPanel.this.codeWorker != null && !JEmbedPanel.this.codeWorker.isDone()) {
                JEmbedPanel.this.codeWorker.cancel(true);
            }
            JEmbedPanel.this.setVisible(false);
        }
    };
    Action updateAction = new AbstractAction(Msg.get("edit.update")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JEmbedPanel.this.spinner.workStarted();
            JEmbedPanel.this.updateAction.setEnabled(false);
            JEmbedPanel.this.codeWorker = new SwingWorker<String, Object>(){

                @Override
                protected String doInBackground() throws Exception {
                    JEmbedPanel.this.window.ui2Engine();
                    AlbumBean engine = JEmbedPanel.this.context.getEngine();
                    BeanBinder.setProperties((Object)engine, JEmbedPanel.this);
                    return engine.makeEmbedCode();
                }

                @Override
                protected void done() {
                    try {
                        JEmbedPanel.this.spinner.workDone();
                        JEmbedPanel.this.updateAction.setEnabled(true);
                        if (this.isCancelled()) {
                            return;
                        }
                        String code = (String)this.get();
                        JEmbedPanel.this.codeArea.setText(code);
                        JEmbedPanel.this.codeArea.selectAll();
                        JEmbedPanel.this.copyToClipboardAction.setEnabled(true);
                    }
                    catch (InterruptedException code) {
                    }
                    catch (ExecutionException ex) {
                        try {
                            throw ex.getCause();
                        }
                        catch (ElementException elex) {
                            Debug.showStackTraceDialog(JEmbedPanel.this.window, ex.getCause());
                        }
                        catch (Throwable t) {
                            while (t.getCause() != null) {
                                t = t.getCause();
                            }
                            Debug.showFriendlyErrorDialog(JEmbedPanel.this.window, t);
                        }
                    }
                }
            };
            JEmbedPanel.this.codeWorker.execute();
        }
    };
    JAlbumContext context;
    JAlbumFrame window;
    JLabel embedInfo = new JLabel(Msg.get("ui.embedInfo"));
    JLabel albumWidthLabel = new JLabel(Msg.get("ui.albumWidth"));
    JTextField albumWidth = new JSmartTextField(4);
    JLabel albumHeightLabel = new JLabel(Msg.get("ui.albumHeight"));
    JTextField albumHeight = new JSmartTextField(4);
    JLabel embedCodeLabel = new JLabel(Msg.get("ui.embedCode"));
    JProgressSpinner spinner = new JProgressSpinner();
    JTextArea codeArea = new JSmartTextArea(8, 50);
    SwingWorker codeWorker;

    public JEmbedPanel(JAlbumContext context) throws HeadlessException {
        super(Msg.get("ui.embedAlbum"));
        this.context = context;
        this.window = context.getFrame();
        this.init();
    }

    private void init() {
        TitledBorder border = this.getTitledBorder();
        border.setTitleFont(border.getTitleFont().deriveFont(16.0f));
        this.setOpaque(false);
        this.embedInfo.setIcon(ShareIcons.embed);
        this.codeArea.setFocusTraversalKeys(0, null);
        this.codeArea.setFocusTraversalKeys(1, null);
        this.codeArea.setEditable(false);
        this.codeArea.setLineWrap(true);
        this.codeArea.setWrapStyleWord(true);
        this.add("p", this.embedInfo);
        this.add("p", this.albumWidthLabel);
        this.add("", this.albumWidth);
        this.add("tab", this.albumHeightLabel);
        this.add("", this.albumHeight);
        this.add("tab", new JButton(this.updateAction));
        this.add("", this.spinner);
        this.add("p", this.embedCodeLabel);
        this.add("br hfill vfill", new JScrollPane(this.codeArea));
        this.add("p right", new JButton(this.copyToClipboardAction));
        this.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                this.spinner.setHidden(true);
                AlbumBean engine = this.context.getEngine();
                BeanBinder.getProperties((Object)engine, this);
                this.copyToClipboardAction.setEnabled(false);
                this.updateAction.actionPerformed(null);
            }
        });
    }
}

