/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import javax.swing.FocusManager;
import javax.swing.JFormattedTextField;
import se.datadosen.component.ControlPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.EditListener2;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.util.Debug;
import se.datadosen.util.MapBinder;
import se.datadosen.util.PropertyBinder;

public class JCustomPanel
extends ControlPanel
implements EditListener2 {
    protected JAlbumContext context;
    protected PluginContext pc;
    protected EditPanel editPanel;
    private Properties initiatedValues;
    private Map<String, Object> loadedState;
    protected AlbumObject currentAO;
    private boolean loadingUI = false;

    public JCustomPanel(JAlbumContext context) {
        this.context = context;
        this.pc = context.getPluginContext();
        this.editPanel = this.pc.getEditPanel();
        this.setBackground(JAlbumColor.text);
        this.setOpaque(true);
        context.getFrame().addJAlbumListener(new JAlbumAdapter(){

            @Override
            public void skinChanged(JAlbumEvent e) {
                JCustomPanel.this.editPanel.removeCustomTab(JCustomPanel.this);
                JCustomPanel.this.editPanel.removeEditListener(JCustomPanel.this);
            }
        });
    }

    @Override
    public void setAlbumObject(AlbumObject ao) {
        this.saveUI();
        this.currentAO = ao;
        this.loadUI();
    }

    private void initUI() {
        if (this.initiatedValues == null) {
            this.initiatedValues = PropertyBinder.getProperties(this);
            this.editPanel.addEditListener(this);
        } else {
            PropertyBinder.syncUI(this.initiatedValues, this);
        }
    }

    protected boolean isLoadingUI() {
        return this.loadingUI;
    }

    protected void loadUI() {
        try {
            this.loadingUI = true;
            this.initUI();
            if (this.currentAO != null) {
                AlbumObjectProperties props = this.currentAO.getProperties();
                props.loadUI(this);
                this.loadedState = MapBinder.getMap(this);
            }
        }
        finally {
            this.loadingUI = false;
        }
    }

    protected void init() {
        this.loadUI();
    }

    protected void saveUI() {
        Map<String, Object> currentState;
        if (this.currentAO == null || this.loadingUI) {
            return;
        }
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        if (focusOwner instanceof JFormattedTextField) {
            JFormattedTextField tf = (JFormattedTextField)focusOwner;
            try {
                tf.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!(currentState = MapBinder.getMap(this)).equals(this.loadedState)) {
            AlbumObjectProperties props = this.currentAO.getProperties();
            try {
                props.saveUI(this);
            }
            catch (FileNotFoundException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        }
    }

    @Override
    public void saveState() {
        this.saveUI();
    }
}

