/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JAwardsBadge
extends JComponent {
    private float alpha = 1.0f;
    private Awards awards = new Awards();
    private Thread animator;

    public JAwardsBadge() {
        this.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L) {
                this.animate(this.isShowing());
            }
        });
    }

    @Override
    public void paintComponent(Graphics gg) {
        super.paintComponent(gg);
        Graphics2D g = (Graphics2D)gg;
        float a = this.alpha;
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        ImageIcon award = this.awards.getCurrentAward();
        if (award != null) {
            g.setComposite(AlphaComposite.getInstance(3, a));
            g.drawImage(award.getImage(), (this.getWidth() - award.getIconWidth()) / 2, (this.getHeight() - award.getIconHeight()) / 2, null);
        }
        award = this.awards.getNextAward();
        g.setComposite(AlphaComposite.getInstance(3, 1.0f - a));
        g.drawImage(award.getImage(), (this.getWidth() - award.getIconWidth()) / 2, (this.getHeight() - award.getIconHeight()) / 2, null);
        this.alpha -= 0.05f;
    }

    private void animate(boolean animate) {
        if (animate) {
            this.animator = new Thread("Splash animator"){

                @Override
                public void run() {
                    try {
                        while (true) {
                            if (JAwardsBadge.this.alpha >= 0.0f) {
                                1.sleep(40L);
                                JAwardsBadge.this.repaint();
                                continue;
                            }
                            1.sleep(2500L);
                            JAwardsBadge.this.alpha = 1.0f;
                            JAwardsBadge.this.awards.nextAward();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            };
            this.animator.setDaemon(true);
            this.animator.start();
        } else if (this.animator != null) {
            this.animator.interrupt();
        }
    }

    private static class Awards {
        String[] awards = new String[]{"aboutcom.png", "brothersoft.png", "chipde.png", "downloadcom.png", "macupdate.png", "trustpilot.png"};
        int currentAward = (int)(System.currentTimeMillis() / 1000L % (long)this.awards.length);
        private int requestCount = 1;

        public ImageIcon getCurrentAward() {
            if (this.requestCount == 1) {
                return null;
            }
            return new ImageIcon(this.getClass().getResource("images/awards/" + this.awards[this.currentAward]));
        }

        public ImageIcon getNextAward() {
            int i = this.currentAward + 1;
            if (i >= this.awards.length) {
                i = 0;
            }
            return new ImageIcon(this.getClass().getResource("images/awards/" + this.awards[i]));
        }

        public void nextAward() {
            ++this.requestCount;
            ++this.currentAward;
            if (this.currentAward >= this.awards.length) {
                this.currentAward = 0;
            }
        }
    }
}

