/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.jalbum.util.Profiler;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.CategoryCounters;
import se.datadosen.jalbum.CircularFolderReferenceException;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DateRange;
import se.datadosen.jalbum.DirectoryChaining;
import se.datadosen.jalbum.IgnoreOrdering;
import se.datadosen.jalbum.IncludeOption;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.TreeCollection;
import se.datadosen.jalbum.WebLocation;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.NameValue;
import se.datadosen.util.NamedThreadFactory;

public class JAlbumUtilities {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("Scheduler"));

    public static Properties importProject(File projectFile) throws IOException {
        String directory;
        String style;
        if (!projectFile.isAbsolute()) {
            projectFile = projectFile.getCanonicalFile();
        }
        Properties loaded = IO.readPropertyFile(projectFile);
        Properties props = new Properties();
        String skin = loaded.getProperty("skin");
        if (skin != null & (style = loaded.getProperty("style")) != null) {
            props = JAlbumUtilities.loadHints(skin, style);
        }
        props.putAll((Map<?, ?>)loaded);
        if (!(projectFile.equals(AlbumProject.defaultProjectFile) || props.containsKey("directory") && !"true".equals(props.getProperty("ignoreDirectory")))) {
            props.setProperty("directory", projectFile.getParentFile().getAbsolutePath());
        }
        if ("true".equals(props.get("sameDirectory")) && (directory = props.getProperty("directory")) != null) {
            props.put("outputDirectory", directory);
            props.remove("sameDirectory");
        }
        if (!props.containsKey("homepageAddress")) {
            String text;
            String upLinkUrl;
            if ("true".equals(props.getProperty("skin.useUplink"))) {
                upLinkUrl = props.getProperty("skin.uplinkUrl");
                if (upLinkUrl != null) {
                    props.setProperty("homepageAddress", upLinkUrl);
                }
            } else {
                upLinkUrl = props.getProperty("skin.upLinkMain");
                if (upLinkUrl != null) {
                    props.setProperty("homepageAddress", upLinkUrl);
                }
            }
            if ((text = props.getProperty("skin.upLinkMainTxtA")) != null) {
                props.setProperty("homepageLinkText", text);
            }
            if ((upLinkUrl = props.getProperty("skin.uplinkURL")) != null) {
                props.setProperty("homepageAddress", upLinkUrl);
            }
            if ((upLinkUrl = props.getProperty("skin.homeLink")) != null) {
                props.setProperty("homepageAddress", upLinkUrl);
            }
            if ((upLinkUrl = props.getProperty("skin.homePageURL")) != null) {
                props.setProperty("homepageAddress", upLinkUrl);
            }
            if ((text = props.getProperty("skin.homePageLinkText")) != null) {
                props.setProperty("homepageLinkText", text);
            }
        }
        if (!props.containsKey("albumAddress")) {
            props.setProperty("albumAddress", "");
        }
        if (!props.containsKey("outputDirectory") && Config.getConfig().getOutputDirectoryLocation() == Config.OutputDirectoryLocation.web) {
            File webDir = new File(Config.getConfig().getWebDirectory());
            props.setProperty("outputDirectory", new File(webDir, AlbumProject.getName(projectFile)).getAbsolutePath());
        }
        if ("true".equals(props.get("chainDirectories"))) {
            props.put("directoryChaining", DirectoryChaining.FULL_TREE.name());
        }
        return props;
    }

    static Properties loadHints(String skin, String style) throws IOException {
        File styleHintsFile;
        String imageLinking;
        File skinDir = Config.getConfig().chainedSkinsDir.getFile(skin);
        File hintsFile = new File(skinDir, "hints.jap");
        Properties hints = new Properties();
        if (hintsFile.exists()) {
            hints = IO.readPropertyFile(hintsFile);
        }
        if ((imageLinking = hints.getProperty("imageLinking")) != null) {
            hints.remove("imageLinking");
            boolean makeCloseups = false;
            boolean includeOriginals = false;
            switch (imageLinking) {
                case "LinkScaled": {
                    makeCloseups = true;
                    break;
                }
                case "LinkOriginals": {
                    includeOriginals = true;
                    break;
                }
                case "LinkOriginalsViaScaled": {
                    makeCloseups = true;
                    includeOriginals = true;
                }
            }
            hints.put("makeCloseups", "" + makeCloseups);
            hints.put("includeOriginals", "" + includeOriginals);
        }
        if (hints.containsKey("style")) {
            style = hints.getProperty("style");
        }
        if ((styleHintsFile = new File(skinDir, "styles/" + IO.baseName(style) + ".jap")).exists()) {
            Properties styleHints = IO.readPropertyFile(styleHintsFile);
            hints.putAll((Map<?, ?>)styleHints);
        }
        return hints;
    }

    private static CategoryCounters countWebLocationCategories(AlbumObject ao, CategoryCounters counters, boolean recursive) throws IOException, JsonException {
        try (Profiler.Sample _s = Profiler.profile();){
            WebLocation wl = new WebLocation(ao.getFile());
            if (!wl.isJsonAlbum()) {
                counters.add(Category.webLocation, 1);
                CategoryCounters categoryCounters = counters;
                return categoryCounters;
            }
            URI target = wl.getURI();
            URI jsonURI = target.resolve("data1.json");
            String json = jsonURI.isAbsolute() ? IO.readTextUrl(jsonURI.toURL()) : IO.readTextFile(new File(ao.getFile().getParentFile(), wl.getURI().getPath()));
            JsonObject root = (JsonObject)Jsoner.deserialize((String)json);
            JsonObject countersJson = (JsonObject)root.getMap(Jsoner.mintJsonKey((String)(recursive ? "deepCounters" : "counters"), null));
            if (countersJson != null) {
                for (String key : countersJson.keySet()) {
                    try {
                        String cat = key.substring(0, key.length() - 1);
                        counters.add(Category.valueOf(cat), countersJson.getIntegerOrDefault(Jsoner.mintJsonKey((String)key, (Object)0)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            CategoryCounters categoryCounters = counters;
            return categoryCounters;
        }
    }

    private JAlbumUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countComponentTree(JComponent root) {
        Object object = root.getTreeLock();
        synchronized (object) {
            return JAlbumUtilities.countComponentTree(root, root.getComponents());
        }
    }

    private static int countComponentTree(JComponent root, Component[] components) {
        int count = 0;
        for (Component c : components) {
            if (!(c instanceof JComponent)) continue;
            ++count;
            Component[] children = ((JComponent)c).getComponents();
            if (children.length <= 0) continue;
            count += JAlbumUtilities.countComponentTree((JComponent)c, children);
        }
        return count;
    }

    public static void fillCombo(JComboBox combo, File dir, FileFilter filter) {
        if (!dir.isDirectory()) {
            return;
        }
        JAlbumUtilities.fillCombo(combo, new ChainedDirectory(dir), filter);
    }

    public static void fillCombo(JComboBox combo, ChainedDirectory dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        Arrays.sort(files, (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(((File)o1).getName(), ((File)o2).getName()));
        for (File f : files) {
            if (f.getName().toLowerCase().endsWith(".css")) {
                combo.addItem(new Item(f.getName(), IO.baseName(f)));
                continue;
            }
            combo.addItem(new NameValue<File>(f.getName(), f));
        }
    }

    public static Map getUserVariables(Properties props) {
        return JAlbumUtilities.getPrefixedVariables(props, "user.");
    }

    public static Map getSkinVariables(Properties props) {
        return JAlbumUtilities.getPrefixedVariables(props, "skin.");
    }

    public static Map getOrdinaryVariables(Properties props) {
        HashMap<String, String> theMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (e.getKey().toString().indexOf(46) != -1) continue;
            theMap.put(e.getKey().toString(), e.getValue().toString());
        }
        return theMap;
    }

    private static Properties getPrefixedVariables(Properties props, String prefix) {
        Properties theMap = new Properties();
        for (Map.Entry<Object, Object> item : props.entrySet()) {
            String name = item.getKey().toString();
            if (!name.startsWith(prefix)) continue;
            theMap.put(name.substring(prefix.length()), item.getValue().toString());
        }
        return theMap;
    }

    public static boolean hasWebPages(AlbumObject folder) {
        if (!folder.isFolder()) {
            return false;
        }
        for (AlbumObject ao : folder.getChildren(false)) {
            if (ao.getCategory() != Category.webPage || !ao.isIncluded()) continue;
            return true;
        }
        return false;
    }

    public static CategoryCounters countCategories(AlbumObject folder) throws CircularFolderReferenceException {
        return JAlbumUtilities.countCategories(folder, new CategoryCounters(), true);
    }

    public static CategoryCounters countCategories(AlbumObject folder, boolean recursive) {
        return JAlbumUtilities.countCategories(folder, new CategoryCounters(), recursive);
    }

    /*
     * Loose catch block
     */
    public static CategoryCounters countCategories(AlbumObject folder, CategoryCounters counters, boolean recursive) {
        try (Profiler.Sample _s = Profiler.profile();){
            if (folder.getCategory() == Category.webLocation) {
                try {
                    CategoryCounters categoryCounters = JAlbumUtilities.countWebLocationCategories(folder, counters, recursive);
                    return categoryCounters;
                }
                catch (JsonException | IOException ex) {
                    JAlbum.logger.fine(ex.toString());
                    CategoryCounters categoryCounters = null;
                    if (_s != null) {
                        _s.close();
                    }
                    return categoryCounters;
                }
            }
            if (!recursive) {
                for (AlbumObject ao2 : folder.getChildren(false)) {
                    if (!ao2.isIncluded() || ao2.isFolder() && ao2.isHidden()) continue;
                    counters.increase(ao2.getCategory());
                }
            } else {
                TreeCollection tc = new TreeCollection(folder);
                tc.ordered(false);
                tc.parallelStream().forEach(ao -> {
                    if (ao.getCategory() == Category.webLocation) {
                        try {
                            JAlbumUtilities.countWebLocationCategories(ao, counters, recursive);
                        }
                        catch (JsonException | IOException ex) {
                            Logger.getLogger(JAlbumUtilities.class.getName()).log(Level.FINE, null, ex);
                        }
                    } else {
                        counters.increase(ao.getCategory());
                    }
                });
            }
            CategoryCounters categoryCounters = counters;
            return categoryCounters;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static CategoryCounters countCategories(List<AlbumObject> objects, CategoryCounters counters, boolean recursive) {
        return JAlbumUtilities.countCategories(objects, counters, new LinkedHashSet<File>(), recursive);
    }

    private static CategoryCounters countCategories(List<AlbumObject> objects, CategoryCounters counters, LinkedHashSet<File> visited, boolean recursive) {
        try (Profiler.Sample _s = Profiler.profile();){
            if (objects != null) {
                for (AlbumObject ao : objects) {
                    counters.increase(ao.getCategory());
                    if (visited.contains(ao.getFile()) || !recursive || !ao.isFolder() || visited.contains(ao.getFile())) continue;
                    visited.add(ao.getFile());
                    counters = JAlbumUtilities.countCategories(ao.getChildren(false), counters, visited, recursive);
                }
            }
            CategoryCounters categoryCounters = counters;
            return categoryCounters;
        }
    }

    public static AlbumObject getThemeObject(AlbumObject folder) {
        String themePath = (String)folder.getProperties().get("themeImagePath");
        AlbumObject ti = null;
        if (themePath != null) {
            ti = folder.getChild(themePath);
        }
        if (ti == null && folder.getProperties().get("hasThemeImage", Boolean.TRUE).booleanValue()) {
            ti = folder.getRepresentingAlbumObject(true);
        }
        return ti;
    }

    public static long deepLastModified(AlbumObject folder) throws IOException {
        return JAlbumUtilities.deepLastModified(folder, ForkJoinPool.commonPool());
    }

    public static long deepLastModified(AlbumObject folder, ForkJoinPool pool) throws IOException, OperationAbortedException {
        try (IgnoreOrdering _ignore = new IgnoreOrdering(folder);){
            Profiler.Sample _s;
            block16: {
                _s = Profiler.profile();
                try {
                    if (folder.getFile().exists()) break block16;
                    long l = 0L;
                    if (_s != null) {
                        _s.close();
                    }
                    return l;
                }
                catch (Throwable throwable) {
                    if (_s != null) {
                        try {
                            _s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            if (!folder.getFactory().isCached()) {
                AlbumObjectFactory factory = new AlbumObjectFactory(folder.getEngine());
                factory.setCached(true);
                folder = factory.createInstance(folder.getFile());
            }
            long l = JAlbumUtilities.doDeepLastModified(folder, pool);
            if (_s != null) {
                _s.close();
            }
            return l;
        }
    }

    private static long doDeepLastModified(AlbumObject folder, ForkJoinPool pool) throws IOException, OperationAbortedException {
        try {
            long lastModified = folder.getLastModified();
            Future f = pool.submit(() -> folder.getDescendants(IncludeOption.HIDDEN, IncludeOption.EXCLUDED).ordered(false).parallelStream().mapToLong(ao -> {
                if (Thread.currentThread().isInterrupted()) {
                    throw new OperationAbortedException();
                }
                return ao.getLastModified();
            }).max());
            OptionalLong max = (OptionalLong)f.get();
            if (max.isPresent()) {
                return Math.max(lastModified, max.getAsLong());
            }
            return lastModified;
        }
        catch (InterruptedException ex) {
            System.out.println("Interrupted");
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            try {
                throw ex.getCause();
            }
            catch (OperationAbortedException ex2) {
                throw ex2;
            }
            catch (IOException ex2) {
                throw ex2;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public static DateRange getDeepCameraDates(AlbumObject folder) {
        try (Profiler.Sample _s = Profiler.profile();){
            if (!folder.isFolder()) {
                throw new IllegalArgumentException("Passed AlbumObject is not a folder: " + String.valueOf(folder));
            }
            if (!folder.getFactory().isCached()) {
                AlbumObjectFactory factory = new AlbumObjectFactory(folder.getEngine());
                factory.setCached(true);
                folder = factory.createInstance(folder.getFile());
            }
            DateRange dateRange = JAlbumUtilities.doGetDeepCameraDates(folder);
            return dateRange;
        }
    }

    private static DateRange doGetDeepCameraDates(AlbumObject folder) {
        DateRange range = JAlbumUtilities.getCameraDates(folder);
        long firstCameraDate = range.first != 0L ? range.first : Long.MAX_VALUE;
        long lastCameraDate = range.last;
        for (AlbumObject ao : folder.getChildren(false)) {
            if (!ao.isIncluded() || !ao.isFolder()) continue;
            DateRange r = JAlbumUtilities.doGetDeepCameraDates(ao);
            if (r.first > 0L && r.first < firstCameraDate) {
                firstCameraDate = r.first;
            }
            if (r.last <= lastCameraDate) continue;
            lastCameraDate = r.last;
        }
        return new DateRange(firstCameraDate != Long.MAX_VALUE ? firstCameraDate : 0L, lastCameraDate);
    }

    public static DateRange getCameraDates(AlbumObject folder) {
        AlbumObjectProperties props = folder.getProperties();
        long cameraDatesUpdatedDate = props.get("cameraDatesUpdatedDate", 0L);
        long firstCameraDate = props.get("firstCameraDate", 0L);
        long lastCameraDate = props.get("lastCameraDate", 0L);
        if (firstCameraDate != 0L && lastCameraDate != 0L && cameraDatesUpdatedDate >= folder.getLastModified()) {
            return new DateRange(firstCameraDate, lastCameraDate);
        }
        JAlbum.logger.log(Level.FINER, "Cache miss for {0}", folder);
        firstCameraDate = Long.MAX_VALUE;
        lastCameraDate = Long.MIN_VALUE;
        props.remove("firstCameraDate");
        props.remove("lastCameraDate");
        props.remove("cameraDatesUpdatedDate");
        Predicate<AlbumObject> videosAndImages = ao -> ao.getCategory() == Category.image || ao.getCategory() == Category.video;
        folder.getChildren(false).parallelStream().filter(videosAndImages).forEach(ao -> ao.getCameraDate());
        for (AlbumObject ao2 : folder.getChildren(false)) {
            long cameraDate;
            if (!ao2.isIncluded() || !videosAndImages.test(ao2) || (cameraDate = ao2.getCameraDate() != 0L ? ao2.getCameraDate() : ao2.getFile().lastModified()) == 0L) continue;
            if (cameraDate < firstCameraDate) {
                firstCameraDate = cameraDate;
            }
            if (cameraDate <= lastCameraDate) continue;
            lastCameraDate = cameraDate;
        }
        if (firstCameraDate != Long.MAX_VALUE && lastCameraDate != Long.MIN_VALUE) {
            props.put("firstCameraDate", firstCameraDate);
            props.put("lastCameraDate", lastCameraDate);
            props.put("cameraDatesUpdatedDate", System.currentTimeMillis());
        }
        props.save(true);
        return new DateRange(firstCameraDate != Long.MAX_VALUE ? firstCameraDate : 0L, lastCameraDate != Long.MIN_VALUE ? lastCameraDate : 0L);
    }

    private static void deleteCameraDateCache(AlbumObject folder) {
        AlbumObjectProperties props = folder.getProperties();
        props.remove("firstCameraDate");
        props.remove("lastCameraDate");
        props.remove("cameraDatesUpdatedDate");
        props.save();
        for (AlbumObject ao : folder.getChildren(false)) {
            if (!ao.isFolder()) continue;
            JAlbumUtilities.deleteCameraDateCache(ao);
        }
    }

    public static long getLastAdded(AlbumObject folder) {
        long lastAdded = 0L;
        for (AlbumObject ao : folder.getChildren(false)) {
            long la;
            if (!ao.isIncluded() || ao.isHidden() || ao.isFolder() || (la = ao.getWhenAdded()) <= lastAdded) continue;
            lastAdded = la;
        }
        return lastAdded;
    }

    public static long getDeepLastAdded(AlbumObject folder) {
        try (Profiler.Sample _s = Profiler.profile();){
            long lastAdded = 0L;
            for (AlbumObject ao : folder.getChildren(false)) {
                if (!ao.isIncluded() || ao.isHidden()) continue;
                long la = ao.getWhenAdded();
                if (ao.isFolder()) {
                    la = JAlbumUtilities.getDeepLastAdded(ao);
                }
                if (la <= lastAdded) continue;
                lastAdded = la;
            }
            long l = lastAdded;
            return l;
        }
    }

    public static boolean isDirty(File dest, AlbumObject source) {
        long destLastMod = dest.lastModified();
        if (destLastMod == 0L) {
            return true;
        }
        long lastMod = source.getLastModified();
        File rep = source.getRepresentingImageFile();
        long repLastMod = rep != null ? rep.lastModified() : 0L;
        lastMod = Math.max(lastMod, repLastMod);
        return lastMod > destLastMod;
    }

    public static boolean isDirty(File dest, File source) {
        long destLastMod = dest.lastModified();
        if (destLastMod == 0L) {
            return true;
        }
        return source.lastModified() > destLastMod;
    }

    public static void runOnAWT(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return scheduler.schedule(command, delay, unit);
    }

    public static <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return scheduler.schedule(callable, delay, unit);
    }
}

