/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Properties;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.IO;

public class JAlbumSite {
    static JAlbumSite theInstance;
    private static final String PAD_URL = "http://jalbum.net/pad.xml";
    private String padContent;
    private String clientVersion;
    private static Properties properties;
    private Exception lastException;
    private static final int CONNECT_TIMEOUT = 5000;

    public boolean isAvailable() {
        return properties != null;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void update() throws ElementException, IOException {
        URL padUrl;
        String url = System.getProperty("padUrl", PAD_URL);
        File padFile = new File(Config.getConfig().progDir, "/system/pad.xml");
        if (padFile.exists()) {
            padUrl = padFile.toURI().toURL();
            System.out.println("JAlbumSite: Using PAD from " + String.valueOf(padUrl));
        } else {
            padUrl = new URL(url + "?java.version=" + IO.urlEncode(System.getProperty("java.version")) + "&jalbum.version=" + IO.urlEncode(AlbumBean.getInternalVersion()) + "&os.name=" + IO.urlEncode(System.getProperty("os.name")) + "&lang=" + Config.getConfig().getInterpretedLanguage());
        }
        URLConnection urlConnection = padUrl.openConnection();
        urlConnection.setConnectTimeout(5000);
        urlConnection.setReadTimeout(5000);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
            this.padContent = IO.readAll(in);
        }
        Element programVersion = Elements.getElementByName("Program_Version", this.padContent, false);
        if (programVersion == null) {
            throw new IOException(Msg.get("ui.cannotFindVersionInformationError") + " " + String.valueOf(padUrl));
        }
        this.clientVersion = programVersion.getContent().toString();
        Element extensionData = Elements.getElementByName("JalbumExtension_Data", this.padContent, false);
        properties = extensionData == null ? new Properties() : AttributeTokenizer.getProperties(extensionData.getContent().toString());
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getSkinsUrl() {
        return JAlbumSite.getProperty("skinsUrl", "https://jalbum.net/skins/new");
    }

    public String getSkinInfoUrl() {
        return this.getProperty("skinInfoUrl");
    }

    public String getSkinLikesUrl() {
        return JAlbumSite.getProperty("skinLikesUrl", "https://jalbum.net/integration/like-skin");
    }

    public String getBinariesUrl() {
        return JAlbumSite.getProperty("binariesUrl", "https://jalbum.net/download/bin");
    }

    public String getDictionariesUrl() {
        return JAlbumSite.getProperty("dictionariesUrl", "https://jalbum.net/download/dictionaries");
    }

    public String getMyJAlbumActivationUrl() {
        return this.getProperty("myJAlbumActivationUrl");
    }

    public String getMyJAlbumAltActivationUrl() {
        return this.getProperty("myJAlbumAltActivationUrl");
    }

    public String getMyJAlbumInfoUrl() {
        return this.getProperty("myJAlbumInfoUrl");
    }

    public String getMyJAlbumQuotaUrl() {
        return JAlbumSite.getProperty("myJAlbumQuotaUrl", "https://jalbum.net/integration/check-quota");
    }

    public String getAutoCompleteUrl(String tagPart) {
        try {
            return JAlbumSite.getProperty("autoCompleteUrl", "https://jalbum.net/integration/auto-complete?tag=" + URLEncoder.encode(tagPart, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getMyJAlbumPasswordProtectUrl(String hostName) {
        String path = this.getProperty("myJAlbumPasswordProtectPath");
        if (path == null) {
            return null;
        }
        return IO.combinePaths("http://" + hostName, path);
    }

    public String getMyJAlbumUpgradeUrl() {
        return JAlbumSite.getProperty("myJAlbumUpgradeUrl", this.getMyJAlbumInfoUrl());
    }

    public String getJAlbumLicenseUrl() {
        return JAlbumSite.getProperty("jAlbumLicenseUrl", this.getMyJAlbumUpgradeUrl());
    }

    public String getPricingUrl() {
        return JAlbumSite.getProperty("jAlbumPricingUrl", "https://jalbum.net/purchase");
    }

    public int getMyJAlbumFileClusterSize() {
        return Integer.parseInt(JAlbumSite.getProperty("myJAlbumFileClusterSize", "8192"));
    }

    public String getAddAlbumUrl() {
        return this.getProperty("addAlbumUrl");
    }

    public String getUpdateAlbumUrl() {
        return this.getProperty("updateAlbumUrl");
    }

    public String getAddAlbumInfoUrl() {
        return this.getProperty("addAlbumInfoUrl");
    }

    public String getCommunityUrl() {
        return this.getProperty("communityUrl");
    }

    public String getSkinBugReportUrl() {
        return JAlbumSite.getProperty("skinBugReportUrl", "https://jalbum.net/forum/forum.jspa?forumID=2");
    }

    public String getSupportingUrl() {
        return JAlbumSite.getProperty("supportingUrl", "https://jalbum.net/support");
    }

    public String getHelpUrl() {
        return JAlbumSite.getProperty("helpUrl", "https://jalbum.net/help");
    }

    public String getAboutUsUrl() {
        return JAlbumSite.getProperty("aboutUsUrl", "https://jalbum.net/about");
    }

    public String getUpgradeUrl() {
        return JAlbumSite.getProperty("upgradeUrl", "https://jalbum.net/software/download");
    }

    public String getGoogleMapAPIKey() {
        return JAlbumSite.getProperty("googleMapAPIKey", "AIzaSyBOYrGgcUTI67vn5UFP4nkBlWdKplxcGgg");
    }

    public String getGiveAwayHostingUrl() {
        return JAlbumSite.getProperty("giveAwayHostingUrl", "https://jalbum.net/give-away-hosting-page");
    }

    public long getTimeStamp() {
        long ts = Long.valueOf(JAlbumSite.getProperty("timestamp", "0")) * 1000L;
        return ts;
    }

    public String getSkinUrl(String skin) {
        String res = JAlbumSite.getProperty("skinUrl", "https://jalbum.net/skins/skin/");
        return IO.combinePaths(res, IO.urlEncode(skin));
    }

    public String getSkinDownloadUrl(String skin) {
        return this.getSkinUrl(skin) + "/get";
    }

    public String getWidgetsUrl() {
        return JAlbumSite.getProperty("widgetsUrl", "https://jalbum.net/widgets");
    }

    public String getWidgetsAPIUrl() {
        return JAlbumSite.getProperty("widgetsAPIUrl", "https://jalbum.net/integration/widgets");
    }

    public String getGeneratorUrl(Locale loc) {
        String url = JAlbumSite.getProperty("generatorUrl", "https://jalbum.net");
        String lang = loc.getLanguage();
        return url + "/" + lang + "/";
    }

    public static String getGeneratorUrl() {
        return JAlbumSite.getInstance().getGeneratorUrl(Locale.getDefault());
    }

    public String getHomeUrl() {
        return JAlbumSite.getProperty("homeUrl", "http://jalbum.net");
    }

    public String getDefaultWidgets() {
        return JAlbumSite.getProperty("defaultWidgets", "");
    }

    public String getTermsURL() {
        return JAlbumSite.getProperty("termsUrl", "https://jalbum.net/terms-and-conditions");
    }

    public String getSignupUrl() {
        return JAlbumSite.getProperty("signupUrl", "https://jalbum.net/signup");
    }

    public String getIntegrationUrl() {
        return JAlbumSite.getProperty("integrationUrl", "https://jalbum.net/integration/");
    }

    public String getSignUpAPIUrl() {
        return JAlbumSite.getProperty("signupAPIUrl", "https://jalbum.net/integration/register-user");
    }

    public String getVerifyCidUrl() {
        return JAlbumSite.getProperty("verifyCidUrl", "https://jalbum.net/integration/verify-cid");
    }

    public String getEvaluationUrl() {
        return JAlbumSite.getProperty("evaluationUrl", "https://jalbum.net/integration/evaluate");
    }

    public String getProtectedPathsUrl() {
        return this.getProperty("protectedPathsUrl");
    }

    public String getForgotPasswordUrl() {
        return JAlbumSite.getProperty("forgotPasswordUrl", "https://jalbum.net/forgot-password");
    }

    public String getWhySignInUrl() {
        return JAlbumSite.getProperty("whySignInUrl", "https://jalbum.net/signup");
    }

    public String getPublishLandingUrl() {
        return JAlbumSite.getProperty("publishLandingUrl", "https://jalbum.net/published/album");
    }

    public String getRecentAlbumsUrl() {
        return JAlbumSite.getProperty("recentAlbumsUrl", "https://jalbum.net/explore/recent");
    }

    public String getPublishedExternalAlbumUrl() {
        return this.getProperty("publishedExternalAlbumUrl");
    }

    public String getUploaderCodeUrl() {
        return this.getProperty("uploaderCodeUrl");
    }

    public String getOnStartCodeUrl() {
        return this.getProperty("onStartCodeUrl");
    }

    public String getBuyImageUrl() {
        return JAlbumSite.getProperty("buyImageUrl", "http://www.mostphotos.com/{0}?ref=49898");
    }

    public String getOnStartCodeClassName() {
        return this.getProperty("onStartCodeClassName");
    }

    public static String getPromotion() {
        String p = JAlbumSite.getProperty("promotion", "");
        try {
            return p != null ? URLDecoder.decode(p, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getProperty(String property, String defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        String value = properties.getProperty(property);
        return value != null ? value : defaultValue;
    }

    private String getProperty(String property) {
        if (properties == null) {
            return null;
        }
        return properties.getProperty(property);
    }

    private Properties getProperties() {
        return properties;
    }

    private JAlbumSite() {
        try {
            this.update();
        }
        catch (IOException | ElementException ex) {
            this.lastException = ex;
        }
    }

    private JAlbumSite(boolean isTrue) throws ElementException, IOException {
        this.update();
    }

    public static JAlbumSite getInstance() {
        if (theInstance == null) {
            theInstance = new JAlbumSite();
        }
        return theInstance;
    }

    public static JAlbumSite getTrueInstance() throws ElementException, IOException {
        block3: {
            block2: {
                if (theInstance == null) break block2;
                if (properties != null) break block3;
            }
            theInstance = new JAlbumSite(true);
        }
        return theInstance;
    }
}

