/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.inet.jortho.SpellChecker;
import digfx.util.FXBinder;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import net.jalbum.UsageCounters;
import net.jalbum.browser.WebBrowser;
import net.jalbum.component.JProgressManager;
import net.jalbum.component.JQRComponent;
import net.jalbum.component.RememberedName;
import net.jalbum.projectgroups.ProjectGroups;
import net.jalbum.remotefs.RemoteFile;
import net.jalbum.undo.UndoHandler;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.FileChooser;
import se.datadosen.component.Hour;
import se.datadosen.component.JDividerBar;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JNotification;
import se.datadosen.component.JNotificationsButton;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSpeechBubble;
import se.datadosen.component.JStackLabel;
import se.datadosen.component.JToolBarButton;
import se.datadosen.component.RiverLayout2;
import se.datadosen.component.SmartAction;
import se.datadosen.component.WaitCursor;
import se.datadosen.component.search.UITarget;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.io.DualPrintStream;
import se.datadosen.io.NotifyingPrintStream;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumFileFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.CircularFolderReferenceException;
import se.datadosen.jalbum.CollaborationBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.EasyJFrame;
import se.datadosen.jalbum.FileCopier;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.InvalidLicenseException;
import se.datadosen.jalbum.JAboutWindow;
import se.datadosen.jalbum.JAccountStatusPanel;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JAlbumTrayIcon;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.JAlbumWindow;
import se.datadosen.jalbum.JBackupFrame;
import se.datadosen.jalbum.JChangeStatus;
import se.datadosen.jalbum.JConsoleFrame;
import se.datadosen.jalbum.JDownloadWizard;
import se.datadosen.jalbum.JEmbedPanel;
import se.datadosen.jalbum.JExternalToolsMenu;
import se.datadosen.jalbum.JFileListMenu;
import se.datadosen.jalbum.JFileMenuItem;
import se.datadosen.jalbum.JHtmlBox;
import se.datadosen.jalbum.JMainSettingsPanel;
import se.datadosen.jalbum.JMultiMaker;
import se.datadosen.jalbum.JNewProjectDialog;
import se.datadosen.jalbum.JPhonePreviewer;
import se.datadosen.jalbum.JPreferencesWindow;
import se.datadosen.jalbum.JPreviewPanel;
import se.datadosen.jalbum.JProgressDialog;
import se.datadosen.jalbum.JProjectsPanel;
import se.datadosen.jalbum.JPublishWizard;
import se.datadosen.jalbum.JRestoreFrame;
import se.datadosen.jalbum.JSearchBar;
import se.datadosen.jalbum.JSettingsWindow;
import se.datadosen.jalbum.JShareWindow;
import se.datadosen.jalbum.JSignUpDialog;
import se.datadosen.jalbum.JSkinErrorDialog;
import se.datadosen.jalbum.JSkinInfo;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.LicenseManagerImpl;
import se.datadosen.jalbum.MacUtilities;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.MyConsoleHandler;
import se.datadosen.jalbum.NotADirectoryException;
import se.datadosen.jalbum.NotificationManager;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PluginManager;
import se.datadosen.jalbum.PreviewServer;
import se.datadosen.jalbum.ProjectSettings;
import se.datadosen.jalbum.RecentProjectFiles;
import se.datadosen.jalbum.RecoveryTool;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.SkinLoadingThread;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.Sounds;
import se.datadosen.jalbum.SpellCheckerUtils;
import se.datadosen.jalbum.StyleFileFilter;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.TransferProtocol;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.event.IsPersistent;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.jalbum.event.JAlbumListener;
import se.datadosen.jalbum.structure.MirrorTransformer;
import se.datadosen.net.NetUtil;
import se.datadosen.net.Share;
import se.datadosen.tags.ElementException;
import se.datadosen.util.AliasAction;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.IdleExecutor;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.MappedAction;
import se.datadosen.util.MenuAction;
import se.datadosen.util.MultilingualAction;
import se.datadosen.util.NameValue;
import se.datadosen.util.Platform;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.ReportingThread;
import se.datadosen.util.StringUtil;
import se.datadosen.util.URLChecker;
import se.datadosen.util.VersionNumber;
import se.datadosen.util.WindowUtilities;
import se.datadosen.util.WorkCounter;
import se.datadosen.util.annotations.Shortcut;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

@RememberedName(value="Main window")
public class JAlbumFrame
extends EasyJFrame
implements JAlbumWindow {
    public final JAlbumContext context = JAlbumContext.getInstance(this);
    public static final String SKIN_LOADED_PROPERTY = "skinLoaded";
    public static final String ROOT_FOLDER_PROPERTY = "rootFolder";
    public static final String PROJECT_LOADING_PROPERTY = "projectLoading";
    public static final String PROJECT_LOADED_PROPERTY = "projectLoaded";
    public static final String SETTINGS_PROPERTY = "settings";
    public static final Font TITLE_FONT = "zh".equals(Config.getConfig().getInterpretedLanguage()) ? new Font("SansSerif", 0, 18) : JAlbumFrame.createFont("OpenSans-Light.ttf", 18);
    public static final Font HEADER_FONT = JAlbumFrame.createFont("OpenSans-Regular.ttf", 18);
    public static final Font H1_FONT = HEADER_FONT.deriveFont((float)Config.getConfig().getFontSize() + 6.0f);
    public static final Font H2_FONT = HEADER_FONT.deriveFont((float)Config.getConfig().getFontSize() + 4.0f);
    public static final Font H3_FONT = HEADER_FONT.deriveFont((float)Config.getConfig().getFontSize() + 3.0f);
    private ArrayList jalbumListeners = new ArrayList();
    private BooleanProperty projectLoadedProperty = new SimpleBooleanProperty(false);
    public final BeanBinder binder = new BeanBinder();
    public JPreferencesWindow preferencesWindow = new JPreferencesWindow(this);
    public final UndoHandler undoHandler = UndoHandler.getInstance();
    JConsoleFrame console = new JConsoleFrame(this);
    private ReportingThread processThread = null;
    private Thread updateCheckerThread = null;
    Config cfg = Config.getConfig();
    private ProjectSettings cleanProjectSettings = null;
    private ProjectSettings previousProjectSettings = null;
    JAlbumFrameIcons icons = JAlbumFrameIcons.getInstance();
    public JAlbumFrameActions actions = new JAlbumFrameActions();
    public JMainSettingsPanel mainSettingsPanel = new JMainSettingsPanel(this);
    NotificationManager notificationManager = new NotificationManager();
    JChangeStatus changeStatus = new JChangeStatus(this);
    public JProgressSpinner progressSpinner = new JProgressSpinner();
    public JProgressManager progressManager = new JProgressManager(this);
    JPreviewPanel previewPanel = new JPreviewPanel();
    private static final long THIRTY_DAY_MILLIS = 2592000000L;
    private static final String BROWSER_EV_START = "evaluationStart";
    private static final String BROWSER_USE_REPORTED = "browserUseReported";
    public JAlbumExplorer albumExplorer;
    public JAlbumFrameButtons toolBars;
    public JAlbumFrameMenus frameMenus;
    JShareWindow shareWindow;
    JSkinInfo skinInfoFrame;
    public JSettingsWindow settingsWindow;
    JPublishWizard publishWizard;
    public JProgressDialog progressDialog;
    public JStackLabel statusBar;
    JAccountStatusPanel accountStatusPanel;
    private JButton showErrorsButton;
    public final WaitCursor waitCursor;
    public AlbumBean engine;
    private File editDirectory;
    StringBuffer errorBuffer;
    public FileChooser projectChooser;
    private JAlbumAdapter _adapter;
    boolean exitOnClose;
    boolean loadHints;
    boolean loadingProject;
    private Properties previousSettings;
    private Properties appliedHints;
    private FileFilter albumProjectFileFilter;
    VersionNumber skinVersion;
    private String importPublishedSettingsAddress;
    PreviewServer previewServer;
    JSearchBar searchBar;
    JMultiMaker multiMaker;
    private ScheduledFuture markAsCleanFuture;
    private final PropertyChangeListener markAsCleanListener;
    private IdleExecutor restartPrompter;
    WorkCounter configureCounter;
    ProjectSettings freeSettings;

    public ReadOnlyBooleanProperty projectLoadedProperty() {
        return this.projectLoadedProperty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JAlbumFrame(File projectFile) {
        JPanel glass = new JPanel();
        glass.setLayout(new OverlayLayout(glass));
        glass.setOpaque(false);
        this.setGlassPane(glass);
        glass.setVisible(true);
        glass.add(this.previewPanel);
        this.previewPanel.setVisible(false);
        glass.setVisible(false);
        this.albumExplorer = new JAlbumExplorer(this);
        this.toolBars = new JAlbumFrameButtons();
        this.frameMenus = new JAlbumFrameMenus();
        this.shareWindow = new JShareWindow(this);
        this.settingsWindow = new JSettingsWindow(this);
        this.publishWizard = new JPublishWizard(this.context);
        this.statusBar = new JStackLabel();
        this.accountStatusPanel = new JAccountStatusPanel(JAlbumContext.getInstance());
        this.showErrorsButton = new JPlainButton(Icons.small("warning"), 2);
        this.waitCursor = new WaitCursor(this);
        this.errorBuffer = new StringBuffer();
        this.projectChooser = ChooserFactory.createFileChooser(this);
        this.exitOnClose = true;
        this.loadHints = true;
        this.loadingProject = false;
        this.previousSettings = null;
        this.appliedHints = null;
        this.albumProjectFileFilter = new FileNameExtensionFilter("jAlbum Project files", "jap");
        this.skinVersion = new VersionNumber("0");
        this.importPublishedSettingsAddress = "http://";
        this.previewServer = new PreviewServer();
        this.searchBar = new JSearchBar(this);
        this.markAsCleanListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JAlbumFrame.this.removePropertyChangeListener(JAlbumFrame.SKIN_LOADED_PROPERTY, JAlbumFrame.this.markAsCleanListener);
                JAlbumFrame.this.markAsCleanFuture = JAlbumUtilities.schedule(() -> JAlbumUtilities.runOnAWT(() -> {
                    JAlbumFrame.this.ui2Engine();
                    JAlbumFrame.this.markAsClean();
                }), 1000L, TimeUnit.MILLISECONDS);
            }
        };
        this.restartPrompter = new IdleExecutor(100, TimeUnit.MILLISECONDS);
        this.configureCounter = new WorkCounter();
        this.binder.addUI(this.mainSettingsPanel, this, this.settingsWindow.generalPanel, this.settingsWindow);
        this.binder.walkComponents((name, comp) -> comp.setName((String)name));
        this.enableEvents(64L);
        try {
            this.init();
            File myAlbums = ProjectGroups.getInstance().getCurrentGroup().getLocation();
            if (myAlbums.exists()) {
                this.projectChooser.setCurrentDirectory(myAlbums);
            }
            JAlbumUtilities.runOnAWT(() -> {
                File p = projectFile;
                if (projectFile == null && AlbumProject.defaultProjectFile.exists()) {
                    p = AlbumProject.defaultProjectFile;
                }
                this.newProject(p);
            });
            if (!this.preferencesWindow.checkForUpdates.isSelected()) return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void pack() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeLater(this.settingsWindow::pack);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else {
            this.settingsWindow.pack();
        }
    }

    public void packThis() {
        super.pack();
        Rectangle r = this.preferencesWindow.windowBounds;
        if (Platform.isMac()) {
            MacUtilities.enableFullScreen(this, true);
        }
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        if (this.preferencesWindow.rememberWindowBounds.isSelected()) {
            if (r.width > 0 && r.height > 0 && this.cfg.getWindowState() == 0 && screenBounds.contains(r)) {
                this.setBounds(r);
            } else {
                this.setLocationRelativeTo(null);
                if (this.cfg.getWindowState() >= 0) {
                    this.setExtendedState(this.cfg.getWindowState());
                }
            }
            int divLoc = this.cfg.getDividerLocation();
            if (divLoc > 0) {
                this.albumExplorer.splitPane.setDividerLocation(divLoc);
            }
        } else {
            JAlbumFrame.optimizeFrameSize(this);
        }
    }

    void setFullscreenForMac() {
        SwingUtilities.invokeLater(() -> {
            if (this.preferencesWindow.rememberWindowBounds.isSelected()) {
                Rectangle r = this.preferencesWindow.windowBounds;
                if (this.cfg.getWindowState() == -1 && Platform.isMac()) {
                    MacUtilities.toggleFullScreen(this);
                }
            }
        });
    }

    void ensureSignedIn(String title, Action whenSignedInAction) {
        int secondAnswer = JOptionPane.showConfirmDialog(this, Msg.get("upload.haveAccountQuestion"), title, 0);
        if (secondAnswer == -1) {
            return;
        }
        if (secondAnswer == 1) {
            JSignUpDialog suDialog = new JSignUpDialog((Window)this);
            suDialog.setVisible(true);
            if (suDialog.isSignupOk()) {
                SignInManager sm = SignInManager.getInstance();
                sm.userName.setText(suDialog.userName.getText());
                sm.password.setText(new String(suDialog.password.getPassword()));
                sm.setOnConfirmedSignIn(() -> whenSignedInAction.actionPerformed(null));
                sm.signInAction.actionPerformed(null);
            }
            return;
        }
        SignInManager sm = SignInManager.getInstance();
        sm.setOnConfirmedSignIn(() -> whenSignedInAction.actionPerformed(null));
        SignInManager.getInstance().showDialog();
    }

    private static void optimizeFrameSize(JFrame frame) {
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)frameSize.height < (double)screenSize.height / 1.25) {
            frameSize.height = (int)((double)screenSize.height / 1.25);
        }
        if ((double)frameSize.height > (double)screenSize.height / 1.15) {
            frameSize.height = (int)((double)screenSize.height / 1.15);
        }
        float aspect = 1.5f;
        if (screenSize.width < screenSize.height) {
            aspect = 1.0f / aspect;
        }
        frameSize.width = (int)(30.0f + (float)frameSize.height * aspect);
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        frame.setSize(frameSize);
        frame.setLocationRelativeTo(null);
    }

    public void showNotification(JNotification notification) {
        this.notificationManager.showNotification(notification);
    }

    public void dismissNotifications() {
        this.notificationManager.dismissNotifications();
    }

    void abortCurrentSkinLoading() {
        SkinLoadingThread loader = this.mainSettingsPanel.scheduledOnLoadThread;
        if (loader != null) {
            loader.abort();
            try {
                loader.join(8000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(JAlbumFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setTitle() {
        File f;
        Object title = Msg.get("ui.windowTitle");
        LicenseManager mgr = this.context.getLicenseManager();
        if (!mgr.isLicenseValid()) {
            title = (String)title + " " + Msg.get("ui.Free");
        }
        if ((f = this.projectChooser.getSelectedFile()) != null) {
            f = new File(f.getAbsolutePath());
            title = (String)title + " [";
            File parent = f.getParentFile();
            Object projectFileName = "";
            if (!f.getName().equals("jalbum-settings.jap")) {
                projectFileName = File.separatorChar + f.getName();
            }
            title = parent.getParentFile() == null ? (String)title + parent.getName() + (String)projectFileName + "]" : (String)title + parent.getParentFile().getName() + File.separatorChar + parent.getName() + (String)projectFileName + "]";
            if (this.albumExplorer.editor.isVisible()) {
                title = (String)title + " - " + this.albumExplorer.editor.getAO().getName();
            }
        }
        this.setTitle((String)title);
    }

    public ProjectSettings getCleanProjectSettings() {
        return this.cleanProjectSettings;
    }

    public boolean checkProjectSettings(ProjectSettings projectSettings) throws Exception {
        ProjectSettings currentProjectSettings = this.getProjectSettings();
        return this.checkProjectSettings(projectSettings, currentProjectSettings);
    }

    private boolean checkProjectSettings(ProjectSettings projectSettings, ProjectSettings currentSettings) throws Exception {
        return projectSettings != null && this.projectChooser.getSelectedFile() != null && !currentSettings.unionEquals(projectSettings);
    }

    boolean askProjectSave(String title) {
        try {
            if (!Config.getConfig().isShowWarnings()) {
                return true;
            }
            if (!this.mainSettingsPanel.isLoadingSkin()) {
                this.ui2Engine();
                if (this.checkProjectSettings(this.cleanProjectSettings)) {
                    JDialog topmost = new JDialog(this);
                    topmost.setAlwaysOnTop(true);
                    int answer = JOptionPane.showConfirmDialog(topmost, Msg.get("ui.saveChangesToProjectQuestion"), title, 1, 2);
                    topmost.dispose();
                    switch (answer) {
                        case 0: {
                            return this.saveProject(false);
                        }
                        case 1: {
                            return true;
                        }
                    }
                    return false;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return true;
    }

    boolean askStopSharing() {
        if (!this.shareWindow.shareBean.isRunning() || this.shareWindow.shareBean.getShares().isEmpty()) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog(this, Msg.get("ui.activeSharesWarning"), Msg.get("ui.exitMenu"), 2, 2);
        return answer == 0;
    }

    void setTexts() {
        this.setTitle(Msg.get("ui.windowTitle"));
        this.frameMenus.setTexts();
        this.toolBars.setTexts();
        this.albumExplorer.setTexts();
        this.shareWindow.setTexts();
        this.mainSettingsPanel.setTexts();
        this.settingsWindow.setTexts();
        this.preferencesWindow.setTitle(Msg.get("ui.prefsPanel"));
        this.settingsWindow.setTitle(Msg.get("ui.albumSettingsTitle"));
        this.console.setTitle(Msg.get("ui.consoleMenu"));
        this.progressDialog.setTitle(Msg.get("ui.generatingAlbumInfo"));
        this.statusBar.setText("");
    }

    private void renameTab(JTabbedPane tabs, JComponent comp, String newName) {
        int index = tabs.indexOfTab(comp.getName());
        if (index != -1) {
            tabs.setTitleAt(index, newName);
            comp.setName(newName);
        }
    }

    public synchronized void removeJAlbumListener(JAlbumListener listener) {
        if (this.jalbumListeners.contains(listener)) {
            ArrayList list = this.jalbumListeners == null ? new ArrayList(2) : (ArrayList)this.jalbumListeners.clone();
            list.remove(listener);
            this.jalbumListeners = list;
        }
    }

    @Override
    public synchronized void addJAlbumListener(JAlbumListener listener) {
        if (!this.jalbumListeners.contains(listener)) {
            ArrayList list = this.jalbumListeners == null ? new ArrayList(2) : (ArrayList)this.jalbumListeners.clone();
            list.add(listener);
            this.jalbumListeners = list;
        }
    }

    protected void fireSkinUIDisplayed(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).skinUIDisplayed(e);
        }
    }

    protected void fireSkinUIHidden(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).skinUIHidden(e);
        }
    }

    protected void fireStyleChanged(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).styleChanged(e);
        }
    }

    protected void fireSkinChanged(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            JAlbumListener listener = (JAlbumListener)it.next();
            if (!(listener instanceof IsPersistent)) {
                it.remove();
            }
            listener.skinChanged(e);
        }
        this.albumExplorer.onContextMenu(null);
    }

    protected void fireAlbumCreationStarted(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).albumCreationStarted(e);
        }
    }

    protected void fireAlbumCreationFinished(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).albumCreationFinished(e);
        }
    }

    void fireSkinLoaded() {
        JAlbumUtilities.runOnAWT(() -> this.firePropertyChange(SKIN_LOADED_PROPERTY, false, true));
    }

    private boolean structureChangeCheck() {
        AlbumObjectProperties props = this.getRoot().getProperties();
        if (props.containsKey("lastMadeDate") && !props.get("transformer", MirrorTransformer.instance).equals(props.get("lastTransformer", MirrorTransformer.instance))) {
            int res = this.messageBox(Msg.get("ui.structureChangedWarning"), 28, Msg.get("ui.makeAlbum"));
            return res == 4;
        }
        return true;
    }

    private static Font createFont(String name, int size) {
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font font = Font.createFont(0, JAlbum.class.getResourceAsStream("fonts/" + name));
            return font.deriveFont(0, size);
        }
        catch (FontFormatException | IOException ex) {
            System.err.println("Error creating font: " + String.valueOf(ex));
            return new Font("Dialog", 0, size);
        }
    }

    private void init() throws Exception {
        this.initConsole();
        ToolTipManager mgr = ToolTipManager.sharedInstance();
        if (mgr.getDismissDelay() <= 4000) {
            mgr.setDismissDelay(10000);
        }
        mgr.setInitialDelay(2 * mgr.getInitialDelay() / 3);
        this.multiMaker = new JMultiMaker(this.context);
        this.albumExplorer.projectGroupsPanel.setProjectOrdering(Config.getConfig().getProjectOrdering());
        if (!Platform.isMac()) {
            this.setIconImages(this.icons.getWindowIcons());
        }
        this.progressDialog = new JProgressDialog(this, "", true);
        this.setTexts();
        this.setJMenuBar(this.frameMenus.mainMenuBar);
        this.projectChooser.setFileFilter(this.albumProjectFileFilter);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.albumExplorer, "Center");
        this.albumExplorer.topPanel.add((Component)this.toolBars.getCommunityToolBar(), "East");
        this.settingsWindow.populateWithDefaultTabs();
        contentPane.add((Component)this.createStatusPanel(), "South");
        if (this.shareWindow.shareBean.isAutoStart()) {
            Thread t = new Thread("Web server launcher thread"){

                @Override
                public void run() {
                    JAlbumFrame.this.shareWindow.startAction.actionPerformed(null);
                }
            };
            t.setDaemon(true);
            t.start();
        }
        this.context.getLicenseManager().addPropertyChangeListener("licenseValid", evt -> {
            this.setTitle();
            if (evt.getNewValue() == Boolean.TRUE) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, Msg.get("ui.licenseActivatedInfo"), Msg.get("ui.signIn"), 1));
            }
        });
        this.cfg.addPropertyChangeListener("fontSize", evt -> new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int diff = (Integer)evt.getNewValue() - (Integer)evt.getOldValue();
                this.changeFontSize(JAlbumFrame.this.getRootPane(), diff);
            }

            private void changeFontSize(Container comp, int diff) {
                for (Component c : comp.getComponents()) {
                    Font f = c.getFont();
                    if (f != null) {
                        c.setFont(f.deriveFont(f.getSize2D() + (float)diff));
                    }
                    if (!(c instanceof Container)) continue;
                    this.changeFontSize((Container)c, diff);
                }
            }
        });
        this.cfg.addPropertyChangeListener(pce -> {
            switch (pce.getPropertyName()) {
                case "lookAndFeelName": 
                case "fontSize": 
                case "showOpenHTMLEditorButton": 
                case "customTitleBar": {
                    this.restartPrompter.onIdle(() -> JOptionPane.showMessageDialog(this, Msg.get("ui.restartToActivateChanges")));
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getSource() instanceof JTextComponent && e.getModifiersEx() == 640) {
                    switch (e.getKeyCode()) {
                        case 65: 
                        case 70: 
                        case 71: 
                        case 75: 
                        case 80: 
                        case 87: {
                            return true;
                        }
                    }
                }
                return false;
            }
        });
        SpellCheckerUtils.registerDictionaries();
        SpellCheckerUtils.setDefaults();
        Config config = Config.getConfig();
        config.addPropertyChangeListener("language", pce -> {
            try {
                SpellChecker.setCurrentLocale((Locale)new Locale(Locale.getDefault().getLanguage()));
            }
            catch (IllegalArgumentException ex) {
                config.setCheckSpelling(false);
            }
        });
        this.addPropertyChangeListener(SKIN_LOADED_PROPERTY, pce -> {
            if (!this.context.getLicenseManager().isLicenseValid()) {
                this.freeSettings = new ProjectSettings();
                this.freeSettings.main = PropertyBinder.getProperties(this.settingsWindow);
                Map skinVars = this.getSkinUIVariables();
                this.freeSettings.skin.clear();
                if (skinVars != null) {
                    this.freeSettings.skin.putAll(skinVars);
                }
            }
        });
        if (!config.isBackgroundMode() && System.currentTimeMillis() - JAlbum.getGUID() > 86400000L) {
            JNotification n = new JNotification(Msg.get("prefs.backgroundModeToolTip") + ". <a href=\"about:blank\">" + Msg.get("ui.showMeHow") + "</a>", JNotification.Type.TIP);
            n.onLinkClicked(he -> {
                n.setDismissed(true);
                UITarget backgroundModeTarget = new UITarget(this.preferencesWindow.backgroundMode);
                backgroundModeTarget.open(he.getInputEvent());
            });
            n.setExpiration(20);
            n.setRememberDismissed(true);
            if (!n.isDismissedBefore()) {
                SwingUtilities.invokeLater(() -> this.showNotification(n));
            }
        }
    }

    private JComponent createStatusPanel() {
        ControlPanel westPanel = new ControlPanel(new RiverLayout2(4, 0));
        westPanel.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 6));
        westPanel.add(this.changeStatus);
        westPanel.add(this.progressSpinner);
        this.progressSpinner.setHidden(true);
        this.progressSpinner.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        if (Platform.isMac()) {
            this.statusBar.setFont(this.statusBar.getFont().deriveFont(this.statusBar.getFont().getSize2D() - 2.0f));
        }
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        westPanel.add((Component)this.statusBar, "hfill");
        this.accountStatusPanel.setVisible(false);
        ControlPanel eastPanel = new ControlPanel(new RiverLayout2(4, 0));
        eastPanel.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 6));
        eastPanel.add(new JDividerBar());
        eastPanel.add((Component)this.progressManager, "hfill");
        JDividerBar dividerBar = new JDividerBar();
        this.progressManager.setReferenceComponent(dividerBar);
        eastPanel.add(dividerBar);
        eastPanel.add(this.accountStatusPanel);
        eastPanel.add(this.showErrorsButton);
        this.showErrorsButton.setToolTipText(Msg.get("ui.clickToShowErrors"));
        this.showErrorsButton.setVisible(false);
        this.showErrorsButton.addActionListener(e -> {
            this.console.setVisible(true);
            this.showErrorsButton.setVisible(false);
        });
        JPanel containingPanel = new JPanel(new BorderLayout());
        containingPanel.setOpaque(true);
        containingPanel.setBorder(JAlbumBorders.createStatusbarBorder());
        containingPanel.add((Component)westPanel, "Center");
        containingPanel.add((Component)eastPanel, "East");
        return containingPanel;
    }

    public void initConsole() {
        if (this.cfg.isDebugMode()) {
            System.setOut(new DualPrintStream(System.out, this.console.getPrintStream()));
            System.setErr(new DualPrintStream(System.err, this.console.getPrintStream()));
        } else {
            System.setOut(this.console.getPrintStream());
            System.setErr(this.console.getPrintStream());
        }
        NotifyingPrintStream errorNotifier = new NotifyingPrintStream(System.err){

            @Override
            public void dataPrinted() {
                JAlbumUtilities.runOnAWT(() -> JAlbumFrame.this.showErrorsButton.setVisible(true));
            }
        };
        System.setErr(errorNotifier);
        JAlbum.logger.addHandler(new MyConsoleHandler(System.out));
        this.console.setDefaultScriptEngine();
    }

    public void initProject(File inputDir) {
        this.settingsWindow.generalPanel.directory.setText(inputDir.getAbsolutePath());
        if (Config.getConfig().getOutputDirectoryLocation() == Config.OutputDirectoryLocation.web) {
            File webDir = new File(Config.getConfig().getWebDirectory());
            File outputDir = new File(webDir, inputDir.getName());
            this.settingsWindow.generalPanel.outputDirectory.setText(outputDir.getAbsolutePath());
        }
        File projectFile = new File(inputDir, "jalbum-settings.jap");
        this.projectChooser.setSelectedFile(projectFile);
        if (projectFile.exists()) {
            this.loadProject(projectFile);
        } else {
            this.ui2Engine();
        }
        this.setTitle();
        this.initView();
        this.fixUIdisabling();
    }

    private static void log(String s) {
        System.out.println(s);
    }

    void showAboutBox() {
        JAboutWindow dlg = new JAboutWindow(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    public void doExit() {
        if (this.exitOnClose) {
            try {
                if (JAlbumTrayIcon.getInstance().isVisible()) {
                    this.setVisible(false);
                    return;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (!this.askProjectSave(Msg.get("ui.exitMenu"))) {
                return;
            }
            if (!this.askStopSharing()) {
                return;
            }
            this.albumExplorer.rememberLastLocation();
            if (PluginManager.onExit()) {
                if (this.preferencesWindow.rememberWindowBounds.isSelected()) {
                    if (this.getExtendedState() == 0) {
                        this.preferencesWindow.windowBounds = this.getBounds();
                    }
                    this.cfg.setWindowState(this.getExtendedState());
                    if (Platform.isMac() && MacUtilities.isFullScreen(this)) {
                        this.cfg.setWindowState(-1);
                    }
                    this.cfg.setDividerLocation(this.albumExplorer.splitPane.getDividerLocation());
                    this.cfg.setFolderPropertiesWidth(this.albumExplorer.folderPropertyPanel.getWidth());
                    this.preferencesWindow.savePreferences();
                }
                this.albumExplorer.browserPanel.dispose();
                System.exit(0);
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (this.preferencesWindow.rememberWindowBounds.isSelected()) {
                WindowUtilities.saveBounds(this);
            }
            this.doExit();
        } else {
            super.processWindowEvent(e);
        }
    }

    void makeAlbum() {
        this.makeAlbum(null, false);
    }

    void makeAlbum(Boolean forceRebuild, boolean forceVideoProcessing) {
        if (Config.getConfig().isBackgroundMode()) {
            this.multiMaker.makeCurrentProjectInBackground(forceRebuild, forceVideoProcessing, false);
        } else {
            this.doMakeAlbum(forceRebuild, forceVideoProcessing, this.preferencesWindow.closeProgressDialog.isSelected());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMakeAlbum(final Boolean forceRebuid, final boolean forceVideoProcessing, final boolean closeWhenFinished) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component fo = kfm.getFocusOwner();
        if (fo instanceof JTextComponent) {
            fo.transferFocus();
            fo.requestFocusInWindow();
            SwingUtilities.invokeLater(() -> this.doMakeAlbum(forceRebuid, forceVideoProcessing, closeWhenFinished));
            return;
        }
        NameValue skin = (NameValue)this.mainSettingsPanel.skin.getSelectedItem();
        File skinDir = (File)skin.value;
        SkinProperties sp = new SkinProperties(skinDir);
        if (sp.getVersion().compareTo(this.skinVersion) > 0) {
            PropertyChangeListener listener = new PropertyChangeListener(){
                final /* synthetic */ JAlbumFrame this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.this$0.removePropertyChangeListener(JAlbumFrame.SKIN_LOADED_PROPERTY, this);
                    SwingUtilities.invokeLater(() -> this.this$0.doMakeAlbum(forceRebuid, forceVideoProcessing, closeWhenFinished));
                }
            };
            this.addPropertyChangeListener(SKIN_LOADED_PROPERTY, listener);
            this.reloadSkin();
            return;
        }
        Object object = JAlbum.initializedOkMonitor;
        synchronized (object) {
            int res;
            File oldOutputDir = this.engine.getOutputDir();
            this.ui2Engine();
            File imageDir = new File(this.engine.getDirectory());
            File outputDir = this.engine.getOutputDir();
            if (!imageDir.equals(outputDir) && !IO.isSubdirectoryOf(imageDir, outputDir) && this.settingsWindow.includeOriginals.isSelected() && !this.settingsWindow.isCopyOriginals()) {
                res = 1;
                if (Config.getConfig().isShowWarnings()) {
                    res = this.messageBox(Msg.get("ui.externalLinksWarning"), 19, Msg.get("ui.makeAlbum"));
                }
                if (res != 1) {
                    return;
                }
            }
            if (!outputDir.equals(oldOutputDir) && (res = this.messageBox(Msg.get("ui.makeAlbumInfo", outputDir), 3, Msg.get("ui.makeAlbum"))) != 1) {
                return;
            }
            if (!this.structureChangeCheck()) {
                return;
            }
            try {
                SignInManager manager;
                if (this.preferencesWindow.saveOnMakeAlbum.isSelected() && this.projectChooser.getSelectedFile() != null) {
                    this.saveProject(this.projectChooser.getSelectedFile());
                }
                if ((manager = SignInManager.getInstance()).isSignedIn()) {
                    this.engine.setUserName(manager.getUserName());
                } else {
                    this.engine.setUserName(null);
                }
                if (forceRebuid != null) {
                    this.engine.setAppendImages(forceRebuid == false);
                }
                this.engine.setForceVideoProcessing(forceVideoProcessing);
                if (Runtime.getRuntime().availableProcessors() > 1) {
                    this.engine.setCpuCores((Integer)this.preferencesWindow.cpuCores.getSelectedItem());
                }
                this.fireAlbumCreationStarted(new JAlbumEvent(this));
                if (this.processThread == null) {
                    this.processThread = new ReportingThread(this, "Make album thread"){
                        final /* synthetic */ JAlbumFrame this$0;
                        {
                            this.this$0 = this$0;
                            super(name);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                this.this$0.errorBuffer = new StringBuffer();
                                this.this$0.dismissNotifications();
                                this.this$0.actions.makeAction.setEnabled(false);
                                this.this$0.actions.publishAction.setEnabled(false);
                                this.this$0.progressSpinner.workStarted();
                                Object object = JAlbum.initializedOkMonitor;
                                synchronized (object) {
                                    this.this$0.statusBar.setText("");
                                    if (forceRebuid != null) {
                                        this.this$0.engine.makeAlbum();
                                    } else {
                                        this.this$0.engine.smartMakeAlbum();
                                    }
                                }
                                this.this$0.statusBar.setText(Msg.get("ui.makingAlbumDone", this.this$0.engine.getCurrentProject().getName(), this.this$0.engine.getStopwatch()));
                                if (closeWhenFinished) {
                                    this.this$0.progressDialog.setVisible(false);
                                } else {
                                    SwingUtilities.invokeAndWait(this.this$0.progressDialog::setDialogToFinishedState);
                                }
                                this.this$0.processThread = null;
                                this.this$0.changeStatus.refresh();
                            }
                            catch (IOException | Error | InterruptedException | RuntimeException | InvocationTargetException | ScriptException | ElementException t) {
                                this.this$0.progressDialog.setVisible(false);
                                this.this$0.processThread = null;
                                if (!(t instanceof OperationAbortedException)) {
                                    Tracer.getInstance().trace("crash", t, t.toString(), "action:make album", "skin:" + this.this$0.engine.getSkin(), "class:" + String.valueOf(t.getClass()));
                                }
                                try {
                                    if (t.getCause() instanceof CircularFolderReferenceException) {
                                        throw t.getCause();
                                    }
                                    throw t;
                                }
                                catch (NumberFormatException ex) {
                                    Debug.showStackTraceDialog(this.this$0, ex);
                                }
                                catch (IllegalArgumentException ex) {
                                    this.this$0.messageBox(ex.getMessage(), 32);
                                    this.this$0.statusBar.setText(ex.getMessage());
                                }
                                catch (UnsupportedEncodingException ex) {
                                    this.this$0.messageBox(Msg.get("ui.unsupportedEncodingError", this.this$0.engine.getTextEncoding()), 32);
                                    this.this$0.statusBar.setText(ex.toString());
                                }
                                catch (NotADirectoryException ex) {
                                    this.this$0.messageBox(ex.getMessage(), 32);
                                    this.this$0.progressDialog.updateStateAndSetVisible(false);
                                    this.this$0.statusBar.setText(ex.getMessage());
                                    this.this$0.actions.settingsAction.actionPerformed(null);
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace(System.err);
                                    this.this$0.messageBox(ex.toString(), 32);
                                    this.this$0.statusBar.setText(ex.getMessage());
                                }
                                catch (OperationAbortedException ex) {
                                    this.this$0.progressDialog.updateStateAndSetVisible(false);
                                    this.this$0.statusBar.setText(Msg.get("ui.operationAborted"));
                                    if (ex.getMessage() != null) {
                                        JOptionPane.showMessageDialog(this.this$0, ex.getMessage(), Msg.get("ui.operationAborted"), 0);
                                    }
                                }
                                catch (ScriptException | ElementException ex) {
                                    ex.printStackTrace(System.err);
                                    Tracer.getInstance().trace("crash", ex, new String[0]);
                                    if (this.this$0.cfg.isDebugMode()) {
                                        Debug.showCopyableError(this.this$0, ex, Msg.get("ui.scriptingError"));
                                    } else {
                                        JSkinErrorDialog d = new JSkinErrorDialog(this.this$0.progressDialog, this.this$0.context, ex);
                                        d.setVisible(true);
                                    }
                                }
                                catch (InvalidLicenseException ex) {
                                    ex.showDialog(this.this$0);
                                }
                                catch (Throwable t2) {
                                    Debug.showStackTraceDialog(this.this$0, t2);
                                }
                            }
                            finally {
                                this.this$0.progressSpinner.workDone();
                                try {
                                    this.this$0.fireAlbumCreationFinished(new JAlbumEvent(this));
                                }
                                finally {
                                    this.this$0.actions.publishAction.setEnabled(true);
                                    try {
                                        SwingUtilities.invokeAndWait(() -> {
                                            this.this$0.engine2UI(true);
                                            this.this$0.directorySelected();
                                        });
                                    }
                                    catch (InterruptedException | InvocationTargetException ex) {
                                        ex.printStackTrace(System.err);
                                    }
                                }
                            }
                            if (this.this$0.errorBuffer.length() > 0) {
                                JScrollPane sp = new JScrollPane();
                                JSmartTextArea ta = new JSmartTextArea(this.this$0.errorBuffer.toString());
                                ta.setEditable(false);
                                sp.getViewport().add((Component)ta, null);
                                JOptionPane.showMessageDialog(this.this$0, sp, Msg.get("ui.errorsDuringAlbumGeneration"), 2);
                            }
                        }
                    };
                    this.processThread.setPriority(1);
                    this.processThread.setDaemon(true);
                    this.progressDialog.abort = false;
                    this.processThread.start();
                } else {
                    this.processThread = null;
                }
            }
            catch (BeanBinderException ex) {
                Debug.showErrorDialog(this, ex);
            }
            catch (RuntimeException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        }
    }

    void setSkinGlassPane() {
        this.setGlassPane(this.previewPanel);
    }

    void setPreviewImage() {
        NameValue skin = (NameValue)this.mainSettingsPanel.skin.getSelectedItem();
        String style = this.mainSettingsPanel.getSelectedStyle();
        if (skin == null || style == null) {
            return;
        }
        this.setPreviewImage(skin, style);
    }

    void setPreviewImage(NameValue<File> skin, String style) {
        File f = new File((File)skin.value, "styles/" + IO.baseName(style) + ".jpg");
        if (!f.exists()) {
            f = new File((File)skin.value, "preview.jpg");
        }
        if (f.exists()) {
            this.previewPanel.setImage(f);
        } else {
            this.previewPanel.setText(Msg.get("ui.noPreviewAvailable"));
        }
    }

    void executeScript(File f, Map<String, Object> extraVars) {
        if (f.exists()) {
            try {
                if (this.engine == null) {
                    this.engine = this.setupNewEngine();
                }
                this.engine.init();
                if (extraVars != null) {
                    this.engine.globalVariables.putAll(extraVars);
                }
                this.engine.processScript(f, this.engine.globalVariables);
            }
            catch (ScriptException ex) {
                Tracer.getInstance().trace("crash", ex, "action:load skin", "skin:" + this.engine.getSkin(), "class:" + String.valueOf(ex.getClass()));
                if (this.cfg.isDebugMode()) {
                    Debug.showCopyableError(this, ex, Msg.get("ui.scriptingError"));
                } else {
                    JSkinErrorDialog d = new JSkinErrorDialog(this.progressDialog, this.context, ex);
                    d.setVisible(true);
                }
                ex.printStackTrace(System.out);
            }
            catch (OperationAbortedException ex) {
                this.statusBar.setText(Msg.get("ui.operationAborted"));
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
                Tracer.getInstance().trace("crash", ex, "action:load skin", "skin:" + this.engine.getSkin(), "class:" + String.valueOf(ex.getClass()));
            }
        }
    }

    public boolean isSkinUISelected() {
        return this.settingsWindow.isSkinUISelected();
    }

    @Override
    public void setSkinUI(ControlPanel ui) {
        if (ui != null) {
            Thread current = Thread.currentThread();
            if (current instanceof SkinLoadingThread) {
                if (((SkinLoadingThread)current).isAborted()) {
                    System.out.println("Ignoring setSkinUI from aborted skin");
                    return;
                }
            } else {
                System.err.println("setSkinUI not called from skin loading thread");
            }
        }
        JAlbumUtilities.runOnAWT(() -> this.settingsWindow.setSkinUI(ui));
    }

    void markAsClean() {
        try {
            this.cleanProjectSettings = this.previousProjectSettings = this.getProjectSettings();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void markSkinAsClean() {
        if (this.cleanProjectSettings != null) {
            this.cleanProjectSettings.skin = this.engine.getSkinVariables();
        } else {
            this.cleanProjectSettings = this.previousProjectSettings = this.getProjectSettings();
        }
    }

    public void reloadSkin() {
        this.abortCurrentSkinLoading();
        try {
            this.ui2Engine();
            this.loadHints = false;
            try {
                this.engine.unloadCurrentSkin();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mainSettingsPanel.skinSelectedActionListener.actionPerformed(null);
        }
        finally {
            this.loadHints = true;
        }
    }

    private static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public boolean newProject() {
        if (this.newProject(AlbumProject.defaultProjectFile.exists() ? AlbumProject.defaultProjectFile : null)) {
            JNewProjectDialog newProjectDialog = new JNewProjectDialog(this);
            this.show(newProjectDialog);
            return !newProjectDialog.isCancelled();
        }
        return false;
    }

    AlbumBean setupNewEngine() {
        this.engine = new AlbumBean();
        this.context.setEngine(this.engine);
        this.engine.setCurrentProject(this.getCurrentProject());
        this.engine.addAlbumBeanListener(this.progressDialog);
        this.engine.addAlbumBeanListener(new AlbumBeanListener(){

            @Override
            public void warning(String message) {
                JNotification n = new JNotification(message, JNotification.Type.WARNING);
                n.setPriority(JNotification.Priority.HIGH);
                n.setExpiration(6);
                JAlbumFrame.this.showNotification(n);
            }

            @Override
            public void errorOccured(Throwable t, AlbumObject ao) {
                if (JAlbumFrame.this.cfg.isDebugMode()) {
                    t.printStackTrace(System.err);
                }
                if ((t = JAlbumFrame.getRootCause(t)) instanceof RuntimeException && JAlbumFrame.this.cfg.isDebugMode()) {
                    throw (RuntimeException)t;
                }
                String msg = Msg.get("ui.objectSkippedError", ao.getPathFromRoot(), t.toString());
                JHtmlBox box = new JHtmlBox(msg);
                JNotification n = new JNotification(box, JNotification.Type.WARNING);
                box.onLinkClicked(he -> {
                    Sounds.play("Frog.aiff");
                    JAlbumFrame.this.albumExplorer.gotoPath(ao.getPathFromRoot());
                });
                n.setPriority(JNotification.Priority.HIGH);
                n.setExpiration(12);
                JAlbumFrame.this.showNotification(n);
                if (JAlbumFrame.this.errorBuffer.length() == 0) {
                    JAlbumFrame.this.errorBuffer.append(Msg.get("ui.fileProcessingError")).append("\n");
                }
                JAlbumFrame.this.errorBuffer.append(ao.getPathFromRoot()).append(": ").append(t.toString()).append("\n");
            }
        });
        return this.engine;
    }

    public boolean newProject(File projectFile) {
        if (this.engine != null && !this.askProjectSave(AlbumProject.defaultProjectFile.equals(projectFile) ? Msg.get("ui.newProjectMenu") : Msg.get("ui.openProjectMenu"))) {
            return false;
        }
        this.engine = new AlbumBean();
        this.context.setEngine(this.engine);
        this.initView();
        File skinDir = this.cfg.chainedSkinsDir.getFile(this.engine.getSkin());
        JAlbumUtilities.fillCombo(this.mainSettingsPanel.style, new File(skinDir, "styles"), (java.io.FileFilter)new StyleFileFilter());
        this.projectChooser.setSelectedFile(null);
        this.setTitle();
        if (projectFile != null) {
            this.doLoadProject(projectFile);
        } else {
            try {
                this.loadHints = false;
                try {
                    this.mainSettingsPanel.setSelectedSkin(this.engine.getSkin());
                    this.engine2UI();
                }
                finally {
                    this.loadHints = true;
                }
                this.applyHints();
                this.ui2Engine();
                this.cleanProjectSettings = this.previousProjectSettings = this.getProjectSettings();
            }
            catch (BeanBinderException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (this.updateCheckerThread == null || !this.updateCheckerThread.isAlive()) {
            this.statusBar.setText(Msg.get("ui.introInfo"));
        }
        return true;
    }

    public boolean closeProject() {
        Tracer.getInstance().trace("close project");
        return this.newProject(AlbumProject.defaultProjectFile.exists() ? AlbumProject.defaultProjectFile : null);
    }

    static void fillCombo(JComboBox combo, File dir, java.io.FileFilter filter) {
        JAlbumUtilities.fillCombo(combo, dir, filter);
    }

    static void fillCombo(JComboBox combo, ChainedDirectory dir, java.io.FileFilter filter) {
        JAlbumUtilities.fillCombo(combo, dir, filter);
    }

    boolean saveProject(boolean alwaysSaveAs) {
        if (alwaysSaveAs || this.projectChooser.getSelectedFile() == null) {
            File oldFile = this.projectChooser.getSelectedFile();
            int returnVal = this.projectChooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.saveProject(this.projectChooser.getSelectedFile());
                return true;
            }
            this.projectChooser.setSelectedFile(oldFile);
            return false;
        }
        this.saveProject(this.projectChooser.getSelectedFile());
        return true;
    }

    public void scanImageDirectory() {
        File dir = new File(this.settingsWindow.getDirectory());
        if (!dir.isDirectory()) {
            return;
        }
        File projectFile = new File(dir, "jalbum-settings.jap");
        if (projectFile.exists()) {
            this.loadProject(projectFile);
        }
    }

    private Set getChangedKeys(Properties before, Properties after) {
        HashSet<String> changedKeys = new HashSet<String>();
        if (before == null) {
            return changedKeys;
        }
        for (String string : before.keySet()) {
            if (before.getProperty(string).equals(after.getProperty(string))) continue;
            changedKeys.add(string);
        }
        return changedKeys;
    }

    private Properties filterProperties(Map allSettings, Set keysToKeep) {
        Properties filtered = new Properties();
        for (String key : keysToKeep) {
            if (!allSettings.containsKey(key)) continue;
            filtered.put(key, allSettings.get(key));
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyHints() {
        this.engine.setMakeThumbs(true);
        if (!this.preferencesWindow.useLayoutHints.isSelected() || !this.loadHints) {
            return;
        }
        try {
            if (!this.loadingProject) {
                this.ui2Engine();
            }
            if (this.preferencesWindow.restorePreviousSettings.isSelected() && this.previousSettings != null) {
                Set changedKeys = this.getChangedKeys(this.appliedHints, BeanBinder.getProperties(this.engine));
                for (String key : changedKeys) {
                    this.previousSettings.remove(key);
                }
                BeanBinder.setProperties(this.engine, this.previousSettings);
            }
            NameValue skin = (NameValue)this.mainSettingsPanel.skin.getSelectedItem();
            Properties hints = JAlbumUtilities.loadHints(skin.name, this.engine.getStyle());
            if (this.preferencesWindow.restorePreviousSettings.isSelected()) {
                Properties allSettings = BeanBinder.getProperties((Object)this.engine, false);
                this.previousSettings = this.filterProperties(allSettings, hints.keySet());
            }
            this.engine.setSkinVariables(this.filterProperties(this.engine.getSkinVariables(), StringUtil.stringToSet(this.engine.getSkinProperties().getProperty("preserveVariables", ""))));
            this.engine.setProperties(hints);
            this.appliedHints = hints;
        }
        catch (Exception ex) {
            this.statusBar.setText(ex.getMessage());
            Debug.showErrorDialog(this, ex);
        }
        finally {
            if (!this.loadingProject) {
                this.engine2UI();
            }
        }
    }

    public boolean renameProjectDirectory(String newName) throws IOException {
        File projectDir;
        File oldImageDir = new File(this.settingsWindow.getDirectory());
        File oldProjectDir = this.getProjectDir();
        if (!oldProjectDir.renameTo(projectDir = new File(oldProjectDir.getParentFile(), newName)) || projectDir.listFiles() == null) {
            return false;
        }
        String directory = oldImageDir.getAbsolutePath();
        directory = directory.replace(oldProjectDir.getAbsolutePath(), projectDir.getAbsolutePath());
        this.settingsWindow.generalPanel.directory.setText(directory);
        String outputDirectory = this.settingsWindow.getOutputDirectory().replace(oldProjectDir.getAbsolutePath(), projectDir.getAbsolutePath());
        this.settingsWindow.generalPanel.directory.repaint();
        this.settingsWindow.generalPanel.outputDirectory.setText(outputDirectory);
        File oldProjectFile = this.projectChooser.getSelectedFile();
        File projectFile = new File(projectDir, oldProjectFile.getName());
        this.projectChooser.setSelectedFile(projectFile);
        this.frameMenus.fileMenuRecentFilesMenu.replaceFile(oldProjectFile, projectFile);
        this.setTitle();
        if (projectFile.exists()) {
            Properties props = JAlbumUtilities.importProject(projectFile);
            props.setProperty("directory", directory);
            props.setProperty("outputDirectory", outputDirectory);
            props.setProperty("remoteDirectory", "");
            this.engine.setRemoteDirectory("");
            try (FileOutputStream fos = new FileOutputStream(projectFile);){
                props.store(fos, "jAlbum Project");
            }
        }
        this.ui2Engine();
        this.initView();
        return true;
    }

    public boolean renameImageDirectory(String newImageDirectoryName) throws IOException {
        File currentProjectFile;
        boolean sameDir = this.settingsWindow.getDirectory().equals(this.settingsWindow.getOutputDirectory());
        File currentImageDirectory = new File(this.settingsWindow.getDirectory());
        File newImageDirectory = new File(currentImageDirectory.getParent(), newImageDirectoryName);
        File projectFile = currentProjectFile = this.projectChooser.getSelectedFile();
        this.settingsWindow.generalPanel.directory.setText(newImageDirectory.getAbsolutePath());
        this.settingsWindow.generalPanel.directory.repaint();
        if (sameDir) {
            this.settingsWindow.generalPanel.outputDirectory.setText(newImageDirectory.getAbsolutePath());
        }
        if (currentProjectFile.getParentFile().equals(currentImageDirectory)) {
            projectFile = new File(newImageDirectory, currentProjectFile.getName());
            this.projectChooser.setSelectedFile(projectFile);
            this.frameMenus.fileMenuRecentFilesMenu.replaceFile(currentProjectFile, projectFile);
            this.setTitle();
        }
        if (projectFile.exists()) {
            Properties props = JAlbumUtilities.importProject(projectFile);
            props.setProperty("directory", newImageDirectory.getAbsolutePath());
            if (sameDir) {
                props.setProperty("outputDirectory", newImageDirectory.getAbsolutePath());
            }
            props.setProperty("remoteDirectory", "");
            this.engine.setRemoteDirectory("");
            try (FileOutputStream fos = new FileOutputStream(projectFile);){
                props.store(fos, "jAlbum Project");
            }
        }
        this.ui2Engine();
        return true;
    }

    public boolean loadProject(File projectFile) {
        this.editDirectory = null;
        if (!projectFile.equals(AlbumProject.defaultProjectFile) && !this.askProjectSave(Msg.get("ui.openProjectMenu"))) {
            return false;
        }
        return this.doLoadProject(projectFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doLoadProject(File projectFile) {
        this.freeSettings = null;
        this.cleanProjectSettings = null;
        this.abortCurrentSkinLoading();
        this.configureCounter.workStarted();
        Properties props = null;
        try {
            WaitCursor.WaitToken _wt = this.waitCursor.getToken();
            try {
                int answer;
                if (!projectFile.equals(AlbumProject.defaultProjectFile)) {
                    Tracer.getInstance().trace("open project", AlbumProject.getName(projectFile));
                }
                this.loadingProject = true;
                this.firePropertyChange(PROJECT_LOADING_PROPERTY, null, null);
                this.setupNewEngine();
                props = JAlbumUtilities.importProject(projectFile);
                BeanBinder.setProperties(this.engine, props);
                this.engine.setSkinVariables(JAlbumUtilities.getSkinVariables(props));
                this.engine.setUserVariables(JAlbumUtilities.getUserVariables(props));
                File imageDirectory = new File(this.engine.getDirectory());
                if (this.engine.getDirectory().length() > 0 && !projectFile.equals(AlbumProject.defaultProjectFile) && !imageDirectory.exists()) {
                    this.engine.setDirectory(projectFile.getParentFile().getAbsolutePath());
                }
                if (projectFile.equals(AlbumProject.defaultProjectFile)) {
                    BeanBinder.setProperties(Config.getConfig(), props);
                    PropertyBinder.syncUI(props, this.preferencesWindow);
                    BeanBinder.getProperties((Object)Config.getConfig(), this.preferencesWindow);
                } else {
                    this.frameMenus.fileMenuRecentFilesMenu.addFile(projectFile);
                    this.projectChooser.setSelectedFile(projectFile);
                    this.setTitle();
                    this.statusBar.setText(Msg.get("ui.projectLoaded") + " " + projectFile.getAbsolutePath());
                }
                if (!JAlbumFrame.isJustPreferences(props)) {
                    this.loadHints = false;
                }
                if (!this.engine.getSkinDir().exists() && (answer = JOptionPane.showConfirmDialog(this, Msg.get("ui.missingSkin", this.engine.getSkin()), Msg.get("ui.missingSkinTitle"), 0, 0)) == 0) {
                    SkinManager sm = new SkinManager();
                    sm.installSkin(this.engine.getSkin(), new URL(JAlbumSite.getInstance().getSkinDownloadUrl(this.engine.getSkin())), () -> this.doLoadProject(projectFile));
                }
                if (!this.albumExplorer.isPreviewTabShowing()) {
                    this.albumExplorer.setExplorerView();
                }
                this.removePropertyChangeListener(SKIN_LOADED_PROPERTY, this.markAsCleanListener);
                if (this.markAsCleanFuture != null) {
                    this.markAsCleanFuture.cancel(false);
                    this.markAsCleanFuture = null;
                }
                this.addPropertyChangeListener(SKIN_LOADED_PROPERTY, this.markAsCleanListener);
                this.mainSettingsPanel.skin.setActionCommand("comboBoxChangedDuringProjectLoading");
                this.mainSettingsPanel.setSelectedSkin(this.engine.getSkin());
                this.engine2UI();
                this.albumExplorer.selectRootFolderInTreeView();
                if (this.engine.isNotifyNotes() && this.engine.getNotes().length() > 0) {
                    final JNotification n = new JNotification();
                    n.setType(JNotification.Type.TIP);
                    JHtmlBox box = new JHtmlBox(this, Msg.get("ui.projectHasNotes", "about:blank")){
                        final /* synthetic */ JAlbumFrame this$0;
                        {
                            this.this$0 = this$0;
                            super(htmlText);
                        }

                        @Override
                        protected void linkActivated(HyperlinkEvent e) {
                            n.abortButton.doClick();
                            if (!this.this$0.settingsWindow.isVisible()) {
                                this.this$0.settingsWindow.pack();
                                this.this$0.settingsWindow.setVisible(true);
                            }
                            this.this$0.settingsWindow.toFront();
                            this.this$0.settingsWindow.buttonBarPane.show(this.this$0.settingsWindow.advancedPanel);
                            this.this$0.settingsWindow.advancedPanel.setSelectedComponent(this.this$0.settingsWindow.notesPanel);
                        }
                    };
                    n.setContent(box);
                    n.setExpiration(10);
                    this.showNotification(n);
                }
                this.loadingProject = false;
                this.firePropertyChange(PROJECT_LOADED_PROPERTY, null, null);
                boolean bl = true;
                if (_wt != null) {
                    _wt.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (_wt != null) {
                        try {
                            _wt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    this.engine2UI();
                    this.setCursor(Cursor.getDefaultCursor());
                    Debug.showErrorDialog(this, ex);
                }
                catch (HeadlessException | BeanBinderException t) {
                    this.statusBar.setText(t.getMessage());
                    this.setCursor(Cursor.getDefaultCursor());
                    Debug.showErrorDialog(this, t);
                }
            }
        }
        finally {
            this.loadHints = true;
            this.loadingProject = false;
            this.configureCounter.workDone();
        }
        return false;
    }

    public boolean isLoadingProject() {
        return this.loadingProject;
    }

    public AlbumProject getCurrentProject() {
        return this.albumExplorer.albumManager.getCurrentProject();
    }

    File getSkinDefaultsFile() {
        return new File(MiniConfig.getMiniConfig().configDir, this.engine.getSkin() + "-defaults.jap");
    }

    void saveAsSkinDefault() {
        try {
            this.ui2Engine();
            ProjectSettings settings = this.getProjectSettings();
            File f = this.getSkinDefaultsFile();
            JAlbumFrame.removeProjectSpecific(settings.main);
            settings.save(f);
            this.statusBar.setText(Msg.get("ui.skinDefaultsSaved", f.getAbsolutePath()));
            JOptionPane.showMessageDialog(this, Msg.get("ui.skinDefaultsResetMessage"), Msg.get("ui.saveAsSkinDefault"), 1);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    public boolean saveProject(File projectFile) {
        Object fileName = projectFile.getName();
        if (!((String)fileName).endsWith(".jap")) {
            fileName = (String)fileName + ".jap";
        }
        projectFile = new File(projectFile.getParentFile(), (String)fileName);
        try {
            this.ui2Engine();
            this.markAsClean();
            ProjectSettings settings = this.getProjectSettings();
            if (projectFile.equals(AlbumProject.defaultProjectFile)) {
                BeanBinder.getProperties((Object)Config.getConfig(), settings.main);
                PropertyBinder.getProperties(this.preferencesWindow, settings.main);
                settings.main.remove("directory");
                settings.main.remove("remoteDirectory");
            } else {
                if (projectFile.getParentFile().equals(new File(this.engine.getDirectory()))) {
                    settings.main.put("ignoreDirectory", "true");
                }
                this.frameMenus.fileMenuRecentFilesMenu.addFile(projectFile);
                this.actions.saveProjectAction.setEnabled(true);
                this.projectChooser.setSelectedFile(projectFile);
                this.setTitle();
                AlbumProject ap = this.getCurrentProject();
                ap.setProjectFile(projectFile);
                this.albumExplorer.albumManager.setCurrentProject(ap);
                if (this.preferencesWindow.backupProjects.isSelected() && projectFile.exists()) {
                    File backupFile = new File(projectFile.getParentFile(), projectFile.getName() + ".bak");
                    IO.copyFile(projectFile, backupFile);
                }
            }
            settings.save(projectFile);
            this.statusBar.setText(Msg.get("ui.projectSaved") + " " + projectFile.getAbsolutePath());
            return true;
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.statusBar.setText(ex.getMessage());
            return false;
        }
    }

    private void importSettingsFromFile(File f) {
        try {
            this.importSettings(IO.readPropertyFile(f), f.getAbsolutePath());
        }
        catch (IOException ex) {
            Debug.showFriendlyErrorDialog(this, ex);
        }
    }

    private boolean isOwningAlbum(String fromPath) {
        try {
            if (!fromPath.startsWith("http:") && !fromPath.startsWith("https:")) {
                return true;
            }
            URL fromURL = new URL(fromPath);
            String fromHost = fromURL.getHost();
            AccountManager mgr = AccountManager.getInstance();
            Enumeration e = mgr.getAccounts().elements();
            while (e.hasMoreElements()) {
                AccountProfile ap = (AccountProfile)e.nextElement();
                try {
                    URL u = new URL(ap.getWebRootURL());
                    if (!fromHost.equals(u.getHost())) continue;
                    return true;
                }
                catch (MalformedURLException malformedURLException) {
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    static void removeProjectSpecific(Properties props) {
        props.remove("directory");
        props.remove("outputDirectory");
        props.remove("accountProfileName");
        props.remove("remoteDirectory");
        props.remove("albumAddress");
        props.remove("notes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importSettings(Properties props, String fromPath) {
        int answer;
        JAlbumFrame.removeProjectSpecific(props);
        String newSkin = props.getProperty("skin");
        if (newSkin != null) {
            this.engine.setSkin(newSkin);
        }
        if (!this.isOwningAlbum(fromPath)) {
            SkinProperties sp = this.engine.getSkinProperties();
            String preventCopy = sp.getProperty("preventCopy", "backgroundImageName,logoName,customLink,customLinkText,watermark,googleSiteID,facebookAppId,fotomotoID,shopId,uploadPath,header,footer,headHook,bodyHook,playlist,debugMode,debugVars");
            for (String v : preventCopy.split(" *,\\ *")) {
                props.remove("skin." + v);
            }
        }
        BeanBinder.setProperties(this.engine, props);
        this.engine.setSkinVariables(JAlbumUtilities.getSkinVariables(props));
        this.engine.setUserVariables(JAlbumUtilities.getUserVariables(props));
        try {
            this.loadHints = false;
            this.loadingProject = true;
            this.mainSettingsPanel.setSelectedSkin(this.engine.getSkin());
        }
        finally {
            this.loadHints = true;
            this.loadingProject = false;
        }
        if (!this.engine.getSkinDir().exists() && (answer = JOptionPane.showConfirmDialog(this, Msg.get("ui.missingSkin", this.engine.getSkin()), Msg.get("ui.missingSkinTitle"), 0, 0)) == 0) {
            SkinManager sm = new SkinManager();
            try {
                String skin = this.engine.getSkin();
                sm.installSkin(skin, new URL(JAlbumSite.getInstance().getSkinDownloadUrl(skin)), () -> {
                    this.engine2UI();
                    this.statusBar.setText(Msg.get("ui.importSettingsDone", fromPath));
                });
            }
            catch (MalformedURLException ex) {
                Debug.showErrorDialog(this, ex);
            }
            return;
        }
        this.engine2UI(true);
        this.statusBar.setText(Msg.get("ui.importSettingsDone", fromPath));
    }

    public String getProjectName() {
        File projectFile = this.projectChooser.getSelectedFile();
        return projectFile != null ? IO.webSafe(projectFile.getParentFile().getName()) : "";
    }

    public File getProjectDir() {
        File projectFile = this.projectChooser != null ? this.projectChooser.getSelectedFile() : null;
        return projectFile != null ? projectFile.getParentFile() : null;
    }

    public ProjectSettings getProjectSettings() {
        return new ProjectSettings(this.engine);
    }

    public void engine2UI() {
        this.engine2UI(false);
    }

    void engine2UI(boolean quick) {
        try {
            if (quick) {
                this.mainSettingsPanel.skin.removeActionListener(this.mainSettingsPanel.skinSelectedActionListener);
            }
            this.settingsWindow.userVariablesTable.clear();
            TreeMap vars = new TreeMap(this.engine.getUserVariables());
            this.settingsWindow.userVariablesTable.putAll(vars);
            this.binder.readModel(this.engine);
            if (quick) {
                this.mainSettingsPanel.skin.addActionListener(this.mainSettingsPanel.skinSelectedActionListener);
            }
            this.settingsWindow.videosPanel.videoParametersTable.setData(this.engine.getVideoParameters());
            Object ui = this.getSkinUI();
            if (ui instanceof JComponentHolder) {
                JComponentHolder skinUI = (JComponentHolder)ui;
                PropertyBinder.syncUI(new HashMap(vars), skinUI);
                PropertyBinder.syncUI(this.engine.getSkinVariables(), skinUI);
            } else if (ui instanceof Parent) {
                FXBinder.syncUI(vars, (Node)((Parent)ui));
                FXBinder.syncUI((Map)this.engine.getSkinVariables(), (Node)((Parent)ui));
            }
            this.initView();
            this.fixUIdisabling();
            this.repaint();
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    void applySettings() {
        int answer;
        boolean oldVisibleOnProfiePage = this.engine.isVisibleOnProfilePage();
        String oldWebPassword = this.engine.getWebPassword();
        File oldOutputDirectory = this.engine.getOutputDir();
        this.ui2Engine();
        File outputDirectory = this.engine.getOutputDir();
        if (!outputDirectory.equals(oldOutputDirectory) && oldOutputDirectory.exists() && (answer = JOptionPane.showConfirmDialog(this, Msg.get("ui.outputDirectoryChangedPrompt", outputDirectory.getAbsolutePath()), Msg.get("ui.outputDirectoryChangedTitle"), 0)) == 0) {
            boolean success = oldOutputDirectory.renameTo(outputDirectory);
            if (!success && outputDirectory.exists()) {
                outputDirectory.delete();
                success = oldOutputDirectory.renameTo(outputDirectory);
            }
            if (success) {
                this.directorySelected();
                this.statusBar.setText(Msg.get("ui.albumMoved", outputDirectory.getAbsolutePath()));
            }
        }
        if (oldVisibleOnProfiePage != this.engine.isVisibleOnProfilePage() || !oldWebPassword.equals(this.engine.getWebPassword())) {
            this.messageBox(Msg.get("ui.changesAppliedOnUpload"), Msg.get("ui.shareOnJalbumNet"));
        }
        if (this.previousProjectSettings != null) {
            try {
                ProjectSettings currentSettings = this.getProjectSettings();
                if (!currentSettings.unionEquals(this.previousProjectSettings)) {
                    this.firePropertyChange(SETTINGS_PROPERTY, false, true);
                }
                this.previousProjectSettings = currentSettings;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void ui2Engine() throws BeanBinderException {
        this.ui2Engine(this.engine);
        this.changeStatus.refresh();
    }

    public void skinUI2Engine(AlbumBean engine) {
        if (!this.context.getLicenseManager().isLicenseValid() && this.freeSettings != null) {
            BeanBinder.setProperties(engine, this.freeSettings.main);
            engine.setSkinVariables(this.freeSettings.skin);
        } else {
            Map vars = this.getSkinUIVariables();
            if (vars != null) {
                engine.setSkinVariables(vars);
            }
        }
    }

    public Map getSkinUIVariables() {
        Object ui = this.getSkinUI();
        if (ui instanceof JComponentHolder) {
            Properties props = PropertyBinder.getProperties((JComponentHolder)ui);
            return props;
        }
        if (ui instanceof Parent) {
            return FXBinder.getMap((Node)((Parent)ui));
        }
        return null;
    }

    public void ui2Engine(AlbumBean engine) throws BeanBinderException {
        if (!this.context.getLicenseManager().isLicenseValid() && this.freeSettings != null) {
            this.freeSettings.main.put("directory", this.settingsWindow.generalPanel.directory.getText());
            this.freeSettings.main.put("outputDirectory", this.settingsWindow.generalPanel.outputDirectory.getText());
            this.freeSettings.main.put("skin", this.mainSettingsPanel.getSelectedSkin());
            String style = this.mainSettingsPanel.getSelectedStyle();
            if (style != null) {
                this.freeSettings.main.put("style", style);
            }
            BeanBinder.setProperties(engine, this.freeSettings.main);
            engine.setSkinVariables(this.freeSettings.skin);
        } else {
            this.binder.writeModel(engine);
            this.skinUI2Engine(engine);
            engine.setUserVariables(this.settingsWindow.userVariablesTable.getMap());
            if (this.settingsWindow.videosPanel.videoParametersTable.isEnabled()) {
                engine.setVideoParameters(this.settingsWindow.videosPanel.videoParametersTable.getData());
            }
        }
        this.albumExplorer.editor.saveState();
        BeanBinder.setProperties((Object)engine, this.preferencesWindow);
    }

    public void fixUIdisabling() {
        this.actions.saveProjectAction.setEnabled(this.projectChooser.getSelectedFile() != null);
        this.actions.duplicateProjectAction.setEnabled(this.projectChooser.getSelectedFile() != null);
        this.directorySelected();
    }

    void directorySelected() {
        boolean selected = this.settingsWindow.getDirectory().length() > 0 && this.settingsWindow.getOutputDirectory().length() > 0;
        boolean ready = selected && !this.engine.isMakingAlbum();
        this.shareWindow.setShareCurrentEnabled(ready);
        this.albumExplorer.albumManager.infoAction.setEnabled(ready);
        this.actions.makeAction.setEnabled(ready && !this.albumExplorer.browserPanel.isRebuilding());
        this.actions.makeInBackgroundAction.setEnabled(ready);
        this.actions.makeAndUploadInBackgroundAction.setEnabled(ready);
        this.actions.uploadInBackgroundAction.setEnabled(ready);
        this.actions.forceRebuildAction.setEnabled(ready);
        this.actions.makeTestAction.setEnabled(ready);
        this.actions.embedAlbumAction.setEnabled(ready);
        this.albumExplorer.reviewModeAction.setEnabled(ready);
        boolean hasFiles = this.albumDirHasFiles();
        this.actions.viewAlbumAction.setEnabled(selected && hasFiles);
        this.actions.phonePreviewerAction.setEnabled(selected && hasFiles && Config.getConfig().isServerBasedPreview());
        this.actions.publishAction.setEnabled(ready && hasFiles && !this.albumExplorer.browserPanel.isRebuilding());
    }

    private boolean albumDirHasFiles() {
        File dir = new File(this.settingsWindow.getOutputDirectory());
        if (!dir.isAbsolute()) {
            dir = new File(this.settingsWindow.getDirectory(), this.settingsWindow.getOutputDirectory());
        }
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles(new UploadBean.UploadFileFilter());
            return files.length > 0;
        }
        return false;
    }

    public AlbumObject getRoot() {
        return this.albumExplorer.getRootFolder();
    }

    public void initView() {
        File f = new File(this.settingsWindow.getDirectory());
        if (this.editDirectory == null || !this.editDirectory.equals(f)) {
            this.editDirectory = f;
            AlbumObjectFactory factory = new AlbumObjectFactory(this.engine){

                @Override
                public AlbumFileFilter getFileFilter() {
                    if (this.fileFilter == null) {
                        this.fileFilter = new AlbumFileFilter(this.engine);
                        String resName = this.engine.getResourceDirectory();
                        this.fileFilter.getIgnoreDirs().remove(resName);
                    }
                    return this.fileFilter;
                }

                @Override
                public boolean isCacheThumbnails() {
                    return Config.getConfig().isCacheThumbnails();
                }
            };
            factory.setUndoNotifier(this.undoHandler);
            this.context.setAlbumObjectfactory(factory);
            AlbumObject root = factory.createInstance(f);
            AlbumObject oldRoot = this.albumExplorer.getRootFolder();
            this.albumExplorer.setRootFolder(root);
            this.albumExplorer.viewFolder(root);
            this.undoHandler.discardAllEdits();
            this.actions.updateCollaborationActions();
            this.firePropertyChange(ROOT_FOLDER_PROPERTY, null, root);
            this.projectLoadedProperty.set(root != null && root.getChildren(false) != null);
        }
    }

    void checkForUpdates(final boolean onStartup) {
        this.updateCheckerThread = new Thread(this, "UpdateChecker"){
            final /* synthetic */ JAlbumFrame this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block10: {
                    try {
                        this.this$0.statusBar.pushText(Msg.get("ui.updateCheckInfo"));
                        String padVersion = JAlbumSite.getTrueInstance().getClientVersion();
                        if (new VersionNumber(padVersion).compareTo(new VersionNumber(AlbumBean.getInternalVersion())) > 0) {
                            LicenseManagerImpl mgr = (LicenseManagerImpl)JAlbumContext.getInstance().getLicenseManager();
                            String msg = Msg.get("ui.newUpdateAvailable", padVersion, mgr.isLicenseValidFor(padVersion) ? Msg.get("ui.freeUpdate") : Msg.get("ui.updateNotFree"));
                            int answer = JOptionPane.showConfirmDialog(this.this$0, msg, Msg.get("ui.checkForUpdatesTitle"), 0, 1);
                            if (answer == 0) {
                                Object uic = "";
                                if (mgr.isLicenseValid() && mgr.getUIC() != null) {
                                    uic = "&uic=" + mgr.getUIC();
                                }
                                BrowserLauncher.openURL(JAlbumSite.getTrueInstance().getUpgradeUrl() + "?utm_source=client&utm_medium=yesButton&utm_campaign=checkForUpdatesDialog" + (String)uic);
                                this.this$0.doExit();
                            }
                            break block10;
                        }
                        if (!onStartup) {
                            String msg = Msg.get("ui.versionIsCurrentInfo");
                            JOptionPane.showMessageDialog(this.this$0, msg, Msg.get("ui.checkForUpdates"), 1);
                        }
                        return;
                    }
                    catch (HeadlessException | IOException | ElementException ex) {
                        if (!onStartup) {
                            ex.printStackTrace(System.err);
                            JOptionPane.showMessageDialog(this.this$0, ex.toString(), Msg.get("ui.checkForUpdatesTitle"), 0);
                        }
                    }
                    finally {
                        this.this$0.statusBar.popText(Msg.get("ui.updateCheckInfo"));
                    }
                }
            }
        };
        this.updateCheckerThread.setDaemon(true);
        this.updateCheckerThread.start();
    }

    void prepareWindow(Window win) {
        if (win.isShowing()) {
            win.toFront();
            return;
        }
        win.pack();
        Dimension windowPreferedSize = win.getPreferredSize();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle sb = gc.getBounds();
        if (gc.getDevice() == GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()) {
            sb = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        }
        Dimension assignedSize = this.min(windowPreferedSize, sb.getSize());
        win.setSize(assignedSize);
        win.setLocationRelativeTo(this);
    }

    public void show(Window win) {
        this.prepareWindow(win);
        win.setVisible(true);
    }

    public static void centerRelativeTo(Component comp, Component ref) {
        Point refLoc = ref.getLocationOnScreen();
        Dimension refSize = ref.getSize();
        Dimension compSize = comp.getSize();
        int xpos = (refSize.width - compSize.width) / 2 + refLoc.x;
        int ypos = (refSize.height - compSize.height) / 2 + refLoc.y;
        comp.setLocation(xpos, ypos);
    }

    private Dimension min(Dimension d1, Dimension d2) {
        int minWidth = d1.width < d2.width ? d1.width : d2.width;
        int minHeight = d1.height < d2.height ? d1.height : d2.height;
        return new Dimension(minWidth, minHeight);
    }

    public AlbumBean getEngine() {
        return this.engine;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Override
    public Object getSkinUI() {
        if (this.settingsWindow == null) {
            return null;
        }
        if (this.settingsWindow.skinUIHolder.skinUI instanceof JFXPanel) {
            JFXPanel jfxPanel = (JFXPanel)this.settingsWindow.skinUIHolder.skinUI;
            return jfxPanel.getScene() != null ? jfxPanel.getScene().getRoot() : null;
        }
        return this.settingsWindow.skinUIHolder.skinUI;
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public void addFiles(List<File> files) {
        this.albumExplorer.explorer.handleFileAdd(files);
    }

    private static boolean isJustPreferences(Properties props) {
        return !props.containsKey("skin");
    }

    void setPreviousProjectSettings(ProjectSettings projectSettings) {
        this.previousProjectSettings = projectSettings;
    }

    private void showBrowserErrorMessage() {
        JOptionPane.showMessageDialog(this, Msg.get("browser.notWorking"), Msg.get("browser.notWorkingTitle"), 0);
    }

    public void openInBrowser(String urlString) {
        try {
            this.openInBrowser(new URL(urlString), null);
        }
        catch (MalformedURLException ex) {
            Debug.showErrorDialog(this, new MalformedURLException(urlString));
        }
    }

    public void openInBrowser(String urlString, Boolean useInternal) {
        try {
            this.openInBrowser(new URL(urlString), useInternal);
        }
        catch (MalformedURLException ex) {
            Debug.showErrorDialog(this, new MalformedURLException(urlString));
        }
    }

    public void openInBrowser(URL url, Boolean useInternal) {
        this.openInBrowser(this.getCurrentProject(), url, useInternal);
    }

    void openInBrowser(AlbumProject ap, URL url, Boolean useInternal) {
        this.openInBrowser(ap, url, useInternal, 0);
    }

    void openInBrowser(AlbumProject ap, URL url, Boolean useInternal, int modifiers) {
        block21: {
            boolean fileURL = url.getProtocol().equals("file");
            if (fileURL && Config.getConfig().isServerBasedPreview()) {
                try {
                    url = this.prepareServerBasedPreview(ap, new File(url.toURI()));
                    fileURL = false;
                }
                catch (Exception ex) {
                    Logger.getLogger(JAlbumFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fileURL && Config.getConfig().getLocalServerURL().length() > 0) {
                try {
                    File f = new File(url.toURI());
                    String relPath = IO.relativePath(f, new File(Config.getConfig().getWebDirectory()));
                    if (!relPath.startsWith("../")) {
                        url = new URL(IO.combinePaths(Config.getConfig().getLocalServerURL(), relPath));
                        fileURL = false;
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(JAlbumFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            try {
                if (useInternal == null) {
                    useInternal = Config.getConfig().getPreviewMode() != Config.PreviewMode.external;
                }
                if ((modifiers & 1) != 0) {
                    if (url.getProtocol().startsWith("http")) {
                        JPhonePreviewer.showDialog((Component)this, this, url);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this, Msg.get("ui.activateEmbeddedWebServer"), Msg.get("ui.phonePreviewer"), 0);
                    }
                    return;
                }
                if (useInternal.booleanValue()) {
                    Preferences prefs = Preferences.userNodeForPackage(WebBrowser.class);
                    long now = System.currentTimeMillis();
                    if (now - prefs.getLong(BROWSER_EV_START, 0L) > 7776000000L) {
                        prefs.putLong(BROWSER_EV_START, now);
                        UsageCounters.reset("internalPreviews");
                    }
                    long evStart = prefs.getLong(BROWSER_EV_START, now);
                    Tracer.getInstance().trace("integrated browser use");
                    if (UsageCounters.increase("internalPreviews") >= 5 && !prefs.getBoolean(BROWSER_USE_REPORTED, false) && now - evStart > 2592000000L) {
                        Tracer.getInstance().trace("licensed browser use", () -> prefs.putBoolean(BROWSER_USE_REPORTED, true), new String[0]);
                    }
                    try {
                        this.openWithInternalBrowser(url, fileURL);
                    }
                    catch (IOException | Error | RuntimeException error) {
                        this.showBrowserErrorMessage();
                        Logger.getLogger(JAlbumFrame.class.getName()).log(Level.SEVERE, null, error);
                        if (fileURL) {
                            this.openLocalWithBrowserLauncher(new File(url.toURI()));
                            break block21;
                        }
                        this.openWithBrowserLauncher(url);
                    }
                    break block21;
                }
                Tracer.getInstance().trace("preview album", "previewMode:external");
                if (fileURL) {
                    this.openLocalWithBrowserLauncher(new File(url.toURI()));
                } else {
                    this.openWithBrowserLauncher(url);
                }
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void openWithInternalBrowser(URL url, boolean local) throws IOException {
        if (local || URLChecker.getResponseCode(url) < 401) {
            JToggleButton tb = (JToggleButton)this.albumExplorer.previewAction.getValue("toggleButton");
            if (tb != null) {
                tb.setSelected(true);
            }
            this.albumExplorer.showPreview();
            this.albumExplorer.browserPanel.openURL(url);
        } else {
            JOptionPane.showMessageDialog(this, Msg.get("browser.URLnotWorking"), Msg.get("browser.URLnotWorking"), 0);
        }
    }

    private void openWithBrowserLauncher(URL url) {
        try {
            BrowserLauncher.openURL(url.toExternalForm());
        }
        catch (IOException ex) {
            Logger.getLogger(JAlbumFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void openLocalWithBrowserLauncher(File indexFile) {
        try {
            BrowserLauncher.openLocal(indexFile);
        }
        catch (IOException ex) {
            System.err.println(ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    public File getIndexFile() {
        File dir = new File(this.settingsWindow.getOutputDirectory());
        if (!dir.isAbsolute()) {
            dir = new File(this.settingsWindow.getDirectory(), this.settingsWindow.getOutputDirectory());
        }
        File rootDir = dir;
        File indexFile = new File(dir, this.settingsWindow.indexPageName.getText() + this.settingsWindow.pageExtension.getText());
        return indexFile;
    }

    public boolean indexFileExists() {
        if (!this.getIndexFile().exists()) {
            int answer = JOptionPane.showConfirmDialog(this, Msg.get("ui.albumNotFoundInfo"), Msg.get("ui.preview"), 0, 1);
            if (answer != 0) {
                this.albumExplorer.setExplorerView();
                return false;
            }
            this.addJAlbumListener(new JAlbumAdapter(){

                @Override
                public void albumCreationFinished(JAlbumEvent e) {
                    try {
                        JAlbumFrame.this.openWithInternalBrowser(JAlbumFrame.this.getIndexFile().toURI().toURL(), true);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JAlbumFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    JAlbumFrame.this.progressDialog.dispose();
                    JAlbumFrame.this.removeJAlbumListener(this);
                }
            });
            this.actions.makeTestAction.actionPerformed(null);
            return true;
        }
        return true;
    }

    private static boolean isScreenMenuBar() {
        return Boolean.valueOf(System.getProperty("apple.laf.useScreenMenuBar", "false"));
    }

    void setProjectName(String newName) {
        AlbumProject ap = this.getCurrentProject();
        File oldProjectFile = ap.getProjectFile();
        File newProjectFile = new File(ap.getProjectFile().getParentFile(), newName + ".jap");
        ap.setProjectFile(newProjectFile);
        this.albumExplorer.albumManager.setCurrentProject(ap);
        this.projectChooser.setSelectedFile(newProjectFile);
        this.frameMenus.fileMenuRecentFilesMenu.replaceFile(oldProjectFile, newProjectFile);
        this.setTitle();
    }

    public URL prepareServerBasedPreview(File indexFile) throws Exception {
        return this.prepareServerBasedPreview(this.getCurrentProject(), indexFile);
    }

    private URL prepareServerBasedPreview(AlbumProject ap, File indexFile) throws Exception {
        Set<Share> shares = this.previewServer.getShares();
        String shareName = "/" + ap.getName();
        Share previewShare = new Share(indexFile.getParent(), shareName, true);
        shares.remove(previewShare);
        shares.add(previewShare);
        this.previewServer.setShares(shares, "no-cache,must-revalidate");
        if (!this.previewServer.isRunning()) {
            try {
                int port = Integer.parseInt(Config.getConfig().getPreviewServerPort());
                this.previewServer.setPort(port);
            }
            catch (NumberFormatException port) {
                // empty catch block
            }
            this.previewServer.start();
        }
        Object indexPath = shareName;
        indexPath = IO.combinePaths((String)indexPath, indexFile.getName());
        return new URL("http", this.previewServer.getHost() != null ? this.previewServer.getHost() : NetUtil.getLocalHostAddress(), this.previewServer.getPort(), IO.urlEncode((String)indexPath));
    }

    private static boolean altDown(ActionEvent ae) {
        return (ae.getModifiers() & 8) != 0;
    }

    private static Window getDialogAncestor(Component c) {
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Dialog)) continue;
            return (Dialog)p;
        }
        return null;
    }

    public class JAlbumFrameActions {
        @Text(value="ui.newProjectMenu", postfix="...")
        @Shortcut(value="cmd N")
        public Action newProjectAction = new LambdaAction(() -> JAlbumFrame.this.newProject());
        @Text(value="ui.projectGallery", postfix="...")
        @Shortcut(value="cmd G")
        public Action projectGalleryAction = new LambdaAction(() -> JProjectsPanel.showDialog(JAlbumFrame.this));
        @Text(value="ui.openProjectMenu")
        @Shortcut(value="cmd O")
        Action openProjectAction = new LambdaAction(() -> {
            if (!JAlbumFrame.this.askProjectSave(Msg.get("ui.openProjectMenu"))) {
                return;
            }
            File oldFile = JAlbumFrame.this.projectChooser.getSelectedFile();
            int returnVal = JAlbumFrame.this.projectChooser.showOpenDialog(JAlbumFrame.this);
            if (returnVal == 0) {
                JAlbumFrame.this.doLoadProject(JAlbumFrame.this.projectChooser.getSelectedFile());
            } else {
                JAlbumFrame.this.projectChooser.setSelectedFile(oldFile);
            }
        });
        @Text(value="ui.closeProjectMenu")
        @Shortcut(value="cmd W")
        public Action closeProjectAction = new LambdaAction(() -> JAlbumFrame.this.closeProject());
        @Text(value="ui.saveProjectMenu")
        @Shortcut(value="cmd S")
        public Action saveProjectAction = new LambdaAction(() -> {
            if (JAlbumFrame.this.projectChooser.getSelectedFile() != null) {
                JAlbumFrame.this.saveProject(JAlbumFrame.this.projectChooser.getSelectedFile());
            }
        });
        @Text(value="ui.saveProjectAsMenu")
        public Action saveProjectAsAction = new LambdaAction(() -> {
            File oldFile = JAlbumFrame.this.projectChooser.getSelectedFile();
            int returnVal = JAlbumFrame.this.projectChooser.showSaveDialog(JAlbumFrame.this);
            if (returnVal == 0) {
                JAlbumFrame.this.saveProject(JAlbumFrame.this.projectChooser.getSelectedFile());
            } else {
                JAlbumFrame.this.projectChooser.setSelectedFile(oldFile);
            }
        });
        @Text(value="ui.saveAsDefaultMenu")
        @ToolTipText(value="ui.saveAsDefaultToolTip")
        public Action saveAsDefaultAction = new LambdaAction(() -> JAlbumFrame.this.saveProject(AlbumProject.defaultProjectFile));
        @Text(value="ui.saveAsSkinDefault")
        @ToolTipText(value="ui.saveAsSkinDefaultToolTip")
        public Action saveAsSkinDefaultAction = new LambdaAction(() -> JAlbumFrame.this.saveAsSkinDefault());
        @Text(value="ui.exitMenu")
        Action exitAction = new LambdaAction(() -> JAlbumFrame.this.doExit());
        @Text(value="ui.helpTopicsMenu")
        Action helpTopicsAction = new LambdaAction(() -> {
            try {
                File localHelp = new File(JAlbumFrame.this.cfg.progDir, "help/index.html");
                if (localHelp.exists()) {
                    BrowserLauncher.openLocal(localHelp);
                } else {
                    BrowserLauncher.openURL(JAlbumSite.getInstance().getHelpUrl() + "?referrer=jalbumHelpMenu&utm_source=client&utm_medium=helpTopicsItem&utm_campaign=helpMenu");
                }
            }
            catch (IOException ex) {
                JAlbumFrame.this.messageBox(ex.getMessage(), 32);
            }
        });
        @Text(value="ui.checkForUpdatesMenu")
        Action helpCheckUpdatesAction = new LambdaAction(() -> JAlbumFrame.this.checkForUpdates(false));
        @Text(value="ui.jalbumOnTheWebMenu")
        Action helpWebAction = new LambdaAction(() -> {
            try {
                BrowserLauncher.openURL("http://jalbum.net?utm_source=client&utm_medium=jAlbumWeb&utm_campaign=helpMenu");
            }
            catch (IOException ex) {
                JAlbumFrame.this.messageBox(ex.getMessage(), 32);
            }
        });
        @Text(value="ui.aboutMenu")
        Action aboutAction = new LambdaAction(() -> JAlbumFrame.this.showAboutBox());
        @Text(value="ui.supportingJAlbumMenu")
        Action supportingjAlbumAction = new LambdaAction(() -> {
            try {
                BrowserLauncher.openURL(JAlbumSite.getInstance().getSupportingUrl() + "/?utm_source=client&utm_medium=supportingItem&utm_campaign=helpMenu&referrer=jalbumHelpMenu" + this.attemptSignIn());
            }
            catch (IOException ex) {
                JAlbumFrame.this.messageBox(ex.getMessage(), 32);
            }
        });
        @Text(value="ui.licenseInfo")
        Action licenseInfoAction = new LambdaAction(() -> JAlbumFrame.this.showAboutBox());
        @Text(value="ui.importSettingsMenu")
        Action importSettingsAction = new LambdaAction(() -> {
            FileChooser projectChooser1 = ChooserFactory.createFileChooser(JAlbumFrame.this);
            File myAlbums = ProjectGroups.getInstance().getCurrentGroup().getLocation();
            if (myAlbums.exists()) {
                projectChooser1.setCurrentDirectory(myAlbums);
            }
            projectChooser1.setDialogTitle(Msg.get("ui.importSettingsTitle"));
            projectChooser1.setFileFilter(JAlbumFrame.this.albumProjectFileFilter);
            int returnVal = projectChooser1.showOpenDialog(JAlbumFrame.this);
            if (returnVal == 0) {
                JAlbumFrame.this.importSettingsFromFile(projectChooser1.getSelectedFile());
            }
        });
        @Text(value="ui.importPublishedSettingsMenu")
        Action importPublishedSettingsAction = new LambdaAction(() -> {
            final String answer = (String)JOptionPane.showInputDialog(JAlbumFrame.this, Msg.get("ui.importPublishedSettingsInfo"), Msg.get("ui.importPublishedSettingsTitle"), 1, null, null, JAlbumFrame.this.importPublishedSettingsAddress);
            if (answer != null) {
                JAlbumFrame.this.importPublishedSettingsAddress = answer;
                new SwingWorker<Properties, Object>(this){
                    final /* synthetic */ JAlbumFrameActions this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    protected Properties doInBackground() throws Exception {
                        ZipEntry entry;
                        this.this$1.JAlbumFrame.this.progressSpinner.workStarted();
                        this.this$1.JAlbumFrame.this.statusBar.setText("");
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Object address = answer.trim();
                        if (((String)address).indexOf(32) != -1) {
                            address = IO.urlEncode((String)address);
                        }
                        if (!((String)address).toLowerCase().startsWith("http://") && !((String)address).toLowerCase().startsWith("https://")) {
                            address = "http://" + (String)address;
                        }
                        if (((String)address).toLowerCase().endsWith(".html") || ((String)address).toLowerCase().endsWith(".htm")) {
                            address = ((String)address).substring(0, ((String)address).lastIndexOf(47));
                        }
                        IO.downloadFile(new URL(IO.combinePaths((String)address, "lifeboat.zip")), baos);
                        byte[] bytes = baos.toByteArray();
                        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                        ZipInputStream zis = new ZipInputStream(bais);
                        Properties props = new Properties();
                        while ((entry = zis.getNextEntry()) != null) {
                            if (!entry.getName().endsWith(".jap")) continue;
                            props.load(zis);
                            zis.close();
                            return props;
                        }
                        throw new FileNotFoundException(Msg.get("ui.projectFileNotFoundError", address));
                    }

                    @Override
                    protected void done() {
                        this.this$1.JAlbumFrame.this.progressSpinner.workDone();
                        try {
                            Object address = answer.trim();
                            if (((String)address).indexOf(32) != -1) {
                                address = IO.urlEncode((String)address);
                            }
                            if (!((String)address).toLowerCase().startsWith("http://") && !((String)address).toLowerCase().startsWith("https://")) {
                                address = "http://" + (String)address;
                            }
                            this.this$1.JAlbumFrame.this.importSettings((Properties)this.get(), (String)address);
                        }
                        catch (InterruptedException address) {
                        }
                        catch (ExecutionException ex) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof FileNotFoundException) {
                                JOptionPane.showMessageDialog(this.this$1.JAlbumFrame.this, Msg.get("ui.albumSettingsNotFoundError"), Msg.get("ui.importPublishedSettingsTitle"), 0);
                            }
                            Debug.showErrorDialog(this.this$1.JAlbumFrame.this, cause);
                        }
                    }
                }.execute();
            }
        });
        @Text(value="ui.importDefaultSettingsMenu")
        Action importDefaultSettingsAction = new LambdaAction(() -> JAlbumFrame.this.importSettingsFromFile(AlbumProject.defaultProjectFile));
        @Text(value="ui.skinDirectoryMenu")
        @Shortcut(value="cmd shift S")
        Action openSkinDirectoryAction = new LambdaAction(() -> {
            File skinDir = JAlbumFrame.this.cfg.chainedSkinsDir.getFile(JAlbumFrame.this.engine.getSkin());
            this.open(skinDir);
        });
        @Text(value="ui.programDirectoryMenu")
        @Shortcut(value="cmd shift P")
        Action openProgramDirectoryAction = new LambdaAction(() -> this.open(JAlbumFrame.this.cfg.progDir));
        @Text(value="ui.configDirectoryMenu")
        @Shortcut(value="cmd shift C")
        Action openConfigDirectoryAction = new LambdaAction(() -> this.open(MiniConfig.getMiniConfig().configDir));
        @Text(value="ui.imageDirectoryLabel")
        @Shortcut(value="cmd shift I")
        Action openImageDirectoryAction = new LambdaAction(() -> {
            JAlbumFrame.this.ui2Engine();
            Tracer.getInstance().trace("open image directory");
            this.open(new File(JAlbumFrame.this.engine.getDirectory()));
        });
        @Text(value="ui.outputDirectory")
        @Shortcut(value="cmd shift O")
        Action openOutputDirectoryAction = new LambdaAction(() -> {
            JAlbumFrame.this.ui2Engine();
            Tracer.getInstance().trace("open output directory");
            this.open(JAlbumFrame.this.engine.getOutputDir());
        });
        @Text(value="ui.duplicateProject", postfix="...")
        Action duplicateProjectAction = new LambdaAction(() -> {
            AlbumProject currentProject = JAlbumFrame.this.getCurrentProject();
            File dest = null;
            try {
                while (true) {
                    Object projectName = currentProject.getName() + " (" + Msg.get("ui.copyOfSomething") + ")";
                    projectName = JAlbumFrame.this.readString(Msg.get("newproject.albumNameLabel"), Msg.get("ui.duplicateProject"), (String)projectName);
                    if (projectName == null) return;
                    dest = new File(currentProject.getRootFolder().getFile().getParentFile(), (String)projectName);
                    if (!dest.exists()) break;
                    JOptionPane.showMessageDialog(JAlbumFrame.this, Msg.get("newProject.projectAlreadyExistsError", dest.getName()), Msg.get("ui.duplicateProject"), 0);
                }
                dest.mkdir();
                FileCopier copier = new FileCopier(JAlbumFrame.this);
                AlbumObject destAO = currentProject.getRootFolder().getFactory().createInstance(dest);
                ProjectSettings settings = JAlbumFrame.this.getProjectSettings();
                settings.main.remove("directory");
                settings.main.remove("remoteDirectory");
                settings.main.remove("outputDirectory");
                File newProjFile = new File(dest, "jalbum-settings.jap");
                settings.save(newProjFile);
                File interpretedOutputDirectory = JAlbumFrame.this.engine.getOutputDir();
                copier.copyFiles(Arrays.asList(currentProject.getRootFolder().getFile().listFiles(f -> !IO.isSystemFile(f.getName()) && !f.getName().endsWith(".jap") && !f.equals(interpretedOutputDirectory))), destAO);
                JAlbumFrame.this.loadProject(newProjFile);
                AlbumObject root = JAlbumFrame.this.albumExplorer.getRootFolder();
                AlbumObjectProperties rootProps = root.getProperties();
                rootProps.remove("lastPublishedDate");
                rootProps.remove("firstPublishedDate");
                rootProps.remove("remotePath");
                rootProps.remove("albumURL");
                rootProps.save();
                return;
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JAlbumFrame.this, ex);
            }
        });
        @Text(value="ui.backupProjects", postfix="...")
        Action backupProjectsAction = new LambdaAction(ae -> {
            JBackupFrame backupFrame = new JBackupFrame(JAlbumFrame.this.context);
            backupFrame.setVisible(true);
        });
        @Text(value="ui.restoreProjects", postfix="...")
        Action restoreProjectsAction = new LambdaAction(ae -> {
            JRestoreFrame restoreFrame = new JRestoreFrame(JAlbumFrame.this.context);
            restoreFrame.setVisible(true);
        });
        public Action lastToolTargetAction;
        @Text(value="ui.lastTool")
        @Shortcut(value="cmd L")
        public Action lastToolAction = new LambdaAction(e -> {
            if (this.lastToolTargetAction != null) {
                this.lastToolTargetAction.actionPerformed(e);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }).enabled(false);
        @Text(value="ui.reloadSkin")
        @Shortcut(value="cmd R")
        Action reloadSkinAction = new LambdaAction(() -> JAlbumFrame.this.reloadSkin());
        @ToolTipText(value="ui.attachInboxToolTip")
        @se.datadosen.util.annotations.Icon(value="20x20/collaborative-attach.svg")
        private Action getAccountAction = new AbstractAction(Msg.get("ui.attachInbox", Msg.get("ui.userName").toLowerCase() + "@jalbum.net")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.ensureSignedIn(Msg.get("ui.attachInbox", Msg.get("ui.userName").toLowerCase() + "@jalbum.net"), JAlbumFrameActions.this.attachAction);
            }
        };
        @ToolTipText(value="ui.attachInboxToolTip")
        @se.datadosen.util.annotations.Icon(value="20x20/collaborative-attach.svg")
        private Action attachAction = new AbstractAction(Msg.get("ui.attachInbox", Msg.get("ui.userName").toLowerCase() + "@jalbum.net")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        JAlbumFrame.this.progressSpinner.workStarted();
                        this.setEnabled(false);
                        CollaborationBean cb = new CollaborationBean();
                        cb.attachInbox(JAlbumFrame.this.getRoot(), JAlbumFrameActions.this.getSignedInAccountProfile());
                        return null;
                    }

                    @Override
                    protected void done() {
                        this.setEnabled(true);
                        JAlbumFrame.this.progressSpinner.workDone();
                        JAlbumFrameActions.this.updateCollaborationActions();
                        try {
                            this.get();
                            JOptionPane.showMessageDialog(JAlbumFrame.this, Msg.get("ui.attachInboxConfirmation", JAlbumFrameActions.this.getAttachedEmail(), JAlbumFrame.this.getRoot().getName()), Msg.get("ui.attachInbox", JAlbumFrameActions.this.getAttachedEmail()), 1);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            Debug.showFriendlyErrorDialog(JAlbumFrame.this, ex.getCause());
                        }
                    }
                }.execute();
            }
        };
        @se.datadosen.util.annotations.Icon(value="20x20/collaborative-detach.svg")
        private Action detachAction = new AbstractAction(Msg.get("ui.detachInbox", Msg.get("ui.userName").toLowerCase() + "@jalbum.net")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        JAlbumFrame.this.progressSpinner.workStarted();
                        this.setEnabled(false);
                        CollaborationBean cb = new CollaborationBean();
                        cb.detachInbox(JAlbumFrame.this.getRoot(), JAlbumFrameActions.this.getAttachedAccountProfile());
                        return null;
                    }

                    @Override
                    protected void done() {
                        this.setEnabled(true);
                        JAlbumFrame.this.progressSpinner.workDone();
                        JAlbumFrameActions.this.updateCollaborationActions();
                        try {
                            this.get();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            Debug.showFriendlyErrorDialog(JAlbumFrame.this, ex.getCause());
                        }
                    }
                }.execute();
            }
        };
        public AliasAction attachDetachAction = new AliasAction(this.attachAction);
        @Text(value="ui.fetchNewObjects")
        @se.datadosen.util.annotations.Icon(value="20x20/collaborative-fetch.svg")
        Action fetchNewObjectsAction = new LambdaAction(() -> {
            final AlbumProject currentProject = JAlbumFrame.this.getCurrentProject();
            new SwingWorker<Integer, String>(this){
                CollaborationBean cb = new CollaborationBean();
                final /* synthetic */ JAlbumFrameActions this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String msg : chunks) {
                        this.this$1.JAlbumFrame.this.statusBar.setText(msg);
                    }
                }

                @Override
                protected Integer doInBackground() throws Exception {
                    currentProject.workStarted();
                    this.this$1.JAlbumFrame.this.setEnabled(false);
                    this.publish(Msg.get("ui.checkingObjects", this.this$1.JAlbumFrame.this.getRoot().getName()));
                    AccountProfile ap = this.this$1.getAttachedAccountProfile();
                    this.cb.connect(ap);
                    List<RemoteFile> newObjects = this.cb.listNewObjects(ap, this.this$1.JAlbumFrame.this.getRoot());
                    int objectCount = newObjects.size();
                    if (objectCount > 0) {
                        this.publish(Msg.get("ui.fetchingObjects", objectCount, this.this$1.JAlbumFrame.this.getRoot().getName()));
                        this.cb.fetchNewObjects(newObjects, this.this$1.JAlbumFrame.this.getRoot());
                    }
                    this.publish(Msg.get("edit.doneInfo"));
                    return objectCount;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                protected void done() {
                    this.cb.disconnect();
                    this.this$1.JAlbumFrame.this.setEnabled(true);
                    currentProject.workDone();
                    this.this$1.updateCollaborationActions();
                    try {
                        int objectCount = (Integer)this.get();
                        if (objectCount <= 0) return;
                    }
                    catch (InterruptedException objectCount) {
                        return;
                    }
                    catch (ExecutionException ex) {
                        Debug.showFriendlyErrorDialog(this.this$1.JAlbumFrame.this, ex.getCause());
                    }
                }
            }.execute();
        });
        @Text(value="ui.inviteEmail")
        @ToolTipText(value="ui.inviteTooltip")
        @se.datadosen.util.annotations.Icon(value="20x20/email.svg")
        Action inviteEmailAction = new LambdaAction(() -> {
            String body = Msg.get("ui.inviteMailBody", this.getAttachedEmail(), JAlbumFrame.this.getRoot().getName());
            body = IO.urlEncode(body);
            try {
                URI uri = new URI("mailto:?reply-to=" + this.getAttachedEmail() + "&subject=" + IO.urlEncode(JAlbumFrame.this.getRoot().getName()) + "&body=" + body);
                Desktop.getDesktop().mail(uri);
            }
            catch (IOException | URISyntaxException ex) {
                Debug.showErrorDialog(JAlbumFrame.this, ex);
            }
        });
        @Text(value="ui.inviteQR")
        @se.datadosen.util.annotations.Icon(value="20x20/qr-code.svg")
        Action inviteQRAction = new LambdaAction(() -> {
            String body = IO.urlEncode(Msg.get("ui.inviteQRMailBody"));
            String url = "mailto:" + this.getAttachedEmail() + "?&subject=" + IO.urlEncode(JAlbumFrame.this.getRoot().getName()) + "&body=" + body;
            JOptionPane.showMessageDialog(JAlbumFrame.this, new JQRComponent(url), Msg.get("ui.inviteQR"), -1);
        });
        @Text(value="ui.downloadSkins")
        @ToolTipText(value="ui.downloadSkinsToolTip")
        Action downloadMoreSkinsAction = new LambdaAction(() -> {
            try {
                BrowserLauncher.openURL(JAlbumSite.getInstance().getSkinsUrl() + "?utm_source=client&utm_medium=jAlbumWeb&utm_campaign=helpMenu");
            }
            catch (IOException ex) {
                JAlbumFrame.this.messageBox(ex.getMessage(), 32);
            }
        });
        @se.datadosen.util.annotations.Icon(value="14x14/sign-in.svg")
        Action signInAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignInManager.getInstance().showDialog();
            }
        };
        Action signOutAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.toolBars.signInOutButton.setAction(JAlbumFrameActions.this.signInAction);
                SignInManager.getInstance().doSignOut();
            }
        };
        @se.datadosen.util.annotations.Icon(value="16x16/btn-view.svg")
        @Text(value="ui.search")
        @ToolTipText(value="ui.searchToolTip")
        @Shortcut(value="ctrl SPACE")
        Action searchAction = new LambdaAction(e -> JAlbumFrame.this.searchBar.activate());
        @se.datadosen.util.annotations.Icon(value="20x20/help.svg")
        Action helpAction = new LambdaAction(e -> {
            try {
                File localHelp = new File(JAlbumFrame.this.cfg.progDir, "help/index.html");
                if (localHelp.exists()) {
                    BrowserLauncher.openLocal(localHelp);
                } else {
                    BrowserLauncher.openURL(JAlbumSite.getInstance().getHelpUrl() + "?referrer=jalbumHelpButton&utm_source=client&utm_medium=helpButton&utm_campaign=client");
                }
            }
            catch (IOException ex) {
                JAlbumFrame.this.messageBox(ex.getMessage(), 32);
            }
        });
        @Text(value="ui.importPublishedAlbum", postfix="...")
        public Action importPublishedAlbum = new LambdaAction(e -> {
            Tracer.getInstance().trace("import published album");
            JDownloadWizard pw = new JDownloadWizard(JAlbumFrame.this.context);
            JAlbumFrame.this.prepareWindow(pw);
            pw.accountsStep.connectAction.actionPerformed(null);
            pw.setVisible(true);
        });
        @Text(value="ui.importLocalAlbum", postfix="...")
        public Action importLocalAlbum = new LambdaAction(e -> {
            Tracer.getInstance().trace("import local album");
            DirectoryChooser chooser = ChooserFactory.createDirectoryChooser(JAlbumFrame.this);
            chooser.setDialogTitle("Select album folder to import as project");
            int answer = chooser.showOpenDialog(JAlbumFrame.this);
            if (answer != 0) {
                return;
            }
            File srcDir = chooser.getSelectedFile();
            File projectDir = IO.ensureUnique(ProjectGroups.getInstance().getCurrentGroup().getLocation(), srcDir.getName());
            projectDir.mkdirs();
            try {
                JAlbumFrame.this.statusBar.pushText("Importing...");
                JAlbumFrame.this.progressSpinner.workStarted();
                JAlbumFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                RecoveryTool.recreateProjectFromAlbum(srcDir, projectDir);
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JAlbumFrame.this, ex);
            }
            finally {
                JAlbumFrame.this.statusBar.popText("Importing...");
                JAlbumFrame.this.progressSpinner.workDone();
                JAlbumFrame.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        @Text(value="ui.makeAlbum")
        @se.datadosen.util.annotations.Icon(value="16x16/btn-make.svg")
        @Shortcut(value="F9")
        public Action makeAction = new LambdaAction(e -> JAlbumFrame.this.makeAlbum(null, false)).enabled(false);
        @Text(value="ui.makeInBackground")
        @Shortcut(value="cmd M")
        public Action makeInBackgroundAction = new LambdaAction(() -> JAlbumFrame.this.multiMaker.makeCurrentProjectInBackground(false));
        @Text(value="ui.makeAndUploadInBackground")
        @Shortcut(value="cmd shift M")
        public Action makeAndUploadInBackgroundAction = new LambdaAction(() -> JAlbumFrame.this.multiMaker.makeCurrentProjectInBackground(true));
        @Text(value="ui.makeTest")
        @ToolTipText(value="ui.makeAlbumToolTip")
        @Shortcut(value="alt F9")
        public Action makeTestAction = new LambdaAction(e -> JAlbumFrame.this.makeAlbum(false, false)).enabled(false);
        @Text(value="ui.forceRemake")
        @ToolTipText(value="ui.rebuildAllToolTip")
        @Shortcut(value="shift F9")
        Action forceRebuildAction = new LambdaAction(e -> JAlbumFrame.this.makeAlbum(true, JAlbumFrame.altDown(e))).enabled(false);
        @Text(value="ui.multiMaker", postfix="...")
        @Shortcut(value="cmd alt M")
        public SmartAction multiMakerAction = new SmartAction(){
            {
                this.updateToolTip();
                JAlbumFrame.this.context.getLicenseManager().addPropertyChangeListener("licenseValid", pce -> this.updateToolTip());
            }

            private void updateToolTip() {
                this.putValue("ShortDescription", Boolean.valueOf(JAlbumFrame.this.context.getLicenseManager().isLicenseValid()) != false ? Msg.get("ui.multiMakerToolTip") : Msg.get("ui.licensedOnlyMask"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.multiMaker.setVisible(true);
                JAlbumFrame.this.multiMaker.setState(0);
                JAlbumFrame.this.multiMaker.toFront();
            }
        };
        @Text(value="ui.settings")
        @se.datadosen.util.annotations.Icon(value="16x16/btn-settings.svg")
        @Shortcut(value="F4")
        public Action settingsAction = new LambdaAction(e -> {
            Tracer.getInstance().trace("show settings");
            JAlbumFrame.this.settingsWindow.setVisible(true);
        });
        @se.datadosen.util.annotations.Icon(value="16x16/btn-settings.svg")
        public Action skinSettingsAction = new MultilingualAction(){
            {
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JAlbumFrame.this.getSkinUI() != null) {
                    if (!JAlbumFrame.this.settingsWindow.isShowing()) {
                        JAlbumFrame.this.settingsWindow.pack();
                        JAlbumFrame.this.settingsWindow.setVisible(true);
                    }
                    Tracer.getInstance().trace("show skin settings");
                    JAlbumFrame.this.settingsWindow.buttonBarPane.show(JAlbumFrame.this.settingsWindow.skinSettingsPanel);
                    JAlbumFrame.this.settingsWindow.toFront();
                }
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.languageUpdated();
            }

            @Override
            public void languageUpdated() {
                this.putValue("Name", JAlbumFrame.this.getSkinUI() != null ? Msg.get("ui.skinSettings", JAlbumFrame.this.engine.getSkin()) + "..." : Msg.get("ui.noSkinSettings"));
            }
        };
        @ToolTipText(value="skinInfo.title", postfix="...")
        @se.datadosen.util.annotations.Icon(value="16x16/information.svg")
        public Action skinInfoAction = new LambdaAction(e -> {
            if (JAlbumFrame.this.skinInfoFrame == null) {
                JAlbumFrame.this.skinInfoFrame = new JSkinInfo(JAlbumContext.getInstance());
            }
            JAlbumFrame.this.show(JAlbumFrame.this.skinInfoFrame);
            JAlbumFrame.this.skinInfoFrame.toFront();
        });
        @se.datadosen.util.annotations.Icon(value="20x20/btn-view-uploaded.svg")
        public Action viewRemoteAlbumAction = new LambdaAction(e -> {
            boolean altDown = e != null && (e.getModifiers() & 8) != 0;
            AlbumObjectProperties props = JAlbumFrame.this.albumExplorer.getRootFolder().getProperties();
            String url = IO.urlEncode((String)props.get("albumURL"));
            try {
                if (altDown) {
                    JAlbumFrame.this.openInBrowser(JAlbumFrame.this.getCurrentProject(), new URL(url), false, e.getModifiers());
                } else {
                    JAlbumFrame.this.openInBrowser(JAlbumFrame.this.getCurrentProject(), new URL(url), null, e.getModifiers());
                }
            }
            catch (MalformedURLException ex) {
                Debug.showErrorDialog(JAlbumFrame.this, new MalformedURLException(url));
            }
        }).enabled(false);
        @Text(value="ui.preview")
        @ToolTipText(value="ui.viewAlbumToolTip")
        @se.datadosen.util.annotations.Icon(value="20x20/btn-view.svg")
        @Shortcut(value="F12")
        public Action viewAlbumAction = new LambdaAction(e -> {
            boolean altDown;
            boolean bl = altDown = e != null && (e.getModifiers() & 8) != 0;
            if (JAlbumFrame.this.albumExplorer.isPreviewMode() && !altDown) {
                JAlbumFrame.this.albumExplorer.setExplorerView();
                return;
            }
            try {
                final File indexFile = JAlbumFrame.this.getIndexFile();
                if (!indexFile.exists()) {
                    int answer = JOptionPane.showConfirmDialog(JAlbumFrame.this, Msg.get("ui.albumNotFoundInfo"), Msg.get("ui.preview"), 0, 1);
                    if (answer != 0) {
                        return;
                    }
                    JAlbumFrame.this.addJAlbumListener(new JAlbumAdapter(this){
                        final /* synthetic */ JAlbumFrameActions this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void albumCreationFinished(JAlbumEvent e) {
                            try {
                                if (altDown) {
                                    this.this$1.JAlbumFrame.this.openInBrowser(indexFile.toURI().toURL(), (Boolean)false);
                                } else {
                                    this.this$1.JAlbumFrame.this.openInBrowser(indexFile.toURI().toURL(), null);
                                }
                                UsageCounters.increase("preview");
                            }
                            catch (MalformedURLException ex) {
                                throw new RuntimeException(ex);
                            }
                            this.this$1.JAlbumFrame.this.progressDialog.dispose();
                            this.this$1.JAlbumFrame.this.removeJAlbumListener(this);
                        }
                    });
                    this.makeTestAction.actionPerformed(e);
                } else {
                    if (altDown) {
                        JAlbumFrame.this.openInBrowser(JAlbumFrame.this.getCurrentProject(), indexFile.toURI().toURL(), false, e.getModifiers());
                    } else {
                        JAlbumFrame.this.openInBrowser(JAlbumFrame.this.getCurrentProject(), indexFile.toURI().toURL(), null, e.getModifiers());
                    }
                    UsageCounters.increase("preview");
                }
            }
            catch (HeadlessException | MalformedURLException ex) {
                Logger.getLogger(JAlbumFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }).enabled(false);
        @Text(value="ui.phonePreviewer")
        @Shortcut(value="shift F12")
        public Action phonePreviewerAction = new LambdaAction(e -> this.viewAlbumAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.getActionCommand(), e.getWhen(), 1))).enabled(false);
        @Text(value="ui.sharePanel", postfix="...")
        Action showShareWindowAction = new LambdaAction(() -> JAlbumFrame.this.show(JAlbumFrame.this.shareWindow));
        @Text(value="ui.publishPanel", postfix="...")
        @Shortcut(value="cmd alt U")
        Action showPublishWindowAction = new LambdaAction(e -> {
            if (JAlbumFrame.this.publishWizard != null && JAlbumFrame.this.publishWizard.isShowing() && (e.getModifiers() & 1) == 0) {
                JAlbumFrame.this.publishWizard.toFront();
                return;
            }
            JAlbumFrame.this.publishWizard = new JPublishWizard(JAlbumFrame.this.context);
            JAlbumFrame.this.show(JAlbumFrame.this.publishWizard);
        });
        @Text(value="ui.upload")
        @ToolTipText(value="ui.publishToolTip")
        @se.datadosen.util.annotations.Icon(value="20x20/upload.svg")
        public Action publishAction = new LambdaAction(e -> {
            boolean shiftDown;
            AccountManager manager = AccountManager.getInstance();
            AccountProfile currentAccount = manager.findCurrentAccount(JAlbumFrame.this.engine);
            boolean externalAccount = currentAccount != null && !currentAccount.isMyjalbum();
            boolean altDown = e != null && (e.getModifiers() & 8) != 0;
            boolean bl = shiftDown = e != null && (e.getModifiers() & 1) != 0;
            if (manager.hasAccounts() && shiftDown) {
                this.showPublishWindowAction.actionPerformed(e);
            } else if (manager.hasAccounts()) {
                JAlbumFrame.this.ui2Engine();
                File dir = JAlbumFrame.this.engine.getOutputDir();
                if (!dir.isDirectory()) {
                    JOptionPane.showMessageDialog(JAlbumFrame.this, Msg.get("publish.invalidOutputDirectoryError"), Msg.get("publish.publishAlbumTitle"), 1);
                    return;
                }
                Tracer.getInstance().trace("open quick publish window");
                JPublishWizard pw = new JPublishWizard(JAlbumFrame.this.context);
                JAlbumFrame.this.prepareWindow(pw);
                pw.accountsStep.connectAction.actionPerformed(null);
                if (!(altDown ^ externalAccount)) {
                    pw.publishStep.smartUploadAction.actionPerformed(null);
                } else {
                    SwingUtilities.invokeLater(() -> JAlbumFrame.this.show(pw));
                }
            } else {
                JButton toJalbum = new JButton(Msg.get("upload.toJalbumNet"), Icons.get("dor-32-gradient", 24));
                toJalbum.addActionListener(e2 -> {
                    JAlbumFrame.getDialogAncestor((JButton)e2.getSource()).setVisible(false);
                    JAlbumFrame.getDialogAncestor((JButton)e2.getSource()).dispose();
                    JAlbumFrame.this.ensureSignedIn(Msg.get("ui.upload"), JAlbumFrame.this.actions.publishAction);
                });
                JButton toOwnSite = new JButton(Msg.get("upload.toOwnWebSite"), Icons.get("earth_mini", 24));
                toOwnSite.addActionListener(e2 -> {
                    JAlbumFrame.getDialogAncestor((JButton)e2.getSource()).setVisible(false);
                    JAlbumFrame.getDialogAncestor((JButton)e2.getSource()).dispose();
                    AccountManager.getInstance().addAccount(new AccountProfile(Msg.get("publish.NewAccount")));
                    JAlbumFrame.this.actions.showPublishWindowAction.actionPerformed(e);
                });
                try {
                    File signupFile = new File(Config.getConfig().progDir, "system/signup.properties");
                    if (signupFile.exists()) {
                        Properties props = IO.readPropertyFile(signupFile);
                        String pName = (String)props.get("partnerName");
                        String pIconUrl = (String)props.get("partnerIconUrl");
                        String pServerName = (String)props.get("partnerServerName");
                        String pProtocol = (String)props.get("partnerProtocol");
                        if (pName != null && pIconUrl != null) {
                            toJalbum = new JButton(pName, new ImageIcon(new URL(pIconUrl)));
                            toJalbum.addActionListener(e2 -> {
                                JAlbumFrame.getDialogAncestor((JButton)e2.getSource()).setVisible(false);
                                JAlbumFrame.getDialogAncestor((JButton)e2.getSource()).dispose();
                                JAlbumFrame.this.actions.showPublishWindowAction.actionPerformed(e);
                                AccountProfile ap = new AccountProfile(Msg.get("publish.NewAccount"));
                                if (pServerName != null) {
                                    ap.setFtpServer(pServerName);
                                }
                                if (pProtocol != null) {
                                    ap.setProtocol(TransferProtocol.valueOf(pProtocol));
                                }
                                JAlbumFrame.this.publishWizard.accountsStep.addAccount(ap);
                                JAlbumFrame.this.publishWizard.accountsStep.ftpUser.requestFocusInWindow();
                            });
                        }
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                JOptionPane.showOptionDialog(JAlbumFrame.this, Msg.get("upload.destinationQuestion"), Msg.get("ui.upload"), 0, 3, null, new Object[]{toJalbum, toOwnSite}, toJalbum);
            }
        });
        @Text(value="ui.uploadInBackground")
        @Shortcut(value="cmd shift U")
        public Action uploadInBackgroundAction = new LambdaAction(() -> {
            AccountManager mgr = AccountManager.getInstance();
            if (!mgr.hasAccounts() || mgr.findCurrentAccount(JAlbumFrame.this.engine).getFtpWebRootDirectory().equals("VALUE_UNSET")) {
                this.publishAction.actionPerformed(null);
            } else {
                JAlbumFrame.this.multiMaker.uploadInBackground(JAlbumFrame.this.engine);
            }
        });
        @Text(value="ui.embedAlbum")
        @ToolTipText
        @se.datadosen.util.annotations.Icon(value="16x16/embed.svg")
        public Action embedAlbumAction = new LambdaAction(() -> {
            JSmartDialog dialog = new JSmartDialog((Frame)JAlbumFrame.this, Msg.get("ui.embedAlbum"));
            JEmbedPanel embedPanel = new JEmbedPanel(JAlbumFrame.this.context);
            embedPanel.setBorder(null);
            dialog.getContentPane().add(embedPanel);
            dialog.pack();
            dialog.setLocationRelativeTo(JAlbumFrame.this);
            dialog.setVisible(true);
        });
        @Text(value="ui.prefsPanel")
        @Shortcut(value="cmd ,")
        Action showPreferencesWindowAction = new LambdaAction(() -> {
            Tracer.getInstance().trace("show preferences");
            JAlbumFrame.this.show(JAlbumFrame.this.preferencesWindow);
        });
        @Text(value="ui.consoleMenu")
        @Shortcut(value="F7")
        Action showConsoleWindowAction = new LambdaAction(() -> JAlbumFrame.this.console.setVisible(true));
        @Text(value="ui.activateLicense", postfix="...")
        Action activateLicenseAction = new LambdaAction(() -> {
            LicenseManagerImpl mgr = (LicenseManagerImpl)JAlbumFrame.this.context.getLicenseManager();
            mgr.activateLicense();
        });
        @Text(value="ui.detachLicense", postfix="...")
        Action detachLicenseAction = new LambdaAction(() -> {
            LicenseManagerImpl mgr = (LicenseManagerImpl)JAlbumFrame.this.context.getLicenseManager();
            int answer = JOptionPane.showConfirmDialog(JAlbumFrame.this, Msg.get("ui.detachLicenseConfirmation", mgr.getUserName()), Msg.get("ui.detachLicense"), 0);
            if (answer == 0) {
                mgr.detachLicense();
            }
        });
        @Text(value="ui.contextHelp")
        @Shortcut(value="F1")
        Action contextHelpAction = new LambdaAction(() -> {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window active = keyboardFocusManager.getActiveWindow();
            ContextHelp.getInstance().getContext(active).getHelpAction().actionPerformed(null);
        });

        private String attemptSignIn() {
            SignInManager mgr = SignInManager.getInstance();
            if (mgr.isSignedIn()) {
                return "&cid=" + AccountManager.getCid(mgr.getUserName(), mgr.getPassword());
            }
            return "";
        }

        private void open(File dir) {
            try {
                Desktop.getDesktop().open(dir);
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public JAlbumFrameActions() {
            Msg.maintainTranslated(this);
            SignInManager.getInstance().addPropertyChangeListener("signIn", evt -> this.updateCollaborationActions());
            this.multiMakerAction.enabledProperty().bind((ObservableValue)JAlbumFrame.this.context.getLicenseManager().licenseValidProperty());
        }

        public void setLastTool(Action lastTool) {
            this.setLastTool(lastTool, (String)lastTool.getValue("Name"));
        }

        public void setLastTool(Action lastTool, String name) {
            this.lastToolTargetAction = lastTool;
            this.lastToolAction.putValue("Name", Msg.get("ui.lastTool") + ": " + name);
            this.lastToolAction.setEnabled(true);
        }

        private void updateCollaborationActions() {
            String email;
            if (JAlbumFrame.this.getRoot() != null && (email = this.getAttachedEmail()) != null) {
                this.detachAction.putValue("Name", Msg.get("ui.detachInbox", email));
                this.attachDetachAction.setAction(this.detachAction);
                boolean found = this.getAttachedAccountProfile() != null;
                this.detachAction.setEnabled(found);
                this.inviteEmailAction.setEnabled(found);
                this.inviteQRAction.setEnabled(found);
                this.fetchNewObjectsAction.setEnabled(found);
                return;
            }
            this.inviteEmailAction.setEnabled(false);
            this.inviteQRAction.setEnabled(false);
            this.fetchNewObjectsAction.setEnabled(false);
            String username = (String)JAlbumFrame.this.getRoot().getProperties().get("inboxUserName");
            if (username == null) {
                SignInManager siMgr = SignInManager.getInstance();
                if (siMgr.isSignedIn()) {
                    username = siMgr.getUserName();
                    this.attachAction.putValue("Name", Msg.get("ui.attachInbox", username.toLowerCase() + "@jalbum.net"));
                    this.attachDetachAction.setAction(this.attachAction);
                } else {
                    this.attachDetachAction.setAction(this.getAccountAction);
                    username = Msg.get("ui.userName");
                }
            }
        }

        String getAttachedEmail() {
            String inboxUserName = (String)JAlbumFrame.this.getRoot().getProperties().get("inboxUserName");
            if (inboxUserName != null) {
                return inboxUserName.toLowerCase() + "@jalbum.net";
            }
            return null;
        }

        private AccountProfile getAttachedAccountProfile() {
            SignInManager smgr;
            AccountManager mgr;
            AccountProfile ap = null;
            String inboxUserName = (String)JAlbumFrame.this.getRoot().getProperties().get("inboxUserName");
            if (inboxUserName != null && (ap = (mgr = AccountManager.getInstance()).findJAlbumAccountByUserName(inboxUserName)) == null && inboxUserName.equals((smgr = SignInManager.getInstance()).getUserName())) {
                return this.getSignedInAccountProfile();
            }
            return ap;
        }

        private AccountProfile getSignedInAccountProfile() {
            AccountProfile ap = null;
            SignInManager smgr = SignInManager.getInstance();
            if (smgr.isSignedIn()) {
                ap = new AccountProfile();
                ap.setProtocol(TransferProtocol.sftp);
                ap.setFtpServer(smgr.getUserName() + ".jalbum.net");
                ap.setFtpPort(22);
                ap.setFtpUser(smgr.getUserName());
                ap.setFtpPassword(smgr.getPassword());
                ap.setName();
            }
            return ap;
        }
    }

    public class JAlbumFrameButtons {
        public static final int MARGIN = 8;
        private JToolBar communityToolBar = new JToolBar();
        public JButton signInOutButton;
        public JNotificationsButton notificationButton;
        JLinkLabel pricingLink;

        JAlbumFrameButtons() {
            this.signInOutButton = new JToolBarButton(JAlbumFrame.this.actions.signInAction);
            this.notificationButton = new JNotificationsButton(JAlbumFrame.this.albumExplorer.notificationButtonAction);
            this.pricingLink = new JLinkLabel(JAlbumSite.getInstance().getPricingUrl() + "/?utm_source=client&utm_medium=pricingLink&utm_campaign=mainWindow", Msg.get("ui.pricing"));
            this.init();
        }

        public JComponent getCommunityToolBar() {
            return this.communityToolBar;
        }

        private void init() {
            this.communityToolBar.setFloatable(false);
            this.communityToolBar.add(this.pricingLink);
            this.communityToolBar.add(Box.createHorizontalStrut(8));
            this.communityToolBar.add(this.notificationButton);
            this.communityToolBar.add(Box.createHorizontalStrut(4));
            this.communityToolBar.add(this.signInOutButton);
            this.communityToolBar.addSeparator();
            JToolBarButton searchButton = new JToolBarButton(JAlbumFrame.this.actions.searchAction, true);
            if (UsageCounters.get("searchSupport") == 0) {
                JAlbumUtilities.schedule(() -> {
                    if (UsageCounters.get("searchSupport") == 0) {
                        SwingUtilities.invokeLater(() -> {
                            JSpeechBubble bubble = new JSpeechBubble("<html><center>" + Msg.get("ui.useSearchBarPrompt") + "</center></html>");
                            bubble.setExpiration(8);
                            bubble.show(searchButton, new Hour(7));
                            Sounds.play("Blow.aiff");
                        });
                    }
                }, 8L, TimeUnit.MINUTES);
            }
            this.communityToolBar.add(searchButton);
            this.communityToolBar.addSeparator();
            this.communityToolBar.add(ContextHelp.getInstance().getContext(JAlbumFrame.this).getHelpButton());
            this.communityToolBar.add(Box.createHorizontalStrut(4));
            JAlbumFrame.this.getNotificationManager().addPropertyChangeListener("oldNotificationsSize", evt -> this.notificationButton.setNotifications((Integer)evt.getNewValue()));
            PropertyChangeListener listener = evt -> this.refreshPricingLinkState();
            SignInManager.getInstance().addPropertyChangeListener("signIn", listener);
            SignInManager.getInstance().addPropertyChangeListener("signIn", evt -> {
                if (evt.getNewValue() == Boolean.TRUE) {
                    CollaborationBean.enablePolling(JAlbumFrame.this.albumExplorer.albumManager.getProjects());
                } else {
                    CollaborationBean.disablePolling();
                }
            });
            JAlbumFrame.this.context.getLicenseManager().addPropertyChangeListener("licenseValid", listener);
            this.refreshPricingLinkState();
        }

        void refreshPricingLinkState() {
            this.pricingLink.setVisible(!JAlbumFrame.this.context.getLicenseManager().isLicenseValid());
        }

        void setTexts() {
            this.pricingLink.setText(Msg.get("ui.pricing"));
        }
    }

    public class JAlbumFrameMenus {
        final JMenuBar mainMenuBar = new JMenuBar();
        @Text(value="ui.fileMenu")
        final JMenu fileMenu = new JMenu();
        @Text(value="ui.recentProjectsMenu")
        final JFileListMenu fileMenuRecentFilesMenu = new JFileListMenu(RecentProjectFiles.getInstance());
        @Text(value="ui.import")
        final JMenu importMenu = new JMenu();
        @Text(value="ui.edit")
        final JMenu editMenu = new JMenu();
        @Text(value="ui.view")
        final JMenu viewMenu = new JMenu();
        final JMenuItem viewMenuAddressBarItem;
        final JMenuItem viewMenuFilterBarItem;
        final JMenuItem viewMenuFolderPropertiesItem;
        final JMenuItem viewMenuHideExcludedItem;
        @Text(value="ui.labelType")
        final JMenu viewMenuLabelTypeSubMenu;
        @Text(value="ui.zoom")
        final JMenu viewMenuZoomSubMenu;
        @Text(value="edit.ordering")
        final JMenu viewMenuOrderBySubMenu;
        @Text(value="edit.folderOrdering")
        final JMenu viewMenuOrderFoldersBySubMenu;
        @Text(value="edit.organize")
        final JMenu organizeMenu;
        @Text(value="ui.albumMenu")
        final JMenu albumMenu;
        @Text(value="ui.toolsMenu")
        final JMenu toolsMenu;
        @Text(value="ui.openDirectoriesMenu")
        final JMenu openDirectoriesMenu;
        @Text(value="ui.externalToolsMenu")
        final JMenu toolsMenuExternalToolsSubMenu;
        @Text(value="ui.helpMenu")
        final JMenu helpMenu;
        final JMenuItem helpMenuActivateLicenseMenuItem;
        @Text(value="ui.edit")
        final JMenu editModeEditMenu;
        @Text(value="edit.filtersHeading")
        public final JMenu imageToolsMenu;
        @Text(value="ui.effectsPanel")
        public final JMenu imageEffectsMenu;
        private final List<JMenu> editMenus;
        private final List<JMenu> defaultMenus;

        private String attemptSignIn() {
            SignInManager mgr = SignInManager.getInstance();
            if (mgr.isSignedIn()) {
                return "&cid=" + AccountManager.getCid(mgr.getUserName(), mgr.getPassword());
            }
            return "";
        }

        JAlbumFrameMenus() {
            this.viewMenuAddressBarItem = new JCheckBoxMenuItem(JAlbumFrame.this.albumExplorer.addressBarAction);
            this.viewMenuFilterBarItem = new JCheckBoxMenuItem(MappedAction.noIcon(JAlbumFrame.this.albumExplorer.filterBarAction));
            this.viewMenuFolderPropertiesItem = new JCheckBoxMenuItem(MappedAction.noIcon(JAlbumFrame.this.albumExplorer.folderPropertiesAction));
            this.viewMenuHideExcludedItem = new JCheckBoxMenuItem(JAlbumFrame.this.albumExplorer.hideExcludedAction);
            this.viewMenuLabelTypeSubMenu = new JMenu();
            this.viewMenuZoomSubMenu = new JMenu();
            this.viewMenuOrderBySubMenu = new JMenu();
            this.viewMenuOrderFoldersBySubMenu = new JMenu();
            this.organizeMenu = new JMenu();
            this.albumMenu = new JMenu();
            this.toolsMenu = new JMenu();
            this.openDirectoriesMenu = new JMenu();
            this.toolsMenuExternalToolsSubMenu = new JExternalToolsMenu(JAlbumFrame.this);
            this.helpMenu = new JMenu();
            this.helpMenuActivateLicenseMenuItem = new JMenuItem();
            this.editModeEditMenu = new JMenu();
            this.imageToolsMenu = new JMenu();
            this.imageEffectsMenu = new JMenu();
            this.editMenus = List.of(this.fileMenu, this.editModeEditMenu, this.imageToolsMenu, this.imageEffectsMenu, this.albumMenu, this.toolsMenu, this.helpMenu);
            this.defaultMenus = List.of(this.fileMenu, this.editMenu, this.viewMenu, this.organizeMenu, this.albumMenu, this.toolsMenu, this.helpMenu);
            Msg.maintainTranslated(this);
            this.fileMenuRecentFilesMenu.addFileListMenuListener(e -> {
                JFileMenuItem item = (JFileMenuItem)e.getSource();
                JAlbumFrame.this.loadProject(item.getFullPath());
            });
            LicenseManager mgr = JAlbumFrame.this.context.getLicenseManager();
            mgr.addPropertyChangeListener("identified", evt -> this.helpMenuActivateLicenseMenuItem.setAction(mgr.getUserId() != -1 ? JAlbumFrame.this.actions.detachLicenseAction : JAlbumFrame.this.actions.activateLicenseAction));
            this.helpMenuActivateLicenseMenuItem.setAction(mgr.getUserId() != -1 ? JAlbumFrame.this.actions.detachLicenseAction : JAlbumFrame.this.actions.activateLicenseAction);
            this.buildMenu();
            JAlbumFrame.this.albumExplorer.editor.initMenus(this.editModeEditMenu, this.imageToolsMenu, this.imageEffectsMenu);
            JAlbumFrame.this.albumExplorer.viewPanel.addPropertyChangeListener("selectedCard", pce -> {
                if (pce.getOldValue() == JAlbumFrame.this.albumExplorer.editor || pce.getNewValue() == JAlbumFrame.this.albumExplorer.editor) {
                    Object object = this.mainMenuBar.getTreeLock();
                    synchronized (object) {
                        this.mainMenuBar.removeAll();
                        if (pce.getNewValue() == JAlbumFrame.this.albumExplorer.editor) {
                            for (JMenu m : this.editMenus) {
                                this.mainMenuBar.add(m);
                            }
                        } else {
                            for (JMenu m : this.defaultMenus) {
                                this.mainMenuBar.add(m);
                            }
                        }
                    }
                    this.mainMenuBar.revalidate();
                    this.mainMenuBar.repaint();
                }
            });
        }

        private void buildMenu() {
            this.fileMenu.add(JAlbumFrame.this.actions.newProjectAction);
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(JAlbumFrame.this.actions.projectGalleryAction));
            this.fileMenu.add(new JMenuItem(JAlbumFrame.this.actions.openProjectAction));
            this.fileMenu.add(this.fileMenuRecentFilesMenu);
            this.fileMenu.add(this.importMenu);
            this.importMenu.add(JAlbumFrame.this.actions.importSettingsAction);
            this.importMenu.add(JAlbumFrame.this.actions.importPublishedSettingsAction);
            this.importMenu.add(JAlbumFrame.this.actions.importDefaultSettingsAction);
            this.importMenu.addSeparator();
            this.importMenu.add(JAlbumFrame.this.actions.importLocalAlbum);
            this.importMenu.add(JAlbumFrame.this.actions.importPublishedAlbum);
            this.fileMenu.add(JAlbumFrame.this.actions.closeProjectAction);
            this.fileMenu.addSeparator();
            this.fileMenu.add(JAlbumFrame.this.actions.saveProjectAction);
            this.fileMenu.add(JAlbumFrame.this.actions.saveProjectAsAction);
            this.fileMenu.add(JAlbumFrame.this.actions.duplicateProjectAction);
            this.fileMenu.addSeparator();
            this.fileMenu.add(JAlbumFrame.this.actions.backupProjectsAction);
            this.fileMenu.add(JAlbumFrame.this.actions.restoreProjectsAction);
            this.fileMenu.addSeparator();
            this.fileMenu.add(JAlbumFrame.this.actions.saveAsDefaultAction);
            this.fileMenu.add(JAlbumFrame.this.actions.saveAsSkinDefaultAction);
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(new MenuAction(JAlbumFrame.this.albumExplorer.printAction)));
            if (!JAlbumFrame.isScreenMenuBar()) {
                this.fileMenu.addSeparator();
                this.fileMenu.add(JAlbumFrame.this.actions.exitAction);
            }
            this.editMenu.add(new MenuAction(JAlbumFrame.this.undoHandler.getUndoAction()));
            this.editMenu.add(new MenuAction(JAlbumFrame.this.undoHandler.getRedoAction()));
            this.editMenu.addSeparator();
            this.editMenu.add(new MenuAction(JAlbumFrame.this.albumExplorer.addAction));
            this.editMenu.add(new MenuAction(JAlbumFrame.this.albumExplorer.excludeSelectedAction));
            this.editMenu.addSeparator();
            this.editMenu.add(new MenuAction(JAlbumFrame.this.albumExplorer.cutAction));
            this.editMenu.add(new MenuAction(JAlbumFrame.this.albumExplorer.copyAction));
            this.editMenu.add(new MenuAction(JAlbumFrame.this.albumExplorer.pasteAction));
            this.editMenu.addSeparator();
            this.editMenu.add(JAlbumFrame.this.albumExplorer.selectAllAction);
            this.editMenu.add(JAlbumFrame.this.albumExplorer.selectExcludedAction);
            this.editMenu.add(JAlbumFrame.this.albumExplorer.invertSelectionAction);
            this.viewMenuAddressBarItem.setModel(JAlbumFrame.this.albumExplorer.addressBarMenuItem.getModel());
            this.viewMenu.add(this.viewMenuAddressBarItem);
            this.viewMenu.add(this.viewMenuFilterBarItem);
            this.viewMenu.add(this.viewMenuFolderPropertiesItem);
            this.viewMenu.add(this.viewMenuLabelTypeSubMenu);
            this.viewMenuHideExcludedItem.setModel(JAlbumFrame.this.albumExplorer.hideExcludedMenuItem.getModel());
            this.viewMenu.add(this.viewMenuHideExcludedItem);
            for (JMenuItem item : JAlbumFrame.this.albumExplorer.createLabelTypeItems()) {
                this.viewMenuLabelTypeSubMenu.add(item);
            }
            this.viewMenu.addSeparator();
            this.viewMenuZoomSubMenu.add(JAlbumFrame.this.albumExplorer.zoomInAction);
            this.viewMenuZoomSubMenu.add(JAlbumFrame.this.albumExplorer.zoomOutAction);
            this.viewMenuZoomSubMenu.add(JAlbumFrame.this.albumExplorer.resetZoomAction);
            this.viewMenu.add(this.viewMenuZoomSubMenu);
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.viewMenuOrderBySubMenu);
            JAlbumFrame.this.albumExplorer.populateOrderingSubMenu(this.viewMenuOrderBySubMenu);
            this.viewMenu.add(this.viewMenuOrderFoldersBySubMenu);
            JAlbumFrame.this.albumExplorer.populateFolderOrderingSubMenu(this.viewMenuOrderFoldersBySubMenu);
            this.viewMenu.addSeparator();
            this.viewMenu.add(JAlbumFrame.this.albumExplorer.refreshAction);
            JAlbumFrame.this.albumExplorer.populateOrganizeMenu(this.organizeMenu);
            this.albumMenu.add(new MenuAction(JAlbumFrame.this.actions.makeAction));
            this.albumMenu.add(JAlbumFrame.this.actions.makeInBackgroundAction);
            this.albumMenu.add(JAlbumFrame.this.actions.makeAndUploadInBackgroundAction);
            this.albumMenu.add(JAlbumFrame.this.actions.forceRebuildAction);
            this.albumMenu.add(JAlbumFrame.this.actions.makeTestAction);
            this.albumMenu.add(new AliasAction(JAlbumFrame.this.actions.viewAlbumAction, (Icon)null));
            this.albumMenu.add(JAlbumFrame.this.actions.phonePreviewerAction);
            this.albumMenu.addSeparator();
            this.albumMenu.add(new MenuAction(JAlbumFrame.this.actions.uploadInBackgroundAction));
            this.albumMenu.add(new MenuAction(JAlbumFrame.this.actions.embedAlbumAction));
            this.albumMenu.add(new MenuAction(JAlbumFrame.this.albumExplorer.albumManager.infoAction));
            this.albumMenu.add(new MenuAction(JAlbumFrame.this.actions.settingsAction));
            this.toolsMenu.add(JAlbumFrame.this.actions.lastToolAction);
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(JAlbumFrame.this.albumExplorer.reviewModeAction);
            this.toolsMenu.add(JAlbumFrame.this.actions.showShareWindowAction);
            this.toolsMenu.add(JAlbumFrame.this.actions.multiMakerAction);
            this.toolsMenu.add(JAlbumFrame.this.actions.showPublishWindowAction);
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.openDirectoriesMenu);
            this.openDirectoriesMenu.add(JAlbumFrame.this.actions.openImageDirectoryAction);
            this.openDirectoriesMenu.add(JAlbumFrame.this.actions.openOutputDirectoryAction);
            this.openDirectoriesMenu.add(JAlbumFrame.this.actions.openSkinDirectoryAction);
            this.openDirectoriesMenu.add(JAlbumFrame.this.actions.openProgramDirectoryAction);
            this.openDirectoriesMenu.add(JAlbumFrame.this.actions.openConfigDirectoryAction);
            this.toolsMenu.add(this.toolsMenuExternalToolsSubMenu);
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(JAlbumFrame.this.actions.showConsoleWindowAction);
            if (!JAlbumFrame.isScreenMenuBar()) {
                this.toolsMenu.addSeparator();
                this.toolsMenu.add(JAlbumFrame.this.actions.showPreferencesWindowAction);
            }
            this.helpMenu.add(new MenuAction(JAlbumFrame.this.actions.searchAction));
            this.helpMenu.add(JAlbumFrame.this.actions.helpTopicsAction);
            this.helpMenu.add(new JMenuItem(JAlbumFrame.this.actions.contextHelpAction));
            this.helpMenu.addSeparator();
            this.helpMenu.add(JAlbumFrame.this.actions.helpCheckUpdatesAction);
            this.helpMenu.addSeparator();
            this.helpMenu.add(JAlbumFrame.this.actions.helpWebAction);
            this.helpMenu.add(new JMenuItem(JAlbumFrame.this.actions.downloadMoreSkinsAction));
            this.helpMenu.add(JAlbumFrame.this.actions.supportingjAlbumAction);
            this.helpMenu.add(JAlbumFrame.this.actions.licenseInfoAction);
            this.helpMenu.add(this.helpMenuActivateLicenseMenuItem);
            if (!JAlbumFrame.isScreenMenuBar()) {
                this.helpMenu.addSeparator();
                this.helpMenu.add(JAlbumFrame.this.actions.aboutAction);
            }
            this.mainMenuBar.add(this.fileMenu);
            this.mainMenuBar.add(this.editMenu);
            this.mainMenuBar.add(this.viewMenu);
            this.mainMenuBar.add(this.organizeMenu);
            this.mainMenuBar.add(this.albumMenu);
            this.mainMenuBar.add(this.toolsMenu);
            this.mainMenuBar.add(this.helpMenu);
        }

        void setTexts() {
            JAlbumFrame.this.actions.signInAction.putValue("Name", Msg.get("ui.signIn"));
            JAlbumFrame.this.actions.signOutAction.putValue("Name", Msg.get("ui.signOutUser", SignInManager.getInstance().getUserName()));
            JAlbumFrame.this.actions.helpAction.putValue("Name", Msg.get("ui.helpMenu"));
            JAlbumFrame.this.progressManager.setToolTipText("ui.clickForDetails");
        }
    }
}

