/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JHtmlPane;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JHyperTextDialog;
import se.datadosen.jalbum.JPublishWizard;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SlowOperation;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.BeanBinder;

public class JAddAccountDialog
extends JSmartDialog {
    private boolean isExisting = true;
    private boolean altActivationUrl;
    private JAlbumFrameIcons icons = JAlbumFrameIcons.getInstance();
    private JLabel tipLabel = new JLabel(Msg.get("ui.signupTipLabel"));
    private JRadioButton addExisting = new JRadioButton(Msg.get("publish.useExisting"));
    private JRadioButton addMyJAlbum = new JRadioButton(Msg.get("publish.useMyJAlbum"));
    private ButtonGroup addType = new ButtonGroup(){
        {
            this.add(JAddAccountDialog.this.addExisting);
            this.add(JAddAccountDialog.this.addMyJAlbum);
            JAddAccountDialog.this.addExisting.setSelected(true);
        }
    };
    ControlPanel myjalbumPanel = new ControlPanel(Msg.get("publish.myJAlbumAccount"));
    JLabel userNameLabel = new JLabel(Msg.get("ui.userName"));
    JTextField userName = new JSmartTextField(16);
    JLabel passwordLabel = new JLabel(Msg.get("ui.password"));
    JPasswordField password = new JPasswordField(16);
    JHtmlPane moreInfoPane = new JHtmlPane();
    Action okAction = new AbstractAction(Msg.get("ok")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JAddAccountDialog.this.isExisting) {
                ((JPublishWizard)JAddAccountDialog.this.getOwner()).accountsStep.addAccount(new AccountProfile(Msg.get("publish.NewAccount")));
                JAddAccountDialog.this.setVisible(false);
            } else {
                JAddAccountDialog.this.activateAccount();
            }
        }
    };
    Action cancelAction = new AbstractAction(Msg.get("cancel")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAddAccountDialog.this.setVisible(false);
        }
    };

    public JAddAccountDialog(JPublishWizard parent, boolean modal, boolean altActivationUrl) throws ElementException, IOException {
        super((Window)parent, modal);
        Msg.maintainTranslated(this);
        this.altActivationUrl = altActivationUrl;
        if (altActivationUrl) {
            System.out.println("Using alt signup URL at " + JAlbumSite.getTrueInstance().getMyJAlbumAltActivationUrl());
        }
        this.init(parent);
    }

    private void postPage(final URL url, final Map data) throws Throwable {
        SlowOperation activateOp = new SlowOperation(this){
            final /* synthetic */ JAddAccountDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void operation() throws Throwable {
                RobustResty r = new RobustResty();
                String result = r.text(url.toURI(), (AbstractContent)RobustResty.form(data)).toString();
                this.setResult(result);
            }

            @Override
            public void abort() {
            }
        };
        boolean done = activateOp.launch(this, new JLabel(Msg.get("publish.communicating") + " ...", ((JPublishWizard)this.getOwner()).accountsStep.serverIcon, 10), ((JPublishWizard)this.getOwner()).accountsStep.serverConnectionIcon, Msg.get("publish.myJAlbumHosting"));
        if (done) {
            String result;
            String doc = (String)activateOp.getResult();
            if (this.altActivationUrl) {
                System.out.println("Result from server:\n" + doc);
            }
            if ((result = Elements.contentOfElement("result", doc)) == null) {
                throw new Exception("Script error. Please contact hosting@jalbum.net:\n" + doc);
            }
            String message = Elements.contentOfElement("message", doc);
            String htmlMessage = Elements.contentOfElement("htmlMessage", doc);
            Element account = Elements.getElementByName("account", doc, false);
            String confirmationText = Elements.contentOfElement("requireConfirmation", doc);
            if (result.equals("ok")) {
                if (message != null) {
                    JOptionPane.showMessageDialog(this, message, Msg.get("wiz.signupOkTitle"), 1);
                }
                if (htmlMessage != null) {
                    JHyperTextDialog dialog = new JHyperTextDialog(this, Msg.get("publish.myJAlbumHosting"), htmlMessage, 1, confirmationText);
                    dialog.setVisible(true);
                    if (dialog.isOkPressed() && confirmationText != null) {
                        data.put("confirmed", "true");
                        this.postPage(url, data);
                    }
                }
                if (account != null) {
                    Map<String, String> attributes = account.getAttributes();
                    AccountProfile newProfile = new AccountProfile(attributes.get("webRootURL"));
                    BeanBinder.setProperties(newProfile, attributes);
                    newProfile.setName();
                    JPublishWizard publishWizard = (JPublishWizard)this.getOwner();
                    publishWizard.accountsStep.addAccount(newProfile);
                    this.setVisible(false);
                    publishWizard.accountsStep.connectAction.actionPerformed(null);
                }
            } else if (result.equals("fail")) {
                if (message != null) {
                    JOptionPane.showMessageDialog(this, message, Msg.get("publish.myJAlbumHosting"), 0);
                } else {
                    JHyperTextDialog dialog = new JHyperTextDialog(this, Msg.get("publish.myJAlbumHosting"), htmlMessage, 0);
                    dialog.setVisible(true);
                }
            }
        }
    }

    private void activateAccount() {
        try {
            URL url = new URL(this.altActivationUrl ? JAlbumSite.getTrueInstance().getMyJAlbumAltActivationUrl() : JAlbumSite.getTrueInstance().getMyJAlbumActivationUrl());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("userName", this.userName.getText());
            data.put("password", new String(this.password.getPassword()));
            data.put("language", Config.getConfig().getInterpretedLanguage());
            data.put("confirmed", "true");
            this.postPage(url, data);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, t.getMessage(), Msg.get("publish.myJAlbumHosting"), 0);
        }
    }

    private void manageDisabling() {
        this.okAction.setEnabled(this.userName.getText().length() > 1 && this.password.getPassword().length > 1);
    }

    private void init(JDialog parent) throws IOException, ElementException {
        this.setTitle(Msg.get("publish.addAccount"));
        if (this.altActivationUrl) {
            this.setTitle(this.getTitle() + " - Test");
        }
        this.tipLabel.setIcon(Icons.get("lightbulb", 20));
        this.addExisting.addActionListener(e -> {
            if (this.isExisting) {
                return;
            }
            this.isExisting = true;
            JComponent c = (JComponent)this.getContentPane();
            c.remove(this.myjalbumPanel);
            this.pack();
            this.okAction.setEnabled(true);
        });
        this.addMyJAlbum.addActionListener(e -> {
            if (!this.isExisting) {
                return;
            }
            this.isExisting = false;
            JComponent c = (JComponent)this.getContentPane();
            c.add("br hfill", this.myjalbumPanel);
            this.pack();
            this.userName.requestFocusInWindow();
            this.manageDisabling();
        });
        this.userName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JAddAccountDialog.this.manageDisabling();
            }
        });
        this.password.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JAddAccountDialog.this.manageDisabling();
            }
        });
        String info = Msg.get("publish.moreInfo", JAlbumSite.getTrueInstance().getMyJAlbumInfoUrl());
        this.moreInfoPane.setHtmlText(info);
        this.moreInfoPane.addHyperlinkListener(e -> {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                try {
                    BrowserLauncher.openURL(e.getURL().toExternalForm() + "?utm_source=client&utm_medium=moreInfoLink&utm_campaign=addAccountDialog");
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), Msg.get("wiz.openFailed"), 0);
                }
            }
        });
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new RiverLayout());
        c.add("br", this.tipLabel);
        c.add("p", this.addExisting);
        c.add("br", this.addMyJAlbum);
        this.myjalbumPanel.add("br", this.userNameLabel);
        this.myjalbumPanel.add("tab", this.userName);
        this.myjalbumPanel.add("br", this.passwordLabel);
        this.myjalbumPanel.add("tab", this.password);
        this.myjalbumPanel.add("p", this.moreInfoPane);
        this.registerActions(this.okAction, this.cancelAction);
        this.pack();
        this.addMyJAlbum.doClick();
    }
}

