/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import se.datadosen.component.Hour;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.Debug;
import se.datadosen.util.Multilingual;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JAccountStatusPanel
extends JComponent
implements Multilingual {
    Action showGiftsPageAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.small("gift"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SignInManager mgr = SignInManager.getInstance();
                String userName = mgr.getUserName();
                if (userName == null) {
                    return;
                }
                String giveAwayHostingURL = JAlbumSite.getInstance().getGiveAwayHostingUrl() + "/?utm_source=client&utm_medium=giveAwayHostingAction&utm_campaign=accountStatusPanel&referrer=jalbumStatusBar&cid=" + AccountManager.getCid(userName, mgr.getPassword());
                BrowserLauncher.openURL(giveAwayHostingURL);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.out);
            }
        }
    };
    final JAlbumContext context;
    private AccountManager.AccountStatus accountStatus;
    private JLabel jAlbumStorageLabel = new JLabel();
    Font font = this.jAlbumStorageLabel.getFont();
    @Text(value="ui.upgrade")
    @ToolTipText(value="ui.upgradeStorage")
    private JLinkLabel upgradeStorageLink;
    private JProgressSpinner updateSpinner;
    private JAccountStatusMeter meter;
    private Integer giftCards;
    private JButton giftsButton;
    @Text(value="ui.upgradeStorage")
    Action upgradeStorageAction;
    Action gotoSiteAction;
    @Text(value="edit.update")
    Action updateAction;

    public void setStatus(AccountManager.AccountStatus accountStatus) {
        this.accountStatus = accountStatus;
        String usage = (String)accountStatus.get("usage");
        String quota = (String)accountStatus.get("quota");
        this.giftCards = null;
        if (accountStatus.containsKey("giftCards")) {
            this.giftCards = Integer.parseInt((String)accountStatus.get("giftCards"));
        }
        if (usage != null && quota != null) {
            this.setValues(Long.parseLong(usage), Long.parseLong(quota));
        } else {
            this.setValues(null, null);
        }
    }

    public AccountManager.AccountStatus getStatus() {
        return this.accountStatus;
    }

    private void setValues(Long used, Long quota) {
        this.meter.used = used;
        this.meter.quota = quota;
        this.languageUpdated();
        this.repaint();
    }

    public JAccountStatusPanel(JAlbumContext context) {
        if (Platform.isMac()) {
            this.font = this.font.deriveFont(this.font.getSize2D() - 2.0f);
        }
        this.upgradeStorageLink = new JLinkLabel("", "");
        this.updateSpinner = new JProgressSpinner(16);
        this.giftsButton = new JPlainButton(this.showGiftsPageAction);
        this.upgradeStorageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SignInManager mgr = SignInManager.getInstance();
                    String userName = mgr.getUserName();
                    if (userName == null) {
                        return;
                    }
                    String upgradeURL = JAlbumSite.getInstance().getMyJAlbumUpgradeUrl() + "/?utm_source=client&utm_medium=upgradeStorageAction&utm_campaign=accountStatusPanel&referrer=jalbumStatusBar&cid=" + AccountManager.getCid(userName, mgr.getPassword());
                    BrowserLauncher.openURL(upgradeURL);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.out);
                }
            }
        };
        this.gotoSiteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SignInManager mgr = SignInManager.getInstance();
                    String userName = mgr.getUserName();
                    if (userName == null) {
                        return;
                    }
                    String siteURL = JAlbumSite.getInstance().getHomeUrl() + "/users/" + userName + "/?utm_source=client&utm_medium=gotoSiteAction&utm_campaign=accountStatusPanel&referrer=jalbumStatusBar&cid=" + AccountManager.getCid(userName, mgr.getPassword());
                    BrowserLauncher.openURL(siteURL);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.out);
                }
            }
        };
        this.updateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.isEnabled()) {
                    return;
                }
                this.setEnabled(false);
                JAccountStatusPanel.this.updateSpinner.setVisible(true);
                new SwingWorker<AccountManager.AccountStatus, Object>(){

                    @Override
                    protected AccountManager.AccountStatus doInBackground() throws Exception {
                        SignInManager mgr = SignInManager.getInstance();
                        if (!mgr.isSignedIn()) {
                            throw new RuntimeException("Not signed in");
                        }
                        return AccountManager.getJalbumAccountStatus(mgr.getUserName(), mgr.getPassword());
                    }

                    @Override
                    protected void done() {
                        try {
                            AccountManager.AccountStatus status = (AccountManager.AccountStatus)this.get();
                            JAccountStatusPanel.this.setStatus(status);
                        }
                        catch (InterruptedException status) {
                        }
                        catch (ExecutionException ex) {
                            Debug.showErrorDialog(JAccountStatusPanel.this, ex.getCause());
                        }
                        JAccountStatusPanel.this.updateAction.setEnabled(true);
                        JAccountStatusPanel.this.updateSpinner.setVisible(false);
                    }
                }.execute();
            }
        };
        this.context = context;
        this.meter = new JAccountStatusMeter();
        Msg.maintainTranslated(this);
        this.setLayout(new BoxLayout(this, 0));
        this.upgradeStorageLink.setFont(this.font);
        this.upgradeStorageLink.addActionListener(this.upgradeStorageAction::actionPerformed);
        this.updateSpinner.setVisible(false);
        this.add(this.updateSpinner);
        this.add(this.meter);
        this.add(this.giftsButton);
        this.add(Box.createHorizontalStrut(6));
        this.add(this.upgradeStorageLink);
        this.add(Box.createHorizontalStrut(6));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.meter.setVisible(visible);
    }

    @Override
    public void languageUpdated() {
        this.giftsButton.setVisible(this.giftCards != null);
        if (this.giftCards != null) {
            this.giftsButton.setToolTipText(Msg.get("ui.giftCardsLeft", this.giftCards));
            TipOfTheDay.showSpeechBubble(this.giftsButton, new Hour(11), Msg.get("ui.giftCardsHint", this.giftCards), 10);
        }
        if (this.meter != null) {
            this.meter.setTexts();
        }
    }

    private static Color rainbow(float ratio) {
        Color green = new Color(0, 200, 0, 100);
        Color yellow = JAccountStatusPanel.dilute(Color.yellow, 0.3f);
        Color red = new Color(255, 75, 75);
        float threshold = 0.5f;
        if (ratio < threshold) {
            return green;
        }
        if ((double)(ratio = (ratio - threshold) / (1.0f - threshold)) < 0.5) {
            return JAccountStatusPanel.mix(green, yellow, ratio * 2.0f);
        }
        return JAccountStatusPanel.mix(yellow, red, (ratio - 0.5f) * 2.0f);
    }

    private static Color mix(Color c1, Color c2, float balance) {
        float invBal = 1.0f - balance;
        return new Color((int)((float)c1.getRed() * invBal + (float)c2.getRed() * balance), (int)((float)c1.getGreen() * invBal + (float)c2.getGreen() * balance), (int)((float)c1.getBlue() * invBal + (float)c2.getBlue() * balance), (int)((float)c1.getAlpha() * invBal + (float)c2.getAlpha() * balance));
    }

    private static Color dilute(Color c, float amount) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)((float)c.getAlpha() * (1.0f - amount)));
    }

    private static Color darker(Color c) {
        float FACTOR = 0.6f;
        return new Color((int)((float)c.getRed() * FACTOR), (int)((float)c.getGreen() * FACTOR), (int)((float)c.getBlue() * FACTOR), 150);
    }

    private static float clamp(float value, float min, float max) {
        return Math.min(max, Math.max(value, min));
    }

    private class JAccountStatusMeter
    extends JComponent
    implements Multilingual {
        private JLabel accountStatusLabel = new JLabel();
        private Long used = null;
        private Long quota = null;
        private DecimalFormat formatter = new DecimalFormat("0.0");
        private float alpha = 1.0f;

        public JAccountStatusMeter() {
            this.init();
        }

        private void init() {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    AccountProfile account;
                    String userName = SignInManager.getInstance().getUserName();
                    if (userName != null && (account = AccountManager.getInstance().findJAlbumAccountByUserName(userName)) != null) {
                        JAccountStatusPanel.this.gotoSiteAction.setEnabled(true);
                        JAccountStatusPanel.this.gotoSiteAction.putValue("Name", Msg.get("share.gotoURL") + " " + account.getFtpServer());
                        return;
                    }
                    JAccountStatusPanel.this.gotoSiteAction.setEnabled(false);
                    JAccountStatusPanel.this.gotoSiteAction.putValue("Name", "No account activated");
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            popupMenu.add(JAccountStatusPanel.this.gotoSiteAction);
            popupMenu.add(JAccountStatusPanel.this.upgradeStorageAction);
            popupMenu.addSeparator();
            popupMenu.add(JAccountStatusPanel.this.updateAction);
            this.setComponentPopupMenu(popupMenu);
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        JAccountStatusPanel.this.gotoSiteAction.actionPerformed(null);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    JAccountStatusMeter.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    JAccountStatusMeter.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            this.accountStatusLabel.setFont(JAccountStatusPanel.this.font);
            this.setTexts();
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setBackground(UIManager.getColor("ProgressBar.background"));
            JAccountStatusPanel.this.updateSpinner.setVisible(false);
            JPanel textPanel = new JPanel(new BorderLayout());
            textPanel.setOpaque(false);
            textPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            textPanel.add((Component)this.accountStatusLabel, "Center");
            this.add((Component)textPanel, "Center");
        }

        private void setTexts() {
            this.accountStatusLabel.setText(Msg.get("ui.percentUsed", this.used != null ? Long.valueOf(100L * this.used / this.quota) : "---"));
            this.setToolTipText(Msg.get("ui.jAlbumStorage") + ": " + Msg.get("publish.quotaInfo", this.formatUsed(), this.formatQuota()));
        }

        private String formatUsed() {
            if (this.used == null) {
                return "--";
            }
            return DataSizeFormatter.formatBytes(this.used * 1024L).toString();
        }

        private String formatQuota() {
            if (this.quota == null) {
                return "--";
            }
            return DataSizeFormatter.formatBytes(this.quota * 1024L).toString();
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this.alpha = 0.0f;
            }
            super.setVisible(visible);
            if (visible) {
                new Thread("animator"){

                    @Override
                    public void run() {
                        try {
                            JAccountStatusMeter.this.alpha = 0.0f;
                            while (JAccountStatusMeter.this.alpha <= 1.0f) {
                                3.sleep(30L);
                                JAccountStatusMeter.this.repaint();
                                JAccountStatusMeter.this.alpha += 0.08f;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }

        @Override
        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            Graphics2D g = (Graphics2D)g2;
            this.alpha = JAccountStatusPanel.clamp(this.alpha, 0.0f, 1.0f);
            AlphaComposite composite = AlphaComposite.getInstance(3, this.alpha);
            g.setComposite(composite);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getBackground());
            Insets in = this.getInsets();
            int w = this.getWidth() - in.left - in.right;
            int h = this.getHeight() - in.top - in.bottom;
            int r = 4;
            g.fillRoundRect(in.left, in.top, w, h, r, r);
            if (this.used != null && this.quota != null) {
                try {
                    float ratio = this.used.floatValue() / this.quota.floatValue();
                    if (ratio > 1.0f) {
                        ratio = 1.0f;
                    }
                    Color c = JAccountStatusPanel.rainbow(ratio);
                    g.setColor(c);
                    g.setClip(in.left, in.top, (int)((float)w * ratio), h);
                    g.fillRoundRect(in.left, in.top, w, h, r, r);
                    g.setClip(null);
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void languageUpdated() {
            this.setTexts();
        }
    }
}

