/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.jalbum.OutputFormat;
import net.jalbum.Rendition;
import net.jalbum.Variant;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterPipeline;
import net.jalbum.filters.Alignment;
import net.jalbum.filters.ColorProfileFilter;
import net.jalbum.filters.LogoFilter;
import net.jalbum.filters.TextFilter;
import net.jalbum.filters.VerticalAlignment;
import se.datadosen.io.CachedFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.LinkFileAlbumObject;
import se.datadosen.util.FileFilters;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.IO;
import se.datadosen.util.Scope;

public class ImageRenderer {
    private static final Pattern variantPattern = Pattern.compile(".+-\\d+w\\..+");
    private static final LogoFilter playSuperimposeFilter = LogoFilter.getVideoOverlay();
    private final AlbumObject ao;
    private AlbumObject rep;
    private final AlbumBean engine;
    private final List<Variant> closeupVariants;
    private final List<Variant> thumbVariants;
    private Dimension imageDim;
    private Dimension thumbDim;
    private BufferedImage intermediateImage;
    private List<Rendition> closeupRenditions;
    private List<Rendition> thumbRenditions;
    private static final ColorProfileFilter colorProfileFilter = new ColorProfileFilter();

    private static Dimension getScaledDim(Dimension dim, float scale) {
        if (scale == 1.0f) {
            return dim;
        }
        return new Dimension((int)(scale * (float)dim.width), (int)(scale * (float)dim.height));
    }

    public ImageRenderer(AlbumObject ao) {
        ArrayList<Object> tv;
        ArrayList<Object> cv;
        this.engine = ao.getEngine();
        this.ao = this.engine.isLinkInternally(ao) ? ((LinkFileAlbumObject)ao).getInternalTarget() : ao;
        if (this.engine.getSkinProperties().isSupportsVariants() && !ao.getVars().getMap().containsKey("maxImageWidth")) {
            cv = new ArrayList<Variant>(this.engine.getImageVariantList());
            tv = new ArrayList<Variant>(this.engine.getThumbVariantList());
        } else {
            cv = new ArrayList();
            tv = new ArrayList();
        }
        if (ao.isUseOriginal()) {
            cv.clear();
        }
        if (!this.engine.isMakeImages()) {
            cv.clear();
        }
        Variant dup = new Variant(1.0f, this.engine.getOutputFormat());
        cv.remove(dup);
        tv.remove(dup);
        cv.add(Variant.TYPICAL);
        tv.add(Variant.TYPICAL);
        Collections.sort(cv);
        Collections.sort(tv);
        this.closeupVariants = cv.stream().distinct().collect(Collectors.toList());
        this.thumbVariants = tv.stream().distinct().collect(Collectors.toList());
        this.computeRenditions();
    }

    private static BufferedImage addDebugText(BufferedImage im, Scope locals, Rendition r, String text, int size, int shadowDistance) {
        BufferedImage copy = im;
        if ("true".equals(System.getProperty("debugVariants"))) {
            copy = GraphicsUtilities.duplicate(im);
            TextFilter tf = new TextFilter();
            tf.setSize(24);
            tf.setText(r.getVariant().getScale() + "x: " + r.getWidth() + " x " + r.getHeight() + " (" + String.valueOf((Object)r.getFormat()) + ")");
            tf.setShadowDistance(-5);
            tf.setStrengthPercent(100);
            tf.setColor(Color.white);
            tf.setShadowColor(new Color(0, 0, 0, 50));
            tf.setAlign(Alignment.center);
            tf.setValign(VerticalAlignment.center);
            locals.put("scale", (Object)Float.valueOf(r.getVariant().getScale()));
            copy = tf.filter(copy, locals);
        }
        return copy;
    }

    BufferedImage processCloseups(BufferedImage inputImage, ColorModel colorModel, FilterPipeline filterPipeline, File outputDir) throws IOException {
        if (this.ao.getCategory() == Category.webLocation && !this.engine.getSkinProperties().isMakeWebLocationSlides()) {
            return inputImage;
        }
        Scope locals = this.ao.getVars().push(new Scope());
        BufferedImage typical = null;
        BufferedImage im = inputImage;
        Dimension bounds = ImageRenderer.getScaledDim(this.imageDim, this.engine.getImageScale());
        boolean filtersProcessed = false;
        for (Rendition r : this.closeupRenditions) {
            im = this.engine.scaleToFit(im, r.getVariant().getScaledDimension(bounds), this.engine.getScalingMethod());
            if (!filtersProcessed) {
                if (colorModel != null) {
                    im = colorProfileFilter.filter(colorModel, im, locals);
                }
                this.intermediateImage = im = this.engine.processFilters(filterPipeline, im, this.ao, locals, 2, r.getVariant().getScale());
                im = this.engine.processFilters(filterPipeline, im, this.ao, locals, 3, r.getVariant().getScale());
                filtersProcessed = true;
            }
            if (r.getVariant() == Variant.TYPICAL) {
                typical = im;
                continue;
            }
            BufferedImage copy = ImageRenderer.addDebugText(im, locals, r, r.getVariant().getScale() + "x: " + r.getWidth() + " x " + r.getHeight() + " (" + String.valueOf((Object)r.getFormat()) + ")", 24, -5);
            IO.workerPool.submit(() -> {
                try {
                    FileFilters.saveImage(copy, new File(outputDir, r.getName()), r.getFormat().getExtension(), this.engine, null);
                }
                catch (IOException ex) {
                    Logger.getLogger(ImageRenderer.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        return typical;
    }

    public BufferedImage getAndResetIntermediateImage() {
        BufferedImage im = this.intermediateImage;
        this.intermediateImage = null;
        return im;
    }

    BufferedImage processThumbs(BufferedImage inputImage, ColorModel colorModel, File repFile, FilterPipeline filterPipeline, File outputDir) throws IOException {
        Scope locals = this.ao.getVars();
        BufferedImage typical = null;
        BufferedImage im = inputImage;
        boolean isFolderImage = this.ao.isFolder() && this.engine.folderThumbDim != null;
        im = this.engine.processFilters(filterPipeline, im, this.ao, locals, isFolderImage ? 6 : 4);
        boolean filtersProcessed = false;
        Dimension bounds = ImageRenderer.getScaledDim(this.thumbDim, this.engine.getThumbScale());
        for (Rendition r : this.thumbRenditions) {
            im = this.engine.scaleToFit(im, r.getVariant().getScaledDimension(bounds), this.engine.getScalingMethod());
            if (!filtersProcessed) {
                im = colorProfileFilter.filter(colorModel, im, locals);
                im = this.engine.processFilters(filterPipeline, im, this.ao, locals, isFolderImage ? 7 : 5, r.getVariant().getScale());
                if (this.engine.isSuperimposeFilmIcon() && repFile.exists() && this.ao.getCategory() == Category.video) {
                    HashMap<String, Object> filterVars = new HashMap<String, Object>();
                    filterVars.put("engine", this.engine);
                    filterVars.put("stage", 5);
                    filterVars.put("scale", Float.valueOf(r.getVariant().getScale() * (float)this.engine.getScaleForStage(5)));
                    im = playSuperimposeFilter.filter(im, filterVars);
                }
                filtersProcessed = true;
            }
            if (r.getVariant() == Variant.TYPICAL) {
                typical = im;
                continue;
            }
            BufferedImage copy = ImageRenderer.addDebugText(im, locals, r, r.getVariant().getScale() + "x (" + String.valueOf((Object)r.getFormat()) + ")", 14, 2);
            FileFilters.saveImage(copy, new File(outputDir, r.getName()), r.getFormat().getExtension(), this.engine, null);
        }
        return typical;
    }

    Dimension getMaxCloseupDimension(Dimension imageDim) {
        return ImageRenderer.getScaledDim(imageDim, this.closeupVariants.get(0).getScale());
    }

    Dimension getMaxThumbDimension(Dimension thumbDim) {
        return ImageRenderer.getScaledDim(thumbDim, this.thumbVariants.get(0).getScale());
    }

    private OutputFormat resolveType(Variant v) {
        OutputFormat imageType = v.getFormat();
        if (imageType == null) {
            imageType = this.engine.getOutputFormat();
        }
        return imageType;
    }

    private void computeRenditions() {
        this.closeupRenditions = new ArrayList<Rendition>();
        this.thumbRenditions = new ArrayList<Rendition>();
        boolean isFolderImage = this.ao.isFolder() && this.engine.folderThumbDim != null;
        this.rep = this.ao.getRepresentingAlbumObject(true);
        if (this.rep == null) {
            this.rep = this.ao;
        }
        AlbumObject use = isFolderImage ? this.ao : this.rep;
        Scope vars = use.getVars();
        this.imageDim = AlbumBean.getImageDim(vars);
        this.thumbDim = isFolderImage ? AlbumBean.getFolderThumbDim(vars) : AlbumBean.getThumbDim(vars);
        Dimension newDim = null;
        try {
            newDim = this.ao.getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (newDim == null) {
            throw new IllegalArgumentException("Dimension information missing from " + String.valueOf(this.ao));
        }
        Dimension origDim = newDim;
        Dimension closeupDim = newDim;
        FilterPipeline filterPipeline = null;
        FilterList stack = (FilterList)use.getProperties().get("filterList");
        if (stack != null) {
            filterPipeline = new FilterPipeline(stack);
        }
        Dimension maxImageDim = ImageRenderer.getScaledDim(this.imageDim, this.engine.getImageScale());
        Dimension maxThumbDim = ImageRenderer.getScaledDim(this.thumbDim, this.engine.getThumbScale());
        Dimension intermediateDim = null;
        boolean filtersProcessed = false;
        newDim = this.engine.getFilteredSize(filterPipeline, Variant.TYPICAL, newDim, vars, 1);
        for (Variant v : this.closeupVariants) {
            Rendition toAdd;
            newDim = closeupDim = GraphicsUtilities.fitWithinBounds(newDim.width, newDim.height, v.getScaledDimension(maxImageDim));
            if (!filtersProcessed) {
                newDim = this.engine.getFilteredSize(filterPipeline, v, newDim, vars, 2);
                closeupDim = this.engine.getFilteredSize(filterPipeline, v, newDim, vars, 3);
                filtersProcessed = true;
            }
            if (v == Variant.TYPICAL) {
                intermediateDim = newDim;
            }
            if (this.closeupRenditions.contains(toAdd = new Rendition(this.ao, closeupDim, this.resolveType(v), v, this.engine.isLinkInternally(this.ao)))) continue;
            this.closeupRenditions.add(toAdd);
        }
        newDim = intermediateDim;
        Dimension max = this.getMaxThumbDimension(maxThumbDim);
        if (intermediateDim.width < max.width || intermediateDim.height < max.height) {
            newDim = origDim;
        }
        filtersProcessed = false;
        newDim = this.engine.getFilteredSize(filterPipeline, Variant.TYPICAL, newDim, vars, isFolderImage ? 6 : 4);
        for (Variant v : this.thumbVariants) {
            Rendition toAdd;
            newDim = GraphicsUtilities.fitWithinBounds(newDim.width, newDim.height, v.getScaledDimension(maxThumbDim));
            if (!filtersProcessed) {
                newDim = this.engine.getFilteredSize(filterPipeline, v, newDim, vars, isFolderImage ? 7 : 5);
                filtersProcessed = true;
            }
            if (this.thumbRenditions.contains(toAdd = new Rendition(use, newDim, this.resolveType(v), v, this.engine.isLinkInternally(use)))) continue;
            this.thumbRenditions.add(toAdd);
        }
    }

    public List<Rendition> getCloseupRenditions() {
        return this.closeupRenditions;
    }

    public List<Rendition> getThumbRenditions() {
        return this.thumbRenditions;
    }

    public List<Rendition> getCloseupRenditions(OutputFormat format) {
        return this.closeupRenditions.stream().filter(r -> r.getFormat() == format).collect(Collectors.toList());
    }

    public List<Rendition> getThumbRenditions(OutputFormat format) {
        return this.thumbRenditions.stream().filter(r -> r.getFormat() == format).collect(Collectors.toList());
    }

    public static Rendition getTypical(List<Rendition> renditions) {
        for (Rendition r : renditions) {
            if (r.getVariant() != Variant.TYPICAL) continue;
            return r;
        }
        throw new RuntimeException("No typical rendition found");
    }

    public static List<Rendition> stripTypical(List<Rendition> renditions) {
        return renditions.stream().filter(r -> r.getVariant() != Variant.TYPICAL).collect(Collectors.toList());
    }

    public static String buildSrcset(List<Rendition> renditions, String typicalPath) {
        if (renditions != null) {
            String parentPath = IO.parentPath(typicalPath);
            StringJoiner sj = new StringJoiner(",");
            for (Rendition r : renditions) {
                sj.add(parentPath + r.getEncodedName() + " " + r.getWidth() + "w");
            }
            return sj.toString();
        }
        return null;
    }

    private void deleteUnusedVariants(Map<String, CachedFile> contents, List<Rendition> renditions) throws IOException {
        String ceiling;
        String prefix;
        if (!this.ao.hasDisplayableImage()) {
            return;
        }
        TreeSet<String> keys = new TreeSet<String>(contents.keySet());
        for (Rendition r : renditions) {
            keys.remove(r.getName());
        }
        String string = prefix = this.ao.isFolder() ? this.ao.getName() : IO.baseName(this.ao.getName());
        while ((ceiling = keys.ceiling(prefix)) != null && ceiling.startsWith(prefix)) {
            keys.remove(ceiling);
            if (!ImageRenderer.isVariant(ceiling, this.ao) && !ImageRenderer.isSameBase(ceiling, this.ao)) continue;
            String ext = IO.extensionOf(ceiling).toLowerCase();
            for (OutputFormat format : OutputFormat.values()) {
                if (!format.getAllExtensions().contains(ext)) continue;
                File toDelete = contents.get(ceiling);
                toDelete.delete();
            }
        }
    }

    void deleteUnusedVariants(Map<String, CachedFile> thumbsContents, Map<String, CachedFile> slidesContents) throws IOException {
        this.deleteUnusedVariants(thumbsContents, this.thumbRenditions);
        this.deleteUnusedVariants(slidesContents, this.closeupRenditions);
    }

    static List<File> listVariantsFor(File typicalFile) {
        File[] content = typicalFile.getParentFile().listFiles();
        ArrayList<File> files = new ArrayList<File>();
        if (content != null) {
            for (File f : content) {
                if (!ImageRenderer.isVariant(f.getName(), typicalFile.getName())) continue;
                files.add(f);
            }
        }
        return files;
    }

    public static boolean isVariant(String testName, String typicalName) {
        String baseName = IO.baseName(typicalName);
        String root = ImageRenderer.nameRoot(testName);
        return root.equals(baseName) && variantPattern.matcher(testName).matches();
    }

    public static boolean isVariant(String testName, AlbumObject typicalAO) {
        String baseName = IO.baseName(typicalAO);
        String root = ImageRenderer.nameRoot(testName);
        return root.equals(baseName) && variantPattern.matcher(testName).matches();
    }

    public static boolean isSameBase(String testName, AlbumObject typicalAO) {
        return IO.baseName(testName).equals(IO.baseName(typicalAO));
    }

    public static boolean isSameRoot(String testName, String typicalName) {
        return ImageRenderer.nameRoot(IO.baseName(testName)).equals(ImageRenderer.nameRoot(typicalName));
    }

    public static String nameRoot(String name) {
        int dashIndex = name.lastIndexOf(45);
        return dashIndex > -1 ? name.substring(0, dashIndex) : name;
    }

    public static String nameSuffix(String name) {
        int dashIndex = name.lastIndexOf(45);
        return dashIndex > -1 ? name.substring(dashIndex) : "";
    }

    private boolean isDirty(File typicalFile, Map<String, CachedFile> contents, List<Rendition> renditions) {
        for (Rendition r : renditions) {
            if (contents.containsKey(r.getName())) continue;
            return true;
        }
        return ImageRenderer.isDirty(typicalFile, this.ao);
    }

    private static boolean isDirty(File dest, AlbumObject source) {
        long destLastMod = dest.lastModified();
        if (destLastMod == 0L) {
            return true;
        }
        long lastMod = source.getMetaLastModified();
        File rep = source.getRepresentingImageFile();
        long repLastMod = rep != null ? rep.lastModified() : 0L;
        lastMod = Math.max(lastMod, repLastMod);
        return lastMod > destLastMod;
    }

    boolean isThumbsDirty(File typicalThumbFile, Map<String, CachedFile> thumbsContents) {
        return this.isDirty(typicalThumbFile, thumbsContents, this.thumbRenditions);
    }

    boolean isCloseupsDirty(File typicalCloseupFile, Map<String, CachedFile> slidesContents) {
        return this.isDirty(typicalCloseupFile, slidesContents, this.closeupRenditions);
    }
}

