/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.io.RenamedFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.ControlFiles;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.StringCodec;

class FileCollection
implements Serializable {
    private static final String COMMENTS_FILE_NAME = "comments.properties";
    private static final String META_FILE_NAME = "meta.properties";
    private static final String PROJECT_ROOT_DIR = "$PROJECT_ROOT_DIR";
    AlbumBean engine;
    File baseDir;
    Set<String> excluded = new HashSet<String>();
    private static final Pattern tabDelim = Pattern.compile("\t");
    private FileCache fileCache = new FileCache();
    private boolean allowUpgrading = false;
    private boolean newFilesFound = false;
    private boolean dateAddedUpdated = false;
    private HashMap<String, File> allExisting;
    private boolean jAlbumDirExists;
    private boolean jAlbumDirCreated;
    private boolean controlFilesMoved;

    public boolean isAllowUpgrading() {
        return this.allowUpgrading;
    }

    public void setAllowUpgrading(boolean allowUpgrading) {
        this.allowUpgrading = allowUpgrading;
    }

    public FileCollection(AlbumBean engine, File baseDir) {
        this.engine = engine;
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    private String resolveRelativeTarget(String targetPath, File rootImageDir) {
        if (targetPath.startsWith(PROJECT_ROOT_DIR)) {
            targetPath = targetPath.replace(PROJECT_ROOT_DIR, rootImageDir.getAbsolutePath());
        }
        return targetPath;
    }

    private File getFile(String[] cols, Map<String, File> existing) {
        String fileName = cols[0];
        if (cols.length > 1 && cols[1].length() > 0) {
            Object targetPath = cols[1];
            if (fileName.startsWith("-")) {
                targetPath = (String)targetPath + "-";
            }
            if (Platform.isWindows() && ((String)targetPath).indexOf(47) != -1) {
                targetPath = ((String)targetPath).replace('/', File.separatorChar);
            } else if (((String)targetPath).indexOf(92) != -1) {
                targetPath = ((String)targetPath).replace('\\', File.separatorChar);
            }
            File found = existing.get(fileName.toLowerCase());
            if (found != null) {
                return found;
            }
            return LinkFile.create(this.baseDir, fileName, this.fileCache.get(new File(this.resolveRelativeTarget((String)targetPath, this.engine.getRootImageDir()))));
        }
        File f = new CachedFile(fileName);
        if (!f.isAbsolute()) {
            f = new CachedFile(this.baseDir, fileName);
            File found = existing.get(fileName.toLowerCase());
            if (found != null) {
                f = found;
            }
            return f;
        }
        return LinkFile.create(this.baseDir, f.getName(), this.fileCache.get(f));
    }

    public Collection<File> listFiles(FileFilter ff) {
        return this.listFiles(ff, false);
    }

    public Collection<File> listFiles(FileFilter ff, boolean includeExcluded) {
        return this.listFiles(ff, includeExcluded, false);
    }

    public Collection<File> listFiles(FileFilter ff, boolean includeExcluded, boolean includeMissing) {
        return this.listEntries(ff, includeExcluded, includeMissing, false).stream().map(fe -> fe.file).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileEntry> listEntries(FileFilter ff, boolean includeExcluded, boolean includeMissing, boolean updateDateAdded) {
        this.newFilesFound = false;
        this.dateAddedUpdated = false;
        boolean isMac = Platform.isMac();
        try {
            this.excluded = new HashSet<String>();
            File[] all = CachedFile.listContent(this.baseDir);
            if (all == null) {
                JAlbum.logger.warning("Missing directory " + String.valueOf(this.baseDir));
            }
            File[] content = CachedFile.filter(all, ff);
            this.allExisting = this.mapFiles(all);
            LinkedHashMap<String, FileEntry> list = new LinkedHashMap<String, FileEntry>();
            ArrayList<FileEntry> fullList = null;
            if (updateDateAdded) {
                fullList = new ArrayList<FileEntry>();
            }
            long now = new Date().getTime();
            try {
                File file = new File(this.baseDir, ".jalbum");
                File albumfilesFile = new File(file, "albumfiles.txt");
                Class<FileCollection> clazz = FileCollection.class;
                synchronized (FileCollection.class) {
                    String line;
                    String text = IO.readTextFile(albumfilesFile);
                    // ** MonitorExit[var15_23] (shouldn't be in output)
                    HashMap<String, File> hashMap = this.mapFiles(content);
                    BufferedReader reader = new BufferedReader(new StringReader(text));
                    while ((line = reader.readLine()) != null) {
                        String[] cols;
                        if (line.length() == 0 || line.charAt(0) == '#') continue;
                        if (isMac && !Normalizer.isNormalized(line, Normalizer.Form.NFC)) {
                            line = Normalizer.normalize(line, Normalizer.Form.NFC);
                        }
                        if ((cols = tabDelim.split(line))[0].length() == 0) continue;
                        File f = this.getFile(cols, hashMap);
                        FileEntry fe = new FileEntry(f);
                        if (cols.length >= 3) {
                            try {
                                fe.whenAdded = this.ensureMillis(Long.parseLong(cols[2]));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (cols.length >= 4) {
                                try {
                                    fe.cameraDate = Long.parseLong(cols[3]) * 1000L;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                        if ("true".equals(System.getProperty("blockLinks", "false")) && f instanceof LinkFile) continue;
                        boolean exists = LinkFile.exists(f, this.engine);
                        if (line.startsWith("-") && !exists) {
                            cols = tabDelim.split(line.substring(1));
                            fe.file = f = this.getFile(cols, hashMap);
                            this.excluded.add(f.getName());
                            fe.excluded = true;
                            if (includeExcluded && (includeMissing && f instanceof LinkFile || LinkFile.exists(f, this.engine)) && ff.accept(f)) {
                                list.put(f.getName(), fe);
                            }
                        } else if ((includeMissing && f instanceof LinkFile || LinkFile.exists(f, this.engine)) && ff.accept(f)) {
                            list.put(f.getName(), fe);
                        }
                        if (fullList == null) continue;
                        fullList.add(fe);
                    }
                }
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
                // empty catch block
            }
            {
                if (content != null) {
                    for (CachedFile cachedFile : content) {
                        FileEntry fe = (FileEntry)list.get(cachedFile.getName());
                        if (fe != null) continue;
                        if (this.engine.isExcludeByDefault()) {
                            this.excluded.add(cachedFile.getName());
                            fe = new FileEntry(cachedFile);
                            fe.excluded = true;
                        }
                        if (!includeExcluded && this.excluded.contains(cachedFile.getName())) continue;
                        if (fe == null) {
                            fe = new FileEntry(cachedFile);
                        }
                        list.put(cachedFile.getName(), fe);
                        if (fullList != null) {
                            fullList.add(fe);
                        }
                        this.newFilesFound = true;
                    }
                }
                if (updateDateAdded) {
                    boolean bl;
                    boolean bl2 = false;
                    for (FileEntry fe : fullList) {
                        if (fe.whenAdded != null) continue;
                        fe.whenAdded = now;
                        bl = true;
                    }
                    if (bl) {
                        try {
                            if (JAlbum.logger.isLoggable(Level.FINER)) {
                                System.out.println("Updating dateAdded to " + String.valueOf(ControlFiles.albumfiles(this.baseDir)));
                            }
                            FileCollection.saveEntries(fullList, this.engine, ControlFiles.albumfiles(this.baseDir));
                            this.dateAddedUpdated = true;
                        }
                        catch (IOException ex) {
                            System.err.println("Can't write to " + String.valueOf(ControlFiles.albumfiles(this.baseDir)));
                        }
                    }
                }
                return list.values();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public Map<String, File> getAllExisting() {
        return this.allExisting;
    }

    public boolean isNewFilesFound() {
        return this.newFilesFound;
    }

    public boolean isDateAddedUpdated() {
        return this.dateAddedUpdated;
    }

    private static void trimTrailingTabs(StringBuilder sb) {
        int i;
        for (i = sb.length() - 1; i >= 0; --i) {
            if (sb.charAt(i) == '\t') continue;
            ++i;
            break;
        }
        sb.delete(i, sb.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEntries(Collection<FileEntry> entries, AlbumBean engine, File targetFile) throws IOException {
        StringBuilder content = new StringBuilder();
        content.append("# This file is created by jAlbum. It sets custom file filtering and ordering for this image directory.\r\n# Files not listed here are added to the end of the album\r\n# Rows beginning with \"-\" indicate excluded files.\r\n# Rows can have up to 3 tab separated columns according to this scheme:\r\n# File name | Target path (for links) | When added (seconds since epoch)\r\n# Note: The target path can reference files and directories in other locations and thereby\r\n# allows you to compile albums consisting of files from several different locations.\r\n\r\n");
        for (FileEntry fe : entries) {
            File file;
            if (fe.excluded) {
                content.append('-');
            }
            if ((file = fe.file) instanceof RenamedFile) {
                file = ((RenamedFile)file).getTarget();
            }
            content.append(file.getName());
            content.append('\t');
            if (file instanceof LinkFile) {
                File projectRootDir;
                File target = ((LinkFile)file).getTarget();
                if (IO.isSubdirectoryOf(target, projectRootDir = engine.getCurrentProject().getRootFolder().getFile()) || target.equals(projectRootDir)) {
                    content.append(PROJECT_ROOT_DIR).append('/').append(projectRootDir.toPath().relativize(target.toPath()));
                } else {
                    content.append(((LinkFile)file).serializeTarget());
                }
            }
            content.append('\t');
            if (fe.whenAdded != null && fe.whenAdded != 0L) {
                content.append(fe.whenAdded / 1000L);
            }
            content.append('\t');
            if (fe.cameraDate != null && fe.cameraDate != 0L) {
                content.append(fe.cameraDate / 1000L);
            }
            FileCollection.trimTrailingTabs(content);
            content.append("\r\n");
        }
        String textEncoding = engine.isWriteUTF8() ? "UTF-8" : engine.getTextEncoding();
        String s = content.toString();
        if (!textEncoding.equals("UTF-8") && !StringCodec.isEncodable(s, textEncoding)) {
            textEncoding = "UTF-8";
        }
        Class<FileCollection> clazz = FileCollection.class;
        synchronized (FileCollection.class) {
            targetFile.getParentFile().mkdir();
            IO.writeTextFile(s, targetFile, textEncoding);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public boolean isExcluded(File f) {
        return this.excluded.contains(f.getName());
    }

    private Long ensureMillis(long whenAdded) {
        if (whenAdded > 100000000000L) {
            return whenAdded;
        }
        return whenAdded * 1000L;
    }

    private HashMap<String, File> mapFiles(File[] content) {
        HashMap<String, File> map = new HashMap<String, File>();
        if (content != null) {
            for (File f : content) {
                map.put(f.getName().toLowerCase(), f);
            }
        }
        return map;
    }

    private Map<String, File> getControlFiles(Map<String, File> allMap) {
        File jAlbumDir = new File(this.baseDir, ".jalbum");
        File[] controlFiles = CachedFile.listFiles(jAlbumDir);
        HashMap<String, File> controlMap = this.mapFiles(controlFiles);
        if (this.allowUpgrading) {
            this.jAlbumDirExists = controlFiles != null;
            this.jAlbumDirCreated = false;
            this.controlFilesMoved = false;
            this.moveIfMissing("albumfiles.txt", allMap, controlMap);
            this.moveIfMissing(META_FILE_NAME, allMap, controlMap);
            this.moveIfMissing(COMMENTS_FILE_NAME, allMap, controlMap);
            if (this.jAlbumDirCreated || this.controlFilesMoved) {
                try {
                    Files.setAttribute(jAlbumDir.toPath(), "dos:hidden", Boolean.TRUE, new LinkOption[0]);
                }
                catch (IOException | ClassCastException | IllegalArgumentException | SecurityException | UnsupportedOperationException ex) {
                    JAlbum.logger.fine("For " + String.valueOf(jAlbumDir) + ": " + ex.toString());
                }
            }
        } else {
            File albumFiles = allMap.get("albumfiles.txt");
            if (!controlMap.containsKey("albumfiles.txt") && albumFiles != null) {
                controlMap.put("albumfiles.txt", albumFiles);
            }
        }
        return controlMap;
    }

    private void moveIfMissing(String fileName, Map<String, File> fromMap, Map<String, File> toMap) {
        File from = fromMap.get(fileName);
        if (!toMap.containsKey(fileName) && from != null) {
            File jAlbumDir = new File(this.baseDir, ".jalbum");
            File to = new File(jAlbumDir, fileName);
            if (!this.jAlbumDirExists && !this.jAlbumDirCreated) {
                this.jAlbumDirCreated = jAlbumDir.mkdir();
            }
            if (from.renameTo(to)) {
                this.controlFilesMoved = true;
                toMap.put(fileName, to);
                if (JAlbum.logger.isLoggable(Level.FINE)) {
                    System.out.println("Moved " + String.valueOf(from) + " to " + String.valueOf(to));
                }
            } else {
                toMap.put(fileName, from);
            }
        }
    }

    private static class FileCache {
        private final Map<File, Map<File, CachedFile>> cache = new HashMap<File, Map<File, CachedFile>>();

        private FileCache() {
        }

        public File get(File f) {
            File ret;
            File dir = f.getParentFile();
            if (dir == null) {
                return f;
            }
            Map<File, CachedFile> dirCache = this.cache.get(dir);
            if (dirCache == null) {
                dirCache = new HashMap<File, CachedFile>();
                CachedFile[] files = CachedFile.listFiles(dir);
                if (files != null) {
                    for (CachedFile cf : files) {
                        dirCache.put(cf, cf);
                    }
                }
                this.cache.put(dir, dirCache);
            }
            return (ret = (File)dirCache.get(f)) != null ? ret : f;
        }
    }

    static class FileEntry {
        File file;
        Long whenAdded;
        Long cameraDate;
        boolean excluded;

        public FileEntry(File file) {
            this.file = file;
        }

        public FileEntry(File file, Long whenAdded, Long cameraDate, boolean excluded) {
            this.file = file;
            this.whenAdded = whenAdded;
            this.cameraDate = cameraDate;
            this.excluded = excluded;
        }
    }
}

