/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jalbum.jlibraw.LibRawImageReaderSpi;
import net.jalbum.util.UnorderedArrayList;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectFilter;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectOrderer;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.ControlFiles;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.FileNamerContext;
import se.datadosen.jalbum.LinkFileAlbumObject;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;

public class FileAlbumObject
extends AlbumObjectImpl {
    protected transient SoftReference<List<AlbumObject>> children;
    protected transient SoftReference<Map<String, AlbumObject>> nameMap;

    protected FileAlbumObject(File file, AlbumObject parent, AlbumObjectFactory factory) {
        super(file, parent, factory);
    }

    @Override
    public List<AlbumObject> getChildren() throws UncheckedIOException {
        return this.getChildren(!this.factory.isIgnoreOrdering());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlbumObject> getChildren(boolean ordered) throws UncheckedIOException {
        List<AlbumObject> children;
        boolean oldChildren = false;
        List<AlbumObject> list = children = this.children != null ? this.children.get() : null;
        if (!(children == null || System.currentTimeMillis() - this.getLastRefreshed() >= 5000L || ordered && children instanceof UnorderedArrayList)) {
            return children;
        }
        FileCollection fc = null;
        long lastModified = this.getLastModified();
        if (this.isFolder() && (children == null || lastModified > this.getLastRefreshed() && lastModified < System.currentTimeMillis())) {
            FileAlbumObject fileAlbumObject = this;
            synchronized (fileAlbumObject) {
                List<AlbumObject> list2 = children = this.children != null ? this.children.get() : null;
                if (children == null || lastModified > this.getLastRefreshed()) {
                    if (children != null) {
                        oldChildren = true;
                    }
                    fc = new FileCollection(this.factory.engine, this.file);
                    fc.setAllowUpgrading(true);
                    Collection<FileCollection.FileEntry> entries = fc.listEntries(this.factory.getFileFilter(), this.factory.isIncludeExcluded(), this.factory.isIncludeMissing(), this.factory.isForAlbumMaking());
                    this.markAsClean();
                    FileNamerContext context = new FileNamerContext(this);
                    ArrayList<AlbumObject> chldrn = new ArrayList<AlbumObject>();
                    AlbumObjectFilter filter = this.factory.getFilter();
                    for (FileCollection.FileEntry fe : entries) {
                        AlbumObjectImpl ao = null;
                        if (oldChildren) {
                            ao = (AlbumObjectImpl)this.getChild(fe.file.getName());
                        }
                        if (ao == null) {
                            ao = (AlbumObjectImpl)this.factory.createInstance(fe.file, context);
                        }
                        if (fe.excluded) {
                            boolean bl = ao.included = !fe.excluded;
                        }
                        if (ao.getName().equals(this.factory.engine.getResourceDirectory())) {
                            try {
                                ao.setHidden(true);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (fe.whenAdded != null) {
                            ao.whenAdded = fe.whenAdded;
                        }
                        ao.cameraDate = fe.cameraDate;
                        if (!filter.test(ao)) continue;
                        chldrn.add(ao);
                    }
                    if (this.excludeDuplicates(chldrn)) {
                        this.firePropertyChange("duplicatesExcluded", false, true);
                    }
                    if (ordered) {
                        children = new ArrayList<AlbumObject>();
                        AlbumObjectOrderer orderer = new AlbumObjectOrderer(this);
                        children.addAll(orderer.sort(chldrn));
                    } else {
                        children = new UnorderedArrayList<AlbumObject>();
                        children.addAll(chldrn);
                    }
                    this.setRep(null);
                    this.children = new SoftReference<List<AlbumObject>>(children);
                    this.nameMap = null;
                    if (fc.isNewFilesFound() && this.factory.isForAlbumMaking()) {
                        this.updateRepresentingIcon();
                    }
                }
            }
        }
        if (children instanceof UnorderedArrayList && ordered) {
            children = this.orderer.sort(children);
            this.children = new SoftReference<List<AlbumObject>>(children);
        }
        if (fc != null) {
            this.importThmAsAttachment(fc.getAllExisting());
        }
        return children;
    }

    @Override
    public void setChildren(List<AlbumObject> children) throws IOException {
        this.children = new SoftReference<List<AlbumObject>>(children);
        this.nameMap = null;
        this.setRep(null);
        FileCollection.saveEntries(children.stream().map(ao -> new FileCollection.FileEntry(ao.getFile(), ao.getWhenAdded(), ((AlbumObjectImpl)ao).cameraDate, !ao.isIncluded())).collect(Collectors.toList()), this.factory.engine, ControlFiles.albumfiles(this.file));
        this.markAsClean();
        this.firePropertyChange("children", null, children);
        this.updateRepresentingIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, AlbumObject> getNameMap() {
        Map<String, AlbumObject> nm;
        Map<String, AlbumObject> map = nm = this.nameMap != null ? this.nameMap.get() : null;
        if (nm == null && this.isFolder()) {
            FileAlbumObject fileAlbumObject = this;
            synchronized (fileAlbumObject) {
                Map<String, AlbumObject> map2 = nm = this.nameMap != null ? this.nameMap.get() : null;
                if (nm == null) {
                    List<AlbumObject> cld;
                    nm = new HashMap<String, AlbumObject>();
                    List<AlbumObject> list = cld = this.children != null ? this.children.get() : null;
                    if (cld == null) {
                        cld = this.getChildren(false);
                    }
                    for (AlbumObject ao : cld) {
                        nm.put(ao.getName().toLowerCase(), ao);
                    }
                    this.nameMap = new SoftReference<Map<String, AlbumObject>>(nm);
                }
            }
        }
        return nm;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.children = null;
        this.nameMap = null;
        this.thumbCache.clear();
        this.firePropertyChange("invalidated", null, null);
    }

    private boolean excludeDuplicates(Collection<AlbumObject> chldrn) {
        AlbumObject[] sorted = (AlbumObject[])chldrn.toArray(AlbumObject[]::new);
        Arrays.sort(sorted, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        boolean duplicatatesExcluded = false;
        String lastBase = null;
        AlbumObject lastAO = null;
        AlbumObject lastRaw = null;
        for (AlbumObject ao : sorted) {
            String base;
            if (ao.isFolder()) continue;
            String ext = IO.extensionOf(ao.getFile());
            if (!FileFilters.isJPEGImage(ao.getFile()) && LibRawImageReaderSpi.isFormatSupported((String)ext)) {
                lastRaw = ao;
            }
            if ((base = IO.baseName(ao.getName())).equals(lastBase)) {
                AlbumObject other;
                AlbumObject albumObject = other = lastRaw == ao ? lastAO : ao;
                if (other != null && other.isIncluded() && lastRaw != null && lastRaw.isIncluded()) {
                    ((AlbumObjectImpl)lastRaw).included = false;
                    duplicatatesExcluded = true;
                }
            }
            lastBase = base;
            lastAO = ao;
        }
        return duplicatatesExcluded;
    }

    static FileAlbumObject createInstance(File file, AlbumObject parent, AlbumObjectFactory factory) {
        return file instanceof LinkFile ? new LinkFileAlbumObject(file, parent, factory) : new FileAlbumObject(file, parent, factory);
    }

    private void importThmAsAttachment(Map<String, File> allExisting) {
        for (File f : allExisting.values()) {
            String base;
            AlbumObject ao;
            if (!IO.isThumbFile(f) || (ao = this.getMatchingAO(base = IO.baseName(f))) == null) continue;
            File destDir = Attachments.getAttachmentsDir(ao.getFile());
            destDir.mkdirs();
            File destFile = new File(destDir, base + ".jpg");
            if (!f.renameTo(destFile)) {
                System.err.println("Error attaching thm file " + String.valueOf(f));
                continue;
            }
            ao.getAttachments().set(destFile, Attachments.Type.IMAGE);
            System.out.println("Attached thm file to " + String.valueOf(ao));
        }
    }

    private AlbumObject getMatchingAO(String baseName) {
        for (AlbumObject ao : this.getChildren()) {
            if (!ao.getFile().getName().startsWith(baseName)) continue;
            return ao;
        }
        return null;
    }
}

