/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.InvalidLicenseException;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.util.Debug;

class ExpiredSupportPlanException
extends InvalidLicenseException {
    private Date supportExpires;

    public ExpiredSupportPlanException(Date supportExpires) {
        super("Support and update plan doesn't cover this jAlbum version");
        this.supportExpires = supportExpires;
    }

    @Override
    public void showDialog(JFrame parent) {
        JExpiredSupportPlanDialog d = new JExpiredSupportPlanDialog(parent);
        d.setLocationRelativeTo(parent);
        ((Dialog)d).setVisible(true);
    }

    private class JExpiredSupportPlanDialog
    extends JSmartDialog {
        JLabel logo;
        private final JFrame parent;
        Action cancelAction;
        Action extendAction;

        public JExpiredSupportPlanDialog(JFrame parent) throws HeadlessException {
            super(parent, Msg.get("ui.expiredSupportPlanTitle"), true);
            this.logo = new JLabel(Icons.get("share-jalbum", 64));
            this.cancelAction = new AbstractAction(Msg.get("cancel")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JExpiredSupportPlanDialog.this.setVisible(false);
                }
            };
            this.extendAction = new AbstractAction(Msg.get("ui.extend")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String cid = null;
                        SignInManager sim = SignInManager.getInstance();
                        if (sim.isSignedIn()) {
                            cid = AccountManager.getCid(sim.getUserName(), sim.getPassword());
                        } else {
                            AccountProfile profile = AccountManager.getInstance().getFirstMyjalbumAccount();
                            if (profile != null) {
                                cid = AccountManager.getCid(profile);
                            }
                        }
                        BrowserLauncher.openURL("http://jalbum.net/purchase?referrer=expiredSupportPlanDialog&utm_source=client&utm_medium=extendAction&utm_campaign=expiredSupportPlanDialog" + (String)(cid != null ? "&cid=" + cid : ""));
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JExpiredSupportPlanDialog.this.parent, ex);
                    }
                }
            };
            this.parent = parent;
            this.init();
        }

        private void init() {
            this.setResizable(false);
            JPanel logoPanel = new JPanel();
            logoPanel.setBorder(BorderFactory.createEmptyBorder(18, 18, 0, 8));
            logoPanel.add(this.logo);
            this.add((Component)logoPanel, "West");
            ControlPanel main = new ControlPanel();
            DateFormat formatter = DateFormat.getDateInstance(3);
            main.add("p", new JLabel("<html>" + Msg.get("ui.expiredSupportPlanInfo", formatter.format(ExpiredSupportPlanException.this.supportExpires)) + "</html>"));
            this.add((Component)main, "East");
            this.registerActions(this.extendAction, this.cancelAction);
            this.pack();
        }
    }
}

