/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPIterator;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.options.IteratorOptions;
import com.adobe.internal.xmp.properties.XMPPropertyInfo;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.XmpManager;

public class EmbeddedProperties
extends TreeMap<String, String> {
    public static final String FILE_PROPERTIES_KEY = "properties";
    private File file;

    public EmbeddedProperties() {
    }

    public EmbeddedProperties(Map<? extends String, ? extends String> m) {
        super(m);
    }

    public EmbeddedProperties(File jpegFile) {
        this.file = jpegFile;
        try {
            XmpManager mgr = new XmpManager(jpegFile);
            XMPMeta meta = mgr.getXMPMeta();
            XMPIterator it = meta.iterator("http://ns.jalbum.net/1.0/", FILE_PROPERTIES_KEY, new IteratorOptions().setJustChildren(true));
            while (it.hasNext()) {
                XMPPropertyInfo item = (XMPPropertyInfo)it.next();
                int index = item.getPath().lastIndexOf(58);
                if (index < 0) continue;
                this.put(item.getPath().substring(index + 1), item.getValue());
            }
        }
        catch (XMPException | IOException ex) {
            JAlbum.logger.fine(ex.toString());
        }
    }

    public void write(File jpegFile) throws IOException {
        try {
            XmpManager mgr = new XmpManager(jpegFile);
            XMPMeta meta = mgr.getXMPMeta();
            meta.deleteProperty("http://ns.jalbum.net/1.0/", FILE_PROPERTIES_KEY);
            for (Map.Entry e : this.entrySet()) {
                meta.setStructField("http://ns.jalbum.net/1.0/", FILE_PROPERTIES_KEY, "http://ns.jalbum.net/1.0/", (String)e.getKey(), (String)e.getValue());
            }
            mgr.save();
        }
        catch (XMPException ex) {
            throw new IOException(ex);
        }
    }

    public void write() throws IOException {
        if (this.file == null) {
            throw new IllegalStateException("No file specified when created");
        }
        this.write(this.file);
    }
}

