/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.util.List;
import net.jalbum.OutputFormat;
import net.jalbum.Rendition;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.ImageRenderer;
import se.datadosen.util.Scope;

public class ElementFactory {
    protected final AlbumObject ao;

    public CategorizedElements thumbnails() {
        return new CategorizedElements(true);
    }

    public CategorizedElements closeups() {
        return new CategorizedElements(false);
    }

    public ElementFactory(AlbumObject ao) {
        this.ao = ao;
    }

    public class CategorizedElements {
        protected final boolean isThumbs;

        CategorizedElements(boolean isThumbs) {
            this.isThumbs = isThumbs;
        }

        public Element picture() {
            Element picture = new Element("picture");
            ImageRenderer renderer = ElementFactory.this.ao.getRenderer();
            Scope vars = ElementFactory.this.ao.getVars();
            String typicalPath = this.isThumbs ? (String)vars.get("thumbPath") : (String)vars.get("imagePath");
            for (OutputFormat format : OutputFormat.values()) {
                List<Rendition> renditions;
                List<Rendition> list = renditions = this.isThumbs ? renderer.getThumbRenditions(format) : renderer.getCloseupRenditions(format);
                if (renditions.isEmpty()) continue;
                picture.appendElement("source").attr("type", format.getMimeType()).attr("srcset", ImageRenderer.buildSrcset(renditions, typicalPath));
            }
            picture.appendChild((Node)this.img());
            return picture;
        }

        public Element img() {
            Scope vars = ElementFactory.this.ao.getVars();
            String typicalPath = this.isThumbs ? (String)vars.get("thumbPath") : (String)vars.get("imagePath");
            Object width = this.isThumbs ? vars.get("thumbWidth") : vars.get("imageWidth");
            Object height = this.isThumbs ? vars.get("thumbHeight") : vars.get("imageHeight");
            Element img = new Element("img").attr("src", typicalPath).attr("width", width.toString()).attr("height", height.toString()).attr("alt", Jsoup.parse((String)((String)vars.get("title"))).text());
            return img;
        }
    }
}

