/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.IOException;
import net.jalbum.component.JProgressManager;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumManager;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Notifier;
import se.datadosen.jalbum.TaskManager;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.tags.ElementException;
import se.datadosen.util.StringUtil;

public class DeletePublishedAlbumTask
extends TaskManager.BackgroundTask
implements AlbumBeanListener {
    private final Object pauseMonitor = new Object();
    JProgressManager.TaskStatus ts = new JProgressManager.TaskStatus();
    private JAlbumContext context;

    public DeletePublishedAlbumTask(AlbumProject ap, JAlbumContext context) {
        super(ap);
        this.init(context);
    }

    private void init(JAlbumContext context) {
        this.context = context;
        this.setName(StringUtil.limit(this.ap.getName(), 30) + " (" + Msg.get("ui.deletePublishedTaskShortName") + ")");
        this.ts.setMessage(this.getName());
        this.ts.setIndeterminate(true);
        this.ts.onAbort(() -> {
            Object object = this.pauseMonitor;
            synchronized (object) {
                this.ts.abort();
                this.cancel();
                if (this.ts.isStarted()) {
                    this.pauseMonitor.notifyAll();
                }
            }
            context.getFrame().progressManager.removeTask(this.ts);
        });
        this.ts.onPause(() -> {
            Object object = this.pauseMonitor;
            synchronized (object) {
                if (!this.ts.isPaused()) {
                    this.pauseMonitor.notifyAll();
                }
            }
        });
    }

    @Override
    protected Object doInBackground() throws Exception {
        this.context.getFrame().progressManager.startTask(this.ts);
        AlbumObject root = this.ap.getRootFolder();
        AlbumObjectProperties props = root.getProperties();
        if (!props.containsKey("albumURL")) {
            throw new JAlbumManager.InformationException(Msg.get("ui.notPublished"));
        }
        String accountProfileName = (String)props.get("accountProfileName");
        if (accountProfileName == null) {
            throw new JAlbumManager.InformationException(Msg.get("ui.notPublished"));
        }
        AccountProfile account = AccountManager.getInstance().findAccountByName(accountProfileName);
        if (account == null) {
            return null;
        }
        String remotePath = (String)props.get("remotePath");
        String albumURL = (String)props.get("albumURL");
        if (remotePath == null || remotePath.length() == 0 || remotePath.equals("/")) {
            return null;
        }
        this.status(Msg.get("ui.connectingToServer") + " " + account.getFtpServer() + "...");
        try (UploadBean uploadBean = new UploadBean();){
            uploadBean.setEngine(this.context.getEngine());
            uploadBean.setAccountProperties(account);
            uploadBean.addAlbumBeanListener(this);
            uploadBean.connect();
            this.status(Msg.get("ui.deletingPublishedAlbum") + "...");
            uploadBean.deleteAlbum(root, remotePath);
            try {
                Notifier notifier = new Notifier(this.context);
                if (notifier.allowedToNotify(account)) {
                    this.status(Msg.get("publish.updatingProfilePage") + "...");
                    notifier.albumDeleted(account, albumURL);
                }
            }
            catch (IOException | ElementException ex) {
                ex.printStackTrace();
            }
            this.status(Msg.get("edit.doneInfo"));
            Object var8_8 = null;
            return var8_8;
        }
    }

    @Override
    protected void done() {
        this.context.getFrame().progressManager.removeTask(this.ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgress(AlbumBeanEvent e, float currentObjectProgress) {
        Object object = this.pauseMonitor;
        synchronized (object) {
            if (this.ts.isPaused()) {
                try {
                    this.pauseMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.ts.setProgress(Msg.get("ui.deleting", e.msg));
    }

    @Override
    public void status(String message) {
        this.ts.setSubMessage(message);
    }

    @Override
    public void imageProcessingStarted(AlbumBeanEvent e) {
        if (this.ts.isAborted()) {
            e.abortProcessing();
        }
        this.updateProgress(e, 0.0f);
    }

    @Override
    public void imageProcessingFinished(AlbumBeanEvent e) {
        if (this.ts.isAborted()) {
            e.abortProcessing();
        }
        this.updateProgress(e, 0.0f);
    }
}

