/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import net.jalbum.component.HasIcon;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.Watchdog;
import se.datadosen.util.IO;
import se.datadosen.util.SafeSimpleDateFormat;
import se.datadosen.util.StringUtil;
import se.datadosen.util.annotations.Unbound;

public class Config
implements Serializable {
    public static final String DARCULA_LAF_NAME = "com.bulenkov.darcula.DarculaLaf";
    public static final String FLAT_DARCULA_LAF_NAME = "com.formdev.flatlaf.FlatDarculaLaf";
    static final String ILLEGAL_CHARACTERS = "#$%&*\"\\/:;?=|~";
    private static Config theConfig;
    public File progDir;
    public File skinsDir;
    public ChainedDirectory chainedSkinsDir;
    ChainedDirectory chainedExtDir;
    ChainedDirectory chainedPluginsDir;
    ChainedDirectory chainedToolsDir;
    public ChainedDirectory chainedSystemDir;
    public File pluginsDir;
    public String language = "default";
    private String look;
    private String lookAndFeel;
    private String lookAndFeelName = "jAlbum Dark";
    private String webHostListUrl = "http://jalbum.net/web-hosts.xml";
    private boolean cleanOutputFiles = true;
    private boolean synchronizeOutputDirectory = true;
    private boolean useHardLinks = false;
    private boolean cacheThumbnails = true;
    private AfterPublishAction afterPublishAction = AfterPublishAction.openPublishedAlbum;
    private boolean encryptManifest = false;
    private String manifestPassword;
    private boolean zipstreaming = true;
    private LoggingLevel loggingLevel = LoggingLevel.warning;
    private String myAlbumsLocation;
    private OutputDirectoryLocation outputDirectoryLocation = OutputDirectoryLocation.project;
    private String webDirectory;
    private boolean showTipOfTheDay = true;
    private int traceVersion = 3;
    private LabelType labelType = LabelType.caption;
    private FileAddMethod fileAddMethod = FileAddMethod.ASK;
    private String illegalCharacters = "#$%&*\"\\/:;?=|~";
    private boolean rememberCopiedFiles = true;
    private boolean writeXmp = true;
    private int maxSimultaneousTransfers = 8;
    private boolean useNativeFileDialogs = true;
    private boolean unifyColorModel = true;
    private boolean videoSupported = true;
    private Set<String> supportedVideoFormats;
    private int dividerLocation = 0;
    private int folderPropertiesWidth = 0;
    private ProjectOrdering projectOrdering = ProjectOrdering.projectsByUse;
    private int recentProjects = 50;
    private int fontSize = 12;
    private boolean useWatchdog = false;
    private boolean useLayoutHints = true;
    private boolean checkForUpdates = true;
    private boolean backgroundSignInOnStart;
    private int windowState = 0;
    private boolean includeLifeboatFile = true;
    private PreviewMode previewMode = PreviewMode.external;
    private boolean serverBasedPreview = true;
    private String localServerURL;
    private String previewServerPort = "8080";
    private boolean checkSpelling = true;
    private boolean indexAlbumObjects = true;
    private boolean indexMetadata = true;
    private String datePattern = "";
    private SimpleDateFormat dateFormatter = (SimpleDateFormat)DateFormat.getDateTimeInstance();
    private boolean rememberLastSelectedItem = true;
    private boolean showOpenHTMLEditorButton = true;
    private NotificationLevel bgNotifications = NotificationLevel.NORMAL;
    private boolean backgroundMode = false;
    private boolean compressAudioClips = true;
    private ThumbnailQuality thumbnailQuality = ThumbnailQuality.HQ;
    private boolean showWarnings = true;
    private int explorerScrollSpeed = 30;
    private boolean rememberWindowBounds = true;
    private boolean scrollToTop = false;
    private boolean customTitleBar = true;
    private PropertyChangeSupport changeSupport;

    private Config() {
        try {
            if (System.getProperty("os.name", "").contains("Windows") && Double.valueOf(System.getProperty("os.version", "9")) < 6.0) {
                this.previewMode = PreviewMode.external;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.changeSupport = new PropertyChangeSupport(this);
        this.progDir = new File("").getAbsoluteFile();
        this.newProgDir();
        if (!this.skinsDir.exists() || !this.pluginsDir.exists()) {
            URL url;
            File classPath;
            String instDirName = System.getProperty("jalbum.installation.dir");
            this.progDir = instDirName != null ? new File(instDirName) : ((classPath = new File(System.getProperty("java.class.path"))).exists() ? classPath.getParentFile().getAbsoluteFile() : ((url = JAlbum.class.getResource("../../../")) != null ? new File(url.getFile()).getParentFile() : new File("")));
            this.newProgDir();
        }
        this.updateChainedDirs();
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(name, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(name, listener);
    }

    private void updateChainedDirs() {
        this.chainedSkinsDir = new ChainedDirectory(this.skinsDir);
        this.chainedExtDir = new ChainedDirectory(new File(this.progDir, "ext"));
        this.chainedPluginsDir = new ChainedDirectory(new File(this.progDir, "plugins"));
        this.chainedToolsDir = new ChainedDirectory(new File(this.progDir, "tools"));
        this.chainedSystemDir = new ChainedDirectory(new File(this.progDir, "system"));
        File configDir = MiniConfig.getMiniConfig().configDir;
        if (configDir != null) {
            this.chainedSkinsDir = new ChainedDirectory(new File(configDir, "skins"), this.chainedSkinsDir, (backgroundFile, foregroundFile) -> {
                SkinProperties bgProps = new SkinProperties(backgroundFile);
                SkinProperties fgProps = new SkinProperties(foregroundFile);
                return bgProps.getVersion().compareTo(fgProps.getVersion()) > 0;
            });
            this.chainedExtDir = new ChainedDirectory(new File(configDir, "ext"), this.chainedExtDir, ChainedDirectory.lastModifiedDecider);
            this.chainedPluginsDir = new ChainedDirectory(new File(configDir, "plugins"), this.chainedPluginsDir, ChainedDirectory.lastModifiedDecider);
            this.chainedToolsDir = new ChainedDirectory(new File(configDir, "tools"), this.chainedToolsDir, ChainedDirectory.lastModifiedDecider);
            this.chainedSystemDir = new ChainedDirectory(new File(configDir, "system"), this.chainedSystemDir, ChainedDirectory.lastModifiedDecider);
        }
    }

    public static Config getConfig() {
        if (theConfig == null) {
            theConfig = new Config();
        }
        return theConfig;
    }

    public static File getConfigFile(String newName, String oldName) {
        File oldFile = new File(System.getProperty("user.home"), oldName);
        File newFile = new File(MiniConfig.getMiniConfig().configDir, newName);
        MiniConfig.getMiniConfig().configDir.mkdir();
        try {
            if (!newFile.exists() && oldFile.exists()) {
                IO.copyFile(oldFile, newFile, false);
                System.out.println("Config file " + String.valueOf(newFile) + " migrated from old location " + String.valueOf(oldFile));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return newFile;
    }

    public void setProgramDirectory(File progDir) {
        this.progDir = progDir;
        this.newProgDir();
        this.updateChainedDirs();
    }

    public void setProgramDirectory(String progDir) {
        this.setProgramDirectory(new File(progDir));
    }

    public void setSkinsDirectory(File skinsDir) {
        this.skinsDir = skinsDir;
        this.chainedSkinsDir = new ChainedDirectory(skinsDir);
    }

    public void setSkinsDirectory(String skinsDir) {
        this.setSkinsDirectory(new File(skinsDir));
    }

    public String getLanguage() {
        return this.language;
    }

    @Unbound
    public String getInterpretedLanguage() {
        return this.language.equals("default") ? System.getProperty("user.language") : this.language;
    }

    public void setLanguage(String language) {
        String oldLanguage = this.language;
        this.language = language;
        if (!language.equals("default")) {
            Locale.setDefault(new Locale(language, System.getProperty("user.country")));
        } else {
            Locale.setDefault(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
        }
        Msg.reloadBundle();
        this.changeSupport.firePropertyChange("language", oldLanguage, language);
    }

    private void newProgDir() {
        this.skinsDir = new File(this.progDir, "skins");
        this.pluginsDir = new File(this.progDir, "plugins");
    }

    @Deprecated
    public String getLook() {
        return this.look;
    }

    @Deprecated
    public void setLook(String look) {
        String old = this.look;
        this.look = look;
        this.changeSupport.firePropertyChange("look", old, look);
    }

    public String getLookAndFeelName() {
        return this.lookAndFeelName;
    }

    public void setLookAndFeelName(String lookAndFeelName) {
        String old = this.lookAndFeelName;
        this.lookAndFeelName = lookAndFeelName;
        this.changeSupport.firePropertyChange("lookAndFeelName", old, lookAndFeelName);
    }

    @Deprecated
    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    @Deprecated
    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public String getWebHostListUrl() {
        return this.webHostListUrl;
    }

    public void setWebHostListUrl(String webHostListUrl) {
        this.webHostListUrl = webHostListUrl;
    }

    public boolean isCleanOutputFiles() {
        return this.cleanOutputFiles;
    }

    public void setCleanOutputFiles(boolean clean) {
        this.cleanOutputFiles = clean;
    }

    public boolean isSynchronizeOutputDirectory() {
        return this.synchronizeOutputDirectory;
    }

    public void setSynchronizeOutputDirectory(boolean synchronizeOutputDirectory) {
        this.synchronizeOutputDirectory = synchronizeOutputDirectory;
    }

    public boolean isUseHardLinks() {
        return this.useHardLinks;
    }

    public void setUseHardLinks(boolean useHardLinks) {
        this.useHardLinks = useHardLinks;
    }

    public boolean isCacheThumbnails() {
        return this.cacheThumbnails;
    }

    public void setCacheThumbnails(boolean cacheThumbnails) {
        this.cacheThumbnails = cacheThumbnails;
    }

    public ThumbnailQuality getThumbnailQuality() {
        return this.thumbnailQuality;
    }

    public void setThumbnailQuality(ThumbnailQuality thumbnailQuality) {
        ThumbnailQuality old = this.thumbnailQuality;
        this.thumbnailQuality = thumbnailQuality;
        this.changeSupport.firePropertyChange("thumbnailQuality", (Object)old, (Object)thumbnailQuality);
    }

    public AfterPublishAction getAfterPublishAction() {
        return this.afterPublishAction;
    }

    public void setAfterPublishAction(AfterPublishAction afterPublishAction) {
        this.afterPublishAction = afterPublishAction;
    }

    public boolean isEncryptManifest() {
        return this.encryptManifest;
    }

    public void setEncryptManifest(boolean encryptManifest) {
        this.encryptManifest = encryptManifest;
    }

    public String getManifestPassword() {
        return this.manifestPassword;
    }

    public void setManifestPassword(String manifestPassword) {
        this.manifestPassword = manifestPassword;
    }

    public boolean isZipstreaming() {
        return this.zipstreaming;
    }

    public void setZipstreaming(boolean zipstreaming) {
        this.zipstreaming = zipstreaming;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        LoggingLevel oldLevel = this.loggingLevel;
        this.loggingLevel = loggingLevel;
        JAlbum.logger.setLevel(loggingLevel.getLevel());
        for (Handler handler : JAlbum.logger.getHandlers()) {
            handler.setLevel(loggingLevel.getLevel());
        }
        System.setProperty("log.level", loggingLevel.getLevel().getName());
        this.changeSupport.firePropertyChange("loggingLevel", (Object)oldLevel, (Object)loggingLevel);
    }

    @Unbound
    public boolean isDebugMode() {
        return this.loggingLevel.getLevel().intValue() <= Level.FINER.intValue();
    }

    public String getMyAlbumsLocation() {
        if (this.myAlbumsLocation == null || this.myAlbumsLocation.length() == 0 || new File(this.myAlbumsLocation).getParentFile() != null && !new File(this.myAlbumsLocation).getParentFile().exists()) {
            File defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
            File myAlbums = new File(defaultDir, Msg.get("newproject.myAlbumsDirectory"));
            this.setMyAlbumsLocation(myAlbums.getAbsolutePath());
        }
        return this.myAlbumsLocation;
    }

    public void setMyAlbumsLocation(String myAlbumsLocation) {
        String oldMyAlbumsLocation = this.myAlbumsLocation;
        this.myAlbumsLocation = myAlbumsLocation;
        this.changeSupport.firePropertyChange("myAlbumsLocation", oldMyAlbumsLocation, myAlbumsLocation);
    }

    public String getWebDirectory() {
        if (this.webDirectory == null || this.webDirectory.length() == 0 || new File(this.webDirectory).getParentFile() != null && !new File(this.webDirectory).getParentFile().exists()) {
            File defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
            File webDirectory = new File(defaultDir, "web");
            this.setWebDirectory(webDirectory.getAbsolutePath());
        }
        return this.webDirectory;
    }

    public void setWebDirectory(String webDirectory) {
        String old = this.webDirectory;
        this.webDirectory = webDirectory;
        this.changeSupport.firePropertyChange("webDirectory", old, webDirectory);
    }

    public OutputDirectoryLocation getOutputDirectoryLocation() {
        return this.outputDirectoryLocation;
    }

    public void setOutputDirectoryLocation(OutputDirectoryLocation outputDirectoryLocation) {
        OutputDirectoryLocation old = this.outputDirectoryLocation;
        this.outputDirectoryLocation = outputDirectoryLocation;
        this.changeSupport.firePropertyChange("outputDirectoryLocation", (Object)old, (Object)outputDirectoryLocation);
    }

    public boolean isShowTipOfTheDay() {
        return this.showTipOfTheDay;
    }

    public void setShowTipOfTheDay(boolean showTipOfTheDay) {
        this.showTipOfTheDay = showTipOfTheDay;
    }

    public LabelType getLabelType() {
        return this.labelType;
    }

    public void setLabelType(LabelType labelType) {
        LabelType oldType = this.labelType;
        this.labelType = labelType;
        this.changeSupport.firePropertyChange("labelType", (Object)oldType, (Object)labelType);
    }

    public FileAddMethod getFileAddMethod() {
        return this.fileAddMethod;
    }

    public void setFileAddMethod(FileAddMethod fileAddMethod) {
        this.fileAddMethod = fileAddMethod;
    }

    public String getIllegalCharacters() {
        return this.illegalCharacters;
    }

    public void setIllegalCharacters(String illegalCharacters) {
        this.illegalCharacters = illegalCharacters;
    }

    public boolean isRememberCopiedFiles() {
        return this.rememberCopiedFiles;
    }

    public void setRememberCopiedFiles(boolean rememberCopiedFiles) {
        this.rememberCopiedFiles = rememberCopiedFiles;
    }

    public boolean isWriteXmp() {
        return this.writeXmp;
    }

    public void setWriteXmp(boolean writeXmp) {
        this.writeXmp = writeXmp;
    }

    public String getHttpProxyHost() {
        return System.getProperty("http.proxyHost");
    }

    public void setHttpProxyHost(String httpProxyHost) {
        if (httpProxyHost.length() > 0 || this.getHttpProxyHost() != null) {
            System.setProperty("http.proxyHost", httpProxyHost);
        }
    }

    public String getHttpProxyPort() {
        return System.getProperty("http.proxyPort");
    }

    public void setHttpProxyPort(String httpProxyPort) {
        if (httpProxyPort.length() > 0 || this.getHttpProxyPort() != null) {
            System.setProperty("http.proxyPort", httpProxyPort);
        }
    }

    public int getMaxSimultaneousTransfers() {
        return this.maxSimultaneousTransfers;
    }

    public void setMaxSimultaneousTransfers(int maxSimultaneousTransfers) {
        this.maxSimultaneousTransfers = maxSimultaneousTransfers;
    }

    public boolean isUseNativeFileDialogs() {
        return this.useNativeFileDialogs;
    }

    public void setUseNativeFileDialogs(boolean useNativeFileDialogs) {
        this.useNativeFileDialogs = useNativeFileDialogs;
    }

    public boolean isUnifyColorModel() {
        return this.unifyColorModel;
    }

    public void setUnifyColorModel(boolean unifyColorModel) {
        this.unifyColorModel = unifyColorModel;
    }

    @Unbound
    @Deprecated
    public boolean isVideoSupport() {
        return this.videoSupported;
    }

    public boolean isVideoSupported() {
        return this.videoSupported;
    }

    public void setVideoSupported(boolean videoSupported) {
        boolean oldVideoSupport = this.videoSupported;
        this.videoSupported = videoSupported;
        this.changeSupport.firePropertyChange("videoSupported", oldVideoSupport, videoSupported);
    }

    public Set<String> getSupportedVideoFormats() {
        if (this.supportedVideoFormats == null) {
            this.supportedVideoFormats = StringUtil.stringToSet("g722, a64, ismv, mxf_d10, g729, iv8, 3gp, mpegtsraw, mts, mt2s, wc3movie, shn, vqf, webm, ipod, ogg, smjpeg, rpl, idcin, ffm, xa, rawvideo, rtsp, roq, wmv, mpeg, mpg, sox, sol, iss, gsm, f64be, wv, mov, bit, asf, mpeg1video, m4v, mjpeg, dxa, dv, s24be, mpjpeg, smoothstreaming, 3g2, dirac, pmp, ea, lxf, u32be, dfa, flic, lavfi, pva, apc, bethsoftvid, u16be, ea_cdata, null, mm, asf_stream, dvd, u16le, wtv, nc, tty, vc1test, smush, nut, nuv, s32le, ivf, mtv, u24le, jv, bink, rso, segment, mulaw, vmd, rcv, s32be, f32le, mlp, mpeg2video, dsicin, tmv, spdif, u8, siff, avi, mpegvideo, anm, g723_1, sdp, psp, yuv4mpegpipe, xmv, s16le, 4xm, qcp, rtp, tiertexseq, ingenient, nsv, svcd, cdxl, f32be, image2pipe, dnxhd, h263, vcd, h261, iff, w64, flv, gxf, flac, s24le, u24be, hls,applehttp, u32le, bmv, h264, amr, latm, ipmovie, rl2, film_cpk, mgsts, rm, vc1, mpegts, wsvqa, mp4, vob, voc, mvi, mov,mp4,3gp,3g2,mj2, eac3, lmlm4, truehd, psxstr, mxf, cavsvideo, r3d, mxg, s8, txd, f4v, smk, msnwctcp, thp, paf, yop, image2, idf, filmstrip, c93, ilbc, mmf, f64le, s16be, matroska, qt, m2ts, mkv");
        }
        return this.supportedVideoFormats;
    }

    public void setSupportedVideoFormats(Set<String> supportedVideoFormats) {
        this.supportedVideoFormats = supportedVideoFormats;
        if (supportedVideoFormats.isEmpty()) {
            this.supportedVideoFormats = null;
        }
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int dividerLocation) {
        this.dividerLocation = dividerLocation;
    }

    public int getFolderPropertiesWidth() {
        return this.folderPropertiesWidth;
    }

    public void setFolderPropertiesWidth(int width) {
        this.folderPropertiesWidth = width;
    }

    public ProjectOrdering getProjectOrdering() {
        return this.projectOrdering;
    }

    public void setProjectOrdering(ProjectOrdering projectOrdering) {
        this.projectOrdering = projectOrdering;
    }

    public int getRecentProjects() {
        return this.recentProjects;
    }

    public void setRecentProjects(int recentProjects) {
        int oldRecentProjects = this.recentProjects;
        this.recentProjects = recentProjects;
        this.changeSupport.firePropertyChange("recentProjects", oldRecentProjects, recentProjects);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        int oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.changeSupport.firePropertyChange("fontSize", oldFontSize, fontSize);
    }

    public boolean isUseWatchdog() {
        return this.useWatchdog;
    }

    public void setUseWatchdog(boolean useWatchdog) {
        this.useWatchdog = useWatchdog;
        Watchdog wd = Watchdog.getInstance();
        if (useWatchdog && !wd.isRunning()) {
            wd.run();
        } else if (!useWatchdog && wd.isRunning()) {
            wd.stop();
        }
    }

    public boolean isUseLayoutHints() {
        return this.useLayoutHints;
    }

    public void setUseLayoutHints(boolean useLayoutHints) {
        this.useLayoutHints = useLayoutHints;
    }

    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    public void setCheckForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
    }

    public boolean isBackgroundSignInOnStart() {
        return this.backgroundSignInOnStart;
    }

    public void setBackgroundSignInOnStart(boolean backgroundSignInOnStart) {
        this.backgroundSignInOnStart = backgroundSignInOnStart;
    }

    public int getWindowState() {
        return (this.windowState & 1) != 0 ? 0 : this.windowState;
    }

    public void setWindowState(int windowState) {
        this.windowState = windowState;
    }

    public boolean isIncludeLifeboatFile() {
        return this.includeLifeboatFile;
    }

    public void setIncludeLifeboatFile(boolean includeLifeboatFile) {
        this.includeLifeboatFile = includeLifeboatFile;
    }

    public PreviewMode getPreviewMode() {
        return this.previewMode;
    }

    public void setPreviewMode(PreviewMode previewMode) {
        PreviewMode oldMode = this.previewMode;
        this.previewMode = previewMode;
        this.changeSupport.firePropertyChange("previewMode", (Object)oldMode, (Object)previewMode);
    }

    public boolean isServerBasedPreview() {
        return this.serverBasedPreview;
    }

    public void setServerBasedPreview(boolean serverBasedPreview) {
        boolean oldServerBasedPreview = this.serverBasedPreview;
        this.serverBasedPreview = serverBasedPreview;
        this.changeSupport.firePropertyChange("serverBasedPreview", oldServerBasedPreview, serverBasedPreview);
    }

    public String getPreviewServerPort() {
        return this.previewServerPort;
    }

    public void setPreviewServerPort(String previewServerPort) {
        String oldPreviewServerPort = this.previewServerPort;
        this.previewServerPort = previewServerPort;
        this.changeSupport.firePropertyChange("previewServerPort", oldPreviewServerPort, previewServerPort);
    }

    public boolean isCheckSpelling() {
        return this.checkSpelling;
    }

    public void setCheckSpelling(boolean checkSpelling) {
        boolean oldCheckSpelling = this.checkSpelling;
        this.checkSpelling = checkSpelling;
        this.changeSupport.firePropertyChange("checkSpelling", oldCheckSpelling, checkSpelling);
    }

    public boolean isIndexAlbumObjects() {
        return this.indexAlbumObjects;
    }

    public void setIndexAlbumObjects(boolean indexAlbumObjects) {
        boolean oldIndexAlbumObjects = this.indexAlbumObjects;
        this.indexAlbumObjects = indexAlbumObjects;
        this.changeSupport.firePropertyChange("indexAlbumObjects", oldIndexAlbumObjects, indexAlbumObjects);
    }

    public boolean isIndexMetadata() {
        return this.indexMetadata;
    }

    public void setIndexMetadata(boolean indexMetadata) {
        boolean oldIndexMetadata = this.indexMetadata;
        this.indexMetadata = indexMetadata;
        this.changeSupport.firePropertyChange("indexMetadata", oldIndexMetadata, indexMetadata);
    }

    public SimpleDateFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String pattern) {
        String oldDateFormat = this.datePattern;
        if (pattern.length() > 0) {
            try {
                this.dateFormatter = new SafeSimpleDateFormat(pattern);
                this.datePattern = pattern;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            this.dateFormatter = new SafeSimpleDateFormat(DateFormat.getDateTimeInstance());
            pattern = "";
        }
        this.changeSupport.firePropertyChange("datePattern", oldDateFormat, pattern);
    }

    public boolean isRememberLastSelectedItem() {
        return this.rememberLastSelectedItem;
    }

    public void setRememberLastSelectedItem(boolean rememberLastSelectedItem) {
        this.rememberLastSelectedItem = rememberLastSelectedItem;
    }

    public String getLocalServerURL() {
        return this.localServerURL;
    }

    public void setLocalServerURL(String localServerURL) {
        this.localServerURL = localServerURL;
    }

    public void bind(String propertyName, PropertyChangeListener pcl) {
        this.addPropertyChangeListener(propertyName, pcl);
        pcl.propertyChange(null);
    }

    public boolean isShowOpenHTMLEditorButton() {
        return this.showOpenHTMLEditorButton;
    }

    public void setShowOpenHTMLEditorButton(boolean showOpenHTMLEditorButton) {
        boolean oldShowOpenHTMLEditorButton = this.showOpenHTMLEditorButton;
        this.showOpenHTMLEditorButton = showOpenHTMLEditorButton;
        this.changeSupport.firePropertyChange("showOpenHTMLEditorButton", oldShowOpenHTMLEditorButton, showOpenHTMLEditorButton);
    }

    public NotificationLevel getBgNotifications() {
        return this.bgNotifications;
    }

    public void setBgNotifications(NotificationLevel bgNotifications) {
        this.bgNotifications = bgNotifications;
    }

    public boolean isBackgroundMode() {
        return this.backgroundMode;
    }

    public void setBackgroundMode(boolean backgroundMode) {
        boolean old = this.backgroundMode;
        this.backgroundMode = backgroundMode;
        this.changeSupport.firePropertyChange("backgroundMode", old, backgroundMode);
    }

    public boolean isCompressAudioClips() {
        return this.compressAudioClips;
    }

    public void setCompressAudioClips(boolean compressAudioClips) {
        this.compressAudioClips = compressAudioClips;
    }

    public boolean isShowWarnings() {
        return this.showWarnings;
    }

    public void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
    }

    public int getExplorerScrollSpeed() {
        return this.explorerScrollSpeed;
    }

    public void setExplorerScrollSpeed(int explorerScrollSpeed) {
        int oldSS = this.explorerScrollSpeed;
        this.explorerScrollSpeed = explorerScrollSpeed;
        this.changeSupport.firePropertyChange("explorerScrollSpeed", oldSS, explorerScrollSpeed);
    }

    public boolean isRememberWindowBounds() {
        return this.rememberWindowBounds;
    }

    public void setRememberWindowBounds(boolean rememberWindowBounds) {
        this.rememberWindowBounds = rememberWindowBounds;
    }

    public boolean isScrollToTop() {
        return this.scrollToTop;
    }

    public void setScrollToTop(boolean scrollToTop) {
        this.scrollToTop = scrollToTop;
    }

    public boolean isCustomTitleBar() {
        return this.customTitleBar;
    }

    public void setCustomTitleBar(boolean customTitleBar) {
        boolean oldCustomTitleBar = this.customTitleBar;
        this.customTitleBar = customTitleBar;
        this.changeSupport.firePropertyChange("customTitleBar", oldCustomTitleBar, customTitleBar);
    }

    public static enum AfterPublishAction {
        openPublishedAlbum,
        doNothing;


        public String toString() {
            return Msg.get("prefs." + this.name());
        }
    }

    public static enum LoggingLevel {
        off(Level.OFF),
        severe(Level.SEVERE),
        warning(Level.WARNING),
        info(Level.INFO),
        config(Level.CONFIG),
        fine(Level.FINE),
        finer(Level.FINER),
        finest(Level.FINEST),
        all(Level.ALL);

        private final Level level;

        private LoggingLevel(Level level) {
            this.level = level;
        }

        public String toString() {
            return this.level.getLocalizedName();
        }

        public Level getLevel() {
            return this.level;
        }
    }

    public static enum OutputDirectoryLocation {
        project,
        web;


        public String toString() {
            return Msg.get("outputDirectoryLocation." + this.name());
        }
    }

    public static enum LabelType {
        list("ui.list"),
        details("ui.details"),
        fileName("ui.fileName"),
        title("edit.titleLabel"),
        caption("ui.caption"),
        keywords("edit.keywords");

        private String nameKey;

        private LabelType(String nameKey) {
            this.nameKey = nameKey;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }
    }

    public static enum FileAddMethod {
        ASK("ui.ask", 1, 0x40000000),
        COPY("ui.copy", 1, 0x40000000),
        LINK("ui.link", 0x40000000, 1);

        private int dndAction;
        private int altDndAction;
        private String nameKey;

        private FileAddMethod(String nameKey, int dndAction, int altDndAction) {
            this.nameKey = nameKey;
            this.dndAction = dndAction;
            this.altDndAction = altDndAction;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }

        public int getAction() {
            return this.dndAction;
        }

        public int getAltAction() {
            return this.altDndAction;
        }
    }

    public static enum ProjectOrdering implements HasIcon
    {
        projectsByName("ui.ascending", Icons.small("sort-ascending")),
        projectsByReverseName("ui.descending", Icons.small("sort-descending")),
        projectsByUse("ui.byUse", Icons.get("sort-recent"));

        private final String nameKey;
        private final Icon icon;

        private ProjectOrdering(String nameKey, Icon icon) {
            this.nameKey = nameKey;
            this.icon = icon;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }
    }

    public static enum PreviewMode {
        integrated,
        windowed,
        external;


        public String toString() {
            return Msg.get("previewMode." + this.name());
        }
    }

    public static enum NotificationLevel {
        NORMAL,
        DISCRETE,
        OFF;


        public String toString() {
            return Msg.get("notificationLevel." + this.name().toLowerCase());
        }
    }

    public static enum ThumbnailQuality {
        NORMAL(160),
        HQ(320);

        private final Dimension bounds;

        private ThumbnailQuality(int size) {
            this.bounds = new Dimension(size, size);
        }

        public Dimension getBounds() {
            return this.bounds;
        }

        public String toString() {
            return Msg.get("thumbnailQuality." + this.name().toLowerCase(), this.bounds.width, this.bounds.height);
        }
    }

    public static enum FieldType {
        fileName("ui.fileName"),
        title("edit.titleLabel"),
        caption("ui.caption"),
        keywords("edit.keywords"),
        cameraDate("edit.cameraDateOrdering"),
        added("info.added"),
        modified("info.modified"),
        creator("edit.creator"),
        rights("edit.rights"),
        rightsURL("edit.rightsURL"),
        size("info.size"),
        dimensions("info.dim");

        private String nameKey;

        private FieldType(String nameKey) {
            this.nameKey = nameKey;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }
    }
}

