/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.jalbum.remotefs.RemoteFSException;
import net.jalbum.remotefs.RemoteFile;
import net.jalbum.resty.web.RobustResty;
import se.datadosen.component.JNotification;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.RemoteFileImpl;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.TransferProtocol;
import se.datadosen.util.IO;
import se.datadosen.util.NamedThreadFactory;

class CollaborationBean {
    private static final String INBOX_NAME = ".inbox";
    private static final String getUrl = JAlbumSite.getInstance().getIntegrationUrl() + "inbox-get";
    private static final String listUrl = JAlbumSite.getInstance().getIntegrationUrl() + "inbox-list";
    private static final String createFolderUrl = JAlbumSite.getInstance().getIntegrationUrl() + "inbox-createfolder";
    private static final String deleteUrl = JAlbumSite.getInstance().getIntegrationUrl() + "inbox-delete";
    private final RobustResty resty = new RobustResty();
    private static ScheduledExecutorService minutelyExecutor;
    private String cid;
    private String username;
    private static long lastExecutedTime;

    CollaborationBean() {
    }

    private void createFolder(String path) throws IOException {
        this.resty.xml(createFolderUrl + "?cid=" + this.cid + "&path=" + IO.urlEncode(path));
    }

    private void delete(String path) throws IOException {
        this.resty.xml(deleteUrl + "?cid=" + this.cid + "&path=" + IO.urlEncode(path));
    }

    private String list(String cid, String path) throws IOException {
        String url = listUrl + "?cid=" + cid;
        if (path != null) {
            url = url + "&path=" + IO.urlEncode(path);
        }
        return this.resty.text(url).toString();
    }

    private void getFile(String path, OutputStream out) throws IOException {
        IO.downloadFile(new URL(getUrl + "?cid=" + this.cid + "&path=" + IO.urlEncode(path)), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachInbox(AlbumObject root, AccountProfile ap) throws IOException, RemoteFSException {
        try {
            Tracer.getInstance().trace("Attach inbox");
            this.connect(ap);
            this.createFolder(root.getName());
            AlbumObjectProperties props = root.getProperties();
            props.put("inboxUserName", ap.getFtpUser());
            props.save();
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachInbox(AlbumObject root, AccountProfile ap) throws IOException, RemoteFSException {
        try {
            Tracer.getInstance().trace("Detach inbox");
            this.connect(ap);
            this.delete(root.getName());
            AlbumObjectProperties props = root.getProperties();
            props.remove("inboxUserName");
            props.save();
        }
        finally {
            this.disconnect();
        }
    }

    boolean isConnected() throws RemoteFSException {
        return this.cid != null;
    }

    void disconnect() {
        this.cid = null;
        this.username = null;
    }

    void connect(AccountProfile ap) throws RemoteFSException, IOException {
        this.cid = ap.getCid();
        this.username = ap.getFtpUser();
    }

    List<RemoteFile> listNewObjects(AccountProfile ap, AlbumObject root) throws IOException, RemoteFSException, ParseException {
        return this.getFileTree(ap, root.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fetchNewObjects(List<RemoteFile> newObjects, AlbumObject root) {
        String lastDir = "";
        int count = 0;
        System.out.println(Msg.get("ui.fetchingObjects", newObjects.size(), root.getName()));
        try {
            for (RemoteFile rf : newObjects) {
                if (JAlbum.logger.isLoggable(Level.FINEST)) {
                    System.out.println(Msg.get("ui.fetchingObject", rf.getName()));
                }
                String srcPath = IO.combinePaths(root.getName(), rf.getFullPath());
                if (!rf.isDirectory()) {
                    File dest = new File(root.getFile(), rf.getFullPath());
                    String srcDir = new File(rf.getFullPath()).getParent();
                    if (srcDir == null) {
                        srcDir = "";
                    }
                    if (!srcDir.equals(lastDir)) {
                        dest.getParentFile().mkdirs();
                    }
                    lastDir = srcDir;
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                        this.getFile(srcPath, bos);
                        IO.writeBytes(bos.toByteArray(), dest);
                        ++count;
                        this.delete(srcPath);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                try {
                    this.delete(srcPath);
                }
                catch (IOException iOException) {}
            }
            System.out.println(Msg.get("edit.doneInfo"));
            if (count <= 0) return;
        }
        catch (Throwable throwable) {
            if (count <= 0) throw throwable;
            JNotification note = new JNotification(Msg.get("note.newObjectsArrived", count, root.getName()), JNotification.Type.JALBUM);
            note.setExpiration(10);
            JAlbumContext.getInstance().getFrame().showNotification(note);
            AlbumObjectProperties props = root.getProperties();
            props.put("lastFetchedDate", new Date().getTime());
            props.save();
            throw throwable;
        }
        JNotification note = new JNotification(Msg.get("note.newObjectsArrived", count, root.getName()), JNotification.Type.JALBUM);
        note.setExpiration(10);
        JAlbumContext.getInstance().getFrame().showNotification(note);
        AlbumObjectProperties props = root.getProperties();
        props.put("lastFetchedDate", new Date().getTime());
        props.save();
    }

    private List<RemoteFile> getFileTree(AccountProfile ap, String path) throws IOException, ParseException {
        String content = this.list(ap.getCid(), path);
        LinkedList<RemoteFile> files = new LinkedList<RemoteFile>();
        Scanner sc = new Scanner(content);
        while (sc.hasNextLine() && sc.hasNext()) {
            String rights = sc.next();
            long size = sc.nextLong();
            Date date = new Date(1000L * Long.parseLong(sc.next()));
            String pathFromRoot = sc.nextLine().substring(1);
            RemoteFileImpl rf = new RemoteFileImpl(pathFromRoot, size, date.getTime());
            if (rights.charAt(0) == 'd') {
                rf.setDirectory(true);
            }
            files.add(rf);
        }
        return files;
    }

    private static List<RemoteFile> filter(List<RemoteFile> list, String startsWith) {
        return list.stream().filter(rf -> rf.getFullPath().startsWith(startsWith)).map(rf -> {
            RemoteFileImpl rf2 = new RemoteFileImpl((RemoteFile)rf);
            rf2.setFullPath(rf.getFullPath().substring(startsWith.length()));
            return rf2;
        }).collect(Collectors.toList());
    }

    public static void enablePolling(List<AlbumProject> projects) {
        CollaborationBean.disablePolling();
        minutelyExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("Inbox checker"));
        minutelyExecutor.scheduleWithFixedDelay(() -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastExecutedTime < 30000L) {
                return;
            }
            lastExecutedTime = currentTime;
            AccountProfile ap = CollaborationBean.getSignedInAccountProfile();
            CollaborationBean cb = new CollaborationBean();
            boolean connected = false;
            try {
                ArrayList projectsClone;
                List list = projects;
                synchronized (list) {
                    projectsClone = new ArrayList(projects);
                }
                long attachedCount = projectsClone.stream().filter(p -> p.getRootFolder() != null).filter(p -> p.getRootFolder().getProperties().containsKey("inboxUserName")).count();
                if (attachedCount == 0L) {
                    return;
                }
                List<RemoteFile> list2 = cb.getFileTree(ap, null);
                for (AlbumProject project : projectsClone) {
                    List<RemoteFile> filtered;
                    String inboxUserName;
                    if (minutelyExecutor.isShutdown()) {
                        return;
                    }
                    AlbumObject root = project.getRootFolder();
                    if (root == null || (inboxUserName = (String)root.getProperties().get("inboxUserName")) == null || !inboxUserName.equals(ap.getFtpUser())) continue;
                    if (JAlbum.logger.isLoggable(Level.FINE)) {
                        System.out.println(Msg.get("ui.checkingObjects", root.getName()));
                    }
                    if ((filtered = CollaborationBean.filter(list2, "/" + project.getName() + "/")).isEmpty()) continue;
                    try {
                        project.workStarted();
                        if (!connected) {
                            cb.connect(ap);
                            connected = true;
                        }
                        cb.fetchNewObjects(filtered, project.getRootFolder());
                    }
                    finally {
                        project.workDone();
                    }
                }
            }
            catch (IOException | ParseException | RemoteFSException ex) {
                JAlbum.logger.fine(ex.getMessage());
            }
            finally {
                cb.disconnect();
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    public static void disablePolling() {
        if (minutelyExecutor != null) {
            minutelyExecutor.shutdown();
            minutelyExecutor = null;
        }
    }

    private static AccountProfile getSignedInAccountProfile() {
        SignInManager mgr = SignInManager.getInstance();
        AccountProfile ap = new AccountProfile();
        ap.setProtocol(TransferProtocol.sftp);
        ap.setFtpServer(mgr.getUserName().toLowerCase() + ".jalbum.net");
        ap.setFtpPort(22);
        ap.setFtpUser(mgr.getUserName());
        ap.setFtpPassword(mgr.getPassword());
        ap.setWebRootURL("http://" + ap.getFtpUser());
        ap.setName();
        return ap;
    }
}

