/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.util.IO;

public abstract class ChainedObjects {
    protected ArrayList<AlbumObject> list = new ArrayList();
    protected Map<File, Integer> indexMap = new HashMap<File, Integer>();
    protected final AlbumBean engine;

    public ChainedObjects(AlbumBean engine) {
        this.engine = engine;
    }

    public abstract AlbumObject getPrevious(AlbumObject var1, boolean var2);

    public abstract AlbumObject getNext(AlbumObject var1, boolean var2);

    public abstract String getPreviousPath(AlbumObject var1, boolean var2);

    public abstract String getNextPath(AlbumObject var1, boolean var2);

    protected static boolean qualifies(AlbumObject ao) {
        Category cat = ao.getCategory();
        return ao.isIncluded() && !ao.isHidden() && cat != Category.webPage && cat != Category.webLocation;
    }

    protected String relativePath(AlbumObject ao, AlbumObject rel) {
        return this.relativePath(ao, rel, ObjectType.PAGE);
    }

    protected String relativePath(AlbumObject ao, AlbumObject rel, ObjectType type) {
        if (ao == null) {
            return null;
        }
        AlbumObject dst = ao;
        if (!ao.isFolder()) {
            dst = ao.getParent();
        }
        String path = IO.relativePath(dst.getPathFromRoot(), rel.getPathFromRoot());
        if (type == ObjectType.BASE) {
            return path;
        }
        if (ao.isFolder()) {
            path = IO.combinePaths(path, this.engine.getPageNamer().getIndexName(dst.getFile(), 0));
        } else {
            path = IO.combinePaths(path, this.engine.getSlideDirectory());
            switch (type.ordinal()) {
                case 1: {
                    path = IO.combinePaths(path, this.engine.getPageNamer().getSlideName(ao.getFile()));
                    break;
                }
                case 2: {
                    path = IO.combinePaths(path, this.engine.getTargetName(ao.getFile()));
                }
            }
        }
        return IO.urlEncode(path);
    }

    protected static enum ObjectType {
        BASE,
        PAGE,
        IMAGE;

    }
}

