/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.atomic.AtomicInteger;
import se.datadosen.jalbum.Category;

public class CategoryCounters {
    private AtomicInteger[] counters = new AtomicInteger[Category.values().length];
    private PropertyChangeSupport changeSupport;

    public CategoryCounters() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new AtomicInteger();
        }
    }

    public CategoryCounters(CategoryCounters original) {
        int i;
        for (i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new AtomicInteger();
        }
        for (i = 0; i < this.counters.length; ++i) {
            this.counters[i].addAndGet(original.counters[i].get());
        }
    }

    public CategoryCounters increase(Category category) {
        return this.add(category, 1);
    }

    public CategoryCounters add(Category category, int value) {
        int oldVal = this.counters[category.ordinal()].get();
        int newVal = this.counters[category.ordinal()].addAndGet(value);
        this.firePropertyChange(category.name(), oldVal, newVal);
        return this;
    }

    public CategoryCounters add(CategoryCounters cnt) {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i].addAndGet(cnt.counters[i].intValue());
        }
        return this;
    }

    public int getCount(Category category) {
        return this.counters[category.ordinal()].intValue();
    }

    public int getFileCount() {
        int total = this.getTotalCount();
        return total - this.getCount(Category.folder);
    }

    public int getTotalCount() {
        int total = 0;
        for (AtomicInteger counter : this.counters) {
            total += counter.intValue();
        }
        return total;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("CategoryCounters { ");
        for (Category cat : Category.values()) {
            buf.append((Object)cat);
            buf.append("=");
            buf.append(this.getCount(cat));
            buf.append(" ");
        }
        buf.append("}");
        return buf.toString();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(Category category, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(category.name(), listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

