/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import net.jalbum.util.Func;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JFileSelector;
import se.datadosen.component.JSmartTextField;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.JBackupFrame;
import se.datadosen.jalbum.JMultiMaker;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TypeNavigator;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.TableColumnAdjuster2;
import se.datadosen.util.WindowUtilities;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public abstract class BackupRestoreBase
extends JFrame {
    protected final String CTRL_KEY = InputEvent.getModifiersExText(Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    protected final Preferences prefs = Preferences.userNodeForPackage(BackupRestoreBase.class);
    protected static final String BACKUP_PROJECTS_KEY = "backupProjects";
    protected static final String BACKUP_DIRECTORY_KEY = "backupDirectory";
    protected static final String INCLUDE_LINKED_FILES_KEY = "includeLinkedFiles";
    JAlbumFrame window;
    JAlbumContext context = JAlbumContext.getConsoleInstance();
    protected AlbumProjectModel model;
    protected JTable table;
    protected JPopupMenu popup = new JPopupMenu();
    protected Date dialogOpenDate;
    protected AlbumProject projectAtPoint;
    protected TableRowSorter<AlbumProjectModel> sorter;
    protected JPanel buttonPanel = new JPanel(new FlowLayout(4));
    @Text(value="ui.backupDirectory")
    JLabel backupDirectoryLabel = new JLabel();
    @ToolTipText(value="ui.chooseDirectoryToolTip")
    JTextField backupDirectory = new JSmartTextField();
    @ToolTipText(value="ui.chooseDirectoryToolTip")
    JFileSelector backupDirectorySelector = new JFileSelector(this.backupDirectory);
    @Text(value="ui.includeLinkedFiles")
    JCheckBox includeLinkedFiles = new JCheckBox();
    @Icon(value="16x16/lightbulb.svg")
    JLabel prompt = new JLabel(Msg.get(this instanceof JBackupFrame ? "ui.backupPrompt" : "ui.restorePrompt", this.CTRL_KEY));
    @Text(value="edit.open")
    Action openBackupDirectoryAction = new LambdaAction(ae -> {
        try {
            Desktop.getDesktop().open(new File(this.backupDirectory.getText()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    });
    @Text(value="close")
    Action closeAction = new LambdaAction(ae -> {
        this.setVisible(false);
        this.handleClose();
    });
    JButton openBackupDirectoryButton = new JButton(this.openBackupDirectoryAction);
    JButton closeButton = new JButton(this.closeAction);
    @Text(value="ui.openProject")
    Action openProjectAction = new LambdaAction(ae -> {
        AlbumProject ap = this.projectAtPoint;
        this.window.loadProject(ap.getProjectFile());
        this.window.toFront();
    });
    @Text(value="ui.viewAlbumToolTip")
    Action viewLocalAlbumAction = new LambdaAction(ae -> {
        try {
            AlbumProject ap = this.projectAtPoint;
            AlbumBean tempEngine = new AlbumBean();
            tempEngine.setProperties(ap.getProperties());
            File outputDir = tempEngine.getOutputDir();
            this.window.openInBrowser(ap, outputDir.toURI().toURL(), null);
        }
        catch (IOException ex) {
            Logger.getLogger(JMultiMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
    });
    boolean firstOpen = true;
    protected final DefaultTableCellRenderer albumProjectRenderer = new DefaultTableCellRenderer(){
        private final ImageIcon newAlbumProjectIcon = Icons.getIcon("big.newAlbumProject");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            AlbumProject ap = (AlbumProject)value;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, ap.getName(), isSelected, hasFocus, row, column);
            label.setIcon(ap.icon != null ? ap.icon : this.newAlbumProjectIcon);
            ap.forIcon((icon, cached) -> {
                label.setIcon((javax.swing.Icon)icon);
                if (!cached.booleanValue()) {
                    BackupRestoreBase.this.model.fireTableCellUpdated(row, column);
                }
            });
            return label;
        }
    };
    private final DefaultTableCellRenderer dateCellRenderer = new DefaultTableCellRenderer(){
        private final JLabel label = new JLabel();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel template = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                Date date = (Date)value;
                this.label.setText(date.getTime() != 0L ? BackupRestoreBase.formatDate(date) : "");
                this.label.setOpaque(template.isOpaque());
                this.label.setForeground(template.getForeground());
                this.label.setBackground(template.getBackground());
                this.label.setBorder(null);
                if (date.after(BackupRestoreBase.this.dialogOpenDate)) {
                    this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(Color.green.darker())));
                    this.label.setForeground(Color.green.darker());
                }
            }
            return this.label;
        }
    };

    protected void updateTable(AlbumProject ap) {
        int row = this.model.getProjectIndex(ap);
        if (row != -1) {
            this.model.fireTableRowsUpdated(row, row);
        }
    }

    protected void init() {
        this.dialogOpenDate = new Date();
        this.setIconImages(JAlbumFrameIcons.getInstance().getWindowIcons());
        this.model = new AlbumProjectModel(new ArrayList<AlbumProject>());
        this.table = new JTable(this.model){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(super.getPreferredSize().width, super.getPreferredScrollableViewportSize().height);
            }
        };
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        this.sorter = new TableRowSorter<AlbumProjectModel>(this.model);
        this.sorter.setComparator(0, (p1, p2) -> p1.getName().compareToIgnoreCase(p2.getName()));
        this.table.setRowSorter(this.sorter);
        this.table.setRowHeight(AlbumProject.iconSize.height + 2);
        this.table.setSelectionMode(2);
        TypeNavigator typeNavigator = new TypeNavigator(this.table){

            @Override
            public String getFocusedName() {
                int selectedRow = BackupRestoreBase.this.table.getSelectedRow();
                return selectedRow != -1 ? BackupRestoreBase.this.model.getProject(BackupRestoreBase.this.table.convertRowIndexToModel(selectedRow)).getName() : null;
            }

            @Override
            public void focusNextMatching(String prefix) {
                int i;
                int selectedRow = BackupRestoreBase.this.table.getSelectedRow();
                if (selectedRow == -1) {
                    selectedRow = 0;
                }
                for (i = selectedRow + 1; i < BackupRestoreBase.this.model.getRowCount(); ++i) {
                    if (!this.isMatch(BackupRestoreBase.this.model.getProject(BackupRestoreBase.this.table.convertRowIndexToModel(i)).getName())) continue;
                    BackupRestoreBase.this.table.getSelectionModel().setSelectionInterval(i, i);
                    BackupRestoreBase.this.table.scrollRectToVisible(BackupRestoreBase.this.table.getCellRect(i, 0, true));
                    return;
                }
                for (i = 0; i < selectedRow - 1; ++i) {
                    if (!this.isMatch(BackupRestoreBase.this.model.getProject(BackupRestoreBase.this.table.convertRowIndexToModel(i)).getName())) continue;
                    BackupRestoreBase.this.table.getSelectionModel().setSelectionInterval(i, i);
                    BackupRestoreBase.this.table.scrollRectToVisible(BackupRestoreBase.this.table.getCellRect(i, 0, true));
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        };
        this.popup.add(this.openProjectAction);
        this.popup.add(this.viewLocalAlbumAction);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(() -> {
                    int rowAtPoint = BackupRestoreBase.this.table.rowAtPoint(SwingUtilities.convertPoint(BackupRestoreBase.this.popup, new Point(0, 0), BackupRestoreBase.this.table));
                    if (rowAtPoint > -1) {
                        BackupRestoreBase.this.projectAtPoint = BackupRestoreBase.this.model.getProject(BackupRestoreBase.this.table.convertRowIndexToModel(rowAtPoint));
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.table.setComponentPopupMenu(this.popup);
        for (int colIndex = 0; colIndex < this.model.cols.length; ++colIndex) {
            TableColumn column = this.table.getColumnModel().getColumn(colIndex);
            if (this.model.cols[colIndex].renderer != null) {
                column.setCellRenderer(this.model.cols[colIndex].renderer);
            }
            if (this.model.cols[colIndex].minWidth <= 0) continue;
            column.setMinWidth(this.model.cols[colIndex].minWidth);
        }
        TableColumnAdjuster2.adjustColumnWidths(this.table);
        File defBackupDirectory = new File(System.getProperty("user.home"), "jAlbum-backup");
        this.backupDirectory.setText(this.prefs.get(BACKUP_DIRECTORY_KEY, defBackupDirectory.getAbsolutePath()));
        this.backupDirectorySelector.setDirectories(true);
        this.includeLinkedFiles.setSelected(this.prefs.getBoolean(INCLUDE_LINKED_FILES_KEY, true));
        JComponent content = (JComponent)this.getContentPane();
        content.setBorder(BorderFactory.createEmptyBorder(12, 12, 8, 12));
        ControlPanel controls = new ControlPanel();
        this.prompt.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        controls.add("br", this.backupDirectoryLabel);
        controls.add("tab hfill", this.backupDirectory);
        controls.add(this.backupDirectorySelector);
        controls.add(this.openBackupDirectoryButton);
        controls.add("br", this.includeLinkedFiles);
        this.addAdditionalControls(controls);
        controls.add("p", this.prompt);
        controls.add("br hfill vfill", new JScrollPane(this.table));
        content.add((Component)controls, "Center");
        content.add((Component)this.buttonPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BackupRestoreBase.this.setVisible(false);
                BackupRestoreBase.this.handleClose();
            }
        });
        this.loadSelection();
        this.getLayeredPane().registerKeyboardAction(this.context.getFrame().actions.showConsoleWindowAction, "showConsole", KeyStroke.getKeyStroke(118, 0), 2);
    }

    private void loadSelection() {
        try {
            HashSet<String> selected = new HashSet<String>(Arrays.asList(this.prefs.node(BACKUP_PROJECTS_KEY).keys()));
            ListSelectionModel selModel = this.table.getSelectionModel();
            selModel.clearSelection();
            for (int i = 0; i < this.model.projects.size(); ++i) {
                AlbumProject ap = this.model.getProject(i);
                if (!selected.contains(ap.getName())) continue;
                int viewIndex = this.table.convertRowIndexToView(i);
                this.table.getSelectionModel().addSelectionInterval(viewIndex, viewIndex);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(JMultiMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.dialogOpenDate = new Date();
        }
        super.setVisible(visible);
        this.table.requestFocusInWindow();
    }

    protected void addAdditionalControls(ControlPanel controls) {
    }

    private static String formatDate(Date date) {
        return date != null ? Config.getConfig().getDateFormatter().format(date) : "";
    }

    private void handleClose() {
        try {
            this.prefs.put(BACKUP_DIRECTORY_KEY, this.backupDirectory.getText());
            this.prefs.putBoolean(INCLUDE_LINKED_FILES_KEY, this.includeLinkedFiles.isSelected());
            Preferences node = this.prefs.node(BACKUP_PROJECTS_KEY);
            node.clear();
            for (AlbumProject ap : this.getSelectedProjects()) {
                node.putBoolean(ap.getName(), true);
            }
            WindowUtilities.saveBounds(this);
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(JMultiMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    List<AlbumProject> getSelectedProjects() {
        ArrayList<AlbumProject> selectedProjects = new ArrayList<AlbumProject>();
        for (int index : this.table.getSelectedRows()) {
            selectedProjects.add(this.model.getProject(this.table.convertRowIndexToModel(index)));
        }
        return selectedProjects;
    }

    public BackupRestoreBase(String title, JAlbumContext context) {
        super(title);
        this.window = context.getFrame();
        this.context = context;
    }

    public class AlbumProjectModel
    extends AbstractTableModel {
        protected List<AlbumProject> projects;
        private final Column[] cols;

        public AlbumProjectModel(List<AlbumProject> projects) {
            this.cols = new Column[]{new Column<AlbumProject>(Msg.get("edit.name"), AlbumProject.class, ap -> ap).renderer(BackupRestoreBase.this.albumProjectRenderer).minWidth(200), new Column<String>(Msg.get("ui.location"), String.class, ap -> ap.getRootFolder().getFile().getParentFile().getAbsolutePath()).minWidth(300), new Column<Date>(Msg.get("ui.lastMade"), Date.class, ap -> new Date(ap.getRootFolder().getProperties().get("lastMadeDate", 0L))).renderer(BackupRestoreBase.this.dateCellRenderer).minWidth(190), new Column<Date>(Msg.get("ui.lastBackup"), Date.class, ap -> new Date(ap.getRootFolder().getProperties().get("lastBackupDate", 0L))).renderer(BackupRestoreBase.this.dateCellRenderer).minWidth(190)};
            this.projects = projects;
        }

        int getProjectIndex(AlbumProject project) {
            int i = 0;
            for (AlbumProject ap : this.projects) {
                if (ap.equals(project)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getRowCount() {
            return this.projects.size();
        }

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cols[column].name;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.cols[columnIndex].type;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                AlbumProject ap = this.projects.get(rowIndex);
                Object val = this.cols[columnIndex].getter.apply(ap);
                if (val == null) {
                    val = "";
                }
                return val;
            }
            catch (Exception ex) {
                Logger.getLogger(JMultiMaker.class.getName()).log(Level.SEVERE, null, ex);
                return "";
            }
        }

        public AlbumProject getProject(int rowIndex) {
            return this.projects.get(rowIndex);
        }

        public void addProject(AlbumProject row) {
            int index = this.projects.size();
            this.projects.add(row);
            this.fireTableRowsInserted(index, index);
        }

        public void clear() {
            this.projects.clear();
            this.fireTableDataChanged();
        }

        private void removeProject(AlbumProject row) {
            int rowIndex;
            if (row != null && (rowIndex = this.getProjectIndex(row)) >= 0) {
                this.projects.remove(rowIndex);
                this.fireTableRowsDeleted(rowIndex, rowIndex);
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            AlbumProject ap = this.projects.get(rowIndex);
            this.cols[columnIndex].setter.accept(ap, (AlbumProject)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void setData(List<AlbumProject> data) {
            this.projects = data;
            this.fireTableDataChanged();
            BackupRestoreBase.this.sorter.allRowsChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.cols[columnIndex].isEditable();
        }
    }

    protected static class Column<T> {
        String name;
        String toolTip;
        Class<T> type;
        Func<AlbumProject, T> getter;
        BiConsumer<AlbumProject, T> setter;
        TableCellRenderer renderer;
        int minWidth = 0;

        public Column(String name, Class<T> type, Func<AlbumProject, T> getter) {
            this.name = name;
            this.type = type;
            this.getter = getter;
        }

        public Column renderer(TableCellRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public boolean isEditable() {
            return this.setter != null;
        }

        public Column setter(BiConsumer<AlbumProject, T> setter) {
            this.setter = setter;
            return this;
        }

        public Column toolRip(String toolTip) {
            this.toolTip = toolTip;
            return this;
        }

        public Column minWidth(int minWidth) {
            this.minWidth = minWidth;
            return this;
        }
    }
}

