/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.IOException;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.util.IO;

public class AlbumObjectOrderer {
    private static final String ORDERING_KEY = "ordering";
    private static final String REVERSE_ORDERING_KEY = "reverseOrdering";
    private static final String FOLDERS_FIRST_KEY = "foldersFirst";
    private static final String FOLDER_ORDERING_KEY = "folderOrdering";
    private static final String REVERSE_FOLDER_ORDERING_KEY = "reverseFolderOrdering";
    private AlbumObjectImpl currentFolder;
    private AlbumObject.Ordering ordering = null;
    private AlbumObject.Ordering folderOrdering = AlbumObject.Ordering.date;
    private boolean foldersFirst;
    private boolean reverseOrdering;
    private boolean reverseFolderOrdering;

    public AlbumObjectOrderer(AlbumObjectImpl currentFolder) {
        this.currentFolder = currentFolder;
    }

    public AlbumObject.Ordering getFolderOrdering() {
        this.readProperties();
        return this.folderOrdering;
    }

    public void setFolderOrdering(AlbumObject.Ordering folderOrdering) throws IOException {
        this.folderOrdering = folderOrdering;
        this.writeProperties();
    }

    public boolean isFoldersFirst() {
        this.readProperties();
        return this.foldersFirst;
    }

    public void setFoldersFirst(boolean foldersFirst) throws IOException {
        this.foldersFirst = foldersFirst;
        this.writeProperties();
    }

    public AlbumObject.Ordering getOrdering() {
        this.readProperties();
        return this.ordering;
    }

    public void setOrdering(AlbumObject.Ordering ordering) throws IOException {
        this.ordering = ordering;
        this.writeProperties();
    }

    public boolean isReverseFolderOrdering() {
        this.readProperties();
        return this.reverseFolderOrdering;
    }

    public void setReverseFolderOrdering(boolean reverseFolderOrdering) throws IOException {
        this.reverseFolderOrdering = reverseFolderOrdering;
        this.writeProperties();
    }

    public boolean isReverseOrdering() {
        this.readProperties();
        return this.reverseOrdering;
    }

    public void setReverseOrdering(boolean reverseOrdering) throws IOException {
        this.reverseOrdering = reverseOrdering;
        this.writeProperties();
    }

    private AlbumBean getEngine() {
        return this.currentFolder.factory.engine;
    }

    private void readProperties() {
        if (this.ordering == null) {
            Map props = this.getFolderProperties();
            this.ordering = props.containsKey(ORDERING_KEY) ? AlbumObject.Ordering.valueOf((String)props.get(ORDERING_KEY)) : AlbumObject.Ordering.jalbum;
            String s = (String)props.get(FOLDER_ORDERING_KEY);
            if (s != null) {
                this.folderOrdering = AlbumObject.Ordering.valueOf(s);
            }
            this.foldersFirst = this.isTrue(FOLDERS_FIRST_KEY, props);
            this.reverseOrdering = this.isTrue(REVERSE_ORDERING_KEY, props);
            this.reverseFolderOrdering = this.isTrue(REVERSE_FOLDER_ORDERING_KEY, props);
        }
    }

    private void writeProperties() throws IOException {
        Map props = this.getFolderProperties();
        props.put(ORDERING_KEY, this.ordering.name());
        if (this.reverseOrdering) {
            props.put(REVERSE_ORDERING_KEY, "" + this.reverseOrdering);
        } else {
            props.remove(REVERSE_ORDERING_KEY);
        }
        if (this.foldersFirst) {
            props.put(FOLDERS_FIRST_KEY, "" + this.foldersFirst);
            props.put(FOLDER_ORDERING_KEY, this.folderOrdering.name());
            props.put(REVERSE_FOLDER_ORDERING_KEY, "" + this.reverseFolderOrdering);
        } else {
            props.remove(FOLDERS_FIRST_KEY);
        }
        this.setFolderProperties(props);
    }

    private boolean isTrue(String key, Map props) {
        return "true".equals(props.get(key));
    }

    private Map getFolderProperties() {
        try {
            return this.currentFolder.getFolderProperties();
        }
        catch (IOException ex) {
            return new HashMap();
        }
    }

    private void setFolderProperties(Map properties) throws IOException {
        this.currentFolder.setFolderProperties(properties);
    }

    private AlbumObject.Ordering toOrdering(String jAlbumOrdering) {
        switch (jAlbumOrdering) {
            case "OrderByDate": {
                return AlbumObject.Ordering.date;
            }
            case "OrderByAddedDate": {
                return AlbumObject.Ordering.addedDate;
            }
            case "OrderByCameraDate": {
                return AlbumObject.Ordering.cameraDate;
            }
            case "OrderByName": {
                return AlbumObject.Ordering.name;
            }
        }
        return AlbumObject.Ordering.simpleName;
    }

    public List<AlbumObject> sort(List<AlbumObject> objects) {
        ArrayList<AlbumObject> list = new ArrayList<AlbumObject>();
        AlbumObject[] arr = (AlbumObject[])objects.toArray(AlbumObject[]::new);
        list.addAll(Arrays.asList(this.sort(arr)));
        return list;
    }

    public AlbumObject[] sort(AlbumObject[] objects) {
        this.readProperties();
        if (this.getOrdering() == AlbumObject.Ordering.jalbum) {
            AlbumObject.Ordering imageOrdering = this.toOrdering(this.getEngine().getImageOrdering());
            boolean reverseOrder = this.getEngine().isReverseOrder();
            boolean directoriesFirst = this.getEngine().isDirectoriesFirst();
            Comparator customImageOrdering = this.getEngine().getCustomImageOrdering();
            CustomComparator fileComparator = customImageOrdering != null ? new CustomComparator(customImageOrdering) : AlbumObjectOrderer.getComparator(imageOrdering, reverseOrder);
            AlbumObjectOrderer.sort2(objects, fileComparator, directoriesFirst ? new NaturalOrderComparator(false) : null);
        } else if (this.getOrdering() != AlbumObject.Ordering.custom) {
            Comparator<AlbumObject> fileComparator = AlbumObjectOrderer.getComparator(this.getOrdering(), this.isReverseOrdering());
            Comparator<AlbumObject> directoryComparator = null;
            if (this.isFoldersFirst()) {
                directoryComparator = AlbumObjectOrderer.getComparator(this.getFolderOrdering(), this.isReverseFolderOrdering());
            }
            AlbumObjectOrderer.sort2(objects, fileComparator, directoryComparator);
        }
        return objects;
    }

    private static AlbumObject[] sort2(AlbumObject[] objects, Comparator<AlbumObject> objectComparator, Comparator folderComparator) {
        int i;
        if (folderComparator == null) {
            Arrays.sort(objects, objectComparator);
            return objects;
        }
        Arrays.sort(objects, AlbumObject.Ordering.foldersFirst.getComparator());
        for (i = 0; i < objects.length && objects[i].isFolder(); ++i) {
        }
        Arrays.sort(objects, 0, i, folderComparator);
        Arrays.sort(objects, i, objects.length, objectComparator);
        return objects;
    }

    static Comparator<AlbumObject> getComparator(AlbumObject.Ordering ordering, boolean reverse) {
        switch (ordering) {
            case date: {
                return new LastModifiedDateComparator(reverse);
            }
            case name: {
                return new NaturalOrderComparator(reverse);
            }
            case cameraDate: {
                return new CameraDateComparator(reverse);
            }
            case addedDate: {
                return new AddedDateComparator(reverse);
            }
            case rating: {
                return new RatingComparator(reverse);
            }
            case title: {
                return new TitleComparator(reverse);
            }
            case comment: {
                return new CommentComparator(reverse);
            }
            case category: {
                return new CategoryComparator(reverse);
            }
            case extension: {
                return new FileExtentionComparator(reverse);
            }
            case foldersFirst: {
                return new FoldersFirstComparator(reverse);
            }
        }
        return new SimpleFileNameComparator(reverse);
    }

    private static String get(String s1, String s2) {
        return s1.length() > 0 ? s1 : s2;
    }

    private static class CustomComparator
    implements Comparator<AlbumObject> {
        Comparator fileComparator;

        public CustomComparator(Comparator fileComparator) {
            this.fileComparator = fileComparator;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            return this.fileComparator.compare(o1.getFile(), o2.getFile());
        }
    }

    private static class NaturalOrderComparator
    implements Comparator<AlbumObject> {
        private final boolean reverse;
        private final Collator collator;

        public NaturalOrderComparator() {
            this(false, Locale.getDefault());
        }

        public NaturalOrderComparator(boolean reverse) {
            this(reverse, Locale.getDefault());
        }

        public NaturalOrderComparator(boolean reverse, Locale locale) {
            this.reverse = reverse;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(0);
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            Chunk chunkB;
            Chunk chunkA;
            String a = o1.getName();
            String b = o2.getName();
            int idxA = 0;
            int lenA = a.length();
            int lenB = b.length();
            for (int idxB = 0; idxA < lenA && idxB < lenB; idxA += chunkA.length, idxB += chunkB.length) {
                chunkA = this.nextChunk(a, idxA);
                chunkB = this.nextChunk(b, idxB);
                int typeCmp = Integer.compare(chunkA.type, chunkB.type);
                if (typeCmp != 0) {
                    return this.reverse ? -typeCmp : typeCmp;
                }
                int cmp = switch (chunkA.type) {
                    case 0 -> this.compareCodepoint(chunkA.value, chunkB.value);
                    case 1 -> new BigInteger(chunkA.value).compareTo(new BigInteger(chunkB.value));
                    case 2 -> this.collator.compare(chunkA.value, chunkB.value);
                    default -> 0;
                };
                if (cmp == 0) continue;
                return this.reverse ? -cmp : cmp;
            }
            return this.reverse ? Integer.compare(lenB, lenA) : Integer.compare(lenA, lenB);
        }

        private int compareCodepoint(String s1, String s2) {
            int len1 = s1.length();
            int len2 = s2.length();
            int lim = Math.min(len1, len2);
            for (int i = 0; i < lim; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i))) continue;
                return Integer.compare(c1, c2);
            }
            return Integer.compare(len2, len1);
        }

        private Chunk nextChunk(String s, int index) {
            int len = s.length();
            if (index >= len) {
                return new Chunk("", 2, 0);
            }
            char c = s.charAt(index);
            int start = index;
            int type = this.charType(c);
            while (index < len && this.charType(s.charAt(index)) == type) {
                ++index;
            }
            return new Chunk(s.substring(start, index), type, index - start);
        }

        private int charType(char c) {
            if (!Character.isLetterOrDigit(c)) {
                return 0;
            }
            if (Character.isDigit(c)) {
                return 1;
            }
            return 2;
        }

        private static class Chunk {
            final String value;
            final int type;
            final int length;

            Chunk(String value, int type, int length) {
                this.value = value;
                this.type = type;
                this.length = length;
            }
        }
    }

    private static class LastModifiedDateComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public LastModifiedDateComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            long diff = o1.getFile().lastModified() - o2.getFile().lastModified();
            if (diff < 0L) {
                diff = -1L;
            }
            if (diff > 0L) {
                diff = 1L;
            }
            if (this.reverseOrder) {
                diff = -diff;
            }
            return (int)diff;
        }
    }

    private static class CameraDateComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public CameraDateComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            long diff;
            long d1 = o1.getCameraDate();
            long d2 = o2.getCameraDate();
            if (d1 == 0L) {
                d1 = o1.getLastModified();
            }
            if (d2 == 0L) {
                d2 = o2.getLastModified();
            }
            if ((diff = d1 - d2) < 0L) {
                diff = -1L;
            }
            if (diff > 0L) {
                diff = 1L;
            }
            if (this.reverseOrder) {
                diff = -diff;
            }
            return (int)diff;
        }
    }

    private static class AddedDateComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public AddedDateComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            long diff = o1.getWhenAdded() - o2.getWhenAdded();
            if (diff < 0L) {
                diff = -1L;
            }
            if (diff > 0L) {
                diff = 1L;
            }
            if (this.reverseOrder) {
                diff = -diff;
            }
            return (int)diff;
        }
    }

    private static class RatingComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public RatingComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = o1.getRating() - o2.getRating();
            return this.reverseOrder ? diff : -diff;
        }
    }

    private static class TitleComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public TitleComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = AlbumObjectOrderer.get(o1.getTitle(), o1.getName()).compareToIgnoreCase(AlbumObjectOrderer.get(o2.getTitle(), o2.getName()));
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }

    private static class CommentComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public CommentComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = AlbumObjectOrderer.get(o1.getComment(), o1.getName()).compareToIgnoreCase(AlbumObjectOrderer.get(o2.getComment(), o2.getName()));
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }

    private static class CategoryComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public CategoryComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = (o1.getCategory().toString() + IO.extensionOf(o1.getName()) + o1.getName()).compareToIgnoreCase(o2.getCategory().toString() + IO.extensionOf(o2.getName()) + o2.getName());
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }

    private static class FileExtentionComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public FileExtentionComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = IO.extensionOf(o1.getName()).compareToIgnoreCase(IO.extensionOf(o2.getName()));
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }

    private static class FoldersFirstComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public FoldersFirstComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = 0;
            if (o1.isFolder()) {
                --diff;
            }
            if (o2.isFolder()) {
                ++diff;
            }
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }

    private static class SimpleFileNameComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public SimpleFileNameComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = o1.getName().compareToIgnoreCase(o2.getName());
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }
}

