/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.mov.QuickTimeDirectory;
import com.drew.metadata.mp4.Mp4Directory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import se.datadosen.imaging.exif.ImageInfoFormatter;

public class AlbumObjectMetadata
implements Serializable {
    Metadata metadata;
    long cameraDate;
    private long realCameraDate;

    public static AlbumObjectMetadata getInstance(File f) throws IOException {
        return new AlbumObjectMetadata(f);
    }

    private AlbumObjectMetadata(File f) throws IOException {
        if (!f.isDirectory()) {
            block6: {
                try {
                    this.metadata = ImageMetadataReader.readMetadata((File)f);
                    Date cd = this.getCameraDate(this.metadata);
                    if (cd != null) {
                        this.cameraDate = this.realCameraDate = cd.getTime();
                    }
                }
                catch (ImageProcessingException | FileNotFoundException cd) {
                }
                catch (IOException | RuntimeException ex) {
                    if (!f.exists()) break block6;
                    System.err.println("For file " + f.getAbsolutePath());
                    ex.printStackTrace(System.err);
                }
            }
            if (this.cameraDate == 0L) {
                this.cameraDate = f.lastModified();
            }
        }
    }

    public long getCameraDate() {
        return this.cameraDate;
    }

    public long getRealCameraDate() {
        return this.realCameraDate;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private Date getCameraDate(Metadata metadata) {
        Directory dir = metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
        if (dir != null) {
            String sDate = dir.getString(36867);
            if (sDate != null) {
                return ImageInfoFormatter.parseExifDate(sDate);
            }
        } else {
            dir = metadata.getFirstDirectoryOfType(Mp4Directory.class);
            if (dir != null) {
                return dir.getDate(256);
            }
            dir = metadata.getFirstDirectoryOfType(QuickTimeDirectory.class);
            if (dir != null) {
                return dir.getDate(256);
            }
        }
        return null;
    }
}

