/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.internal.xmp.XMPException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.sun.jna.platform.FileUtils;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.script.ScriptException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterPipeline;
import net.jalbum.filters.CropFilter;
import net.jalbum.jlibraw.RAWImageReadParam;
import net.jalbum.undo.UndoRedoException;
import net.jalbum.undo.UndoableDeleteEdit;
import net.jalbum.undo.UndoableMoveEdit;
import net.jalbum.undo.UndoableNamedEdit;
import net.jalbum.util.MutableSoft;
import net.jalbum.util.Profiler;
import net.jalbum.views.View;
import org.netbeans.editor.WeakPropertyChangeSupport;
import se.datadosen.io.Cached;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.AlbumObjectOrderer;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.ControlFiles;
import se.datadosen.jalbum.DeleteOption;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.GenericRotationSupport;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.ImageRenderer;
import se.datadosen.jalbum.IncludeOption;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.jalbum.TreeCollection;
import se.datadosen.jalbum.VideoProcessor;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.WebLocation;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.FileFilters;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.IO;
import se.datadosen.util.JPEGUtil;
import se.datadosen.util.Orientation;
import se.datadosen.util.Scope;

public abstract class AlbumObjectImpl
implements AlbumObject,
Serializable {
    public static final String WEBLOCATION_EXTENSION = ".webloc";
    private Future delayedChildrenWrite;
    public static final String ALBUMFILES_FILE_NAME = "albumfiles.txt";
    public static final String JALBUM_FOLDER_NAME = ".jalbum";
    public static final String SKIN_TEMPLATES_DIR = "$SKIN_TEMPLATES_DIR";
    public static final String CACHE_FOLDER = "cache";
    private static final Icon brokenLinkIcon = Icons.get("broken_link");
    private static final Icon brokenImageIcon = Icons.get("broken_image");
    private static final Icon brokenViewIcon = Icons.get("cancel-1", 96);
    private static final DataFlavor[] flavors = new DataFlavor[]{AlbumObject.albumObjectFlavor, DataFlavor.javaFileListFlavor};
    private static final Pattern keywordSeparator = Pattern.compile(",\\s?");
    transient AlbumObjectFactory factory;
    protected transient AlbumObject parent;
    File file;
    private Boolean isFolder;
    long whenAdded;
    Long cameraDate;
    String webSafeName;
    transient Category category;
    private transient Orientation orientation;
    String comment = null;
    private long lastRefreshed;
    boolean included = true;
    private transient SoftReference<AlbumObjectMetadata> albumObjectMetadata;
    final transient MutableSoft<AlbumObjectProperties> properties = new MutableSoft<Object>(null);
    transient SoftReference<XmpManager> xmpProperties;
    final transient MutableSoft<Attachments> attachments = new MutableSoft<Object>(null);
    private transient SoftReference<Map<String, String>> commentsCache;
    private transient Map folderProperties;
    private AlbumObject representingAlbumObject;
    protected WeakPropertyChangeSupport changeSupport;
    transient AlbumObjectOrderer orderer;
    protected transient ThumbCache thumbCache = new ThumbCache();
    private transient Scope vars;
    private transient FileFilters.BasicImageInfo imageInfo;
    private transient Map<File, File> fileCache;
    private transient SoftReference<ImageRenderer> imageRenderer;
    private static final File NO_FILE = new File("");
    private transient PropertyChangeListener propertyChangeListener;

    private static String normalizeKeywords(String keywords) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String kw : keywordSeparator.split(keywords)) {
            if (kw.length() <= 0) continue;
            sb.append(sep);
            sb.append(kw);
            sep = ", ";
        }
        return sb.toString();
    }

    private void writeChildrenOnIdle() {
        if (this.delayedChildrenWrite != null) {
            this.delayedChildrenWrite.cancel(false);
        }
        this.delayedChildrenWrite = JAlbumUtilities.schedule(() -> {
            try {
                JAlbum.logger.fine("Updating camera date cache for " + this.getName());
                this.setChildren(this.getChildren());
            }
            catch (IOException ex) {
                Logger.getLogger(AlbumObjectImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }, 3000L, TimeUnit.MILLISECONDS);
    }

    protected void setRep(AlbumObject rep) {
        if (rep == this) {
            throw new IllegalArgumentException("Assign representing object to itself");
        }
        this.representingAlbumObject = rep;
    }

    protected AlbumObject getRep() {
        return this.representingAlbumObject;
    }

    private synchronized File getCachedVersion(File f) {
        if (!this.factory.isCached()) {
            return f;
        }
        if (!this.isFolder()) {
            AlbumObjectImpl folder = (AlbumObjectImpl)this.getParent();
            if (folder != null) {
                return folder.getCachedVersion(f);
            }
            return f;
        }
        if (this.fileCache == null) {
            this.fileCache = new HashMap<File, File>();
            File jAlbumFolder = new File(this.file, JALBUM_FOLDER_NAME);
            CachedFile[] files = CachedFile.listFiles(jAlbumFolder);
            if (files != null) {
                for (CachedFile cached : files) {
                    this.fileCache.put(cached, cached);
                }
            }
        }
        return this.fileCache.get(f);
    }

    @Override
    public ImageRenderer getRenderer() {
        ImageRenderer ir;
        ImageRenderer imageRenderer = ir = this.imageRenderer != null ? this.imageRenderer.get() : null;
        if (ir == null) {
            ir = new ImageRenderer(this);
            this.imageRenderer = new SoftReference<ImageRenderer>(ir);
        }
        return ir;
    }

    @Override
    public void invalidate() {
        this.albumObjectMetadata = null;
        this.commentsCache = null;
        this.imageRenderer = null;
        this.representingAlbumObject = null;
    }

    public void invalidateVars() {
        this.imageRenderer = null;
        this.setVars(null);
    }

    private BufferedImage ensureMinimumSize(BufferedImage old, Dimension minSize) {
        if (old.getWidth() >= minSize.width && old.getHeight() >= minSize.height) {
            return old;
        }
        BufferedImage im = new BufferedImage(Math.max(minSize.width, old.getWidth()), Math.max(minSize.height, old.getHeight()), 2);
        Graphics2D g = im.createGraphics();
        g.drawImage((Image)old, (im.getWidth() - old.getWidth()) / 2, (im.getHeight() - old.getHeight()) / 2, null);
        g.dispose();
        return im;
    }

    protected AlbumObjectImpl(File file, AlbumObject parent, AlbumObjectFactory factory) {
        this.parent = parent;
        this.factory = factory;
        this.setFile(file);
        if (this.isFolder()) {
            this.orderer = new AlbumObjectOrderer(this);
        }
    }

    private void setFile(File f) {
        String safe;
        this.file = f;
        this.isFolder = f.isDirectory();
        if (!this.factory.isCached() && this.isFolder.booleanValue() && f instanceof Cached) {
            ((Cached)((Object)f)).setCacheing(false);
        }
        this.webSafeName = !(safe = IO.webSafe(this.file.getName())).equals(this.file.getName()) ? safe : null;
    }

    private static boolean exists(String s) {
        return s != null && s.trim().length() > 0;
    }

    protected abstract Map<String, AlbumObject> getNameMap();

    @Override
    public FileFilters.BasicImageInfo getImageInfo() throws IOException {
        if (this.imageInfo == null) {
            File rep = this.getRepresentingImageFile();
            if (rep == null) {
                rep = FileFilters.getIconFor(this.file, this.getEngine());
            }
            if (rep != null) {
                this.imageInfo = FileFilters.getBasicImageInfo(rep);
            }
        }
        return this.imageInfo;
    }

    @Override
    public Dimension getSize() throws IOException {
        return this.getSize(false);
    }

    @Override
    public Dimension getSize(boolean filteredSize) throws IOException {
        FileFilters.BasicImageInfo ii = this.getImageInfo();
        if (ii != null) {
            FilterList fl;
            Orientation o = this.getOrientation();
            Dimension dim = o.isRotated() ? new Dimension(ii.getSize().height, ii.getSize().width) : ii.getSize();
            if (filteredSize && (fl = (FilterList)this.getProperties().get("filterList")) != null) {
                FilterPipeline pipeline = new FilterPipeline(fl);
                dim = pipeline.getPrescaleFilteredSize(dim);
                dim = pipeline.getPostscaleFilteredSize(dim);
            }
            return dim;
        }
        return null;
    }

    @Override
    public TreeCollection getDescendants() {
        return new TreeCollection(this);
    }

    @Override
    public int compareTo(AlbumObject o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public TreeCollection getDescendants(IncludeOption opt, IncludeOption ... opts) {
        EnumSet<IncludeOption[]> optSet = EnumSet.of(opt, opts);
        return new TreeCollection(this, optSet);
    }

    @Override
    public final AlbumObject getRepresentingAlbumObject() {
        if (this.representingAlbumObject == null) {
            this.getRepObject(this.factory.engine.isUseThumbForFolderIcon());
        }
        return this.representingAlbumObject;
    }

    @Override
    public AlbumObject getRepresentingAlbumObject(boolean force) {
        return this.getRepObject(force);
    }

    public AlbumObjectImpl getRepObject(boolean force) {
        if (this.representingAlbumObject == null) {
            return this.getRepObject(new VisitorContext(force));
        }
        return (AlbumObjectImpl)this.representingAlbumObject;
    }

    protected AlbumObjectImpl getRepObject(VisitorContext ctx) {
        AlbumObjectImpl rep2;
        if (this.representingAlbumObject != null) {
            return (AlbumObjectImpl)this.representingAlbumObject;
        }
        if (this.getAttachments().isPresent(Attachments.Type.IMAGE)) {
            return null;
        }
        if (!ctx.checkVisit(this)) {
            return null;
        }
        AlbumObjectImpl rep = this.getChosenRepObject();
        if (rep == null && ctx.force && this.isFolder()) {
            Optional<AlbumObject> opt = this.getChildren().stream().filter(ao -> !ao.isFolder() && ao.isIncluded()).filter(ao -> ao.hasDisplayableImage()).findFirst();
            if (opt.isEmpty()) {
                opt = this.getChildren().stream().filter(ao -> ao.isFolder() && ao.isIncluded()).findFirst();
            }
            if (opt.isPresent()) {
                rep = (AlbumObjectImpl)opt.get();
            }
        }
        if (rep != null && (rep2 = rep.getRepObject(ctx)) != null) {
            rep = rep2;
        }
        if (rep == this) {
            System.err.println("Circular folder reference for: " + String.valueOf(this));
        } else {
            this.setRep(rep);
        }
        return rep;
    }

    private AlbumObjectImpl getChosenRepObject() {
        try {
            Map props = this.getFolderProperties();
            String folderIconPath = (String)props.get("folderIcon");
            if (AlbumObjectImpl.exists(folderIconPath)) {
                File f;
                AlbumObjectImpl child = (AlbumObjectImpl)this.getChild(folderIconPath);
                if (child == null && (f = new File(folderIconPath)).isAbsolute()) {
                    child = (AlbumObjectImpl)this.factory.createInstance(f);
                }
                return child;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public AlbumObject getParent() {
        return this.parent;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getLastModified() {
        long last = this.file.lastModified();
        File propFile = this.getCachedVersion(AlbumObjectProperties.getPropertyFile(this.file));
        if (propFile != null) {
            last = Math.max(propFile.lastModified(), last);
        }
        if (this.isFolder()) {
            File metaFile = ControlFiles.meta(this.file);
            last = Math.max(metaFile.lastModified(), last);
            File albumFilesFile = ControlFiles.albumfiles(this.file);
            last = Math.max(albumFilesFile.lastModified(), last);
            File commentsFile = ControlFiles.comments(this.file);
            last = Math.max(commentsFile.lastModified(), last);
        }
        return last;
    }

    @Override
    public long getMetaLastModified() {
        long last = 0L;
        File propFile = this.getCachedVersion(AlbumObjectProperties.getPropertyFile(this.file));
        if (propFile != null) {
            last = Math.max(propFile.lastModified(), last);
        }
        if (this.isFolder()) {
            File metaFile = ControlFiles.meta(this.file);
            last = Math.max(metaFile.lastModified(), last);
        }
        return last;
    }

    @Override
    public void setLastModified(long lastModified) throws IOException {
        long oldLastModified = this.getLastModified();
        Files.setLastModifiedTime(this.file.toPath(), FileTime.fromMillis(lastModified));
        File propFile = this.getCachedVersion(AlbumObjectProperties.getPropertyFile(this.file));
        if (propFile != null) {
            try {
                Files.setLastModifiedTime(propFile.toPath(), FileTime.fromMillis(lastModified));
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        this.firePropertyChange("lastModified", oldLastModified, lastModified);
    }

    @Override
    public long getWhenAdded() {
        return this.whenAdded;
    }

    @Override
    public void setWhenAdded(long whenAdded) throws IOException {
        long oldWhenAdded = this.whenAdded;
        this.whenAdded = whenAdded;
        if (this.parent != null) {
            this.parent.setChildren(this.parent.getChildren());
        }
        this.firePropertyChange("whenAdded", oldWhenAdded, whenAdded);
    }

    @Override
    public long getCameraDate() {
        if (this.cameraDate == null) {
            if (JAlbum.logger.isLoggable(Level.FINE)) {
                System.out.println("Camera date cache miss for " + this.getName());
            }
            this.cameraDate = this.getMetadata().getRealCameraDate();
            if (this.cameraDate != 0L && this.parent != null) {
                ((AlbumObjectImpl)this.parent).writeChildrenOnIdle();
            }
        }
        return this.cameraDate;
    }

    @Override
    public void setCameraDate(long cameraDate) {
        this.cameraDate = cameraDate;
        ((AlbumObjectImpl)this.getParent()).writeChildrenOnIdle();
    }

    public long getLastRefreshed() {
        return this.lastRefreshed;
    }

    @Override
    public Image loadImage() throws IOException {
        return this.loadImage(false, null);
    }

    @Override
    public Image loadImage(boolean useFastLoading, Dimension imageDim) throws IOException {
        return this.loadImage(true, imageDim, false);
    }

    @Override
    public Image loadImage(boolean useFastLoading, Dimension imageDim, boolean applyFilters) throws IOException {
        FilterList fl;
        if (!this.oldHasDisplayableImage()) {
            return null;
        }
        int subsampling = 1;
        if (useFastLoading && imageDim != null) {
            subsampling = FileFilters.calculateSubsamplingByScale(this.getImageInfo(), imageDim);
        }
        BufferedImage im = FileFilters.loadImage(this.getRepresentingImageFile(), subsampling, this.getImageInfo().isRaw() ? (ImageReadParam)this.getProperties().get("imageReadParam", this.factory.engine.getRawParam()) : null, new FileFilters.ReaderFlag[0]);
        im = GenericRotationSupport.adjustOrientation(im, (AlbumObject)this);
        if (applyFilters && (fl = (FilterList)this.getProperties().get("filterList")) != null) {
            try {
                FilterPipeline pipeline = new FilterPipeline(fl);
                im = pipeline.processPrescaleFilters(im);
                im = pipeline.processPostscaleFilters(im);
            }
            catch (Throwable t) {
                System.err.println("Error applying image tools to " + this.file.getAbsolutePath());
                t.printStackTrace(System.err);
            }
        }
        return im;
    }

    @Override
    public AlbumObjectFactory getFactory() {
        return this.factory;
    }

    @Override
    public AlbumBean getEngine() {
        return this.factory.engine;
    }

    @Override
    public void rotateLeft() throws IOException {
        if (this.getOrientation().isFlipped()) {
            this.setOrientation(this.getOrientation().previous());
        } else {
            this.setOrientation(this.getOrientation().next());
        }
    }

    @Override
    public void rotateRight() throws IOException {
        if (this.getOrientation().isFlipped()) {
            this.setOrientation(this.getOrientation().next());
        } else {
            this.setOrientation(this.getOrientation().previous());
        }
    }

    @Override
    public Orientation getOrientation() {
        if (this.orientation == null) {
            AlbumObject rep = this.getRepresentingAlbumObject();
            if (rep == null) {
                rep = this;
            }
            this.orientation = GenericRotationSupport.getOrientation(rep);
        }
        return this.orientation;
    }

    private void ensureUncached() {
        if (this.file instanceof CachedFile) {
            this.file = ((CachedFile)this.file).toFile();
        }
    }

    @Override
    public void setOrientation(Orientation o) throws IOException {
        this.thumbCache.clear();
        Orientation old = this.getOrientation();
        GenericRotationSupport.setOrientation(o, this);
        this.ensureUncached();
        this.orientation = o;
        this.albumObjectMetadata = null;
        this.getMetadata();
        this.factory.getUndoNotifier().undoableEditHappened(this, Msg.get("edit.rotate"), () -> this.setOrientation(old), () -> this.setOrientation(o));
        this.firePropertyChange("orientation", (Object)o, (Object)old);
    }

    public RAWImageReadParam getRAWSettings() {
        return (RAWImageReadParam)this.getProperties().get("imageReadParam");
    }

    public void setRAWSettings(RAWImageReadParam param) {
        this.setRAWSettings(param, this.getRAWSettings());
    }

    public void setRAWSettings(RAWImageReadParam param, RAWImageReadParam undoParam) {
        RAWImageReadParam paramClone = RAWImageReadParam.clone((RAWImageReadParam)param);
        RAWImageReadParam undoParamClone = RAWImageReadParam.clone((RAWImageReadParam)undoParam);
        try {
            if (this.getCategory() != Category.image || !this.getImageInfo().isRaw()) {
                throw new IllegalStateException("Trying to set RAW settings to non RAW object");
            }
            AlbumObjectProperties props = this.getProperties();
            if (param != null) {
                props.put("imageReadParam", param);
            } else {
                props.remove("imageReadParam");
            }
            props.save(false);
            this.updateRepresentingIcon();
            this.factory.getUndoNotifier().undoableEditHappened(this, Msg.get("ui.rawSettings"), () -> this.setRAWSettings(undoParamClone, paramClone), () -> this.setRAWSettings(paramClone, undoParamClone));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public boolean isIncludeOriginal() {
        return this.getProperties().get("includeOriginal", Boolean.FALSE);
    }

    @Override
    public void setIncludeOriginal(boolean includeOriginal) throws IOException {
        AlbumObjectProperties props = this.getProperties();
        props.put("includeOriginal", includeOriginal);
        props.store();
    }

    boolean isType(String ext) {
        return IO.extensionOf(this.getFile()).equalsIgnoreCase(ext);
    }

    @Override
    public boolean isUseOriginal() {
        return this.getProperties().get("useOriginal", this.isType("gif") ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUseOriginal(boolean use) throws IOException {
        AlbumObjectProperties props = this.getProperties();
        props.put("useOriginal", use);
        props.store();
    }

    private void deleteFromParent() throws IOException {
        AlbumObjectImpl pao = (AlbumObjectImpl)this.parent;
        if (pao != null) {
            pao.markAsClean();
            List<AlbumObject> parentChildren = pao.getChildren();
            parentChildren.remove(this);
            pao.setChildren(parentChildren);
        }
    }

    private static boolean isSafeToDelete(File dir) {
        return dir.listFiles(f -> {
            switch (f.getName()) {
                case ".jalbum": 
                case ".DS_Store": 
                case "THUMBS.DB": {
                    return false;
                }
            }
            return true;
        }).length == 0;
    }

    @Override
    public void delete() throws IOException, PermissionException {
        this.delete(EnumSet.noneOf(DeleteOption.class));
    }

    @Override
    public void delete(DeleteOption opt, DeleteOption ... opts) throws IOException, PermissionException {
        this.delete(EnumSet.of(opt, opts));
    }

    protected void delete(EnumSet<DeleteOption> optSet) throws IOException, PermissionException {
        File cachedThumbnailFile;
        File aop;
        UndoableDeleteEdit deleteEdit = null;
        if (this.parent != null && !this.isFolder() && !optSet.contains((Object)DeleteOption.KEEP_COMMENT)) {
            this.setClassicComment(null);
        }
        if (!this.isLink()) {
            if (this.isFolder.booleanValue() && AlbumObjectImpl.isSafeToDelete(this.file)) {
                deleteEdit = new UndoableDeleteEdit(this);
                AlbumObjectImpl.deleteFolderSafely(this.file);
            } else {
                try {
                    FileUtils fu = FileUtils.getInstance();
                    fu.moveToTrash(new File[]{this.file});
                }
                catch (IOException t) {
                    if (this.isFolder()) {
                        if (!AlbumObjectImpl.isSafeToDelete(this.file)) {
                            throw new PermissionException(Msg.get("edit.folderNotEmptyError", this.getName()));
                        }
                        AlbumObjectImpl.deleteFolderSafely(this.file);
                    }
                    this.file.delete();
                }
            }
        }
        if (!optSet.contains((Object)DeleteOption.KEEP_META) && (aop = AlbumObjectProperties.getPropertyFile(this.file)).exists()) {
            aop.delete();
        }
        if ((cachedThumbnailFile = this.getCachedThumbnailFile(this.file)).exists()) {
            cachedThumbnailFile.delete();
        }
        this.getAttachments().delete();
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        albumSynchronizer.delete(this);
        if (!optSet.contains((Object)DeleteOption.KEEP_INCLUDED)) {
            this.deleteFromParent();
        }
        if (deleteEdit != null) {
            this.factory.getUndoNotifier().undoableEditHappened(this, deleteEdit);
        }
        this.firePropertyChange("delete", null, null);
    }

    private static void deleteFolderSafely(File folder) throws PermissionException {
        File jalbumFolder = new File(folder, JALBUM_FOLDER_NAME);
        if (jalbumFolder.exists()) {
            AlbumObjectImpl.deleteDirRecursively(jalbumFolder);
        }
        File dsStore = new File(folder, ".DS_Store");
        dsStore.delete();
        File thumbsDb = new File(folder, "THUMBS.DB");
        thumbsDb.delete();
        if (!folder.delete() && folder.exists()) {
            throw new PermissionException(Msg.get("edit.folderNotEmptyError", folder.getName()));
        }
    }

    private static void deleteDirRecursively(File dir) {
        for (CachedFile f : CachedFile.listFiles(dir)) {
            if (((File)f).isDirectory() && !(f instanceof LinkFile)) {
                AlbumObjectImpl.deleteDirRecursively(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    @Override
    public String getUniqueName(String suggestedName) {
        if (!this.isFolder()) {
            if (IO.extensionOf((String)suggestedName).length() == 0) {
                suggestedName = (String)suggestedName + "." + IO.extensionOf(this.getName());
            }
            return this.getParent().getUniqueName((String)suggestedName);
        }
        String base = IO.baseName((String)suggestedName);
        Object ext = IO.extensionOf((String)suggestedName);
        if (((String)ext).length() > 0) {
            ext = "." + (String)ext;
        }
        Object name = suggestedName;
        int i = 1;
        while (this.containsName((String)name)) {
            name = base + "-" + i + (String)ext;
            ++i;
        }
        return name;
    }

    @Override
    public AlbumObject createFolder(String suggestedName) throws IOException {
        return this.createFolder(this.getChildren(false).size(), suggestedName);
    }

    @Override
    public AlbumObject createFolder(int index, String suggestedName) throws IOException {
        List<AlbumObject> chldrn = this.getChildren();
        final int realIndex = index == -1 ? chldrn.size() : index;
        File folderFile = new File(this.file, this.getUniqueName(suggestedName));
        folderFile.mkdir();
        final AlbumObject ao = this.factory.createInstance(folderFile, this);
        chldrn.add(realIndex, ao);
        this.setChildren(chldrn);
        if (index != -1) {
            this.setOrdering(AlbumObject.Ordering.custom);
        }
        this.factory.getUndoNotifier().undoableEditHappened(this, new UndoableNamedEdit(this, Msg.get("edit.newFolder")){
            final /* synthetic */ AlbumObjectImpl this$0;
            {
                this.this$0 = this$0;
                super(presentationName);
            }

            @Override
            public void doUndo() throws Exception {
                ao.delete();
                this.this$0.fireModelChanged();
            }

            @Override
            public void doRedo() throws Exception {
                ao.getFile().mkdir();
                this.this$0.add(realIndex, ao);
                this.this$0.fireModelChanged();
            }
        });
        return ao;
    }

    @Override
    public AlbumObject createView(View view, int index, String suggestedName) throws IOException {
        List<AlbumObject> chldrn = this.getChildren();
        int realIndex = index == -1 ? chldrn.size() : index;
        File folderFile = new File(this.file, this.getUniqueName(suggestedName));
        folderFile.mkdir();
        ViewAlbumObject viewObject = new ViewAlbumObject(folderFile, this, this.factory);
        viewObject.getProperties().put("viewSource", this.getPathFromRoot());
        view.saveTo(viewObject);
        chldrn.add(realIndex, viewObject);
        this.setChildren(chldrn);
        if (index != -1) {
            this.setOrdering(AlbumObject.Ordering.custom);
        }
        return viewObject;
    }

    @Override
    public AlbumObject createPage(int index, String suggestedName) throws IOException {
        File progDir = Config.getConfig().progDir;
        File skinDir = Config.getConfig().chainedSkinsDir.getFile(this.getEngine().getSkin());
        File templatesDir = new File(skinDir, "templates");
        File original = new File(templatesDir, "empty-page.htt");
        if (!original.exists()) {
            original = new File(progDir, "system/empty-page.htt");
        }
        return this.createPage(index, suggestedName, original);
    }

    @Override
    public AlbumObject createPage(final int index, final String suggestedName, final File original) throws IOException {
        File pageFile;
        List<AlbumObject> chldrn = this.getChildren();
        if (original.getName().equals("empty-page.htt")) {
            pageFile = new File(this.file, this.getUniqueName(suggestedName));
            IO.copyFile(original, pageFile);
        } else {
            pageFile = new LinkFile(this.getFile(), this.getUniqueName(suggestedName), new File("$SKIN_TEMPLATES_DIR/" + original.getName()));
        }
        final AlbumObject ao = this.factory.createInstance(pageFile, this);
        chldrn.add(index, ao);
        this.setChildren(chldrn);
        this.setOrdering(AlbumObject.Ordering.custom);
        AlbumObjectProperties props = ao.getProperties();
        props.put("originalPath", original.getAbsolutePath());
        props.put("originalHash", DigestUtil.md5(original));
        props.store();
        this.factory.getUndoNotifier().undoableEditHappened(this, new UndoableNamedEdit(this, Msg.get("edit.newPage")){
            final /* synthetic */ AlbumObjectImpl this$0;
            {
                this.this$0 = this$0;
                super(presentationName);
            }

            @Override
            public void doUndo() throws Exception {
                ao.delete();
                this.this$0.fireModelChanged();
            }

            @Override
            public void doRedo() throws Exception {
                this.this$0.createPage(index, suggestedName, original);
                this.this$0.fireModelChanged();
            }
        });
        return ao;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getWebName() {
        String name = this.webSafeName != null ? this.webSafeName : this.getName();
        switch (this.getCategory()) {
            case video: {
                return this.getEngine().getVideoProcessor().getOutputName(name);
            }
            case image: 
            case webPage: {
                return this.factory.engine.getTargetName(new File(this.file.getParentFile(), name));
            }
            case webLocation: {
                return this.getTitle();
            }
        }
        return name;
    }

    @Override
    public boolean setName(String name) {
        Object newName = name.trim();
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        String oldName = this.file.getName();
        File renamedFile = new File(this.file.getParentFile(), (String)newName);
        if (!this.isFolder() && !IO.extensionOf((String)newName).equalsIgnoreCase(IO.extensionOf(this.file))) {
            newName = IO.baseName(renamedFile) + "." + IO.extensionOf(this.file);
            renamedFile = new File(renamedFile.getParentFile(), (String)newName);
        }
        if (this.getParent() != null && !oldName.equalsIgnoreCase((String)newName) && this.getParent().containsName((String)newName) || ((String)newName).length() == 0) {
            return false;
        }
        if (this.isLink()) {
            LinkFile lf = (LinkFile)this.file;
            renamedFile = new LinkFile(lf.getLink().getParentFile(), renamedFile.getName(), lf.getTarget());
        }
        if (this.file.renameTo(renamedFile)) {
            if (this.parent != null) {
                AlbumObjectImpl.setTextFileComment(this.getComment(), (AlbumObjectImpl)this.parent, (AlbumObjectImpl)this.parent, oldName, (String)newName);
            } else {
                this.factory.engine.setDirectory(renamedFile.getAbsolutePath());
            }
            this.getAttachments().renameTo(renamedFile);
            File propFile = AlbumObjectProperties.getPropertyFile(this.file);
            File renamedPropFile = AlbumObjectProperties.getPropertyFile(renamedFile);
            if (propFile.exists()) {
                propFile.renameTo(renamedPropFile);
            }
            File thumbFile = this.getCachedThumbnailFile(this.file);
            File renamedThumbFile = this.getCachedThumbnailFile(renamedFile);
            if (thumbFile.exists()) {
                thumbFile.renameTo(renamedThumbFile);
            }
            File fromTranslated = albumSynchronizer.translate(this);
            this.setFile(renamedFile);
            this.invalidate();
            File toTranslated = albumSynchronizer.translate(this);
            albumSynchronizer.moveTo(this, fromTranslated, toTranslated);
            try {
                if (this.parent != null) {
                    ((AlbumObjectImpl)this.parent).markAsClean();
                    this.parent.setChildren(this.parent.getChildren());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.category = null;
            if (((String)newName).equals(this.factory.engine.getResourceDirectory())) {
                try {
                    this.setHidden(true);
                    this.thumbCache.clear();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            this.firePropertyChange("name", oldName, newName);
            this.factory.getUndoNotifier().undoableEditHappened(this, Msg.get("edit.renameFile"), () -> this.setName(oldName), () -> this.setName(name));
            return true;
        }
        return false;
    }

    public void markAsClean() {
        this.lastRefreshed = System.currentTimeMillis();
    }

    @Override
    public String getComment() {
        XmpManager mgr;
        if (this.comment != null) {
            return this.comment;
        }
        if (this.isFolder() && this.factory.engine.isReadJAlbumMetaData()) {
            try {
                Map props = this.getFolderProperties();
                this.comment = (String)props.get("descript");
                return this.comment != null ? this.comment : "";
            }
            catch (IOException ex) {
                return "";
            }
        }
        if (this.factory.engine.isReadJAlbumMetaData() && this.parent != null) {
            try {
                this.comment = ((AlbumObjectImpl)this.parent).getTextFileComment(this.file.getName());
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (this.comment != null) {
                return this.comment;
            }
        }
        if (this.factory.engine.isReadXmp() && (mgr = this.getXmpManager()) != null) {
            this.comment = mgr.getDescription();
            if (this.comment != null) {
                return this.comment;
            }
        }
        this.comment = this.factory.engine.readEmbeddedComment(this);
        return this.comment;
    }

    private void setClassicComment(String newComment) throws IOException {
        if (this.isFolder()) {
            Map props = this.getFolderProperties();
            props.put("descript", newComment);
            this.setFolderProperties(props);
        } else {
            AlbumObjectImpl.setTextFileComment(newComment, (AlbumObjectImpl)this.parent, (AlbumObjectImpl)this.parent, this.file.getName(), this.file.getName());
        }
        this.comment = newComment;
    }

    private void setXmpComment(String newComment) throws IOException {
        XmpManager xmpProps;
        if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
            try {
                xmpProps.setDescription(newComment);
                xmpProps.save();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setComment(final String newComment) throws IOException {
        final String oldComment = this.comment;
        if (Objects.equals(newComment, oldComment)) {
            return;
        }
        this.setClassicComment(newComment);
        this.setXmpComment(newComment);
        this.factory.getUndoNotifier().undoableEditHappened(this, new UndoableNamedEdit(this, Msg.get("ui.caption")){
            final /* synthetic */ AlbumObjectImpl this$0;
            {
                this.this$0 = this$0;
                super(presentationName);
            }

            @Override
            public void doUndo() throws Exception {
                this.this$0.setComment(oldComment == null ? "" : oldComment);
            }

            @Override
            public void doRedo() throws Exception {
                this.this$0.setComment(newComment);
            }
        });
        this.firePropertyChange("comment", oldComment, newComment);
    }

    @Override
    public String getTitle() {
        XmpManager xmpProps;
        AlbumObjectProperties aop;
        String title = null;
        if (this.factory.engine.isReadJAlbumMetaData() && (title = (String)(aop = this.getProperties()).get("title")) != null) {
            return title;
        }
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null && (title = xmpProps.getTitle()) != null) {
            return title;
        }
        Metadata md = this.getMetadata().getMetadata();
        if (md != null && md.containsDirectoryOfType(IptcDirectory.class)) {
            IptcDirectory iptc = (IptcDirectory)md.getFirstDirectoryOfType(IptcDirectory.class);
            switch (this.factory.engine.getTitleSource()) {
                case IPTCObjectName: {
                    if (!iptc.containsTag(517)) break;
                    title = iptc.getString(517);
                    break;
                }
                case IPTCHeadline: {
                    if (!iptc.containsTag(617)) break;
                    title = iptc.getString(617);
                }
            }
        }
        return title != null ? title : "";
    }

    @Override
    public boolean setTitle(String newTitle) {
        String oldTitle = this.getTitle();
        if (!Objects.equals(newTitle, oldTitle)) {
            XmpManager mgr;
            if (Config.getConfig().isWriteXmp() && (mgr = this.getXmpManager()) != null) {
                try {
                    mgr.setTitle(newTitle);
                    mgr.save();
                }
                catch (Throwable t) {
                    System.err.println("Caught " + t.toString() + " writing title to " + this.getName());
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            aop.put("title", newTitle);
            boolean res = aop.save(true);
            this.factory.getUndoNotifier().undoableEditHappened(this, Msg.get("edit.titleLabel"), () -> this.setTitle(oldTitle), () -> this.setTitle(newTitle));
            this.firePropertyChange("title", oldTitle, newTitle);
            return res;
        }
        return true;
    }

    @Override
    public int getRating() {
        Integer rating;
        XmpManager xmpProps;
        AlbumObjectProperties aop;
        Integer r;
        if (this.factory.engine.isReadJAlbumMetaData() && (r = (Integer)(aop = this.getProperties()).get("rating")) != null) {
            return r;
        }
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null && (rating = xmpProps.getRating()) != null) {
            return rating;
        }
        return 0;
    }

    @Override
    public void setRating(int rating) throws IOException {
        int oldRating = this.getRating();
        if (rating != oldRating) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setRating(rating);
                    xmpProps.save();
                }
                catch (XMPException | IOException throwable) {
                    // empty catch block
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            aop.put("rating", rating);
            aop.store(false);
            this.factory.getUndoNotifier().undoableEditHappened(this, Msg.get("ui.ratingToolTip", rating), () -> this.setRating(oldRating), () -> this.setRating(rating));
        }
    }

    @Override
    public Flag getFlag() {
        XmpManager xmpProps;
        AlbumObjectProperties aop;
        Flag flag;
        if (this.factory.engine.isReadJAlbumMetaData() && (flag = (Flag)((Object)(aop = this.getProperties()).get("flag"))) != null) {
            return flag;
        }
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null) {
            try {
                return xmpProps.getFlag();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return Flag.NoFlag;
    }

    @Override
    public void setKeywords(String keywordsIn) throws IOException {
        String oldKeywords;
        String keywords;
        if (keywordsIn == null) {
            keywordsIn = "";
        }
        if (!(keywords = AlbumObjectImpl.normalizeKeywords(keywordsIn)).equals(oldKeywords = this.getKeywords())) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setKeywords(keywords);
                    xmpProps.save();
                }
                catch (XMPException | IOException throwable) {
                    // empty catch block
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            if ("".equals(keywords)) {
                aop.remove("keywords");
            } else {
                aop.put("keywords", keywords);
            }
            aop.store(true);
            this.factory.getUndoNotifier().undoableEditHappened(this, Msg.get("edit.keywords"), () -> this.setKeywords(oldKeywords), () -> this.setKeywords(keywords));
            this.firePropertyChange("keywords", oldKeywords, keywords);
        }
    }

    @Override
    public String getKeywords() {
        XmpManager xmpProps;
        AlbumObjectProperties aop;
        String keywords = null;
        if (this.factory.engine.isReadJAlbumMetaData() && (keywords = (String)(aop = this.getProperties()).get("keywords")) != null) {
            return keywords;
        }
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null) {
            try {
                keywords = xmpProps.getKeywords();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return keywords != null ? keywords : "";
    }

    @Override
    public Set<String> getKeywordSet() {
        TreeSet<String> all = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        String keywords = this.getKeywords();
        if (!keywords.isEmpty()) {
            all.addAll(Arrays.asList(keywordSeparator.split(keywords)));
        }
        return all;
    }

    @Override
    public void setFlag(Flag flag) throws IOException {
        Flag oldFlag = this.getFlag();
        if (flag != oldFlag) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setFlag(flag);
                    xmpProps.save();
                }
                catch (XMPException | IOException throwable) {
                    // empty catch block
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            if (flag == Flag.NoFlag) {
                aop.remove("flag");
            } else {
                aop.put("flag", (Object)flag);
            }
            aop.store(false);
            this.factory.getUndoNotifier().undoableEditHappened(this, flag.toString(), () -> this.setFlag(oldFlag), () -> this.setFlag(flag));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFileMetadataToXmp() throws XMPException, IOException {
        boolean readXmp = this.factory.engine.isReadXmp();
        this.factory.engine.setReadXmp(false);
        try {
            XmpManager xmpProps = this.getXmpManager();
            int modCount = 0;
            if (xmpProps != null) {
                Integer rating;
                AlbumObjectProperties aop;
                String title;
                if (this.getComment().length() > 0) {
                    xmpProps.setDescription(this.getComment());
                    ++modCount;
                }
                if ((title = (String)(aop = this.getProperties()).get("title")) != null) {
                    xmpProps.setTitle(title);
                    ++modCount;
                }
                if ((rating = (Integer)aop.get("rating")) != null) {
                    xmpProps.setRating(rating);
                    ++modCount;
                }
                if (modCount > 0) {
                    xmpProps.save();
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.factory.engine.setReadXmp(readXmp);
        }
    }

    @Override
    public String getPathFromRoot() {
        if (this.parent == null) {
            return "";
        }
        if (this.parent.getParent() == null) {
            return this.getName();
        }
        return this.parent.getPathFromRoot() + "/" + this.getName();
    }

    @Override
    public String getPathFrom(AlbumObject folder) {
        if (this.parent == null) {
            return "";
        }
        if (this.parent == folder) {
            return this.getName();
        }
        return this.parent.getPathFrom(folder) + "/" + this.getName();
    }

    @Override
    public Path getPath() {
        if (this.parent == null) {
            return this.file.toPath();
        }
        return this.parent.getPath().resolve(this.getName());
    }

    @Override
    public AlbumObject getRoot() {
        AlbumObject parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return parent.getRoot();
    }

    @Override
    public AlbumObject getViewRoot() {
        if (this.isView()) {
            return this;
        }
        AlbumObject parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getViewRoot();
    }

    @Override
    public AlbumObjectMetadata getMetadata() {
        AlbumObjectMetadata md;
        AlbumObjectMetadata albumObjectMetadata = md = this.albumObjectMetadata != null ? this.albumObjectMetadata.get() : null;
        if (md == null) {
            try (Profiler.Sample _s = Profiler.profile();){
                md = AlbumObjectMetadata.getInstance(this.file);
                this.albumObjectMetadata = new SoftReference<AlbumObjectMetadata>(md);
            }
            catch (IOException ex) {
                throw new RuntimeException("For file " + this.getFile().getAbsolutePath(), ex);
            }
        }
        return md;
    }

    public AlbumObjectProperties peekProperties() {
        return this.properties != null ? this.properties.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlbumObjectProperties getProperties() {
        AlbumObjectProperties aop = this.properties.get();
        if (aop == null) {
            MutableSoft<AlbumObjectProperties> mutableSoft = this.properties;
            synchronized (mutableSoft) {
                aop = this.properties.get();
                if (aop == null) {
                    try (Profiler.Sample _s = Profiler.profile();){
                        aop = AlbumObjectProperties.getInstance(this);
                        this.propertyChangeListener = evt -> JAlbumUtilities.runOnAWT(() -> this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
                    }
                    aop.removePropertyChangeListener(this.propertyChangeListener);
                    aop.addPropertyChangeListener(this.propertyChangeListener);
                    this.properties.set(aop);
                }
            }
        }
        return aop;
    }

    @Override
    public XmpManager getXmpManager() {
        XmpManager xmpProps;
        XmpManager xmpManager = xmpProps = this.xmpProperties != null ? this.xmpProperties.get() : null;
        if (xmpProps == null && this.file.isFile()) {
            try (Profiler.Sample _s = Profiler.profile();){
                xmpProps = new XmpManager(this);
                this.xmpProperties = new SoftReference<XmpManager>(xmpProps);
            }
            catch (XMPException | IOException ex) {
                if (this.getCategory() == Category.image || this.getCategory() == Category.video) {
                    // empty if block
                }
                return null;
            }
        }
        return xmpProps;
    }

    @Override
    public boolean isDisplayableImage() {
        return this.file.exists() && !FileFilters.hasIcon(this.file);
    }

    private boolean oldHasDisplayableImage() {
        Attachments att = this.getAttachments();
        if (att.isPresent(Attachments.Type.IMAGE)) {
            return true;
        }
        if (this.getCategory() == Category.webLocation) {
            this.getRepresentingImageFile();
        }
        return this.file.exists() && (this.getCachedThumbnailFile(this.file).exists() || !FileFilters.hasIcon(this.file) || this.factory.engine.getVideoProcessor().isFormatSupported(this.file));
    }

    @Override
    public boolean isFolder() {
        if (this.isFolder == null) {
            this.isFolder = this.file.isDirectory();
        }
        return this.isFolder;
    }

    @Override
    public Category getCategory() {
        if (this.category == null) {
            if (this.isFolder()) {
                this.category = Category.folder;
            } else if (FileFilters.isFileSupported(this.file)) {
                this.category = Category.image;
            } else if ("Audio file".equals(FileFilters.getFileCategory(this.file))) {
                this.category = Category.audio;
            } else if (this.factory.engine.getVideoProcessor().isFormatSupported(this.file)) {
                this.category = Category.video;
            } else {
                this.category = Category.other;
                FileFilters.FileType ft = FileFilters.getFileType(this.file);
                if (ft != null) {
                    if ("Web page template".equals(ft.name)) {
                        this.category = Category.webPage;
                    } else if ("Web Location".equals(ft.name)) {
                        this.category = Category.webLocation;
                    }
                }
            }
        }
        return this.category;
    }

    @Override
    public boolean isIncluded() {
        return this.included;
    }

    @Override
    public void setIncluded(boolean included) throws IOException {
        boolean oldIncluded = this.included;
        this.included = included;
        if (included != oldIncluded) {
            File cachedThumbnailFile;
            if (this.parent.getChild(this.getName()) != this) {
                System.err.println("AlbumObject detached");
            }
            this.parent.setChildren(this.parent.getChildren());
            if (!included && !this.isFolder.booleanValue() && (cachedThumbnailFile = this.getCachedThumbnailFile(this.file)).exists()) {
                cachedThumbnailFile.delete();
            }
        }
        this.factory.getUndoNotifier().undoableEditHappened(this, included ? Msg.get("edit.include") : Msg.get("edit.exclude"), () -> this.setIncluded(oldIncluded), () -> this.setIncluded(included));
        this.firePropertyChange("included", oldIncluded, included);
    }

    @Override
    public boolean isHidden() {
        AlbumObjectProperties aop = this.getProperties();
        Boolean hidden = (Boolean)aop.get("hidden");
        return hidden != null ? hidden : false;
    }

    @Override
    public void setHidden(boolean hidden) throws IOException {
        boolean oldHidden = this.isHidden();
        AlbumObjectProperties aop = this.getProperties();
        aop.put("hidden", hidden);
        aop.store(false);
        this.thumbCache.clear();
        this.firePropertyChange("hidden", oldHidden, hidden);
    }

    @Override
    public boolean isWithin(AlbumObject parent) {
        for (AlbumObject ao = this; ao != null; ao = ao.getParent()) {
            if (ao != parent) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean repairLink(File newTarget) throws IOException {
        if (!this.isLink() || this.file.exists() || !newTarget.exists()) {
            return false;
        }
        this.setFile(new LinkFile(((LinkFile)this.file).getLink().getParentFile(), this.file.getName(), newTarget));
        this.invalidate();
        return true;
    }

    @Override
    public AlbumObject getChild(String path) {
        try {
            return this.getChild(path, false);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public AlbumObject getChild(String path, boolean createFolders) throws IOException {
        if (path.length() == 0) {
            return this;
        }
        if (path.indexOf(92) != -1) {
            throw new IllegalArgumentException("Illegal '' path character in path: " + path);
        }
        int slashIndex = path.indexOf(47);
        if (slashIndex >= 0) {
            AlbumObject child = this.getChild(path.substring(0, slashIndex), createFolders);
            if (child != null) {
                return ((AlbumObjectImpl)child).getChild(path.substring(slashIndex + 1), createFolders);
            }
        } else {
            AlbumObject child;
            Map<String, AlbumObject> nm = this.getNameMap();
            AlbumObject albumObject = child = nm != null ? nm.get(path.toLowerCase()) : null;
            if (child == null && createFolders) {
                child = this.createFolder(path);
            }
            return child;
        }
        return null;
    }

    @Override
    public boolean containsName(String name) {
        Map<String, AlbumObject> nm = this.getNameMap();
        if (nm == null) {
            throw new IllegalStateException("Not a folder");
        }
        return nm.containsKey(name.toLowerCase());
    }

    @Override
    public void moveTo(AlbumObject newParent) throws IOException {
        this.moveTo(newParent, -1);
    }

    @Override
    public void moveTo(AlbumObject newParent, String newName) throws IOException {
        this.moveTo(newParent, newName, -1);
    }

    @Override
    public void moveTo(AlbumObject newParent, int position) throws IOException {
        this.moveTo(newParent, this.getName(), position);
    }

    @Override
    public void moveTo(AlbumObject newParent, String newName, int position) throws IOException {
        File newFile;
        File oldFile = this.getFile();
        UndoableMoveEdit undoableEdit = new UndoableMoveEdit(this, newParent, newName, position);
        if (!newParent.isFolder()) {
            throw new IllegalArgumentException("Argument must be a folder");
        }
        if (newParent.containsName(newName)) {
            throw new IOException(Msg.get("edit.objectAlreadyExists", newName));
        }
        List<AlbumObject> chldrn = newParent.getChildren();
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        File fromTranslated = albumSynchronizer.translate(this);
        if (this.isLink()) {
            newFile = new LinkFile(newParent.getFile(), newName, ((LinkFile)this.file).getTarget());
            if (newParent.isWithin(this)) {
                throw new IOException(Msg.get("edit.moveError", ((LinkFile)this.file).getLink(), ((LinkFile)newFile).getLink()));
            }
        } else {
            newFile = new File(newParent.getFile(), newName);
            if (!this.file.renameTo(newFile)) {
                throw new IOException(Msg.get("edit.moveError", this.file, newFile));
            }
        }
        String comment = this.getComment();
        if (this.parent != null) {
            AlbumObjectImpl.setTextFileComment(comment, (AlbumObjectImpl)this.getParent(), (AlbumObjectImpl)newParent, oldFile.getName(), newName);
        }
        this.getAttachments().renameTo(newFile);
        File propFile = AlbumObjectProperties.getPropertyFile(this.file);
        File renamedPropFile = AlbumObjectProperties.getPropertyFile(newFile);
        if (propFile.exists()) {
            renamedPropFile.getParentFile().mkdir();
            propFile.renameTo(renamedPropFile);
        }
        File thumbFile = this.getCachedThumbnailFile(this.file);
        File renamedThumbFile = this.getCachedThumbnailFile(newFile);
        if (thumbFile.exists()) {
            renamedThumbFile.getParentFile().mkdirs();
            thumbFile.renameTo(renamedThumbFile);
        }
        this.invalidate();
        this.deleteFromParent();
        this.setFile(newFile);
        this.parent = (AlbumObjectImpl)newParent;
        if (position != -1) {
            chldrn.add(position, this);
        } else {
            chldrn.add(this);
        }
        newParent.setChildren(chldrn);
        File toTranslated = albumSynchronizer.translate(this);
        albumSynchronizer.moveTo(this, fromTranslated, toTranslated);
        this.factory.getUndoNotifier().undoableEditHappened(this, undoableEdit);
        this.firePropertyChange("moved", oldFile, newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(List<File> files) throws IOException {
        List<AlbumObject> children = this.getChildren();
        try {
            for (File f : files) {
                if (this.containsName(f.getName())) {
                    throw new IOException(Msg.get("edit.objectAlreadyExists", f.getName()));
                }
                AlbumObject ao = this.factory.createInstance((File)new LinkFile(this.file, f.getName(), f), this);
                children.add(ao);
            }
        }
        finally {
            this.setChildren(children);
        }
    }

    @Override
    public void add(Set<AlbumObject> objects) throws IOException {
        this.add(-1, objects);
    }

    @Override
    public void add(AlbumObject object) throws IOException {
        this.add(-1, object);
    }

    @Override
    public void add(int index, AlbumObject ao) throws IOException {
        HashSet<AlbumObject> objects = new HashSet<AlbumObject>();
        objects.add(ao);
        this.add(index, objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, final Set<AlbumObject> objects) throws IOException {
        boolean addToSpecificIndex = index >= 0;
        this.markAsClean();
        List<AlbumObject> children = this.getChildren();
        if (index == -1) {
            index = children.size();
        }
        try {
            for (AlbumObject ao : objects) {
                ((AlbumObjectImpl)ao).parent = this;
            }
            if (index < children.size()) {
                int indexAfterRemoval = index;
                Iterator<AlbumObject> it = children.iterator();
                for (int i = 0; i < index && it.hasNext(); ++i) {
                    AlbumObject ao = it.next();
                    if (!objects.contains(ao)) continue;
                    this.getNameMap().remove(ao.getName().toLowerCase());
                    it.remove();
                    --indexAfterRemoval;
                }
                children.removeAll(objects);
                children.addAll(indexAfterRemoval, objects);
            } else {
                children.removeAll(objects);
                children.addAll(objects);
            }
            this.factory.getUndoNotifier().undoableEditHappened(this, new AbstractUndoableEdit(this){
                final /* synthetic */ AlbumObjectImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public String getPresentationName() {
                    return Msg.get("edit.additionOfNItems", objects.size());
                }

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    try {
                        for (AlbumObject ao : objects) {
                            if (ao.isFolder() && !ao.isLink()) {
                                AlbumObjectImpl.deleteDirRecursively(ao.getFile());
                                this.this$0.markAsClean();
                                ao.getChildren(false).clear();
                            }
                            ao.delete();
                        }
                        this.this$0.fireModelChanged();
                    }
                    catch (IOException | PermissionException ex) {
                        throw new UndoRedoException(ex);
                    }
                }

                @Override
                public boolean canRedo() {
                    return false;
                }

                @Override
                public void redo() throws CannotRedoException {
                    throw new CannotRedoException();
                }
            });
        }
        finally {
            if (!addToSpecificIndex) {
                AlbumObjectOrderer orderer = new AlbumObjectOrderer(this);
                children = orderer.sort(children);
            }
            this.setChildren(children);
            if (addToSpecificIndex) {
                this.setOrdering(AlbumObject.Ordering.custom);
            }
        }
    }

    public AlbumObject addFileOf(AlbumObject source) {
        LinkFile link;
        File f = source.getFile();
        String name = f.getName();
        if (this.containsName(name)) {
            name = this.getUniqueName(name);
        }
        if (this.getEngine().getSkinProperties().isSupportsInternalLinking() && this.getEngine().isUseInternalLinking()) {
            link = new LinkFile(this.getFile(), name, LinkFile.linkOf(source.getFile()));
        } else {
            File target = LinkFile.targetOf(f);
            link = new LinkFile(AlbumObjectImpl.getAlbumParentFile(f), name, target);
        }
        AlbumObjectImpl ao = (AlbumObjectImpl)this.getFactory().createInstance((File)link, this);
        ao.included = source.isIncluded();
        try {
            this.add(ao);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return ao;
    }

    @Override
    public AlbumObject.Ordering getOrdering() {
        return this.orderer.getOrdering();
    }

    @Override
    public void setOrdering(AlbumObject.Ordering ordering) throws IOException {
        if (this.orderer != null) {
            AlbumObject.Ordering oldOrdering = this.orderer.getOrdering();
            this.orderer.setOrdering(ordering);
            this.firePropertyChange("ordering", (Object)oldOrdering, (Object)ordering);
        }
    }

    @Override
    public AlbumObject.Ordering getFolderOrdering() {
        return this.orderer.getFolderOrdering();
    }

    @Override
    public void setFolderOrdering(AlbumObject.Ordering folderOrdering) throws IOException {
        this.orderer.setFolderOrdering(folderOrdering);
    }

    @Override
    public boolean isFoldersFirst() {
        return this.orderer.isFoldersFirst();
    }

    @Override
    public void setFoldersFirst(boolean foldersFirst) throws IOException {
        this.orderer.setFoldersFirst(foldersFirst);
    }

    @Override
    public boolean isReverseOrdering() {
        return this.orderer.isReverseOrdering();
    }

    @Override
    public void setReverseOrdering(boolean reverseOrdering) throws IOException {
        this.orderer.setReverseOrdering(reverseOrdering);
    }

    @Override
    public boolean isReverseFolderOrdering() {
        return this.orderer.isReverseFolderOrdering();
    }

    @Override
    public void setReverseFolderOrdering(boolean reverseFolderOrdering) throws IOException {
        this.orderer.setReverseFolderOrdering(reverseFolderOrdering);
    }

    private static BufferedImage cropToShape(BufferedImage bi, Dimension dDim) {
        Dimension sDim = new Dimension(bi.getWidth(), bi.getHeight());
        double sAspekt = (double)sDim.width / (double)sDim.height;
        double dAspekt = (double)dDim.width / (double)dDim.height;
        if (sAspekt > dAspekt) {
            int newWidth = (int)(dAspekt * (double)sDim.height);
            return bi.getSubimage((sDim.width - newWidth) / 2, 0, newWidth, sDim.height);
        }
        if (sAspekt < dAspekt) {
            int newHeight = (int)((double)sDim.width / dAspekt);
            return bi.getSubimage(0, (sDim.height - newHeight) / 6, sDim.width, newHeight);
        }
        return bi;
    }

    public boolean isCached(Config.ThumbnailQuality mode) {
        return this.thumbCache.icon != null && mode.getBounds().equals(this.thumbCache.bounds);
    }

    @Override
    public ImageIcon getRepresentingIcon(Dimension bounds, boolean enlarge) throws IOException {
        return this.getRepresentingIcon(bounds, false, enlarge);
    }

    @Override
    public ImageIcon getRepresentingIcon(Dimension bounds, boolean fixedShape, boolean enlarge) throws IOException {
        BufferedImage bi;
        ImageIcon ii = this.thumbCache.getIcon(bounds, fixedShape);
        if (ii != null) {
            return ii;
        }
        Object o = null;
        if (this.getRepresentingAlbumObject() != null) {
            ii = this.representingAlbumObject.getRepresentingIcon(bounds, fixedShape, enlarge);
            if (this.isFolder()) {
                BufferedImage ri = AlbumObjectImpl.ensureBuffered(ii);
                ri = this.ensureMinimumSize(ri, new Dimension(160, 160));
                ii = new ImageIcon(ri);
            }
            bi = AlbumObjectImpl.ensureBuffered(ii);
            bi = GenericRotationSupport.adjustOrientation(bi, (AlbumObject)this);
            ii = new ImageIcon(bi);
        } else {
            o = this.doGetRepresentingIcon(bounds, fixedShape, enlarge);
            if (o instanceof ImageIcon) {
                ii = AlbumObjectImpl.scaleToFit((ImageIcon)o, bounds, enlarge);
            } else {
                bi = (BufferedImage)o;
                bi = GenericRotationSupport.adjustOrientation(bi, (AlbumObject)this);
                FilterList fl = (FilterList)this.getProperties().get("filterList");
                if (fl != null) {
                    try {
                        FilterPipeline pipeline = new FilterPipeline(fl);
                        bi = pipeline.processPrescaleFilters(bi);
                        bi = this.factory.engine.scaleToFit(bi, new Dimension(600, 600), "ScaleFast");
                        bi = pipeline.processPostscaleFilters(bi);
                    }
                    catch (Throwable t) {
                        System.err.println("Error applying image tools to " + this.file.getAbsolutePath());
                        t.printStackTrace(System.err);
                    }
                }
                if (fixedShape) {
                    bi = AlbumObjectImpl.cropToShape(bi, bounds);
                }
                ii = AlbumObjectImpl.scaleToFit(new ImageIcon(bi), bounds, enlarge);
            }
        }
        if (this.isHidden()) {
            BufferedImage im = new BufferedImage(ii.getIconWidth(), ii.getIconHeight(), 6);
            Graphics2D g = im.createGraphics();
            AlphaComposite composite = AlphaComposite.getInstance(3, 0.3f);
            g.setComposite(composite);
            g.drawImage(ii.getImage(), 0, 0, null);
            RescaleOp op = new RescaleOp(0.8f, 0.0f, null);
            im = op.filter(im, null);
            ii = new ImageIcon(im);
        }
        this.thumbCache.update(ii, bounds, fixedShape);
        return ii;
    }

    private Object doGetRepresentingIcon(Dimension bounds, boolean fixedShape, boolean enlarge) throws IOException {
        block28: {
            if (!this.hasDisplayableImage()) {
                Icon repIcon = null;
                if (!LinkFile.exists(this.file, this.getEngine())) {
                    repIcon = brokenLinkIcon;
                } else if (this instanceof ViewAlbumObject && ((ViewAlbumObject)this).getLastException() != null) {
                    repIcon = brokenViewIcon;
                } else if (this.isFolder()) {
                    repIcon = Icons.empty();
                } else {
                    if (this.isView()) {
                        return Icons.empty();
                    }
                    repIcon = new ImageIcon(FileFilters.getIconFor(this.file, this.factory.engine).toURI().toURL());
                }
                return repIcon;
            }
            try {
                this.getRepresentingImageFile();
                File thumbnailFile = this.getCachedThumbnailFile(this.file);
                if (thumbnailFile.exists()) {
                    boolean isCachedImage = thumbnailFile.getParentFile().equals(AlbumObjectImpl.getCacheFolder(this.file));
                    if (isCachedImage && thumbnailFile.lastModified() < this.file.lastModified()) {
                        this.thumbCache.clear();
                    } else {
                        BufferedImage bi = FileFilters.loadImage(thumbnailFile);
                        if (bi.getWidth() >= bounds.width || bi.getHeight() >= bounds.height) {
                            return bi;
                        }
                    }
                } else {
                    Attachments att = this.getAttachments();
                    File repImage = att.get(Attachments.Type.IMAGE);
                    if (repImage != null && repImage.exists()) {
                        return FileFilters.loadImage(repImage);
                    }
                }
            }
            catch (IOException thumbnailFile) {
                // empty catch block
            }
            if (bounds.width <= Config.ThumbnailQuality.NORMAL.getBounds().width) {
                try {
                    BufferedImage thumb = this.readEmbeddedThumbnail();
                    FileFilters.BasicImageInfo info = this.getImageInfo();
                    if (AlbumObjectImpl.isPortrait(thumb.getWidth(), thumb.getHeight()) != AlbumObjectImpl.isPortrait(info.width, info.height)) {
                        throw new IOException("Discarding thumbnail that has different aspect than main image");
                    }
                    double maxScale = Math.max((double)info.width / (double)thumb.getWidth(), (double)info.height / (double)thumb.getHeight());
                    Dimension realThumb = new Dimension((int)((double)info.width / maxScale), (int)((double)info.height / maxScale));
                    if (realThumb.height - thumb.getHeight() < -8 || realThumb.width - thumb.getWidth() < -8) {
                        if (realThumb.width > realThumb.height) {
                            realThumb.height -= 2;
                        } else {
                            realThumb.width -= 2;
                        }
                        CropFilter cf = new CropFilter();
                        cf.setXWeight(0.5f);
                        cf.setYWeight(0.5f);
                        cf.setBounds(realThumb);
                        thumb = cf.filter(thumb, null);
                    }
                    return thumb;
                }
                catch (IOException ex) {
                    if (!JAlbum.logger.isLoggable(Level.FINE)) break block28;
                    ex.printStackTrace();
                }
            }
        }
        try {
            int ss = FileFilters.calculateSubsamplingByScale(this.getImageInfo(), bounds);
            BufferedImage bi = FileFilters.loadImage(this.file, ss, this.getImageInfo().isRaw() ? (ImageReadParam)this.getProperties().get("imageReadParam", this.factory.engine.getRawParam()) : null, new FileFilters.ReaderFlag[0]);
            bi = this.factory.engine.scaleToFit(bi, bounds, "ScaleMedium");
            if (bounds.width == Config.ThumbnailQuality.NORMAL.getBounds().width) {
                try {
                    this.setRepresentingIcon(bi, false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return bi;
        }
        catch (IOException e) {
            return brokenImageIcon;
        }
    }

    private static boolean isPortrait(int width, int height) {
        return height > width;
    }

    private BufferedImage readEmbeddedThumbnail() throws IOException {
        try {
            ExifThumbnailDirectory dir;
            AlbumObjectMetadata meta = this.getMetadata();
            if (meta.metadata != null && meta.metadata.containsDirectoryOfType(ExifThumbnailDirectory.class) && (dir = (ExifThumbnailDirectory)meta.metadata.getFirstDirectoryOfType(ExifThumbnailDirectory.class)).containsTag(513) && dir.containsTag(514)) {
                int thumbOffset = dir.getInt(513);
                int thumbLength = dir.getInt(514);
                ImageIcon ii = JPEGUtil.getEmbeddedThumbnail(this.file, thumbOffset, thumbLength);
                return AlbumObjectImpl.ensureBuffered(ii);
            }
        }
        catch (MetadataException | IOException | RuntimeException meta) {
            // empty catch block
        }
        try (ImageInputStream iis = ImageIO.createImageInputStream(this.file);){
            Iterator<ImageReader> it = FileFilters.getImageReaders(IO.extensionOf(this.file), iis);
            while (it.hasNext()) {
                ImageReader ir = it.next();
                try {
                    if (iis == null) continue;
                    ir.setInput(iis, true, true);
                    int minIndex = ir.getMinIndex();
                    if (!ir.hasThumbnails(minIndex)) continue;
                    BufferedImage im = ir.readThumbnail(minIndex, minIndex);
                    ir.dispose();
                    BufferedImage bufferedImage = im;
                    return bufferedImage;
                }
                catch (RuntimeException ex) {
                    System.err.println("Caught " + String.valueOf(ex) + " for " + String.valueOf(this.file) + ":");
                    ex.printStackTrace(System.err);
                }
            }
        }
        throw new IOException("No image readers found for " + this.getName());
    }

    @Override
    public boolean hasDisplayableImage() {
        AlbumObject rep;
        Attachments att = this.getAttachments();
        if (att.isPresent(Attachments.Type.IMAGE)) {
            return true;
        }
        if (this.getCategory() == Category.webLocation) {
            this.getRepresentingImageFile();
        }
        if ((rep = this.getRepresentingAlbumObject()) != null) {
            return rep.hasDisplayableImage();
        }
        return this.file.exists() && (this.getCachedThumbnailFile(this.file).exists() || !FileFilters.hasIcon(this.file) || this.factory.engine.getVideoProcessor().isFormatSupported(this.file));
    }

    @Override
    public File getRepresentingImageFile() {
        Attachments att = this.getAttachments();
        File repImage = att.get(Attachments.Type.IMAGE);
        if (repImage != null && repImage.exists()) {
            return repImage;
        }
        if (this.getRepresentingAlbumObject() != null) {
            return this.getRepresentingAlbumObject().getRepresentingImageFile();
        }
        if (this.file.exists() && FileFilters.isFileSupported(this.file)) {
            return this.file;
        }
        File cacheFile = this.getCachedThumbnailFile(this.file);
        if (!cacheFile.exists() || cacheFile.lastModified() < this.file.lastModified()) {
            if (this.getCategory() == Category.webLocation && this.thumbCache.icon == null) {
                try {
                    cacheFile.getParentFile().mkdirs();
                    BufferedImage repIm = null;
                    AlbumObjectProperties props = this.getProperties();
                    String imageUrl = (String)props.get("imageURI");
                    if (imageUrl != null) {
                        if (imageUrl.length() > 0) {
                            URI rel = this.getFile().toURI();
                            URI src = rel.resolve(imageUrl);
                            repIm = ImageIO.read(src.toURL());
                        }
                    } else {
                        WebLocation wl = new WebLocation(this.file);
                        repIm = wl.findRepresentingImage();
                        this.setComment(wl.getDescription());
                        this.setTitle(wl.getTitle());
                        if (wl.getImageUrl() != null) {
                            props.put("imageURI", wl.getImageUrl().toExternalForm());
                            props.save();
                        }
                    }
                    if (repIm != null) {
                        ImageIO.write(repIm, "jpeg", cacheFile);
                    }
                }
                catch (IOException ex) {
                    System.err.println(ex);
                }
            } else {
                VideoProcessor vp = this.factory.engine.getVideoProcessor();
                if (vp.isFormatSupported(this.file)) {
                    cacheFile.getParentFile().mkdirs();
                    try {
                        VideoProcessor.VideoInfo vi = vp.createThumbnailFile(this.file, cacheFile, (TimeCode)this.getProperties().get("videoPosition"));
                        Orientation o = vi.orientation;
                        if (cacheFile.exists()) {
                            AlbumObjectProperties props = this.getProperties();
                            if (!props.containsKey("orientation")) {
                                props.put("orientation", (Object)o);
                            }
                            if (vi.duration != null) {
                                props.put("videoDuration", vi.duration);
                            }
                            if (vi.fps != null) {
                                props.put("videoFPS", vi.fps);
                            }
                            if (vi.dim != null) {
                                props.put("videoWidth", vi.dim.width);
                                props.put("videoHeight", vi.dim.height);
                            }
                            props.store();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                        cacheFile.delete();
                    }
                    catch (OperationAbortedException operationAbortedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.getRepresentingAlbumObject() != null) {
            return this.representingAlbumObject.getRepresentingImageFile();
        }
        if (this.isFolder()) {
            return null;
        }
        if (cacheFile.exists()) {
            return cacheFile;
        }
        return null;
    }

    @Override
    public void setRepresentingAlbumObject(AlbumObject rep) {
        try {
            AlbumObject oldRep = this.getRepresentingAlbumObject();
            Map props = this.getFolderProperties();
            this.setRep(null);
            if (rep == null) {
                props.remove("folderIcon");
            } else {
                String path = IO.relativePath(rep.getPathFromRoot(), this.getPathFromRoot());
                if (path.equals(".")) {
                    path = rep.getFile().getAbsolutePath();
                }
                props.put("folderIcon", path);
            }
            this.setFolderProperties(props);
            this.setRep(this.getRepresentingAlbumObject());
            this.updateRepresentingIcon();
            this.firePropertyChange("representingAlbumObject", oldRep, this.representingAlbumObject);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public String getThumbnailPath() {
        AlbumObjectImpl rep = this.getRepObject(true);
        if (rep != null) {
            String pathFromRoot = rep.getPathFromRoot();
            String path = "";
            int slashIndex = pathFromRoot.lastIndexOf(47);
            if (slashIndex == -1) {
                String name = pathFromRoot;
            } else {
                path = pathFromRoot.substring(0, slashIndex);
                String name = pathFromRoot.substring(slashIndex + 1);
            }
            path = IO.combinePaths(path, this.factory.engine.getThumbnailDirectory());
            path = IO.combinePaths(path, this.factory.engine.getTargetThumbName(rep.getFile()));
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attachments getAttachments() {
        Attachments att = this.attachments.get();
        if (att == null) {
            MutableSoft<Attachments> mutableSoft = this.attachments;
            synchronized (mutableSoft) {
                att = this.attachments.get();
                if (att == null) {
                    att = new Attachments(this);
                    this.attachments.set(att);
                }
            }
        }
        return att;
    }

    public static ImageIcon scaleToFit(ImageIcon ii, Dimension boundingBox, boolean enlarge) {
        int width = ii.getIconWidth();
        int height = ii.getIconHeight();
        if (!enlarge && width <= boundingBox.width && height <= boundingBox.height) {
            return ii;
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        BufferedImage scaled = AlbumObjectImpl.ensureBuffered(ii.getImage(), width, height);
        scaled = GraphicsUtilities.getFasterScaledInstance(scaled, newWidth, newHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
        return new ImageIcon(scaled, ii.getDescription());
    }

    public static boolean isResourcesFolder(AlbumObject folder) {
        return folder.getName().equals(folder.getEngine().getResourceDirectory());
    }

    private static BufferedImage ensureBuffered(ImageIcon ii) {
        return AlbumObjectImpl.ensureBuffered(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
    }

    private static BufferedImage ensureBuffered(Image img, int iw, int ih) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi = new BufferedImage(iw, ih, 6);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    public String toString() {
        return "/" + this.getPathFromRoot();
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.getPathFromRoot());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlbumObjectImpl other = (AlbumObjectImpl)obj;
        return this.getPathFromRoot() == other.getPathFromRoot();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(this, propertyName, oldValue, newValue);
    }

    @Override
    public void fireModelChanged() {
        this.firePropertyChange("modelChanged", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getCommentsMap() throws IOException {
        Map<Object, Object> commentsMap;
        Map<Object, Object> map = commentsMap = this.commentsCache != null ? this.commentsCache.get() : null;
        if (commentsMap == null) {
            AlbumObjectImpl albumObjectImpl = this;
            synchronized (albumObjectImpl) {
                Map<Object, Object> map2 = commentsMap = this.commentsCache != null ? this.commentsCache.get() : null;
                if (commentsMap == null) {
                    File commentsFile = ControlFiles.comments(this.file);
                    commentsMap = commentsFile.exists() ? IO.readMapFile(ControlFiles.comments(this.file)) : new HashMap<String, String>();
                    this.commentsCache = new SoftReference<Map>(commentsMap);
                }
            }
        }
        return commentsMap;
    }

    private void storeCommentsMap() throws IOException {
        File commentsFile = ControlFiles.comments(this.file);
        commentsFile.getParentFile().mkdir();
        IO.writeMapFile(this.getCommentsMap(), commentsFile);
        this.markAsClean();
    }

    String getTextFileComment(String childName) throws IOException {
        return this.getCommentsMap().get(childName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setTextFileComment(String comment, AlbumObjectImpl oldParent, AlbumObjectImpl newParent, String oldChildName, String newChildName) {
        try {
            Map<String, String> commentsMap;
            if (!newParent.getFile().equals(oldParent.getFile())) {
                Map<String, String> map = oldParent.getCommentsMap();
                synchronized (map) {
                    oldParent.getCommentsMap().remove(oldChildName);
                    oldParent.storeCommentsMap();
                }
            }
            Map<String, String> map = commentsMap = newParent.getCommentsMap();
            synchronized (map) {
                if (!newChildName.equals(oldChildName)) {
                    commentsMap.remove(oldChildName);
                }
                if (comment != null) {
                    commentsMap.put(newChildName, comment);
                } else {
                    commentsMap.remove(newChildName);
                }
                newParent.storeCommentsMap();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setTextFileComment(String comment, AlbumObjectImpl newParent, String newChildName) throws IOException {
        Map<String, String> commentsMap;
        Map<String, String> map = commentsMap = newParent.getCommentsMap();
        synchronized (map) {
            if (comment != null) {
                commentsMap.put(newChildName, comment);
            } else {
                commentsMap.remove(newChildName);
            }
            newParent.storeCommentsMap();
        }
    }

    Map getFolderProperties() throws IOException {
        if (this.folderProperties == null) {
            this.folderProperties = AlbumBean.getFolderProperties(this.file);
        }
        return this.folderProperties;
    }

    void setFolderProperties(Map properties) throws IOException {
        this.getChildren();
        ControlFiles.meta(this.file).getParentFile().mkdir();
        Map onDisk = AlbumBean.getFolderProperties(this.file);
        if (!properties.equals(onDisk)) {
            IO.writeMapFile(properties, ControlFiles.meta(this.file));
        }
        this.markAsClean();
        this.folderProperties = properties;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor element : flavors) {
            if (!flavor.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(flavors[0])) {
            return this;
        }
        if (flavor.equals(flavors[1])) {
            return new File[]{this.file};
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void setRepresentingIcon(BufferedImage thumbnail, boolean changed) throws IOException {
        if (this.factory.isCacheThumbnails()) {
            File thumbnailFile = this.getCachedThumbnailFile(this.file);
            thumbnailFile.getParentFile().mkdirs();
            FileFilters.saveJPEG(thumbnail, thumbnailFile, this.factory.engine);
            this.thumbCache.clear();
        }
        if (changed) {
            this.firePropertyChange("imageUpdated", null, null);
        }
    }

    @Override
    public void updateRepresentingIcon() {
        this.thumbCache.clear();
        this.firePropertyChange("imageUpdated", null, null);
    }

    static File getCacheFolder(File f) {
        return new File(AlbumObjectImpl.getJalbumFolder(f), CACHE_FOLDER);
    }

    private File getCachedThumbnailFile(File f) {
        return new File(AlbumObjectImpl.getCacheFolder(f), this.factory.engine.getTargetThumbName(f, "jpg"));
    }

    static File getAlbumParentFile(File f) {
        return f instanceof LinkFile ? ((LinkFile)f).getLink().getParentFile() : f.getParentFile();
    }

    public static File getJalbumFolder(File f) {
        return new File(AlbumObjectImpl.getAlbumParentFile(f), JALBUM_FOLDER_NAME);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.factory = JAlbumContext.getInstance().getAlbumObjectfactory();
        this.orderer = new AlbumObjectOrderer(this);
        this.thumbCache = new ThumbCache();
    }

    Scope peekVars() {
        return this.vars;
    }

    @Override
    public Scope getVars() {
        if (this.vars == null) {
            try {
                AlbumBean engine = this.factory.engine;
                if (this.isFolder.booleanValue()) {
                    String pathFromRoot = this.parent != null ? this.parent.getPathFromRoot() : "";
                    engine.registerVariables(this, new File(engine.getOutputDir(), pathFromRoot), true);
                } else {
                    if (NO_FILE.equals(this.file)) {
                        return new Scope(engine.globalVariables).name("Album Object");
                    }
                    String pathFromRoot = "";
                    if (this.getParent() != null) {
                        pathFromRoot = this.getParent().getPathFromRoot();
                    }
                    engine.registerVariables(this, new File(engine.getOutputDir(), pathFromRoot), true);
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Cannot register variables for " + this.getName(), ex);
            }
            catch (ScriptException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.vars;
    }

    @Override
    public void setVars(Scope vars) {
        this.vars = vars;
    }

    static class ThumbCache {
        ImageIcon icon;
        Dimension bounds;
        boolean cropToBounds;

        ThumbCache() {
        }

        void update(ImageIcon icon, Dimension bounds, boolean cropToBounds) {
            this.icon = icon;
            this.bounds = bounds;
            this.cropToBounds = cropToBounds;
        }

        ImageIcon getIcon(Dimension bounds, boolean cropToBounds) {
            if (this.icon != null && this.bounds.equals(bounds) && this.cropToBounds == cropToBounds) {
                return this.icon;
            }
            return null;
        }

        void clear() {
            this.icon = null;
        }
    }

    protected static class VisitorContext {
        public final boolean force;
        public final HashSet<AlbumObject> visited = new HashSet();

        public VisitorContext(boolean force) {
            this.force = force;
        }

        public boolean checkVisit(AlbumObjectImpl ao) {
            if (this.visited.contains(ao)) {
                System.err.println("Circular folder link detected when entering " + String.valueOf(ao));
                return false;
            }
            this.visited.add(ao);
            return true;
        }
    }
}

