/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import net.jalbum.undo.UndoHandler;
import net.jalbum.undo.UndoNotifier;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumFileFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFilter;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.FileAlbumObject;
import se.datadosen.jalbum.FileNamerContext;
import se.datadosen.jalbum.ViewAlbumObject;

public class AlbumObjectFactory
implements Serializable,
PropertyChangeListener {
    AlbumBean engine;
    protected AlbumFileFilter fileFilter;
    protected AlbumObjectFilter filter = AlbumObjectFilter.NO_FILTER;
    private boolean cacheThumbnails = true;
    private boolean includeExcluded = true;
    private boolean includeMissing = true;
    private boolean cached = false;
    private boolean forAlbumMaking = false;
    private boolean ignoreOrdering = false;
    private UndoNotifier undoNotifier = UndoHandler.getDummyNotifier();

    public AlbumObjectFactory(AlbumBean engine) {
        this.engine = engine;
        engine.addPropertyChangeListener("directory", this);
    }

    public AlbumObject createInstance(File file) {
        return this.createInstance(file, (AlbumObject)null);
    }

    public AlbumObject createInstance(File file, FileNamerContext context) {
        return this.createInstance(file, context.getFolder());
    }

    public AlbumObject createInstance(File file, AlbumObject parent) {
        AlbumObjectImpl ao;
        if (this.isForAlbumMaking() && file instanceof LinkFile && ((LinkFile)file).isDynamic()) {
            file = ((LinkFile)file).getResolvedLink(this.engine);
        }
        if ((ao = FileAlbumObject.createInstance(file, parent, this)).getFile().isDirectory() && !ao.isLink() && ao.isView()) {
            ao = new ViewAlbumObject(file, parent, this);
        }
        return ao;
    }

    public boolean isCacheThumbnails() {
        return this.cacheThumbnails;
    }

    public void setCacheThumbnails(boolean cacheThumbnails) {
        this.cacheThumbnails = cacheThumbnails;
    }

    public boolean isIncludeExcluded() {
        return this.includeExcluded;
    }

    public void setIncludeExcluded(boolean includeExcluded) {
        this.includeExcluded = includeExcluded;
    }

    public boolean isIncludeMissing() {
        return this.includeMissing;
    }

    public void setIncludeMissing(boolean includeMissing) {
        this.includeMissing = includeMissing;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isForAlbumMaking() {
        return this.forAlbumMaking;
    }

    void setForAlbumMaking(boolean forAlbumMaking) {
        this.forAlbumMaking = forAlbumMaking;
    }

    public boolean isIgnoreOrdering() {
        return this.ignoreOrdering;
    }

    public void setIgnoreOrdering(boolean ignoreOrdering) {
        this.ignoreOrdering = ignoreOrdering;
    }

    public AlbumFileFilter getFileFilter() {
        if (this.fileFilter == null) {
            this.fileFilter = new AlbumFileFilter(this.engine);
        }
        return this.fileFilter;
    }

    public AlbumObjectFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AlbumObjectFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter may not be null");
        }
        this.filter = filter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fileFilter = null;
    }

    public UndoNotifier getUndoNotifier() {
        return this.undoNotifier;
    }

    public void setUndoNotifier(UndoNotifier undoNotifier) {
        this.undoNotifier = undoNotifier;
    }

    Object getEngine() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

