/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.jalbum.ObjectException;
import net.jalbum.filterManager.FilterPipeline;
import net.jalbum.filters.ColorProfileFilter;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.GenericRotationSupport;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.util.FileFilters;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.Scope;

public class AlbumImage {
    static final Dimension OUTER_BOUNDS = new Dimension(4000, 2000);
    final BufferedImage im;
    protected ColorModel colorModel;
    final File file;
    final int stage;
    final AlbumBean engine;
    AlbumObject ao;

    public AlbumImage(BufferedImage image, AlbumBean engine) {
        this.file = null;
        this.im = image;
        this.engine = engine;
        this.stage = 1;
    }

    public AlbumImage(AlbumObject ao) throws IOException {
        this.ao = ao;
        this.file = ao.getRepresentingImageFile();
        if (this.file == null || !this.file.exists()) {
            throw new IOException("AlbumObject " + String.valueOf(ao) + " can't be represented as an image");
        }
        int scale = FileFilters.calculateSubsamplingByScale(ao.getImageInfo(), OUTER_BOUNDS);
        BufferedImage bi = FileFilters.loadImage(this.file, scale, null, FileFilters.ReaderFlag.DONT_APPLY_COLOR_PROFILE);
        this.colorModel = bi.getColorModel();
        if (this.colorModel.getColorSpace().isCS_sRGB()) {
            this.colorModel = null;
        }
        this.engine = ao.getEngine();
        this.stage = 1;
        this.im = bi = GenericRotationSupport.adjustOrientation(bi, ao);
    }

    public AlbumImage(File imageFile, AlbumBean engine) throws IOException {
        this.file = imageFile;
        BufferedImage bi = FileFilters.loadImage(imageFile, engine);
        this.engine = engine;
        this.stage = 1;
        this.im = RotationSupport.adjustOrientation(bi, imageFile);
    }

    protected AlbumImage(AlbumObject ao, File file, BufferedImage im, ColorModel colorModel, int stage, AlbumBean engine) {
        this.ao = ao;
        this.file = file;
        this.im = im;
        this.colorModel = colorModel;
        this.stage = stage;
        this.engine = engine;
    }

    AlbumImage scaleToFit(Dimension dim, float sharpenAmount) {
        return new AlbumImage(this.ao, this.file, this.applyColorProfile(this.engine.scaleToFit(this.im, dim, this.engine.getScalingMethod(), sharpenAmount)), this.colorModel, this.stage, this.engine);
    }

    public AlbumImage scaleToFit(Dimension dim) {
        try {
            return new AlbumImage(this.ao, this.file, this.applyColorProfile(this.engine.scaleToFit(this.im, dim, this.engine.getScalingMethod())), this.colorModel, this.stage, this.engine);
        }
        catch (RuntimeException ex) {
            throw new ObjectException(this.ao, (Throwable)ex);
        }
    }

    protected AlbumImage scaleToFit(Dimension dim, int stage) {
        String scaleMethod = stage == 2 && this.engine.highQualityThumbs ? "ScaleSmooth" : this.engine.getScalingMethod();
        switch (stage) {
            case 2: 
            case 3: {
                dim = AlbumBean.getScaledDim(dim, this.engine.getImageScale());
                break;
            }
            case 4: 
            case 5: {
                dim = AlbumBean.getScaledDim(dim, this.engine.getThumbScale());
            }
        }
        return new AlbumImage(this.ao, this.file, this.applyColorProfile(this.engine.scaleToFit(this.im, dim, scaleMethod)), this.colorModel, stage, this.engine);
    }

    public AlbumImage scaleToThumbnail() {
        return this.scaleToFit(this.engine.thumbDim, 4);
    }

    public AlbumImage scaleToCloseup() {
        return this.scaleToFit(this.engine.imageDim, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlbumImage applyFilter(JAFilter filter, Map vars) {
        JAFilter jAFilter = filter;
        synchronized (jAFilter) {
            return new AlbumImage(this.ao, this.file, filter.filter(GraphicsUtilities.duplicate(this.im), vars), this.colorModel, this.stage, this.engine);
        }
    }

    public AlbumImage applyFilter(JAFilter filter) {
        Map<String, Object> vars = this.ao != null ? this.ao.getVars() : new HashMap();
        return this.applyFilter(filter, vars);
    }

    private BufferedImage applyColorProfile(BufferedImage bi) {
        ColorModel tmpModel = this.colorModel;
        this.colorModel = null;
        return new ColorProfileFilter().filter(tmpModel, bi, null);
    }

    public AlbumImage applyFilters(int stage) {
        Scope vars = new Scope();
        FilterPipeline filterPipeline = null;
        if (this.file != null) {
            AlbumObject ao = this.engine.getFactory().createInstance(this.file);
            filterPipeline = new FilterPipeline(ao);
        }
        return new AlbumImage(this.ao, this.file, this.engine.processFilters(filterPipeline, this.im, this.ao, vars, stage), this.colorModel, stage, this.engine);
    }

    public AlbumImage applyFilters() {
        return this.applyFilters(this.stage);
    }

    public Image getImage() {
        return this.im;
    }

    public BufferedImage getBufferedImage() {
        return this.im;
    }

    @Deprecated
    public AlbumImage saveJPEG(File output, int qualityPercent) throws IOException {
        return this.saveImage(output, qualityPercent);
    }

    public AlbumImage saveImage(File output, int qualityPercent) throws IOException {
        if (output.isDirectory()) {
            output = new File(output, this.file.getName());
        }
        FileFilters.saveJPEG(this.im, output, this.engine, null, (float)qualityPercent / 100.0f);
        return this;
    }

    @Deprecated
    public AlbumImage saveJPEG(File output) throws IOException {
        return this.saveImage(output);
    }

    public AlbumImage saveImage(File output) throws IOException {
        return this.saveJPEG(output, this.engine.getQualityPercent());
    }
}

