/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.util.FileFilters;

public class AlbumFileFilter
implements FileFilter,
Serializable {
    private File outputDir;
    private Set ignoreDirs = new HashSet();
    private Pattern ignorePattern;
    private Pattern includePattern;
    String pageExtension;
    private boolean ignoreControlFiles = true;
    private String resDirName;
    private boolean resDir;
    private AlbumBean engine;

    public boolean isIgnoreControlFiles() {
        return this.ignoreControlFiles;
    }

    public void setIgnoreControlFiles(boolean ignoreControlFiles) {
        this.ignoreControlFiles = ignoreControlFiles;
    }

    public Set<String> getIgnoreDirs() {
        return this.ignoreDirs;
    }

    public AlbumFileFilter(AlbumBean engine) {
        this(engine, engine.getOutputDir(), engine.getIgnorePattern());
        PropertyChangeListener listener = pce -> {
            this.outputDir = engine.getOutputDir();
        };
        engine.addPropertyChangeListener("directory", listener);
        engine.addPropertyChangeListener("outputDirectory", listener);
    }

    public AlbumFileFilter(AlbumBean engine, File outputDir, String ignorePattern) {
        this.engine = engine;
        this.pageExtension = engine.getPageExtension();
        if (this.pageExtension.length() == 0) {
            this.pageExtension = ".html";
        }
        if (outputDir != null) {
            if ("".equals(engine.getDirectory())) {
                outputDir = new File(outputDir.getName());
            }
            this.outputDir = outputDir;
            this.resDirName = engine.getResourceDirectory();
            this.ignoreDirs.add(this.resDirName.toLowerCase());
            this.ignoreDirs.add("gifs".toLowerCase());
            this.ignoreDirs.add(engine.getThumbnailDirectory().toLowerCase());
            this.ignoreDirs.add(engine.getSlideDirectory().toLowerCase());
            this.ignoreDirs.add("hi-res");
        }
        this.ignorePattern = Pattern.compile(ignorePattern, 2);
        String ip = engine.getIncludePattern();
        if (ip != null && ip.length() > 0) {
            this.includePattern = Pattern.compile(engine.getIncludePattern(), 2);
        }
    }

    @Override
    public boolean accept(File file) {
        boolean hasDot;
        String name = file.getName();
        Matcher m = this.ignorePattern.matcher(name);
        if (name.endsWith(".jap") || name.endsWith(".properties") || name.endsWith(".info") || name.equals(".jalbum") || name.equals("albumfiles.txt")) {
            return !this.ignoreControlFiles;
        }
        if (m.matches() || !this.resDir && name.endsWith(this.pageExtension)) {
            return false;
        }
        boolean bl = hasDot = name.indexOf(46) != -1;
        if (file.isDirectory() || !hasDot && !file.exists()) {
            if (this.outputDir != null) {
                if (!this.outputDir.isAbsolute() && name.equals(this.outputDir.getName())) {
                    return false;
                }
                if (this.ignoreDirs.contains(name.toLowerCase()) || file.equals(this.outputDir)) {
                    return false;
                }
            }
            return true;
        }
        if (!hasDot) {
            return false;
        }
        if (this.includePattern != null) {
            Matcher includeMatcher = this.includePattern.matcher(name);
            return includeMatcher.matches();
        }
        if (this.resDir || !file.exists() || FileFilters.isFileSupported(file)) {
            return true;
        }
        return FileFilters.hasIcon(file);
    }

    public boolean isResDir() {
        return this.resDir;
    }

    public AlbumFileFilter setResDir(boolean resDir) {
        this.resDir = resDir;
        return this;
    }
}

