/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.ScriptEnginePool;
import se.datadosen.jalbum.ScriptLanguage;
import se.datadosen.util.Scope;

public class ASTEvaluator {
    private final AlbumBean albumEngine;
    private Scope currentScope = new Scope();
    private Scope currentFolderScope;
    private int row;
    private ScriptLanguage scriptLanguage = null;
    private ScriptEngine se;

    public ASTEvaluator(AlbumBean albumBean, ScriptLanguage sl) {
        this.albumEngine = albumBean;
        this.setScriptLanguage(sl);
    }

    public ASTEvaluator(AlbumBean albumBean, Scope scope) {
        this.albumEngine = albumBean;
        this.setScope(scope);
    }

    public void enterScope(Scope scope) {
        this.currentScope = this.currentScope == null ? scope : this.currentScope.push(scope.getMap());
        AlbumBean.pushVars(scope, this.getScriptEngine());
    }

    public Scope exitScope(Scope scope) {
        if (this.currentScope.getMap() != scope.getMap()) {
            System.err.println("Not exiting same scope as last entered: " + scope.getName() + " vs " + this.currentScope.getName());
        }
        this.currentScope = AlbumBean.popVars(this.currentScope, this.getScriptEngine());
        if (this.currentScope == null) {
            throw new RuntimeException("currentScope is null");
        }
        return this.currentScope;
    }

    public void reset() {
        Bindings bindings = this.getScriptEngine().getBindings(100);
        for (String name : this.currentScope.keySet()) {
            if (name.indexOf(46) != -1) continue;
            bindings.remove(name);
        }
        this.currentScope.clear();
    }

    private void setScope(Scope scope) {
        this.enterScope(scope);
    }

    public Scope getScope() {
        return this.currentScope;
    }

    void setCurrentFolderScope(Scope currentFolderScope) {
        this.currentFolderScope = currentFolderScope;
    }

    public Scope getCurrentFolderScope() {
        return this.currentFolderScope;
    }

    public AlbumBean getAlbumEngine() {
        return this.albumEngine;
    }

    public Object getUsing() {
        return this.albumEngine.using;
    }

    public ScriptEngine getScriptEngine() {
        if (this.se == null) {
            this.se = this.albumEngine.scriptEnginePool.get(this.getScriptLanguage());
            return this.se;
        }
        return this.se;
    }

    public void setScriptLanguage(ScriptLanguage sr) {
        this.scriptLanguage = sr;
        this.se = null;
    }

    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage != null ? this.scriptLanguage : this.albumEngine.getScriptLanguage();
    }

    public boolean exists(String name) {
        Object val = this.getVar(name);
        if (val == null) {
            return false;
        }
        if (!(val instanceof String) && !(val instanceof StringBuilder)) {
            return true;
        }
        return val.toString().length() > 0;
    }

    public Object getVar(String name) {
        return ScriptEnginePool.getVar(name, this.getScriptEngine());
    }

    public <T> T getVar(String name, T defaultValue) {
        Object val = this.getVar(name);
        if (val == null) {
            val = defaultValue;
        }
        return (T)val;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }
}

