/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;

public class WaveRecodingOutputStream
extends OutputStream {
    private final OutputStream out;

    public WaveRecodingOutputStream(AudioFormat inputFormat, AudioFormat outputFormat, OutputStream out) {
        this.out = inputFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && outputFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && inputFormat.getSampleSizeInBits() == 8 ? new UnsignedToSigned8BitOutputStream(out) : out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    private static class UnsignedToSigned8BitOutputStream
    extends OutputStream {
        private final OutputStream out;

        public UnsignedToSigned8BitOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b & 0x7F);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            for (int i = off; i < off + len; ++i) {
                b[i] = (byte)((b[i] & 0xFF) - 128);
            }
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }
    }
}

