/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.IOException;
import java.io.OutputStream;

public class SkipBytesOutputStream
extends OutputStream {
    private OutputStream out;
    int bytesToSkip;

    public SkipBytesOutputStream(OutputStream out, int bytesToSkip) {
        this.out = out;
        this.bytesToSkip = bytesToSkip;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long skipNow = Math.min(len, this.bytesToSkip);
        this.bytesToSkip = (int)((long)this.bytesToSkip - skipNow);
        off = (int)((long)off + skipNow);
        if ((len = (int)((long)len - skipNow)) > 0) {
            this.out.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bytesToSkip == 0) {
            this.out.write(b);
        } else {
            --this.bytesToSkip;
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    private void log(byte[] b, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            System.out.print(b[i]);
            System.out.print(", ");
            if (i % 16 != 0) continue;
            System.out.println("");
        }
    }
}

