/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import se.datadosen.util.Replacer;

public class ReplacingReader
extends Reader
implements Closeable,
AutoCloseable,
Readable {
    private BufferedReader input;
    private final Replacer replacer = new Replacer();
    private char[] buf;
    private int bufPos;

    public ReplacingReader(Map<String, String> mapping, Reader input) throws IOException {
        this.input = new BufferedReader(input);
        for (Map.Entry<String, String> e : mapping.entrySet()) {
            this.replacer.add(e.getKey(), e.getValue());
        }
    }

    public ReplacingReader(Reader input) throws IOException {
        this.input = new BufferedReader(input);
    }

    public ReplacingReader(String search, String replace, Reader input) throws IOException {
        this.input = new BufferedReader(input);
        this.replacer.add(search, replace);
    }

    public ReplacingReader replace(String search, String replace) {
        this.replacer.add(search, replace);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.buf == null) {
            String line = this.input.readLine();
            if (line == null) {
                return -1;
            }
            line = this.replacer.replace(line);
            char[] tmpBuf = line.toCharArray();
            this.buf = new char[tmpBuf.length + 1];
            System.arraycopy(tmpBuf, 0, this.buf, 0, tmpBuf.length);
            this.buf[this.buf.length - 1] = 10;
            this.bufPos = 0;
        }
        int count = Math.min(len, this.buf.length - this.bufPos);
        System.arraycopy(this.buf, this.bufPos, cbuf, off, count);
        this.bufPos += count;
        if (this.bufPos == this.buf.length) {
            this.buf = null;
            this.bufPos = 0;
        }
        return count;
    }
}

