/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import se.datadosen.io.CachedFile;
import se.datadosen.io.CachedLinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.util.IO;

public class LinkFile
extends File {
    protected File link;
    protected File target;

    public LinkFile(File parent, String name, File target) {
        super(target.isAbsolute() || LinkFile.isDynamic(target) ? LinkFile.targetOf(target).getParentFile() : IO.resolvePath(parent, LinkFile.targetOf(target).getParent()), LinkFile.targetOf(target).getName());
        this.link = new File(parent, name);
        this.target = LinkFile.targetOf(target);
    }

    public static File targetOf(File f) {
        if (f instanceof LinkFile) {
            f = ((LinkFile)f).getTarget();
        }
        return f;
    }

    public static File linkOf(File f) {
        if (f instanceof LinkFile) {
            f = ((LinkFile)f).getLink();
        }
        return f;
    }

    @Override
    public String getName() {
        return this.link.getName();
    }

    @Override
    public File getParentFile() {
        return this.link.getParentFile();
    }

    @Override
    public String getParent() {
        return this.link.getParent();
    }

    public String getTargetName() {
        return super.getName();
    }

    @Override
    public boolean isAbsolute() {
        return this.target.isAbsolute();
    }

    @Override
    public File getAbsoluteFile() {
        if (this.isDynamic()) {
            throw new IllegalStateException("Not allowed for dynamic links. Use getResolvedTaget()");
        }
        return super.getAbsoluteFile();
    }

    @Override
    public int compareTo(File other) {
        File f = other;
        if (other instanceof LinkFile) {
            f = ((LinkFile)other).getLink();
        }
        return this.link.compareTo(f);
    }

    @Override
    public int hashCode() {
        return this.link.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof LinkFile && this.compareTo((File)obj) == 0;
    }

    @Override
    public boolean renameTo(File dest) {
        return true;
    }

    public boolean renameTargetTo(File dest) {
        return super.renameTo(dest);
    }

    public File getLink() {
        return this.link;
    }

    public File getTarget() {
        return this.target;
    }

    @Override
    public String toString() {
        return this.link.toString() + " -> " + this.target.toString();
    }

    public String serializeTarget() {
        return this.target.toString();
    }

    public boolean isDynamic() {
        return LinkFile.isDynamic(this.target);
    }

    private static boolean isDynamic(File target) {
        return target.toString().startsWith("$");
    }

    public boolean exists(AlbumBean engine) {
        return this.getResolvedTarget(engine).exists();
    }

    public File getResolvedTarget(AlbumBean engine) {
        return new File(this.target.toString().replace("$SKIN_TEMPLATES_DIR", new File(Config.getConfig().chainedSkinsDir.getFile(engine.getSkin()), "templates").getAbsolutePath()));
    }

    public LinkFile getResolvedLink(AlbumBean engine) {
        File resolvedTarget = this.getResolvedTarget(engine);
        return new LinkFile(this.link.getParentFile(), this.link.getName(), resolvedTarget);
    }

    public static File getResolvedTarget(File f, AlbumBean engine) {
        if (f instanceof LinkFile && ((LinkFile)f).isDynamic()) {
            return ((LinkFile)f).getResolvedTarget(engine);
        }
        return f;
    }

    public static File getResolvedTarget(AlbumObject ao) {
        return LinkFile.getResolvedTarget(ao.getFile(), ao.getEngine());
    }

    public static boolean exists(File f, AlbumBean engine) {
        return LinkFile.getResolvedTarget(f, engine).exists();
    }

    public static File create(File parent, String name, File target) {
        if (target instanceof CachedFile) {
            return new CachedLinkFile(parent, name, (CachedFile)target);
        }
        return new LinkFile(parent, name, target);
    }
}

