/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import se.datadosen.io.Cached;
import se.datadosen.io.CachedFileSupport;

public class CachedFile
extends File
implements Cached {
    private Boolean directory;
    private Boolean symbolicLink;
    private Long lastMod;
    private Long length;
    private Boolean exists;
    private boolean cacheing = true;

    public CachedFile(File parent, String child) {
        super(parent, child);
    }

    public CachedFile(String parent, String child) {
        super(parent, child);
    }

    public CachedFile(String pathname) {
        super(pathname);
    }

    public CachedFile(File f) {
        super(f.getParentFile(), f.getName());
    }

    CachedFile(File f, boolean directory, boolean symbolicLink, long lastMod, long length) {
        super(f.getParentFile(), f.getName());
        this.directory = directory;
        this.lastMod = lastMod;
        this.length = length;
        this.exists = true;
    }

    public void clear() {
        this.directory = null;
        this.symbolicLink = null;
        this.lastMod = null;
        this.length = null;
        this.exists = null;
    }

    @Override
    public boolean isCacheing() {
        return this.cacheing;
    }

    @Override
    public void setCacheing(boolean cacheing) {
        this.cacheing = cacheing;
    }

    @Override
    public boolean isDirectory() {
        if (this.directory == null) {
            this.directory = super.isDirectory();
        }
        return this.directory;
    }

    public boolean isSymbolicLink() {
        if (this.symbolicLink == null) {
            this.symbolicLink = CachedFileSupport.isSymbolicLink(this);
        }
        return this.symbolicLink;
    }

    @Override
    public long lastModified() {
        if (!this.cacheing) {
            return super.lastModified();
        }
        if (this.lastMod == null) {
            this.lastMod = super.lastModified();
        }
        return this.lastMod;
    }

    @Override
    public boolean setLastModified(long time) {
        boolean ok = super.setLastModified(time);
        if (ok) {
            this.lastMod = time;
        }
        return ok;
    }

    @Override
    public long length() {
        if (!this.cacheing) {
            return super.length();
        }
        if (this.length == null) {
            this.length = super.length();
        }
        return this.length;
    }

    @Override
    public boolean exists() {
        if (!this.cacheing) {
            return super.exists();
        }
        if (this.exists == null) {
            this.exists = super.exists();
        }
        return this.exists;
    }

    @Override
    public File toFile() {
        return new File(this.getParentFile(), this.getName());
    }

    public CachedFile[] listFiles() {
        return CachedFile.listFiles(this);
    }

    public CachedFile[] listFiles(FileFilter filter) {
        return CachedFile.listFiles(this, filter);
    }

    public static CachedFile[] listFiles(File dir) {
        return CachedFile.listFiles(dir, null);
    }

    public static CachedFile[] listFiles(File file, FileFilter filter) {
        try {
            return CachedFile.filter(CachedFileSupport.listContent(file), filter);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public CachedFile[] listContent() throws IOException {
        return CachedFile.listContent(this);
    }

    public CachedFile[] listContent(FileFilter filter) throws IOException {
        return CachedFile.listContent(this, filter);
    }

    public static CachedFile[] listContent(File dir) throws IOException {
        return CachedFile.listContent(dir, null);
    }

    public static CachedFile[] listContent(File file, FileFilter filter) throws IOException {
        return CachedFile.filter(CachedFileSupport.listContent(file), filter);
    }

    public static TreeMap<String, CachedFile> map(File dir) {
        TreeMap<String, CachedFile> theMap = new TreeMap<String, CachedFile>();
        CachedFile[] contents = CachedFile.listFiles(dir);
        if (contents != null) {
            for (CachedFile f : contents) {
                theMap.put(f.getName(), f);
            }
        }
        return theMap;
    }

    private File[] standardListFiles() {
        return super.listFiles();
    }

    public static CachedFile[] filter(File[] allFiles, FileFilter filter) {
        if (allFiles == null) {
            return null;
        }
        if (filter == null && allFiles instanceof CachedFile[]) {
            return (CachedFile[])allFiles;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File f : allFiles) {
            if (filter != null && !filter.accept(f)) continue;
            files.add(f);
        }
        return files.toArray(new CachedFile[files.size()]);
    }
}

