/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.imaging.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import se.datadosen.imaging.exif.TagFormatter;
import se.datadosen.jalbum.Cameras;
import se.datadosen.util.FormattedDate;
import se.datadosen.util.SafeSimpleDateFormat;

public class ImageInfoFormatter
implements Serializable {
    protected static TagFormatter meterFormatter = (exif, data) -> {
        Number distance = (Number)data;
        return distance.floatValue() + "m";
    };
    protected static TagFormatter millimeterFormatter = (exif, data) -> {
        Number distance = (Number)data;
        return Math.round(distance.floatValue()) + "mm";
    };
    protected static TagFormatter floatFormatter = (exif, data) -> {
        Rational r;
        if (data instanceof String) {
            return Float.valueOf(Float.parseFloat((String)data));
        }
        if (data instanceof Rational[]) {
            Rational[] rarr = (Rational[])data;
            r = rarr[0];
        } else {
            r = (Rational)data;
        }
        return Float.valueOf(r.floatValue());
    };
    protected static TagFormatter commentFormatter = (exif, data) -> String.valueOf(data);
    protected static TagFormatter secondFormatter = (exif, data) -> {
        if (!(data instanceof Rational) && data instanceof Number) {
            return String.valueOf(data) + "s";
        }
        Rational time = (Rational)data;
        Rational normalisedTime = time.getNumerator() < time.getDenominator() ? new Rational(1L, time.getDenominator() / time.getNumerator()) : new Rational(time.getNumerator() / time.getDenominator(), 1L);
        if (time.floatValue() < 0.3f) {
            return normalisedTime.toString() + "s";
        }
        return time.floatValue() + "s";
    };
    private Metadata metadata;
    private HashMap ruleMap = new HashMap();
    private DateFormat dateFormat;
    protected TagFormatter dateFormatter = new TagFormatter(){

        @Override
        public Object format(ExifSubIFDDirectory exif, Object data) {
            String dateString = data.toString();
            Date d = ImageInfoFormatter.parseExifDate(dateString);
            if (d != null) {
                return new FormattedDate(d, ImageInfoFormatter.this.dateFormat);
            }
            return dateString;
        }
    };
    private static DateFormat[] dateFormats;

    public ImageInfoFormatter() {
        this(null);
    }

    public ImageInfoFormatter(Metadata info) {
        this.metadata = info;
        this.put(36867, this.dateFormatter);
        this.put(36868, this.dateFormatter);
        this.put(37382, meterFormatter);
        this.put(37381, floatFormatter);
        this.put(37378, floatFormatter);
        this.put(33434, secondFormatter);
        this.put(37377, floatFormatter);
        this.put(37386, millimeterFormatter);
        this.put(33437, floatFormatter);
        this.put(37510, commentFormatter);
        this.put(37383, (exif, data) -> {
            switch ((Integer)data) {
                case 2: {
                    return "Center-weighted averaging";
                }
                case 3: {
                    return "Spot";
                }
                case 5: {
                    return "Evaluative";
                }
            }
            return data.toString();
        });
        this.put(41495, (exif, data) -> {
            switch (((Number)data).intValue()) {
                case 0: {
                    return "Undefined";
                }
                case 1: {
                    return "MonochromeArea";
                }
                case 2: {
                    return "OneChipColorArea";
                }
                case 3: {
                    return "TwoChipColorArea";
                }
                case 4: {
                    return "ThreeChipColorArea";
                }
                case 5: {
                    return "ColorSequentialArea";
                }
                case 6: {
                    return "MonochromeLinear";
                }
                case 7: {
                    return "ColorSequentialLinear";
                }
            }
            return data.toString();
        });
        this.put(41486, floatFormatter);
        this.put(41487, floatFormatter);
        this.put(41488, (exif, data) -> {
            switch ((Integer)data) {
                case 1: {
                    return "Inch";
                }
                case 2: {
                    return "Meter";
                }
                case 3: {
                    return "Centimeter";
                }
                case 4: {
                    return "Millimeter";
                }
                case 5: {
                    return "Micrometer";
                }
            }
            return data.toString();
        });
    }

    public void setDateFormat(DateFormat df) {
        this.dateFormat = df;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Deprecated
    public void setMetadata(Metadata info) {
        this.metadata = info;
    }

    public static synchronized Date parseExifDate(String exifDate) {
        for (DateFormat parser : dateFormats) {
            try {
                Date d = parser.parse(exifDate);
                if (d.getTime() < -60000000000000L) {
                    return null;
                }
                return d;
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public void put(int tagType, TagFormatter tf) {
        this.ruleMap.put(tagType, tf);
    }

    @Deprecated
    public Object format(Object data, int tagType) throws MetadataException {
        return this.format((ExifSubIFDDirectory)this.metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class), data, tagType);
    }

    public Object format(ExifSubIFDDirectory exif, Object data, int tagType) throws MetadataException {
        try {
            if (data == null && tagType != 41989) {
                return "";
            }
            TagFormatter tf = (TagFormatter)this.ruleMap.get(tagType);
            if (tf != null) {
                return tf.format(exif, data);
            }
            if (data != null && data.getClass().isArray()) {
                return Array.get(data, 0);
            }
            return data;
        }
        catch (ArithmeticException ex) {
            return "N/A";
        }
    }

    public String format35mmEq(ExifIFD0Directory ifd0Dir, ExifSubIFDDirectory dir) throws MetadataException {
        Object data;
        if (ifd0Dir != null) {
            Rational distance = dir.getRational(37386);
            Cameras cameras = Cameras.getInstance();
            Double multiplier = cameras.getFocalLengthMultiplier(ifd0Dir.getString(271), ifd0Dir.getString(272));
            if (multiplier != null && distance != null) {
                double eq = (double)distance.floatValue() * multiplier;
                return Math.round(eq) + "mm";
            }
        }
        if ((data = dir.getObject(41989)) instanceof Integer) {
            return String.valueOf(data) + "mm";
        }
        return null;
    }

    @Deprecated
    public Object format(int tagType) throws MetadataException {
        return this.format((ExifSubIFDDirectory)this.metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class), tagType);
    }

    public Object format(ExifSubIFDDirectory dir, int tagType) throws MetadataException {
        Object data = dir.getObject(tagType);
        return this.format(dir, data, tagType);
    }

    public static void main(String[] args) throws Exception {
    }

    static {
        String[] patterns = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "dd-MM-yyyy HH:mm:ss", "dd-MM-yy HH:mm:ss", "dd-MM-yyyy", "dd/MM/yyyy HH:mm:ss", "dd/MM/yyyy", "dd.MM.yyyy", "dd.MM.yy HH:mm", "yyyyMMdd HHmmss", "yyyyMMdd HHmm", "MM/dd/yy hh:mm a", "HH:mm:ss dd.MM.yyyy", "yyyy:MM:dd", "yyyy-MM-dd", "dd.MM.yy", "yyyyMMdd", "MM/dd/yy"};
        dateFormats = new DateFormat[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            ImageInfoFormatter.dateFormats[i] = new SafeSimpleDateFormat(patterns[i]);
        }
    }
}

