/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedHashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.jalbum.util.MonitoredWorkQueue;
import se.datadosen.component.ControlPanel;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.FileFilters;

class LinkTreeBuilder {
    private final JExplorerPanel explorer;
    private MonitoredWorkQueue workQueue;
    private final RestrictedFileFilter restrictedFileFilter = new RestrictedFileFilter();
    private LinkDecision linkDecision = LinkDecision.UNDECIDED;

    LinkTreeBuilder(JExplorerPanel explorer) {
        this.explorer = explorer;
        this.workQueue = new MonitoredWorkQueue(explorer, Msg.get("mirroringContent.message"), Msg.get("add"));
    }

    private static void setSmallerFont(JComponent comp) {
        comp.setFont(comp.getFont().deriveFont(comp.getFont().getSize2D() - 1.0f));
    }

    LinkDecision getLinkDecision() {
        if (this.linkDecision == LinkDecision.UNDECIDED) {
            ControlPanel panel = new ControlPanel();
            ((Container)panel).add(new JLabel(Msg.get("linkingBehaviour.message")));
            JLabel hoverTip = new JLabel(Msg.get("ui.hoverTip"));
            LinkTreeBuilder.setSmallerFont(hoverTip);
            ((Container)panel).add("br", hoverTip);
            JButton linkToFolder = new JButton(Msg.get("linkingBehaviour.linkToFolder"));
            linkToFolder.addActionListener(e -> {
                this.linkDecision = LinkDecision.LINK_TO_FOLDER;
                SwingUtilities.getWindowAncestor((Component)e.getSource()).setVisible(false);
            });
            linkToFolder.setToolTipText(Msg.get("linkingBehaviour.linkToFolderToolTip"));
            JButton mirrorContent = new JButton(Msg.get("linkingBehaviour.mirrorContent"));
            mirrorContent.setToolTipText(Msg.get("linkingBehaviour.mirrorContentToolTip"));
            mirrorContent.addActionListener(e -> {
                this.linkDecision = LinkDecision.MIRROR_CONTENT;
                SwingUtilities.getWindowAncestor((Component)e.getSource()).setVisible(false);
            });
            JOptionPane.showOptionDialog(this.explorer, panel, Msg.get("add"), 0, 3, null, new Object[]{linkToFolder, mirrorContent}, linkToFolder);
        }
        return this.linkDecision;
    }

    AlbumObject mirrorContent(File dir, AlbumObject target) throws IOException {
        AlbumObject folder = target.createFolder(dir.getName());
        this.workQueue.submit(() -> this.doMirrorContent(dir, folder));
        return folder;
    }

    private void doMirrorContent(File dir, AlbumObject folder) throws IOException, OperationAbortedException {
        LinkedHashSet<AlbumObject> toAdd = new LinkedHashSet<AlbumObject>();
        for (File f : dir.listFiles(this.restrictedFileFilter)) {
            if (this.workQueue.isAborted()) {
                throw new OperationAbortedException();
            }
            if (f.isDirectory()) {
                AlbumObject sub = folder.createFolder(f.getName());
                toAdd.add(sub);
                this.doMirrorContent(f, sub);
                continue;
            }
            LinkFile link = new LinkFile(folder.getFile(), f.getName(), f);
            toAdd.add(folder.getFactory().createInstance((File)link, folder));
        }
        folder.add(toAdd);
    }

    void awaitCompletion() {
        this.workQueue.awaitCompletion();
    }

    private static class RestrictedFileFilter
    implements FileFilter {
        private RestrictedFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.getName().equals(".jalbum")) {
                return false;
            }
            return f.isDirectory() || FileFilters.isFileSupported(f) || FileFilters.hasIcon(f);
        }
    }

    static enum LinkDecision {
        UNDECIDED,
        LINK_TO_FOLDER,
        MIRROR_CONTENT;

    }
}

