/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.jalbum.browser.BrowserToolBar;
import net.miginfocom.swing.MigLayout;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.ShareIcons;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JEmbedPanel;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Notifier;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.tags.ElementException;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.IO;
import se.datadosen.util.annotations.Text;

public class JSharePanel
extends JPanel {
    private String albumURL;
    private String title;
    private String thumbnailPath;
    private final JAlbumContext context;
    public static final String NAME = "SharePanel";
    private final String LAYOUT_CONSTRAINTS = "grow, gap 4 4 4 4";
    private JAddressPanel addressPanel = new JAddressPanel();
    @Text(value="share.jalbum")
    public Action jalbumSharingAction = new AbstractAction(null, ShareIcons.jalbum_big){
        {
            SignInManager.getInstance().addPropertyChangeListener("signIn", evt -> this.syncEnabledState());
            this.syncEnabledState();
        }

        private void syncEnabledState() {
            this.setEnabled(SignInManager.getInstance().isSignedIn());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AccountManager mgr = AccountManager.getInstance();
                AccountProfile account = mgr.findCurrentAccount(JSharePanel.this.context.getEngine());
                if (account == null) {
                    throw new IllegalStateException("Not signed in");
                }
                AlbumProject project = JSharePanel.this.context.getFrame().getCurrentProject();
                AlbumObject root = project.getRootFolder();
                AlbumObjectProperties props = root.getProperties();
                String url = (String)props.get("albumURL");
                if (url == null) {
                    throw new IllegalStateException("Album not uploaded");
                }
                new Notifier(JSharePanel.this.context).albumAdded(account, url, project, true);
                BrowserLauncher.openURL(JAlbumSite.getInstance().getRecentAlbumsUrl());
            }
            catch (IOException | IllegalStateException | ElementException ex) {
                Logger.getLogger(JSharePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void setEnabled(boolean newValue) {
            if (newValue && !SignInManager.getInstance().isSignedIn()) {
                return;
            }
            boolean oldValue = this.isEnabled();
            super.setEnabled(newValue);
            if (newValue != oldValue) {
                this.firePropertyChange("ShortDescription", "", this.getValue("ShortDescription"));
            }
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("ShortDescription") && !this.isEnabled()) {
                if (!SignInManager.getInstance().isSignedIn()) {
                    return Msg.get("ui.notSignedIn");
                }
                return Msg.get("ui.notAvailableOffline");
            }
            return super.getValue(key);
        }
    };
    JEmbedPanel embedPanel;
    @Text(value="share.facebook")
    public Action facebookAction = this.createSocialAction(ShareIcons.facebook_big, "https://www.facebook.com/sharer/sharer.php?u=");
    @Text(value="share.twitter")
    public Action twitterAction = this.createSocialAction(ShareIcons.twitter_big, "http://twitter.com/home?status=");
    @Text(value="share.tumblr")
    public Action tumblrAction = this.createSocialTitleAction(ShareIcons.tumblr_big, "http://www.tumblr.com/share/link?url=", "&name=", false);
    @Text(value="share.reddit")
    public Action redditAction = this.createSocialTitleAction(ShareIcons.reddit_big, "http://www.reddit.com/submit?url=", "&title=", false);
    @Text(value="share.mail")
    public Action emailAction = this.createSocialTitleAction(ShareIcons.mail_big, "&body=" + Msg.get("browser.mailBody") + " ", "mailto:?to=&subject=", true);
    @Text(value="share.pinterest")
    public Action pinterestAction = new AbstractAction(null, ShareIcons.pinterest_big){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                BrowserLauncher.openURL("http://www.pinterest.com/pin/create/button/?media=" + URLEncoder.encode(JSharePanel.this.albumURL + "/" + JSharePanel.this.thumbnailPath, "utf-8") + "&url=" + URLEncoder.encode(JSharePanel.this.albumURL, "utf-8") + "&description=" + URLEncoder.encode(JSharePanel.this.title, "utf-8"));
            }
            catch (IOException ex) {
                Logger.getLogger(JSharePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };

    public JSharePanel(JAlbumContext context) {
        this.setOpaque(true);
        this.setBackground(JAlbumColor.text);
        this.context = context;
        this.setLayout(new BorderLayout());
        JPanel content = new JPanel((LayoutManager)new MigLayout("align center, wrap 2"));
        content.setOpaque(false);
        JScrollPane scroller = new JScrollPane(content);
        scroller.setBorder(null);
        this.add(scroller);
        this.embedPanel = new JEmbedPanel(context);
        Msg.maintainTranslated(this);
        content.add((Component)this.addressPanel, "grow, gap 4 4 4 4,span 2");
        content.add((Component)JSharePanel.polish(new JPlainButton(this.jalbumSharingAction, true)), "grow, gap 4 4 4 4");
        content.add((Component)JSharePanel.polish(new JPlainButton(this.facebookAction, true)), "grow, gap 4 4 4 4");
        content.add((Component)JSharePanel.polish(new JPlainButton(this.twitterAction, true)), "grow, gap 4 4 4 4");
        content.add((Component)JSharePanel.polish(new JPlainButton(this.tumblrAction, true)), "grow, gap 4 4 4 4");
        content.add((Component)JSharePanel.polish(new JPlainButton(this.redditAction, true)), "grow, gap 4 4 4 4");
        content.add((Component)JSharePanel.polish(new JPlainButton(this.pinterestAction, true)), "grow, gap 4 4 4 4");
        content.add((Component)JSharePanel.polish(new JPlainButton(this.emailAction, true)), "grow, gap 4 4 4 4,span 2");
        content.add((Component)this.embedPanel, "grow, gap 4 4 4 4,span 2");
        ContextHelp.getInstance().add(this, "Share");
    }

    public void updateAlbumInformation(String albumURL, String title, String thumbnailPath) {
        this.albumURL = albumURL;
        this.title = title;
        this.thumbnailPath = thumbnailPath;
    }

    private static JButton polish(JButton button) {
        button.setMargin(new Insets(4, 10, 4, 10));
        button.setFont(button.getFont().deriveFont(16.0f));
        button.setHorizontalAlignment(2);
        button.setIconTextGap(15);
        return button;
    }

    private Action createSocialAction(Icon shareIcon, final String shareURL) {
        return new AbstractAction(this, null, shareIcon){
            final /* synthetic */ JSharePanel this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL(shareURL + IO.urlEncode(this.this$0.albumURL));
                }
                catch (IOException ex) {
                    Logger.getLogger(BrowserToolBar.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
    }

    private Action createSocialTitleAction(Icon shareIcon, final String shareURL, final String titleURL, final boolean reverse) {
        return new AbstractAction(this, null, shareIcon){
            final /* synthetic */ JSharePanel this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (reverse) {
                        BrowserLauncher.openURL(titleURL + this.this$0.title + shareURL + IO.urlEncode(this.this$0.albumURL));
                    }
                    BrowserLauncher.openURL(shareURL + IO.urlEncode(this.this$0.albumURL) + titleURL + this.this$0.title);
                }
                catch (IOException ex) {
                    Logger.getLogger(BrowserToolBar.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
    }

    public class JAddressPanel
    extends ControlPanel {
        private JLinkLabel link;
        Action copyToClipboardAction;

        public JAddressPanel() {
            super(Msg.get("share.url"));
            this.link = new JLinkLabel();
            this.copyToClipboardAction = new AbstractAction(Msg.get("ui.copyToClipboard")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(IO.urlEncode(JAddressPanel.this.link.getText())), null);
                }
            };
            TitledBorder border = this.getTitledBorder();
            border.setTitleFont(border.getTitleFont().deriveFont(16.0f));
            this.setLayout(new FlowLayout());
            this.setOpaque(false);
            this.link.setFont(this.link.getFont().deriveFont(16.0f));
            this.add(this.link);
            this.add(new JButton(this.copyToClipboardAction));
            this.addHierarchyListener(e -> {
                if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                    this.refresh();
                }
            });
        }

        public void refresh() {
            this.link.setURL(JSharePanel.this.albumURL);
            this.link.setText(JSharePanel.this.albumURL);
        }
    }
}

