/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JMapTable;
import se.datadosen.component.JRatingSlider;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.JEditPanel;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.FileNameDocument;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JFlagSelector;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.Text;

public class JPropertyPanel
extends JPanel
implements PropertyChangeListener {
    private JPanel varsPanel = new JPanel(new BorderLayout());
    private JCollapsiblePanel userVariablesPanel = new JCollapsiblePanel(Msg.get("ui.variables"), this.varsPanel);
    private JPanel general = new JPanel(new RiverLayout(4, 0));
    JMapTable userVariablesTable = new JMapTable();
    private static final int LEN = 8;
    private JSmallTextField fileName = new JSmallTextField(8);
    private JSmallTextField title = new JSmallTextField(8);
    private JSmallTextField date = new JSmallTextField(8);
    private JSmallTextField time = new JSmallTextField(8);
    JRatingSlider rating = new JRatingSlider(5);
    @Text(value="edit.flag")
    private JLabel flagLabel = new JSmallLabel();
    JFlagSelector flag = new JFlagSelector();
    private AlbumObject ao;
    JEditPanel editPanel;
    PropertyChangeListener expandedListener = pce -> {};
    Action previousImage = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPropertyPanel.this.editPanel.previousImageAction.actionPerformed(e);
        }
    };
    Action nextImage = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPropertyPanel.this.editPanel.nextImageAction.actionPerformed(e);
        }
    };
    private final Object monitor = new Object();
    private Map<JComponent, JCollapsiblePanel> tabMap = new HashMap<JComponent, JCollapsiblePanel>();

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.rating.setValue(this.ao.getRating());
        this.flag.setSelectedFlag(this.ao.getFlag());
    }

    public JPropertyPanel(JEditPanel editPanel) {
        this.editPanel = editPanel;
        this.init();
    }

    public void addTab(String title, JComponent component) {
        SwingUtilities.invokeLater(() -> {
            Object object = this.monitor;
            synchronized (object) {
                JCollapsiblePanel cp = new JCollapsiblePanel(title, component);
                cp.addPropertyChangeListener(this.expandedListener);
                this.tabMap.put(component, cp);
                Boolean expanded = (Boolean)component.getClientProperty("expanded");
                String priority = (String)component.getClientProperty("priority");
                if (Boolean.TRUE == expanded) {
                    cp.setExpanded(true);
                }
                if ("high".equals(priority)) {
                    this.add((Component)cp, 0);
                } else {
                    this.add(cp);
                }
                if (this.getParent() != null) {
                    this.getParent().validate();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTab(JCollapsiblePanel tab) {
        tab.addPropertyChangeListener(this.expandedListener);
        Object object = this.monitor;
        synchronized (object) {
            this.tabMap.put(tab, tab);
            String priority = (String)tab.getClientProperty("priority");
            if ("high".equals(priority)) {
                this.add((Component)tab, 0);
            } else {
                this.add(tab);
            }
            this.getParent().validate();
        }
    }

    public void removeTab(Component component) {
        if (component instanceof JCollapsiblePanel) {
            component.removePropertyChangeListener(this.expandedListener);
        }
        SwingUtilities.invokeLater(() -> {
            Object object = this.monitor;
            synchronized (object) {
                JCollapsiblePanel cp = this.tabMap.get(component);
                if (cp != null) {
                    this.remove(cp);
                    this.tabMap.remove(component);
                }
                this.getParent().validate();
            }
        });
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.fileName.setFocusable(focusable);
        this.title.setFocusable(focusable);
        this.date.setFocusable(focusable);
        this.time.setFocusable(focusable);
    }

    public void setAlbumObject(AlbumObject ao) {
        TableCellEditor cellEditor;
        this.save();
        if (this.ao != null) {
            this.ao.removePropertyChangeListener(this);
        }
        this.ao = ao;
        if (ao == null) {
            return;
        }
        ao.addPropertyChangeListener("properties", this);
        this.fileName.setText(ao.getName());
        if (ao instanceof AlbumObjectImpl) {
            File file = LinkFile.getResolvedTarget(ao);
            Date fileDate = new Date(file.lastModified());
            DateFormat datePart = DateFormat.getDateInstance(3);
            DateFormat timePart = DateFormat.getTimeInstance(3);
            this.date.setText(datePart.format(fileDate));
            this.time.setText(timePart.format(fileDate));
        }
        this.rating.setValue(ao.getRating());
        this.flag.setSelectedFlag(ao.getFlag());
        this.title.setText(ao.getTitle());
        if (this.userVariablesTable.isEditing() && (cellEditor = this.userVariablesTable.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
        this.userVariablesTable.clear();
        AlbumObjectProperties aoprop = ao.getProperties();
        Map userVariables = (Map)aoprop.get("userVariables");
        if (userVariables != null) {
            this.userVariablesTable.putAll(userVariables);
            if (this.userVariablesTable.getRowCount() > 0) {
                this.userVariablesPanel.setExpanded(true);
            }
        }
    }

    public void componentShown() {
        this.requestFocusInWindow();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createHorizontalStrut(200));
        Msg.maintainTranslated(this);
        this.userVariablesTable.setHeaderNames(Msg.get("ui.userVariablesNameColumn"), Msg.get("ui.userVariablesValueColumn"));
        this.fileName.setDocument(new FileNameDocument());
        this.flag.addActionListener(e -> {
            Flag newFlag = this.flag.getSelectedFlag();
            try {
                this.ao.setFlag(newFlag);
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        });
        this.general.setOpaque(true);
        this.general.setBackground(JAlbumColor.text);
        this.general.setLayout(new RiverLayout(4, 0));
        this.general.add("br", JPropertyPanel.emptyArea(1));
        this.general.add("br", new JSmallLabel(Msg.get("edit.name")));
        this.general.add("tab hfill", this.fileName);
        this.general.add("br", new JSmallLabel(Msg.get("edit.titleLabel")));
        this.general.add("tab hfill", this.title);
        this.general.add("br", new JSmallLabel(Msg.get("edit.date")));
        this.general.add("tab hfill", this.date);
        this.general.add("br", new JSmallLabel(Msg.get("edit.time")));
        this.general.add("tab hfill", this.time);
        this.general.add("br", new JSmallLabel(Msg.get("edit.rating")));
        this.general.add("tab hfill", this.rating);
        this.general.add("br", this.flagLabel);
        this.general.add("tab", this.flag);
        JCollapsiblePanel generalTab = new JCollapsiblePanel(Msg.get("ui.mainPanel"), this.general);
        generalTab.setExpanded(true);
        this.add(generalTab);
        this.varsPanel.add((Component)this.userVariablesTable.getTableHeader(), "North");
        this.varsPanel.add((Component)this.userVariablesTable, "Center");
        this.add(this.userVariablesPanel);
        this.rating.addChangeListener(e -> {
            try {
                this.ao.setRating(this.rating.getValue());
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        });
        FocusListener fl = new FocusListener(){
            private String lastText;

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getComponent() instanceof JTextComponent) {
                    this.lastText = ((JTextComponent)e.getComponent()).getText();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getComponent() instanceof JTextComponent && !this.lastText.equals(((JTextComponent)e.getComponent()).getText())) {
                    JPropertyPanel.this.save(e.getComponent());
                }
            }
        };
        this.fileName.addFocusListener(fl);
        this.title.addFocusListener(fl);
        this.date.addFocusListener(fl);
        this.time.addFocusListener(fl);
        this.userVariablesTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (JPropertyPanel.this.ao == null) {
                    return;
                }
                if (JPropertyPanel.this.userVariablesTable.isEditing()) {
                    return;
                }
                LinkedHashMap vars = JPropertyPanel.this.userVariablesTable.getMap();
                AlbumObjectProperties props = JPropertyPanel.this.ao.getProperties();
                if (vars.isEmpty()) {
                    props.remove("userVariables");
                } else {
                    props.put("userVariables", vars);
                }
                try {
                    props.store(false);
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JPropertyPanel.this, ex);
                }
            }
        });
    }

    void save() {
        this.save(null);
    }

    private void save(Component comp) {
        if (this.ao == null) {
            return;
        }
        if (comp == this.fileName) {
            this.ao.setName(this.fileName.getText());
        }
        if (this.ao instanceof AlbumObjectImpl) {
            try {
                AlbumObjectProperties props = this.ao.getProperties();
                this.ao.setTitle(this.title.getText());
                if (comp == this.date || comp == this.time) {
                    SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3);
                    SimpleDateFormat tf = (SimpleDateFormat)DateFormat.getTimeInstance(3);
                    SimpleDateFormat dateTimeFormat = new SimpleDateFormat(df.toPattern() + " " + tf.toPattern());
                    try {
                        Date newDate = dateTimeFormat.parse(this.date.getText() + " " + this.time.getText());
                        LinkFile.getResolvedTarget(this.ao).setLastModified(newDate.getTime());
                    }
                    catch (ParseException ex) {
                        Debug.showFriendlyErrorDialog(comp, ex);
                    }
                }
                if (this.userVariablesTable.isFocusOwner()) {
                    LinkedHashMap vars = this.userVariablesTable.getMap();
                    if (vars.isEmpty()) {
                        props.remove("userVariables");
                    } else {
                        props.put("userVariables", vars);
                    }
                    props.store();
                }
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        }
    }

    private static Component emptyArea(int size) {
        return Box.createRigidArea(new Dimension(size, size));
    }

    public static class JSmallTextField
    extends JSmartTextField {
        private Border originalBorder;
        private Border emptyBorder;

        public JSmallTextField() {
            this.init();
        }

        public JSmallTextField(int length) {
            super(length);
            this.init();
        }

        public JSmallTextField(Document p0) {
            super(p0, "", 0);
            this.init();
        }

        private void init() {
            this.putClientProperty("spelling", true);
            if (Platform.isMac()) {
                this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
            }
            this.originalBorder = this.getBorder();
            Insets in = this.originalBorder.getBorderInsets(this);
            this.emptyBorder = BorderFactory.createEmptyBorder(in.top, in.left, in.bottom, in.right);
            this.setBorder(this.emptyBorder);
            this.registerKeyboardAction(null, KeyStroke.getKeyStroke(33, 0), 0);
            this.registerKeyboardAction(null, KeyStroke.getKeyStroke(34, 0), 0);
            this.addActionListener(e -> this.getFocusCycleRootAncestor().transferFocus());
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.setBorder(originalBorder);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.setBorder(emptyBorder);
                }
            });
        }
    }

    public static class JSmallLabel
    extends JLabel {
        public JSmallLabel() {
            this.init();
        }

        public JSmallLabel(String text) {
            super(text);
            this.init();
        }

        private void init() {
            if (Platform.isMac()) {
                this.setFont(this.getFont().deriveFont(1, this.getFont().getSize2D() - 2.0f));
            }
            this.makeBold();
            this.setOpaque(false);
        }

        private void makeBold() {
            this.setFont(this.getFont().deriveFont(1));
        }
    }

    public static class JSmallTextArea
    extends JSmartTextArea {
        public JSmallTextArea() {
            this.init();
        }

        public JSmallTextArea(int rows, int columns) {
            super(rows, columns);
            this.init();
        }

        public JSmallTextArea bordered() {
            Border border = new JSmallTextField().getBorder();
            this.setBorder(border);
            return this;
        }

        private void init() {
            this.spelling();
            if (Platform.isMac()) {
                this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
            }
            this.setFocusTraversalKeys(0, null);
            this.setFocusTraversalKeys(1, null);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }
    }
}

