/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import se.datadosen.component.Autocompleter;
import se.datadosen.component.JBackgroundTextField;
import se.datadosen.component.JPlainButton;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFilter;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Multilingual;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JFilterBar
extends JPanel
implements AlbumObjectFilter,
ActionListener {
    private JAlbumExplorer context;
    @ToolTipText(value="close")
    private JButton closeButton = new JPlainButton(Icons.small("abort"), Icons.small("abort-1"));
    @Text(value="ui.filters", postfix=": ")
    private JLabel filterLabel = new JLabel();
    private JToggleButton[] starButtons = new JToggleButton[6];
    private final Flag[] flags = Flag.values();
    private JToggleButton[] flagButtons = new JToggleButton[Flag.values().length];
    @ToolTipText(value="ui.keywordFilterToolTip")
    JKeywordsField keywordsField = new JKeywordsField(12);
    private Node keywordExpression;
    private Future refilterFuture;
    private Runnable refilterRunnable = new Runnable(){
        private Runnable forAWTThread = () -> JFilterBar.this.actionPerformed(null);

        @Override
        public void run() {
            JFilterBar.this.keywordExpression = JFilterBar.this.parseKeywordExpression(JFilterBar.this.keywordsField.getText().toLowerCase());
            SwingUtilities.invokeLater(this.forAWTThread);
        }
    };
    @ToolTipText(value="ui.resetFilters")
    @Icon(value="16x16/reset-filter.svg")
    Action resetFilterAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (JToggleButton tb : JFilterBar.this.starButtons) {
                tb.setSelected(false);
            }
            for (JToggleButton tb : JFilterBar.this.flagButtons) {
                tb.setSelected(false);
            }
            if (JFilterBar.this.keywordsField.getText().length() > 0) {
                JFilterBar.this.keywordsField.setText("");
            } else {
                JFilterBar.this.actionPerformed(e);
            }
        }
    };
    private JButton resetFilterButton = new JPlainButton(this.resetFilterAction);

    public JFilterBar(JAlbumExplorer context) {
        super(new BorderLayout());
        this.context = context;
        this.init();
    }

    private boolean acceptRating(AlbumObject ao) {
        int rating = Math.max(ao.getRating(), 0);
        if (this.starButtons[rating].isSelected()) {
            return true;
        }
        for (JToggleButton tb : this.starButtons) {
            if (!tb.isSelected()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptFlag(AlbumObject ao) {
        Flag flag = ao.getFlag();
        if (this.flagButtons[flag.ordinal()].isSelected()) {
            return true;
        }
        for (JToggleButton tb : this.flagButtons) {
            if (!tb.isSelected()) continue;
            return false;
        }
        return true;
    }

    private boolean addNotEmpty(String s, Set<String> set) {
        if (s != null && s.length() > 0) {
            return set.add(s);
        }
        return false;
    }

    private boolean acceptKeywords(AlbumObject ao) {
        if (this.keywordExpression != null) {
            Set<String> ks = ao.getKeywordSet();
            this.addNotEmpty(ao.getName(), ks);
            this.addNotEmpty(ao.getTitle(), ks);
            this.addNotEmpty(ao.getComment(), ks);
            return this.keywordExpression.eval(this.toLowerCase(ks));
        }
        return true;
    }

    private Set<String> toLowerCase(Set<String> set) {
        TreeSet<String> newSet = new TreeSet<String>();
        for (String s : set) {
            newSet.add(s.toLowerCase());
        }
        return newSet;
    }

    @Override
    public boolean test(AlbumObject ao) {
        return this.acceptRating(ao) && this.acceptFlag(ao) && this.acceptKeywords(ao);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.context.applyFilters();
        this.context.updateStatusBar();
    }

    private void init() {
        JPlainToggleButton tb;
        int i;
        Msg.maintainTranslated(this);
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JAlbumColor.border));
        new Autocompleter(this.keywordsField, this.context.knownKeywords);
        this.keywordsField.onChange(de -> {
            if (this.refilterFuture != null) {
                this.refilterFuture.cancel(false);
            }
            this.refilterFuture = JAlbumUtilities.schedule(this.refilterRunnable, 200L, TimeUnit.MILLISECONDS);
        });
        this.closeButton.addActionListener(e -> {
            this.context.filterBarAction.putValue("SwingSelectedKey", false);
            this.context.filterBarAction.actionPerformed(e);
        });
        JPanel content = new JPanel();
        content.add(this.filterLabel);
        for (i = 0; i <= 5; ++i) {
            tb = new JPlainToggleButton(Icons.small("star-gray-" + i));
            tb.setSelectedIcon(Icons.small("star-yellow-" + i));
            tb.setToolTipText(Msg.get("ui.ratingToolTip", i));
            tb.addActionListener(this);
            this.starButtons[i] = tb;
            content.add(tb);
        }
        content.add(new JLabel("+"));
        this.starButtons[0].setToolTipText(Msg.get("edit.unrated"));
        for (i = 0; i < this.flagButtons.length; ++i) {
            tb = new JPlainToggleButton(this.flags[i].getIcon());
            tb.setSelectedIcon(this.flags[i].getSelectedIcon());
            tb.setToolTipText(this.flags[i].toString());
            tb.addActionListener(this);
            this.flagButtons[i] = tb;
            content.add(tb);
        }
        content.add(new JLabel("+ "));
        content.add(this.keywordsField);
        content.add(this.resetFilterButton);
        this.add((Component)content, "Before");
        JPanel controlPanel = new JPanel(new FlowLayout(0, 0, 3));
        controlPanel.add(this.closeButton);
        controlPanel.add(Box.createHorizontalStrut(4));
        this.add((Component)controlPanel, "After");
        this.validate();
    }

    private Node parseKeywordExpression(String expr) {
        if (expr.indexOf(44) != -1) {
            OrNode orNode = new OrNode();
            StringTokenizer tokens = new StringTokenizer(expr, ",;");
            while (tokens.hasMoreTokens()) {
                orNode.addChild(this.parseKeywordExpression(tokens.nextToken()));
            }
            return orNode;
        }
        if (expr.indexOf(43) != -1) {
            AndNode andNode = new AndNode();
            StringTokenizer tokens = new StringTokenizer(expr, "+");
            while (tokens.hasMoreTokens()) {
                andNode.addChild(new Leaf(tokens.nextToken()));
            }
            return andNode;
        }
        if (expr.trim().length() > 0) {
            return new Leaf(expr);
        }
        return null;
    }

    static class JKeywordsField
    extends JBackgroundTextField
    implements Multilingual {
        public JKeywordsField(int chars) {
            super(chars);
        }

        @Override
        public void languageUpdated() {
            this.setBackgroundText(Msg.get("edit.keywords"));
        }
    }

    private static abstract class Node {
        private Node() {
        }

        abstract boolean eval(Set<String> var1);
    }

    static class JPlainToggleButton
    extends JToggleButton {
        public JPlainToggleButton(javax.swing.Icon icon) {
            super(icon);
            this.init();
        }

        @Override
        public void setBorder(Border border) {
        }

        public void setRealBorder(Border border) {
            super.setBorder(border);
        }

        private void init() {
            super.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
        }
    }

    private static class OrNode
    extends LogicNode {
        private OrNode() {
        }

        @Override
        boolean eval(Set<String> keywords) {
            for (Node node : this.children) {
                if (node == null || !node.eval(keywords)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AndNode
    extends LogicNode {
        private AndNode() {
        }

        @Override
        boolean eval(Set<String> keywords) {
            for (Node node : this.children) {
                if (node == null || node.eval(keywords)) continue;
                return false;
            }
            return true;
        }
    }

    private static class Leaf
    extends Node {
        private String keyword;

        public Leaf(String keyword) {
            this.keyword = keyword.trim();
        }

        @Override
        boolean eval(Set<String> keywords) {
            Optional<String> opt = keywords.stream().filter(kw -> kw.contains(this.keyword)).findAny();
            return opt.isPresent();
        }
    }

    private static abstract class LogicNode
    extends Node {
        protected List<Node> children = new ArrayList<Node>();

        private LogicNode() {
        }

        public void addChild(Node child) {
            this.children.add(child);
        }
    }
}

