/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;

class JFileAddBehaviorDialogs {
    JLabel message = new JLabel();
    JCheckBox rememberChoice = new JCheckBox(Msg.get("ui.rememberChoice"));
    JLabel hoverTip = new JLabel(Msg.get("ui.hoverTip"));
    JButton copyButton = new JButton(Msg.get("ui.copy"));
    JButton linkButton = new JButton(Msg.get("ui.link"));
    JButton useFolderButton = new JButton(Msg.get("ui.useFolder"));
    Object source;

    private static void setSmallerFont(JComponent comp) {
        comp.setFont(comp.getFont().deriveFont(comp.getFont().getSize2D() - 1.0f));
    }

    private JFileAddBehaviorDialogs(JAlbumFrame parent, List<File> files) {
        this.rememberChoice.setToolTipText(Msg.get("ui.rememberChoiceToolTip"));
        JFileAddBehaviorDialogs.setSmallerFont(this.rememberChoice);
        JFileAddBehaviorDialogs.setSmallerFont(this.hoverTip);
        this.copyButton.setToolTipText(Msg.get("ui.copyMethodToolTip"));
        this.linkButton.setToolTipText(Msg.get("ui.linkMethodToolTip"));
        this.useFolderButton.setToolTipText(Msg.get("ui.useFolderMethodToolTip"));
        ActionListener closeAction = e -> {
            this.source = e.getSource();
            SwingUtilities.getWindowAncestor((Component)e.getSource()).setVisible(false);
        };
        this.copyButton.addActionListener(closeAction);
        this.linkButton.addActionListener(closeAction);
        this.useFolderButton.addActionListener(closeAction);
        Box content = Box.createVerticalBox();
        if (files.size() == 1 && files.get(0).isDirectory() && (parent.albumExplorer.getRootFolder() == null || parent.albumExplorer.getRootFolder().getName().length() <= 0)) {
            this.message.setText(Msg.get("ui.addFolderInfo"));
            content.add(this.message);
            content.add(Box.createVerticalStrut(3));
            content.add(this.hoverTip);
            JOptionPane.showOptionDialog(parent, content, Msg.get("add"), 0, 3, null, new Object[]{this.copyButton, this.linkButton, this.useFolderButton}, this.copyButton);
        } else {
            this.message.setText(files.size() > 1 ? Msg.get("ui.addFilesInfo") : Msg.get("ui.addFileInfo"));
            content.add(this.message);
            content.add(Box.createVerticalStrut(3));
            content.add(this.hoverTip);
            content.add(Box.createVerticalStrut(3));
            content.add(this.rememberChoice);
            JOptionPane.showOptionDialog(parent, content, Msg.get("add"), 0, 3, null, new Object[]{this.copyButton, this.linkButton}, this.copyButton);
        }
    }

    static int showDialog(JAlbumFrame frame, List<File> files) {
        Tracer.getInstance().trace("add file method dialog shown");
        JFileAddBehaviorDialogs pane = new JFileAddBehaviorDialogs(frame, files);
        Config.FileAddMethod behavior = null;
        int action = -1;
        if (pane.source == pane.copyButton) {
            behavior = Config.FileAddMethod.COPY;
            Tracer.getInstance().trace("add file method dialog ok", "method:copy", "rememberChoice:" + pane.rememberChoice.isSelected());
        } else if (pane.source == pane.linkButton) {
            behavior = Config.FileAddMethod.LINK;
            Tracer.getInstance().trace("add file method dialog ok", "method:link", "rememberChoice:" + pane.rememberChoice.isSelected());
        } else if (pane.source == pane.useFolderButton) {
            action = 2;
            Tracer.getInstance().trace("add file method dialog ok", "method:move");
        } else {
            Tracer.getInstance().trace("add file method dialog cancelled");
        }
        if (behavior != null) {
            action = behavior.getAction();
            if (pane.rememberChoice.isSelected()) {
                frame.preferencesWindow.fileAddMethod.setSelectedItem((Object)behavior);
                frame.preferencesWindow.savePreferences();
            }
        }
        return action;
    }
}

