/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.undo.CompoundEdit;
import net.jalbum.undo.EditGroup;
import net.jalbum.undo.UndoHandler;
import net.jalbum.undo.UndoableGroupEdit;
import se.datadosen.component.Hour;
import se.datadosen.component.tags.TagsTransferable;
import se.datadosen.explorer.AlbumObjectTransferable;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JAlbumObjectsPanel;
import se.datadosen.explorer.JCopyWarningDialog;
import se.datadosen.explorer.JFileAddBehaviorDialogs;
import se.datadosen.explorer.LinkTreeBuilder;
import se.datadosen.explorer.event.MoveEvent;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.explorer.event.StructureListener;
import se.datadosen.io.LinkFile;
import se.datadosen.io.RenamedFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileCopier;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JNewProjectDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PluginManager;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.TypeNavigator;
import se.datadosen.jalbum.WebLocation;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.StringUtil;

public class JExplorerPanel
extends JAlbumObjectsPanel
implements DragGestureListener,
DropTargetListener {
    public static final String NAME = "explorerPanel";
    private List<JAlbumObject> draggedObjects;
    Rectangle rubberband;
    private Point caretLocation;
    JAlbumObject dropTargetObject;
    boolean insertBefore;
    private transient ArrayList<StructureListener> structureListeners;
    private String backgroundText;
    public Action refreshAction;
    TypeNavigator typeNavigator = new TypeNavigator(this){

        @Override
        public String getFocusedName() {
            String name = "";
            JAlbumObject focused = JExplorerPanel.this.selectionModel.getFocusedObject();
            if (focused == null) {
                focused = (JAlbumObject)JExplorerPanel.this.getComponent(0);
            }
            if (focused != null) {
                name = focused.ao.getName();
            }
            return name;
        }

        @Override
        public void focusNextMatching(String prefix) {
            JAlbumObject focused = JExplorerPanel.this.selectionModel.getFocusedObject();
            if (focused == null) {
                focused = JExplorerPanel.this.getFirstVisibleObject();
            }
            if (focused != null) {
                JAlbumObject jao;
                int i;
                Component[] comps = JExplorerPanel.this.getComponents();
                int focusedIndex = JExplorerPanel.this.selectionModel.indexOf(focused);
                for (i = focusedIndex + 1; i < comps.length; ++i) {
                    jao = (JAlbumObject)comps[i];
                    if (!jao.isVisible() || !this.isMatch(jao.ao.getName())) continue;
                    JExplorerPanel.this.selectionModel.selectSingle(jao);
                    JExplorerPanel.this.scrollRectToVisible(jao.getBounds());
                    return;
                }
                for (i = 0; i < focusedIndex; ++i) {
                    jao = (JAlbumObject)comps[i];
                    if (!jao.isVisible() || !this.isMatch(jao.ao.getName())) continue;
                    JExplorerPanel.this.selectionModel.selectSingle(jao);
                    JExplorerPanel.this.scrollRectToVisible(jao.getBounds());
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        }
    };
    private int sourceActions;

    public JExplorerPanel(final JAlbumExplorer context) {
        super(context);
        JAlbumContext.getInstance().addPropertyChangeListener("engine", evt -> {
            AlbumBean engine = (AlbumBean)evt.getNewValue();
            engine.addPropertyChangeListener(evt1 -> {
                if (evt1.getPropertyName().equals("imageDim") || evt1.getPropertyName().equals("imageScale")) {
                    this.repaint();
                }
            });
        });
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JAlbumObject jao;
                if ((SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isRightMouseButton(e)) && (jao = (JExplorerPanel.this.closestObject = JExplorerPanel.this.getNearestObject(e.getPoint()))) != null) {
                    int center = jao.getX() + jao.getWidth() / 2;
                    JExplorerPanel.this.insertBefore = e.getPoint().x < center;
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JExplorerPanel.this.requestFocusInWindow();
            }
        });
        this.setBackground(JAlbumColor.text);
        this.setBorder(new EmptyBorder(5, 15, 5, 15));
        int scale = context.parent.preferencesWindow.largeThumbnails.isSelected() ? 100 : 60;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        scale = prefs.getInt("iconScale", scale);
        context.thumbZoomSlider.setValue(scale);
        this.setIconScale((double)scale / 100.0);
        this.explorerThumbsLayout.setAlignment(0);
        this.explorerThumbsLayout.setHgap(32);
        this.explorerThumbsLayout.setVgap(26);
        this.setLayout(this.explorerThumbsLayout);
        this.setDropTarget(new DropTarget(this, 0x40000003, this));
        this.refreshAction = new AbstractAction(this){
            final /* synthetic */ JExplorerPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                File dir;
                File jalbumDir;
                File thumbsDir;
                if (e != null && (e.getModifiers() & 9) != 0 && (thumbsDir = new File(jalbumDir = new File(dir = context.currentFolder.getFile(), ".jalbum"), "cache")).exists()) {
                    System.out.println("Flushing thumbnail cache in " + String.valueOf(thumbsDir));
                    for (File f : thumbsDir.listFiles()) {
                        f.delete();
                    }
                }
                context.imageCache.clear();
                UndoHandler.getInstance().discardAllEdits();
                JAlbum.logger.fine("Refreshing");
                context.currentFolder.invalidate();
                context.refreshCurrentNode();
                context.selectNode(context.currentFolder);
                context.viewFolder(context.currentFolder);
            }
        };
        ContextHelp.getInstance().add(this, "Explore");
    }

    JAlbumObject getFirstVisibleObject() {
        for (Component c : this.getComponents()) {
            if (!c.isVisible()) continue;
            return (JAlbumObject)c;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension p = super.getPreferredSize();
        int preferredWidth = this.getParent().getWidth();
        return new Dimension(preferredWidth, p.height);
    }

    private boolean isFolder(JAlbumObject jao) {
        return jao != null && jao.ao.isFolder();
    }

    private boolean isProjectLoaded() {
        return this.context.rootFolder != null && this.context.rootFolder.getName().length() > 0;
    }

    public String getBackgroundText() {
        return this.backgroundText;
    }

    public void setBackgroundText(String backgroundText) {
        this.backgroundText = backgroundText;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.rubberband != null) {
            this.paintRubberband(g);
        }
        if (this.caretLocation != null) {
            this.paintCaret(g);
        }
        if (this.isFolder(this.dropTargetObject)) {
            this.paintDropTargetFolder(g);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.backgroundText != null) {
            g.setColor(Color.darkGray);
            Font originalFont = g.getFont();
            g.setFont(originalFont.deriveFont(20.0f));
            FontMetrics fm = g.getFontMetrics();
            String s = this.backgroundText;
            Rectangle2D rect = fm.getStringBounds(s, g);
            LineMetrics lm = fm.getLineMetrics(s, g);
            g.drawString(s, (int)((double)this.getWidth() - rect.getWidth()) / 2, (int)((double)lm.getAscent() + ((double)this.getHeight() - rect.getHeight()) / 2.0));
            g.setFont(originalFont);
        }
    }

    private void paintRubberband(Graphics g) {
        g.setColor(JAlbumColor.rubberBand);
        g.fillRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
        g.setColor(JAlbumColor.textHighlight);
        g.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
    }

    private void paintCaret(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        g.setColor(JAlbumColor.textText);
        Point cl = this.caretLocation;
        if (this.caretLocation.equals(new Point(0, 0))) {
            Rectangle r = ((JViewport)this.getParent()).getViewRect();
            r.grow(-3, -3);
            g.setStroke(new BasicStroke(3.0f));
            g.drawRect(r.x, r.y, r.width, r.height);
        } else if (this.getLabelType() == Config.LabelType.details) {
            g.fillRect(cl.x, cl.y, this.getWidth() - this.explorerThumbsLayout.getHgap(), 2);
        } else {
            int h = this.getIconBounds().height;
            g.fillRect(cl.x, cl.y, 2, h);
            g.drawLine(cl.x - 2, cl.y, cl.x + 3, cl.y);
            g.drawLine(cl.x - 1, cl.y + 1, cl.x + 2, cl.y + 1);
            g.drawLine(cl.x - 2, cl.y + h, cl.x + 3, cl.y + h);
            g.drawLine(cl.x - 1, cl.y + h - 1, cl.x + 2, cl.y + h - 1);
        }
    }

    private void paintDropTargetFolder(Graphics g) {
        Rectangle r = this.dropTargetObject.getBounds();
        g.setColor(JAlbumColor.rubberBand);
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    JAlbumObject getPreviousComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            if (comps[i] != rel) continue;
            while (i >= 1) {
                if (!comps[--i].isVisible()) continue;
                return (JAlbumObject)comps[i];
            }
        }
        return null;
    }

    JAlbumObject getNextComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length - 1; ++i) {
            if (comps[i] != rel) continue;
            while (i < comps.length - 1) {
                if (!comps[++i].isVisible()) continue;
                return (JAlbumObject)comps[i];
            }
        }
        return null;
    }

    static String dndActionsToString(int sa) {
        return ((sa & 1) != 0 ? "ACTION_COPY " : "") + ((sa & 2) != 0 ? "ACTION_MOVE " : "") + ((sa & 0x40000000) != 0 ? "ACTION_LINK " : "");
    }

    private static int getSourceActions(DropTargetEvent dtde) {
        if (dtde instanceof DropTargetDragEvent) {
            return ((DropTargetDragEvent)dtde).getSourceActions();
        }
        return ((DropTargetDropEvent)dtde).getSourceActions();
    }

    private static int getDropAction(DropTargetEvent dtde) {
        if (dtde instanceof DropTargetDragEvent) {
            return ((DropTargetDragEvent)dtde).getDropAction();
        }
        return ((DropTargetDropEvent)dtde).getDropAction();
    }

    private boolean isDefaultAction(DropTargetEvent dtde) {
        int dropAction = dtde instanceof DropTargetDragEvent ? ((DropTargetDragEvent)dtde).getDropAction() : ((DropTargetDropEvent)dtde).getDropAction();
        if (Platform.isLinux()) {
            return (this.sourceActions & 1 & dropAction) > 0;
        }
        return (this.sourceActions & 2 & dropAction) > 0 || (this.sourceActions & 2) == 0 && (this.sourceActions & 1 & dropAction) > 0;
    }

    int decideDropAction(DropTargetEvent dtde) {
        int result = this.decideDropAction(dtde, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int decideDropAction(DropTargetEvent dtde, boolean overrideSourceActions) {
        int sa;
        int dropAction;
        boolean isTags;
        boolean isJAlbumObject;
        if (dtde instanceof DropTargetDragEvent) {
            isJAlbumObject = ((DropTargetDragEvent)dtde).isDataFlavorSupported(AlbumObject.albumObjectFlavor);
            isTags = ((DropTargetDragEvent)dtde).isDataFlavorSupported(TagsTransferable.tagsFlavor);
            dropAction = ((DropTargetDragEvent)dtde).getDropAction();
            sa = ((DropTargetDragEvent)dtde).getSourceActions();
        } else {
            isTags = ((DropTargetDropEvent)dtde).isDataFlavorSupported(TagsTransferable.tagsFlavor);
            isJAlbumObject = ((DropTargetDropEvent)dtde).isDataFlavorSupported(AlbumObject.albumObjectFlavor);
            dropAction = ((DropTargetDropEvent)dtde).getDropAction();
            sa = ((DropTargetDropEvent)dtde).getSourceActions();
        }
        if (isTags) {
            return 1;
        }
        if (isJAlbumObject) {
            return dropAction;
        }
        try {
            Config.FileAddMethod defaultBehavior = Config.getConfig().getFileAddMethod();
            if (this.isDefaultAction(dtde)) {
                int n = defaultBehavior.getAction();
                return n;
            }
            if (defaultBehavior == Config.FileAddMethod.COPY || defaultBehavior == Config.FileAddMethod.ASK) {
                if (dropAction == 1) {
                    int n = this.isProjectLoaded() ? defaultBehavior.getAltAction() : 2;
                    return n;
                }
                int n = dropAction;
                return n;
            }
            if (dropAction == 0x40000000) {
                int n = this.isProjectLoaded() ? defaultBehavior.getAltAction() : 2;
                return n;
            }
            int n = dropAction;
            return n;
        }
        finally {
            if (!overrideSourceActions && dropAction == sa) {
                return dropAction;
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.updateSourceActions(dtde);
        if (JAlbum.logger.isLoggable(Level.FINER)) {
            System.out.println("Enter: Sourceactions: " + JExplorerPanel.dndActionsToString(dtde.getSourceActions()));
            System.out.println("Enter: Dropaction: " + JExplorerPanel.dndActionsToString(dtde.getDropAction()));
            System.out.println("Enter: Decision: " + JExplorerPanel.dndActionsToString(this.decideDropAction(dtde)));
            System.out.println("");
        }
        if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            dtde.acceptDrag(this.decideDropAction(dtde));
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.updateSourceActions(dtde);
        if (JAlbum.logger.isLoggable(Level.FINER)) {
            System.out.println("Over: Sourceactions: " + JExplorerPanel.dndActionsToString(dtde.getSourceActions()));
            System.out.println("Over: Dropaction: " + JExplorerPanel.dndActionsToString(dtde.getDropAction()));
            System.out.println("Over: Decision: " + JExplorerPanel.dndActionsToString(this.decideDropAction(dtde)));
            System.out.println("");
        }
        if (!this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(this.decideDropAction(dtde));
        Rectangle r = new Rectangle(dtde.getLocation(), new Dimension(60, 60));
        r.translate(-30, -30);
        this.scrollRectToVisible(r);
        Point dragLocation = dtde.getLocation();
        int xpos = this.getInsets().left;
        int ypos = this.getInsets().top;
        JAlbumObject target = this.closestObject = this.getNearestObject(dragLocation);
        if (!dtde.isDataFlavorSupported(TagsTransferable.tagsFlavor)) {
            if (target != null) {
                if (this.getLabelType() == Config.LabelType.details) {
                    xpos = this.explorerThumbsLayout.hgap / 2;
                    int vcenter = target.getY() + target.getHeight() / 2;
                    this.insertBefore = dragLocation.y < vcenter;
                    ypos = this.insertBefore ? target.getY() - this.explorerThumbsLayout.vgap / 2 : target.getY() + target.getHeight() + this.explorerThumbsLayout.vgap / 2;
                    if (!(dtde.isDataFlavorSupported(AlbumObject.albumObjectFlavor) || dragLocation.x >= target.getX() && dragLocation.x <= target.getX() + target.getWidth())) {
                        ypos = 0;
                        xpos = 0;
                        this.closestObject = null;
                    }
                } else {
                    ypos = target.getY() - 2;
                    int center = target.getX() + target.getWidth() / 2;
                    this.insertBefore = dragLocation.x < center;
                    xpos = this.insertBefore ? target.getX() - this.explorerThumbsLayout.hgap / 2 : target.getX() + target.getWidth() + this.explorerThumbsLayout.hgap / 2;
                    if (!(dtde.isDataFlavorSupported(AlbumObject.albumObjectFlavor) || dragLocation.y >= target.getY() && dragLocation.y <= target.getY() + target.getHeight() && dragLocation.x >= target.getX() - this.explorerThumbsLayout.hgap && dragLocation.x <= target.getX() + target.getWidth() + this.explorerThumbsLayout.hgap)) {
                        ypos = 0;
                        xpos = 0;
                        this.closestObject = null;
                    }
                }
            }
            this.caretLocation = new Point(xpos, ypos);
        }
        this.dropTargetObject = null;
        if (target != null && target.getBounds().contains(dragLocation)) {
            if (this.getDraggedObjects() != null) {
                for (JAlbumObject jao : this.getDraggedObjects()) {
                    if (!jao.ao.getFile().equals(target.ao.getFile())) continue;
                    dtde.rejectDrag();
                    return;
                }
            }
            this.dropTargetObject = target;
            if (target.ao.isFolder()) {
                this.caretLocation = null;
            }
        }
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (JAlbum.logger.isLoggable(Level.FINER)) {
            System.out.println("Changed: Sourceactions: " + JExplorerPanel.dndActionsToString(dtde.getSourceActions()));
            System.out.println("Changed: Dropaction: " + JExplorerPanel.dndActionsToString(dtde.getDropAction()));
            System.out.println("Changed: Decision: " + JExplorerPanel.dndActionsToString(this.decideDropAction(dtde)));
            System.out.println("");
        }
        dtde.acceptDrag(this.decideDropAction(dtde));
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.caretLocation = null;
        this.dropTargetObject = null;
        this.repaint();
    }

    private List<File> filterCollissionFiles(List<File> files, AlbumObject target) throws OperationAbortedException {
        CopyDecision copyDecision = CopyDecision.UNDECIDED;
        ArrayList<File> filtered = new ArrayList<File>();
        for (File f : files) {
            CopyDecision decision = copyDecision;
            if (target.containsName(f.getName()) && !f.getParentFile().equals(target.getFile()) && copyDecision == CopyDecision.UNDECIDED) {
                JCopyWarningDialog confirmDialog = new JCopyWarningDialog(this.context.parent, Msg.get("add"), f);
                confirmDialog.setVisible(true);
                if (confirmDialog.buttonPressed == confirmDialog.replaceButton) {
                    decision = CopyDecision.COPY;
                } else if (confirmDialog.buttonPressed == confirmDialog.dontReplaceButton) {
                    decision = CopyDecision.SKIP;
                } else if (confirmDialog.buttonPressed == confirmDialog.keepBothButton) {
                    decision = CopyDecision.KEEPBOTH;
                } else {
                    throw new OperationAbortedException();
                }
                if (confirmDialog.applyToAll.isSelected()) {
                    copyDecision = decision;
                }
            }
            if (decision == CopyDecision.KEEPBOTH) {
                filtered.add(new RenamedFile(target.getUniqueName(f.getName()), f));
                continue;
            }
            if (decision == CopyDecision.SKIP) continue;
            filtered.add(f);
        }
        return filtered;
    }

    private void addKeywords(AlbumObject ao, Collection<String> kw) {
        TreeSet<String> keywords = StringUtil.stringToSet(ao.getKeywords());
        keywords.addAll(kw);
        try {
            ao.setKeywords(StringUtil.setToString(keywords));
        }
        catch (IOException ex) {
            Debug.showFriendlyErrorDialog(this, ex);
        }
    }

    private void handleTagsDropped(DropTargetDropEvent dtde) {
        CompoundEdit groupEdit = null;
        try {
            Collection newKeywords = (Collection)dtde.getTransferable().getTransferData(TagsTransferable.tagsFlavor);
            if (this.dropTargetObject.isSelected()) {
                this.getParent().setCursor(Cursor.getPredefinedCursor(3));
                groupEdit = new UndoableGroupEdit(Msg.get("ui.addKeywords"));
                UndoHandler.getInstance().undoableEditHappened(this, groupEdit);
                this.listSelectedAlbumObjects().parallelStream().forEach(ao -> this.addKeywords((AlbumObject)ao, newKeywords));
                for (AlbumObject ao2 : this.getSelectedAlbumObjects()) {
                    this.addKeywords(ao2, newKeywords);
                }
            } else {
                this.addKeywords(this.dropTargetObject.ao, newKeywords);
            }
            dtde.dropComplete(true);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            dtde.dropComplete(false);
            throw new RuntimeException(ex);
        }
        finally {
            if (groupEdit != null) {
                groupEdit.end();
                UndoHandler.getInstance().update();
                this.getParent().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    protected MouseAdapter getMouseOnComponentAdapter() {
        return this.context.mouseOnComponentAdapter;
    }

    public void updateSourceActions(DropTargetDragEvent dtde) {
        this.sourceActions = JExplorerPanel.getSourceActions(dtde);
    }

    private List<File> moveFiles(List<File> files, AlbumObject target) {
        ArrayList<File> movedFiles = new ArrayList<File>();
        for (File f : files) {
            File moved = new File(target.getFile(), f.getName());
            moved.delete();
            f.renameTo(moved);
            movedFiles.add(moved);
        }
        return movedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        int dropAction = this.decideDropAction(dtde);
        JAlbum.logger.log(Level.FINER, "Drop: {0}", JExplorerPanel.dndActionsToString(dropAction));
        if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            if (dtde.isDataFlavorSupported(TagsTransferable.tagsFlavor)) {
                if (this.dropTargetObject != null) {
                    dtde.acceptDrop(dropAction);
                    this.handleTagsDropped(dtde);
                } else {
                    dtde.rejectDrop();
                }
                this.dropTargetObject = null;
                this.repaint();
                return;
            }
            if (this.getComponentCount() > 0 && this.caretLocation == null && !this.isFolder(this.dropTargetObject)) {
                dtde.rejectDrop();
                return;
            }
            this.caretLocation = null;
            try {
                dtde.acceptDrop(this.decideDropAction(dtde));
                boolean reordered = false;
                if (dtde.isDataFlavorSupported(AlbumObject.albumObjectFlavor)) {
                    reordered = this.handleJAlbumObjectDrop(dtde);
                    this.dropTargetObject = null;
                } else {
                    List<File> files = JExplorerPanel.getFilesFromTransferable(dtde.getTransferable());
                    if (files != null && files.size() > 0) {
                        dtde.dropComplete(true);
                        if (files.size() == 1) {
                            Tracer.getInstance().trace(files.get(0).isDirectory() ? "folder dropped" : "file dropped");
                        } else {
                            Tracer.getInstance().trace("files dropped", "fileCount:" + files.size());
                        }
                        SwingUtilities.invokeLater(() -> {
                            this.handleFileAdd(files, this.decideDropAction(dtde, true), false);
                            this.dropTargetObject = null;
                        });
                        return;
                    }
                }
                dtde.dropComplete(true);
                if (reordered) {
                    this.context.currentFolder.setOrdering(AlbumObject.Ordering.custom);
                    this.context.customOrderingAction.setSelected(true);
                    this.context.handleDisablingOfOrderingMenus();
                }
                this.fireStructureChanged(reordered ? new MoveEvent(this, this.getDraggedObjects()) : new StructureEvent(this, this.getDraggedObjects(), null));
            }
            catch (IOException exc) {
                exc.printStackTrace(System.err);
                dtde.dropComplete(false);
            }
            finally {
                this.draggedObjects = null;
            }
        } else {
            dtde.rejectDrop();
        }
        this.validate();
        this.repaint();
    }

    void initiateMove(List<JAlbumObject> selectedObjects) {
        if (this.draggedObjects != null) {
            this.draggedObjects.forEach(jao -> jao.setCut(false));
        }
        this.draggedObjects = selectedObjects;
        selectedObjects.forEach(jao -> jao.setCut(true));
    }

    boolean isMoveInitiated() {
        return this.draggedObjects != null;
    }

    void resetMove() {
        if (this.draggedObjects != null) {
            this.draggedObjects.forEach(jao -> jao.setCut(false));
        }
        this.draggedObjects = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeMove() {
        this.dropTargetObject = null;
        Point p = MouseInfo.getPointerInfo().getLocation();
        Point panelLoc = this.getLocationOnScreen();
        p.translate(-panelLoc.x, -panelLoc.y);
        JAlbumObject jao = this.closestObject = this.getNearestObject(p);
        if (jao != null) {
            int center = jao.getX() + jao.getWidth() / 2;
            this.insertBefore = p.x < center;
        }
        boolean reordered = this.handleJAlbumObjectDrop(null);
        try {
            if (reordered) {
                this.context.currentFolder.setOrdering(AlbumObject.Ordering.custom);
                this.context.customOrderingAction.setSelected(true);
                this.context.handleDisablingOfOrderingMenus();
            }
            this.fireStructureChanged(reordered ? new MoveEvent(this, this.getDraggedObjects()) : new StructureEvent(this, this.getDraggedObjects(), null));
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            this.resetMove();
            this.validate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleJAlbumObjectDrop(DropTargetDropEvent dtde) {
        if (dtde != null && (dtde.getDropAction() & 0x40000001) != 0 && dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                this.handleFileAdd(files, dtde.getDropAction(), true);
                return false;
            }
            catch (UnsupportedFlavorException ex) {
                Logger.getLogger(JExplorerPanel.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (IOException ex) {
                Logger.getLogger(JExplorerPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            return false;
        }
        boolean reordered = false;
        Tracer.getInstance().trace("albumobjects move");
        List<JAlbumObject> objectsToMove = this.getDraggedObjects();
        try (EditGroup _v = new EditGroup(Msg.get("edit.move"));){
            if (this.isFolder(this.dropTargetObject)) {
                Iterator<JAlbumObject> iterator = objectsToMove.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.dropTargetObject.requestFocusInWindow();
                        return reordered;
                    }
                    JAlbumObject jao = iterator.next();
                    jao.ao.moveTo(this.dropTargetObject.ao);
                    this.remove(jao);
                }
            }
            for (JAlbumObject jao : objectsToMove) {
                if (jao != this.closestObject) continue;
                boolean bl = false;
                return bl;
            }
            if (this.context.currentFolder.equals(objectsToMove.get((int)0).ao.getParent())) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    int insertIndex = this.findInsertIndex();
                    Iterator<JAlbumObject> iterator = objectsToMove.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            reordered = true;
                            return reordered;
                        }
                        JAlbumObject jao = iterator.next();
                        int index = this.getComponentZOrder(jao);
                        if (insertIndex > index) {
                            // empty if block
                        }
                        int n = --insertIndex;
                        ++insertIndex;
                        this.setComponentZOrder(jao, n);
                    }
                }
            }
            int insertIndex = this.findInsertIndex();
            Iterator<JAlbumObject> iterator = objectsToMove.iterator();
            while (iterator.hasNext()) {
                JAlbumObject jao = iterator.next();
                jao.ao.moveTo(this.context.currentFolder);
                this.add((Component)jao, insertIndex++);
            }
            return reordered;
        }
        catch (IOException ex) {
            SwingUtilities.invokeLater(() -> Debug.showFriendlyErrorDialog(this, ex));
        }
        return reordered;
    }

    private static File getTempJAlbumDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"), "jAlbum");
        tempDir.mkdirs();
        return tempDir;
    }

    private static List<File> getFilesFromTransferable(Transferable t) {
        DataFlavor[] flavors = t.getTransferDataFlavors();
        try {
            LinkedList<File> files;
            String urls;
            DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String url = (String)t.getTransferData(DataFlavor.stringFlavor);
                try {
                    URL u = new URL(url);
                    if ("http".equals(u.getProtocol()) || "https".equals(u.getProtocol())) {
                        File tempDir = JExplorerPanel.getTempJAlbumDir();
                        WebLocation wl = new WebLocation(new URL(url));
                        File dest = new File(tempDir, wl.getFileName());
                        wl.writeToFile(dest);
                        ArrayList<File> files2 = new ArrayList<File>();
                        files2.add(dest);
                        return files2;
                    }
                }
                catch (MalformedURLException u) {
                    // empty catch block
                }
            }
            try {
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
            }
            catch (InvalidDnDOperationException url) {
                // empty catch block
            }
            if (t.isDataFlavorSupported(uriListFlavor)) {
                urls = (String)t.getTransferData(uriListFlavor);
                files = new LinkedList<File>();
                for (String u : urls.split("\r\n")) {
                    files.add(new File(new URI(IO.urlEncode(u))));
                }
                return files;
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                urls = (String)t.getTransferData(DataFlavor.stringFlavor);
                urls = urls.replace(" ", "%20");
                files = new LinkedList();
                StringTokenizer tokens = new StringTokenizer(urls);
                while (tokens.hasMoreTokens()) {
                    String urlString = tokens.nextToken();
                    URL url = new URL(urlString);
                    files.add(new File(URLDecoder.decode(url.getFile(), "UTF-8")));
                }
                return files;
            }
        }
        catch (UnsupportedFlavorException | IOException | ClassNotFoundException | URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<File> filterSupportedFiles(List<File> files) {
        ArrayList<File> filtered = new ArrayList<File>();
        for (File f : files) {
            if (!FileFilters.isFileSupported(f) && !FileFilters.hasIcon(f)) continue;
            filtered.add(f);
        }
        return filtered;
    }

    public boolean handleFileAdd(List<File> files) {
        return this.handleFileAdd(files, Config.getConfig().getFileAddMethod().getAction(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFileAdd(List<File> files, int dropAction, boolean dropActionSelected) {
        block34: {
            try {
                boolean qualifiersDown;
                boolean bl = qualifiersDown = dropAction != Config.getConfig().getFileAddMethod().getAction();
                if (files.size() > 0 && "C:\\".equals(files.get(0).getAbsolutePath())) {
                    JOptionPane.showMessageDialog(this.context.parent, "You can't currently copy files from this device to jAlbum.\nPlease copy them to a local hard disk first", Msg.get("ui.copy"), 0);
                    boolean bl2 = false;
                    return bl2;
                }
                File firstFile = files.get(0);
                if (!(files.size() == 1 && firstFile.isDirectory() || firstFile.getParentFile().equals(IO.IMPORT_DIR) || dropAction != 2)) {
                    dropAction = Config.getConfig().getFileAddMethod().getAction();
                }
                if (this.handleSpecialFileTypes(files, dropAction)) {
                    boolean bl3 = true;
                    return bl3;
                }
                if (files.size() == 1 && files.get(0).getName().endsWith(".webloc")) {
                    dropAction = Config.FileAddMethod.COPY.getAction();
                } else if (!dropActionSelected && !qualifiersDown && Config.getConfig().getFileAddMethod() == Config.FileAddMethod.ASK && (dropAction = JFileAddBehaviorDialogs.showDialog(this.context.parent, files)) == -1) {
                    this.repaint();
                    boolean bl4 = true;
                    return bl4;
                }
                if (this.needsDelayedProcessing(files, dropAction)) {
                    boolean bl5 = true;
                    return bl5;
                }
                this.context.setExplorerView();
                AlbumObject target = this.isFolder(this.dropTargetObject) ? this.dropTargetObject.ao : this.context.currentFolder;
                files = this.filterSupportedFiles(files);
                files = this.filterCollissionFiles(files, target);
                if (this.context.currentFolder == null) {
                    this.context.currentFolder = this.context.rootFolder;
                }
                if (dropAction == 1) {
                    FileCopier fc = new FileCopier(this.context.parent);
                    fc.setAllowDuplicates(true);
                    this.context.renderThread.setEnableRefresh(false);
                    files = fc.copyFiles(files, target);
                }
                if (dropAction == 2) {
                    files = this.moveFiles(files, target);
                }
                AlbumObjectFactory factory = JAlbumContext.getInstance().getAlbumObjectfactory();
                LinkedHashSet<AlbumObject> toAdd = new LinkedHashSet<AlbumObject>();
                LinkTreeBuilder linkTreeBuilder = new LinkTreeBuilder(this);
                for (File f : files) {
                    AlbumObject ao;
                    if (dropAction == 0x40000000) {
                        LinkTreeBuilder.LinkDecision linkDecision = LinkTreeBuilder.LinkDecision.UNDECIDED;
                        if (f.isDirectory() && (linkDecision = linkTreeBuilder.getLinkDecision()) == LinkTreeBuilder.LinkDecision.UNDECIDED) break;
                        if (f.isDirectory() && linkDecision == LinkTreeBuilder.LinkDecision.MIRROR_CONTENT) {
                            this.context.renderThread.setEnableRefresh(false);
                            ao = linkTreeBuilder.mirrorContent(f, target);
                        } else {
                            LinkFile link = new LinkFile(target.getFile(), target.getUniqueName(f.getName()), f);
                            ao = factory.createInstance((File)link, target);
                        }
                    } else {
                        ao = factory.createInstance(f, target);
                    }
                    toAdd.add(ao);
                }
                linkTreeBuilder.awaitCompletion();
                if (this.isFolder(this.dropTargetObject)) {
                    try {
                        this.dropTargetObject.ao.add(toAdd);
                        this.selectionModel.selectSingle(this.closestObject);
                        this.selectionModel.setFocusedObject(this.closestObject);
                    }
                    catch (IOException ex) {
                        Debug.showFriendlyErrorDialog(this.context, ex);
                    }
                    break block34;
                }
                try {
                    if (this.closestObject != null) {
                        target.add(this.findInsertIndex(), toAdd);
                    } else {
                        target.add(toAdd);
                    }
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(this.context, ex);
                }
                this.context.refreshView();
                this.context.refreshCurrentNode();
                this.selectionModel.selectMatching(toAdd);
                this.selectionModel.setFocusedObject(this.getJAlbumObject((AlbumObject)toAdd.iterator().next()));
                if (this.context.parent.actions.makeAction.isEnabled()) {
                    TipOfTheDay.showSpeechBubble(this.context.parent.mainSettingsPanel.makeAlbumButton, new Hour(3), Msg.get("tip.makeAlbum", Msg.get("ui.makeAlbum")), 8);
                }
            }
            catch (OperationAbortedException qualifiersDown) {
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
            finally {
                this.context.renderThread.setEnableRefresh(true);
            }
        }
        return false;
    }

    private boolean handleSpecialFileTypes(List<File> files, int dropAction) {
        if (files.size() > 0) {
            File file = files.get(0);
            String fileName = file.getName();
            if (fileName.endsWith(".jap")) {
                this.createOrLoadProject(files, dropAction);
                return true;
            }
            if (!this.context.isProjectLoaded() && new File(file, "jalbum-settings.jap").exists()) {
                this.createOrLoadProject(files, dropAction);
                return true;
            }
            if (fileName.endsWith(".jaskin")) {
                new SkinManager().installSkin(file);
                return true;
            }
            if (fileName.endsWith(".jaext")) {
                PluginManager.installPlugin(file);
                return true;
            }
        }
        return false;
    }

    int findInsertIndex() {
        int insertIndex = -1;
        Component[] comps = this.getComponents();
        if (this.closestObject != null) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] != this.closestObject) continue;
                insertIndex = i;
                if (this.insertBefore) break;
                ++insertIndex;
                break;
            }
        }
        if (insertIndex < 0) {
            insertIndex = comps.length;
        }
        return insertIndex;
    }

    boolean isValidDragDrop(int dropAction, DataFlavor[] flavors) {
        for (DataFlavor dropFlavor : flavors) {
            if (JAlbum.logger.isLoggable(Level.FINEST)) {
                System.out.println("Flavor: " + String.valueOf(dropFlavor));
            }
            if (!dropFlavor.equals(DataFlavor.javaFileListFlavor) && !dropFlavor.equals(AlbumObject.albumObjectFlavor) && !dropFlavor.equals(DataFlavor.stringFlavor)) continue;
            return true;
        }
        return false;
    }

    public List<JAlbumObject> getDraggedObjects() {
        return this.draggedObjects;
    }

    private static Cursor getCursorFromAction(int action) {
        switch (action) {
            case 2: {
                return DragSource.DefaultMoveDrop;
            }
            case 1: {
                return DragSource.DefaultCopyDrop;
            }
            case 0x40000000: {
                return DragSource.DefaultLinkDrop;
            }
        }
        return DragSource.DefaultMoveDrop;
    }

    private static BufferedImage renderToImage(Stream<JAlbumObject> stream) {
        List components = stream.collect(Collectors.toList());
        if (components.isEmpty()) {
            return new BufferedImage(1, 1, 2);
        }
        int minX = components.stream().mapToInt(Component::getX).min().orElse(0);
        int minY = components.stream().mapToInt(Component::getY).min().orElse(0);
        int maxX = components.stream().mapToInt(c -> c.getX() + c.getWidth()).max().orElse(0);
        int maxY = components.stream().mapToInt(c -> c.getY() + c.getHeight()).max().orElse(0);
        int width = maxX - minX;
        int height = maxY - minY;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (Platform.isWindows()) {
            g.setComposite(AlphaComposite.SrcOver);
        } else {
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        g.setBackground(new Color(0, 0, 0, 0));
        g.clearRect(0, 0, width, height);
        g.translate(-minX, -minY);
        for (JAlbumObject comp : components) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.translate(comp.getX(), comp.getY());
            comp.paintDragImage(g2);
            g2.dispose();
        }
        g.dispose();
        return image;
    }

    private static Point computeDragImageOffset(List<JAlbumObject> objects, Point cursorInPanelCoords) {
        if (objects.isEmpty()) {
            return new Point(0, 0);
        }
        int minX = objects.stream().mapToInt(Component::getX).min().orElse(0);
        int minY = objects.stream().mapToInt(Component::getY).min().orElse(0);
        return Platform.isMac() ? new Point(minX - cursorInPanelCoords.x, minY - cursorInPanelCoords.y) : new Point(cursorInPanelCoords.x - minX, cursorInPanelCoords.y - minY);
    }

    public static DragImageResult prepareDragImageAndOffset(List<JAlbumObject> objects, Point cursorInPanelCoords, Component panel) {
        BufferedImage image = JExplorerPanel.renderToImage(objects.stream());
        Point offset = JExplorerPanel.computeDragImageOffset(objects, cursorInPanelCoords);
        if (!Platform.isWindows()) {
            return new DragImageResult(image, offset);
        }
        double scale = GraphicsUtilities.getHiDPIScale(panel);
        if (scale == 1.0) {
            return new DragImageResult(image, offset);
        }
        int scaledWidth = (int)Math.round((double)image.getWidth() * scale);
        int scaledHeight = (int)Math.round((double)image.getHeight() * scale);
        BufferedImage scaledImage = new BufferedImage(scaledWidth, scaledHeight, 2);
        Graphics2D g2 = scaledImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.scale(scale, scale);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        Point scaledOffset = new Point((int)Math.round((double)offset.x * scale), (int)Math.round((double)offset.y * scale));
        return new DragImageResult(scaledImage, scaledOffset);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        if (this.context.longClickFuture != null) {
            this.context.longClickFuture.cancel(true);
        }
        if (this.context.peekPanel.isShowing()) {
            this.context.peekPanel.close();
        }
        this.resetMove();
        BufferedImage dragImage = JExplorerPanel.renderToImage(this.objects().filter(jao -> jao.isSelected()));
        Point cursorInPanelCoords = SwingUtilities.convertPoint(event.getComponent(), event.getDragOrigin(), this);
        DragImageResult di = JExplorerPanel.prepareDragImageAndOffset(this.objects().filter(jao -> jao.isSelected()).collect(Collectors.toList()), cursorInPanelCoords, this);
        try {
            if (Platform.isMac()) {
                event.startDrag(JExplorerPanel.getCursorFromAction(event.getDragAction()), di.image, di.offset, new AlbumObjectTransferable(this.listSelectedAlbumObjects()), null);
            } else {
                event.startDrag(null, di.image, di.offset, new AlbumObjectTransferable(this.listSelectedAlbumObjects()), null);
            }
        }
        catch (Exception ex) {
            event.startDrag(null, di.image, di.offset, new AlbumObjectTransferable(this.listSelectedAlbumObjects()), null);
        }
        this.draggedObjects = this.selectionModel.getSelectedObjects();
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        JAlbumObject jao = (JAlbumObject)comp;
        if (jao.isSelected()) {
            this.selectionModel.objectSelected(jao, false);
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.selectionModel.deselectAll();
    }

    public synchronized void removeStructureListener(StructureListener l) {
        if (this.structureListeners != null && this.structureListeners.contains(l)) {
            ArrayList<StructureListener> listeners = new ArrayList<StructureListener>(this.structureListeners);
            listeners.remove(l);
            this.structureListeners = listeners;
        }
    }

    public synchronized void addStructureListener(StructureListener l) {
        ArrayList<StructureListener> listeners;
        ArrayList<StructureListener> arrayList = listeners = this.structureListeners == null ? new ArrayList<StructureListener>(2) : new ArrayList<StructureListener>(this.structureListeners);
        if (!listeners.contains(l)) {
            listeners.add(l);
            this.structureListeners = listeners;
        }
    }

    void fireStructureChanged(StructureEvent e) {
        if (this.structureListeners != null) {
            for (StructureListener listener : this.structureListeners) {
                listener.structureChanged(e);
            }
        }
    }

    private boolean needsDelayedProcessing(List files, int dropAction) {
        if (this.isProjectLoaded()) {
            return false;
        }
        SwingUtilities.invokeLater(() -> this.createOrLoadProject(files, dropAction));
        return true;
    }

    private void createOrLoadProject(List<File> files, int dropAction) {
        if (files.size() == 1) {
            File file = files.get(0);
            if (file.isDirectory()) {
                File projectFile = new File(file, "jalbum-settings.jap");
                if (projectFile.exists()) {
                    this.context.parent.loadProject(projectFile);
                } else if (dropAction == 2) {
                    this.context.parent.initProject(file);
                } else {
                    this.showNewProjectDialog(this.filterSupportedFiles(Arrays.asList(file.listFiles())), dropAction);
                }
            } else if (file.getName().endsWith(".jap")) {
                this.context.parent.loadProject(file);
            } else {
                this.showNewProjectDialog(this.filterSupportedFiles(files), dropAction);
            }
        } else {
            this.showNewProjectDialog(this.filterSupportedFiles(files), dropAction);
        }
    }

    private void showNewProjectDialog(List files, int dropAction) {
        JNewProjectDialog newProjectDialog = new JNewProjectDialog(this.context.parent);
        String albumNameSuggestion = this.findAlbumNameSuggestion(files);
        newProjectDialog.setAlbumName(albumNameSuggestion);
        newProjectDialog.setFiles(files, dropAction);
        this.context.parent.show(newProjectDialog);
    }

    private String findAlbumNameSuggestion(List files) {
        String parentNameForAllFiles = null;
        for (File file : files) {
            String parentNameOfCurrentFile = file.getParentFile().getName();
            if (parentNameForAllFiles == null) {
                parentNameForAllFiles = parentNameOfCurrentFile;
                continue;
            }
            if (parentNameForAllFiles.equals(parentNameOfCurrentFile)) continue;
            return Msg.get("newproject.defaultName");
        }
        return parentNameForAllFiles;
    }

    private static enum CopyDecision {
        UNDECIDED,
        COPY,
        SKIP,
        KEEPBOTH;

    }

    private static class DragImageResult {
        public Image image;
        public Point offset;

        public DragImageResult(Image image, Point offset) {
            this.image = image;
            this.offset = offset;
        }
    }
}

