/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.util.LaF;
import se.datadosen.util.LambdaAction;

class JCropFocusSelector
extends JBackgroundPanel {
    private float xWeight = 0.5f;
    private float yWeight = 0.2f;
    private float ratio = 1.0f;
    private Rectangle cb = new Rectangle();
    private Point plantPoint;
    private Rectangle plantCropBounds;

    public JCropFocusSelector() {
        this.init();
    }

    public float getxWeight() {
        return this.xWeight;
    }

    public void setxWeight(float xWeight) {
        this.xWeight = JCropFocusSelector.capValue(xWeight, 0.0f, 1.0f);
        this.repaint();
    }

    public float getyWeight() {
        return this.yWeight;
    }

    public void setyWeight(float yWeight) {
        this.yWeight = JCropFocusSelector.capValue(yWeight, 0.0f, 1.0f);
        this.repaint();
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
        this.repaint();
    }

    public Rectangle getCropBounds() {
        return new Rectangle(this.cb);
    }

    private static float capValue(float value, float min, float max) {
        value = Math.max(value, min);
        value = Math.min(value, max);
        return value;
    }

    private static Dimension calcDimension(int width, int height, Dimension boundingBox) {
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return new Dimension(width, height);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)width / maxScale + 0.5), (int)((double)height / maxScale + 0.5));
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        Graphics2D g = (Graphics2D)g2d;
        if (this.bg != null) {
            Rectangle bounds = this.getImageBounds();
            Dimension sDim = bounds.getSize();
            Dimension d = new Dimension(sDim.width, (int)((float)sDim.width / this.ratio));
            Dimension dDim = JCropFocusSelector.calcDimension(d.width, d.height, sDim);
            int cropX = (int)((float)(sDim.width - dDim.width) * this.xWeight);
            int cropY = (int)((float)(sDim.height - dDim.height) * this.yWeight);
            this.cb.x = cropX;
            this.cb.y = cropY;
            this.cb.width = dDim.width;
            this.cb.height = dDim.height;
            AffineTransform backup = g.getTransform();
            g.translate(bounds.x, bounds.y);
            BufferedImage bi = new BufferedImage(bounds.width, bounds.height, 2);
            Graphics2D big = bi.createGraphics();
            Color dimmed = LaF.isDark() ? new Color(0, 0, 0, 180) : new Color(255, 255, 255, 180);
            big.setColor(dimmed);
            big.fillRect(0, 0, bi.getWidth(), bi.getHeight());
            big.setComposite(AlphaComposite.Clear);
            big.fillRect(this.cb.x, this.cb.y, this.cb.width, this.cb.height);
            g.drawImage((Image)bi, 0, 0, this);
            g.setTransform(backup);
        }
    }

    private void init() {
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int hdiff;
                e.translatePoint(-JCropFocusSelector.this.plantPoint.x, -JCropFocusSelector.this.plantPoint.y);
                Point p = e.getPoint();
                Rectangle bounds = JCropFocusSelector.this.getImageBounds();
                Dimension sDim = bounds.getSize();
                Dimension d = new Dimension(sDim.width, (int)((float)sDim.width / JCropFocusSelector.this.ratio));
                Dimension dDim = JCropFocusSelector.calcDimension(d.width, d.height, sDim);
                int cropX = JCropFocusSelector.this.plantCropBounds.x + p.x;
                int cropY = JCropFocusSelector.this.plantCropBounds.y + p.y;
                int wdiff = sDim.width - dDim.width;
                if (wdiff > 0) {
                    JCropFocusSelector.this.setxWeight((float)cropX / (float)wdiff);
                }
                if ((hdiff = sDim.height - dDim.height) > 0) {
                    JCropFocusSelector.this.setyWeight((float)cropY / (float)hdiff);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JCropFocusSelector.this.plantPoint = e.getPoint();
                JCropFocusSelector.this.plantCropBounds = JCropFocusSelector.this.getCropBounds();
            }
        };
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        InputMap im = this.getInputMap();
        ActionMap am = this.getActionMap();
        im.put(KeyStroke.getKeyStroke(38, 0), "up");
        im.put(KeyStroke.getKeyStroke(38, 64), "up");
        am.put("up", new LambdaAction(e -> this.setyWeight(this.getyWeight() - JCropFocusSelector.getIncrement(e))));
        im.put(KeyStroke.getKeyStroke(40, 0), "down");
        im.put(KeyStroke.getKeyStroke(40, 64), "down");
        am.put("down", new LambdaAction(e -> this.setyWeight(this.getyWeight() + JCropFocusSelector.getIncrement(e))));
        im.put(KeyStroke.getKeyStroke(37, 0), "left");
        im.put(KeyStroke.getKeyStroke(37, 64), "left");
        am.put("left", new LambdaAction(e -> this.setxWeight(this.getxWeight() - JCropFocusSelector.getIncrement(e))));
        im.put(KeyStroke.getKeyStroke(39, 0), "right");
        im.put(KeyStroke.getKeyStroke(39, 64), "right");
        am.put("right", new LambdaAction(e -> this.setxWeight(this.getxWeight() + JCropFocusSelector.getIncrement(e))));
    }

    private static float getIncrement(ActionEvent e) {
        return (e.getModifiers() & 0x40) != 0 ? 0.01f : 0.001f;
    }
}

