/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import net.jalbum.component.HasIcon;
import se.datadosen.component.JPlainButton;
import se.datadosen.util.Multilingual;

public class JComboButton<E>
extends JPlainButton
implements Multilingual {
    private final E[] items;
    private int selectedIndex;
    protected boolean showLabel = true;

    public JComboButton(E[] items) {
        this(items, true);
    }

    public JComboButton(E[] items, boolean showLabel) {
        this.items = items;
        this.showLabel = showLabel;
        this.addActionListener(ae -> this.next());
        this.setSelectedIndex(0);
    }

    public E getSelectedItem() {
        return this.items[this.selectedIndex];
    }

    public void setSelectedItem(E selected) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].equals(selected)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    public void setSelectedIndex(int index) {
        E oldSelectedItem = this.getSelectedItem();
        this.selectedIndex = index;
        if (this.showLabel) {
            this.setText(this.items[index].toString());
        } else {
            this.setToolTipText(this.items[index].toString());
        }
        if (this.items[index] instanceof HasIcon) {
            this.setIcon(((HasIcon)this.items[index]).getIcon());
        }
        this.firePropertyChange("selectedItem", oldSelectedItem, this.getSelectedItem());
    }

    public void next() {
        int i = this.selectedIndex + 1;
        if (i >= this.items.length) {
            i = 0;
        }
        this.setSelectedIndex(i);
    }

    @Override
    public void languageUpdated() {
        this.setSelectedIndex(this.selectedIndex);
    }

    @Override
    public boolean isShowLabel() {
        return this.showLabel;
    }

    @Override
    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }
}

